package cn.kinyun.scrm.weixin.sdk.entity.message.event;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @ClassName PicPhotoOrAlbum
 * @Description pic_photo_or_album：弹出拍照或者相册发图的事件推送
 * @Author zhangjing
 * @DATE 2019/4/26 10:36
 * @Version 1.0
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class PicPhotoOrAlbumEvent extends BaseEvent {

    private static final long serialVersionUID = 8050151229553436297L;

    @JacksonXmlProperty(localName = "EventKey")
    private String eventKey;

    /**
     * 发送的图片信息
     */
    @JacksonXmlProperty(localName = "SendPicsInfo")
    private SendPicsInfo sendPicsInfo;
}
