/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.custom;

import com.fasterxml.jackson.annotation.JsonProperty;
import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;

import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 客服会话列表
 * 
 * @title ClientList
 * @desc 客服会话列表
 * @author yanmaoyuan
 * @date 2019年5月5日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ClientList extends ErrorCode{

    private static final long serialVersionUID = 1050543971629122328L;

    @JsonProperty("sessionlist")
    private List<Client> list;
}