/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.analysis.article;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * @title UserShareDto
 * @author yanmaoyuan
 * @date 2019年9月25日
 * @version 1.0
 */
@Data
public class UserShareDto implements Serializable {

    private static final long serialVersionUID = 4787847141583931800L;

    /**
     * 数据的日期，需在begin_date和end_date之间
     */
    @JsonAlias("ref_date")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date refDate;

    /**
     * 分享的场景
     * <pre>
     * 1代表好友转发
     * 2代表朋友圈
     * 3代表腾讯微博
     * 255代表其他
     * </pre>
     */
    @JsonAlias("share_scene")
    private int shareScene;

    /**
     * 分享的人数
     */
    @JsonAlias("share_user")
    private int shareUser;

    /**
     * 分享的次数
     */
    @JsonAlias("share_count")
    private int shareCount;

}