/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.analysis;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;
import lombok.NonNull;

/**
 * 微信数据分析请求参数
 * 
 * @title AnalysisReq
 * @author yanmaoyuan
 * @date 2019年9月24日
 * @version 1.0
 */
@Data
public class AnalysisReq implements Serializable {

    private static final long serialVersionUID = 1L;

    @JsonProperty("begin_date")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd", timezone = "GMT+8")
    @NonNull
    private Date beginDate;

    @JsonProperty("end_date")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd", timezone = "GMT+8")
    @NonNull
    private Date endDate;
}