/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;

import lombok.Data;

/**
 * @title ErrorCode
 * @desc 基础公共实体，只包含错误码和错误信息。
 * @author yanmaoyuan
 * @date 2019年4月22日
 * @version 1.0
 */
@Data
public class ErrorCode implements Serializable {

    private static final long serialVersionUID = 3541581919954258806L;

    /**
     * 错误码
     */
    @JsonProperty("errcode")
    private Integer errCode;

    /**
     * 错误提示信息
     */
    @JsonProperty("errmsg")
    private String errMsg;
}