package com.kuaike.scrm.common.service.dto.req.voicematerial;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Map;


/**
 * @author Created by chenjiaqiang on 2022/03/02
 **/
@Data
public class CreateVoiceCallReq implements Serializable {

    private static final long serialVersionUID = 8653013149133886736L;

    private String mobile;

    private String materialId;

    private Map<String, String> materialParams;

    private Long bizId;

    private String corpId;

    public void validate() {
        Preconditions.checkArgument(StringUtils.isNotBlank(mobile), "手机号不能为空");
        Preconditions.checkArgument(materialParams != null, "模板变量不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(materialId), "语音外呼素材id不能为空");

        Preconditions.checkArgument(bizId != null, "bizId不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(corpId), "corpId不能为空");

    }

}
