package com.kuaike.scrm.common.service.dto.req.voicematerial;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.enums.voicecall.VoiceMaterialTypeEnum;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * @author Created by chenjiaqiang on 2022/03/02
 **/
@Data
public class AddVoiceMaterialReq implements Serializable {

    private static final long serialVersionUID = 5710181709262940361L;

    private String name;

    private String fileName;

    private Integer type;

    private String content;

    private String corpId;

    private Long bizId;

    public void validate() {
        Preconditions.checkArgument(StringUtils.isNotBlank(name), "素材名称不能为空");
        Preconditions.checkArgument(name.length() <= 50, "素材名称超长");
        Preconditions.checkArgument(type != null, "素材类型不能为空");
        Preconditions.checkArgument(bizId != null, "bizId不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(corpId), "corpId不能为空");
        VoiceMaterialTypeEnum voiceMaterialTypeEnum = VoiceMaterialTypeEnum.get(type);
        Preconditions.checkArgument(voiceMaterialTypeEnum != null, "素材类型不存在");
        Preconditions.checkArgument(StringUtils.isNotBlank(content), "素材内容不能为空");
        if (VoiceMaterialTypeEnum.VOICE.equals(voiceMaterialTypeEnum)){
            Preconditions.checkArgument(content.startsWith("http"), "语音文件地址非法");
        }
    }

}
