package com.kuaike.scrm.common.service.dto.req.customeracquisition;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * @author Created by chenjiaqiang on 2023/05/18
 **/
@Data
public class SetSharePlanReq implements Serializable {

    private String linkNum;

    private Integer fkType;

    private String fkId;

    private String weworkAllocRuleNum;

    private String channelNum;

    private String addFriendRemark;

    private String welcomeContent;

    /**
     * xxx,xxx,xxx
     */
    private String tagIds;

    /**
     * 备注欢迎语标签是否生效，1生效
     */
    private Integer isAddFriendConfigEnable;

    public void validate() {
        Preconditions.checkArgument(fkType != null, "fkType不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(linkNum), "linkNum不能为空");
        Preconditions.checkArgument(isAddFriendConfigEnable != null, "isAddFriendConfigEnable不能为空");
    }
}
