/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.dto.req;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class CreateContractReqDto
implements Serializable {
    private Long bizId;
    private String corpId;
    private Long userId;
    private Integer contractType;
    private String originContractId;
    private String personalCustomerId;
    private String templateId;
    private Map<String, Object> params;
    private String idNo;
    private String customerName;
    private Integer businessDateType;
    private Long businessDateId;
    private String businessDataNo;

    public void validateParams() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.bizId), (Object)"\u5546\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.corpId), (Object)"corpId\u4e0d\u80fd\u4e3a\u7a7a");
        if (Objects.isNull(this.userId)) {
            this.userId = NumberUtils.LONG_MINUS_ONE;
        }
        Preconditions.checkArgument((boolean)Objects.nonNull(this.contractType), (Object)"\u5408\u540c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (NumberUtils.INTEGER_TWO.equals(this.contractType)) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.originContractId), (Object)"\u539f\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            this.originContractId = "";
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.templateId), (Object)"\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.personalCustomerId), (Object)"\u5ba2\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)MapUtils.isNotEmpty(this.params), (Object)"\u586b\u5145\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.customerName), (Object)"\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.businessDateType), (Object)"\u4e1a\u52a1\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.businessDateId), (Object)"\u4e1a\u52a1\u6570\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.businessDataNo), (Object)"\u4e1a\u52a1\u6570\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public Long getBizId() {
        return this.bizId;
    }

    public String getCorpId() {
        return this.corpId;
    }

    public Long getUserId() {
        return this.userId;
    }

    public Integer getContractType() {
        return this.contractType;
    }

    public String getOriginContractId() {
        return this.originContractId;
    }

    public String getPersonalCustomerId() {
        return this.personalCustomerId;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public String getIdNo() {
        return this.idNo;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public Integer getBusinessDateType() {
        return this.businessDateType;
    }

    public Long getBusinessDateId() {
        return this.businessDateId;
    }

    public String getBusinessDataNo() {
        return this.businessDataNo;
    }

    public void setBizId(Long bizId) {
        this.bizId = bizId;
    }

    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }

    public void setOriginContractId(String originContractId) {
        this.originContractId = originContractId;
    }

    public void setPersonalCustomerId(String personalCustomerId) {
        this.personalCustomerId = personalCustomerId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public void setIdNo(String idNo) {
        this.idNo = idNo;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public void setBusinessDateType(Integer businessDateType) {
        this.businessDateType = businessDateType;
    }

    public void setBusinessDateId(Long businessDateId) {
        this.businessDateId = businessDateId;
    }

    public void setBusinessDataNo(String businessDataNo) {
        this.businessDataNo = businessDataNo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateContractReqDto)) {
            return false;
        }
        CreateContractReqDto other = (CreateContractReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$bizId = this.getBizId();
        Long other$bizId = other.getBizId();
        if (this$bizId == null ? other$bizId != null : !((Object)this$bizId).equals(other$bizId)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Integer this$contractType = this.getContractType();
        Integer other$contractType = other.getContractType();
        if (this$contractType == null ? other$contractType != null : !((Object)this$contractType).equals(other$contractType)) {
            return false;
        }
        Integer this$businessDateType = this.getBusinessDateType();
        Integer other$businessDateType = other.getBusinessDateType();
        if (this$businessDateType == null ? other$businessDateType != null : !((Object)this$businessDateType).equals(other$businessDateType)) {
            return false;
        }
        Long this$businessDateId = this.getBusinessDateId();
        Long other$businessDateId = other.getBusinessDateId();
        if (this$businessDateId == null ? other$businessDateId != null : !((Object)this$businessDateId).equals(other$businessDateId)) {
            return false;
        }
        String this$corpId = this.getCorpId();
        String other$corpId = other.getCorpId();
        if (this$corpId == null ? other$corpId != null : !this$corpId.equals(other$corpId)) {
            return false;
        }
        String this$originContractId = this.getOriginContractId();
        String other$originContractId = other.getOriginContractId();
        if (this$originContractId == null ? other$originContractId != null : !this$originContractId.equals(other$originContractId)) {
            return false;
        }
        String this$personalCustomerId = this.getPersonalCustomerId();
        String other$personalCustomerId = other.getPersonalCustomerId();
        if (this$personalCustomerId == null ? other$personalCustomerId != null : !this$personalCustomerId.equals(other$personalCustomerId)) {
            return false;
        }
        String this$templateId = this.getTemplateId();
        String other$templateId = other.getTemplateId();
        if (this$templateId == null ? other$templateId != null : !this$templateId.equals(other$templateId)) {
            return false;
        }
        Map<String, Object> this$params = this.getParams();
        Map<String, Object> other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        String this$idNo = this.getIdNo();
        String other$idNo = other.getIdNo();
        if (this$idNo == null ? other$idNo != null : !this$idNo.equals(other$idNo)) {
            return false;
        }
        String this$customerName = this.getCustomerName();
        String other$customerName = other.getCustomerName();
        if (this$customerName == null ? other$customerName != null : !this$customerName.equals(other$customerName)) {
            return false;
        }
        String this$businessDataNo = this.getBusinessDataNo();
        String other$businessDataNo = other.getBusinessDataNo();
        return !(this$businessDataNo == null ? other$businessDataNo != null : !this$businessDataNo.equals(other$businessDataNo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateContractReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $bizId = this.getBizId();
        result = result * 59 + ($bizId == null ? 43 : ((Object)$bizId).hashCode());
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Integer $contractType = this.getContractType();
        result = result * 59 + ($contractType == null ? 43 : ((Object)$contractType).hashCode());
        Integer $businessDateType = this.getBusinessDateType();
        result = result * 59 + ($businessDateType == null ? 43 : ((Object)$businessDateType).hashCode());
        Long $businessDateId = this.getBusinessDateId();
        result = result * 59 + ($businessDateId == null ? 43 : ((Object)$businessDateId).hashCode());
        String $corpId = this.getCorpId();
        result = result * 59 + ($corpId == null ? 43 : $corpId.hashCode());
        String $originContractId = this.getOriginContractId();
        result = result * 59 + ($originContractId == null ? 43 : $originContractId.hashCode());
        String $personalCustomerId = this.getPersonalCustomerId();
        result = result * 59 + ($personalCustomerId == null ? 43 : $personalCustomerId.hashCode());
        String $templateId = this.getTemplateId();
        result = result * 59 + ($templateId == null ? 43 : $templateId.hashCode());
        Map<String, Object> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        String $idNo = this.getIdNo();
        result = result * 59 + ($idNo == null ? 43 : $idNo.hashCode());
        String $customerName = this.getCustomerName();
        result = result * 59 + ($customerName == null ? 43 : $customerName.hashCode());
        String $businessDataNo = this.getBusinessDataNo();
        result = result * 59 + ($businessDataNo == null ? 43 : $businessDataNo.hashCode());
        return result;
    }

    public String toString() {
        return "CreateContractReqDto(bizId=" + this.getBizId() + ", corpId=" + this.getCorpId() + ", userId=" + this.getUserId() + ", contractType=" + this.getContractType() + ", originContractId=" + this.getOriginContractId() + ", personalCustomerId=" + this.getPersonalCustomerId() + ", templateId=" + this.getTemplateId() + ", params=" + this.getParams() + ", idNo=" + this.getIdNo() + ", customerName=" + this.getCustomerName() + ", businessDateType=" + this.getBusinessDateType() + ", businessDateId=" + this.getBusinessDateId() + ", businessDataNo=" + this.getBusinessDataNo() + ")";
    }
}

