package com.kuaike.scrm.common.service;

import com.kuaike.scrm.common.enums.SettingEnum;
import com.kuaike.scrm.common.service.dto.req.SettingReqDto;
import com.kuaike.scrm.common.service.dto.resp.SettingRespDto;

import java.util.List;

public interface SettingService {

    /**
     * 查询手机号中间4位是否需要加密
     *
     * @param bizId 商户ID
     * @return
     */
    boolean getMobileEncrypt(Long bizId);

    /**
     *  设置配置
     * */
    SettingRespDto modSetting(SettingReqDto reqDto);

    /**
     * 获取设置信息
     */
    List<SettingRespDto> settingDetails(SettingEnum settingEnum);

    List<SettingRespDto> getSettingList(Long bizId, String value,Integer type);

    /**
     * 获取指定类型配置
     */
    String getSettingDetail(Long bizId, String settingType);

    /**
     * 查询指定参数的 String 值，若未设置此参数则返回默认值 null
     *
     * @param bizId 商户ID
     * @param paramName 参数名
     * @return 参数值，若未设置此参数则返回默认值 null
     */
    String getString(Long bizId, String paramName);

    /**
     * 查询指定参数的 String 值，若未设置此参数则返回 defaultValue
     * @param bizId 商户名
     * @param paramName 参数名
     * @param defaultValue 默认值
     * @return 参数值，若未设置此参数则返回 defaultValue
     */
    String getStringOrDefault(Long bizId, String paramName, String defaultValue);

    /**
     * 查询指定参数的 Boolean 值，若未设置此参数则返回默认值 false
     *
     * @param bizId 商户ID
     * @param paramName 参数名
     * @return 参数值，若未设置此参数则返回默认值 false
     */
    Boolean getBoolean(Long bizId, String paramName);

    /**
     * 查询指定参数的 Boolean 值，若未设置此参数则返回 defaultValue
     * @param bizId 商户名
     * @param paramName 参数名
     * @param defaultValue 默认值
     * @return 参数值，若未设置此参数则返回 defaultValue
     */
    Boolean getBooleanOrDefault(Long bizId, String paramName, Boolean defaultValue);

    /**
     * 查询指定参数的 Long 值，若未设置此参数则返回默认值 0L
     *
     * @param bizId 商户ID
     * @param paramName 参数名
     * @return 参数值，若未设置此参数则返回默认值 0L
     */
    Long getLong(Long bizId, String paramName);

    /**
     * 查询指定参数的 Long 值，若未设置此参数则返回 defaultValue
     * @param bizId 商户名
     * @param paramName 参数名
     * @param defaultValue 默认值
     * @return 参数值，若未设置此参数则返回 defaultValue
     */
    Long getLongOrDefault(Long bizId, String paramName, Long defaultValue);

    /**
     * 查询指定参数的Integer值，若未设置此参数则返回默认值 0
     *
     * @param bizId 商户ID
     * @param paramName 参数名
     * @return 参数值，若未设置此参数则返回默认值 0
     */
    Integer getInteger(Long bizId, String paramName);

    /**
     * 查询指定参数的 Integer 值，若未设置此参数则返回 defaultValue
     * @param bizId 商户名
     * @param paramName 参数名
     * @param defaultValue 默认值
     * @return 参数值，若未设置此参数则返回 defaultValue
     */
    Integer getIntegerOrDefault(Long bizId, String paramName, Integer defaultValue);

    /**
     * 查询指定参数的 Double 值，若未设置此参数则返回默认值 0.0
     *
     * @param bizId 商户ID
     * @param paramName 参数名
     * @return 参数值，若未设置此参数则返回默认值 0.0
     */
    Double getDouble(Long bizId, String paramName);

    /**
     * 查询指定参数的 Double 值，若未设置此参数则返回 defaultValue
     * @param bizId 商户名
     * @param paramName 参数名
     * @param defaultValue 默认值
     * @return 参数值，若未设置此参数则返回 defaultValue
     */
    Double getDoubleOrDefault(Long bizId, String paramName, Double defaultValue);

    /**
     * 查询指定参数的 Float 值，若未设置此参数则返回默认值 0.0F
     *
     * @param bizId 商户ID
     * @param paramName 参数名
     * @return 参数值，若未设置此参数则返回默认值 0.0F
     */
    Float getFloat(Long bizId, String paramName);

    /**
     * 查询指定参数的 Float 值，若未设置此参数则返回 defaultValue
     * @param bizId 商户名
     * @param paramName 参数名
     * @param defaultValue 默认值
     * @return 参数值，若未设置此参数则返回 defaultValue
     */
    Float getFloatOrDefault(Long bizId, String paramName, Float defaultValue);
}
