package com.kuaike.scrm.common.service;

import com.kuaike.scrm.common.service.dto.*;
import com.kuaike.scrm.common.service.dto.req.qrcode.GenQrcodeReq;
import com.kuaike.scrm.common.service.dto.resp.qrcode.GenQrcodeResp;

import java.util.List;

/**
 * 对外创建企业成员二维码接口
 */
public interface QrCodeService {
    /**
     * 创建企微二维码任务
     * @param params
     */
    void addQrcodeTask(AddQrcodeDto params);


    /**
     * 更新是否自动通过
     * @return
     */
    void updateQrcodeAutoPass(AutoPassReq params);

    /**
     * 提供删除企业二维码接口
     * @param
     */
    void delQrcode(String corpId, List<String> configIds);

    /**
     * 设置欢迎语
     * @param corpId
     * @param configDtos
     */
    void setWelcomeConfig(String corpId, List<WelcomeConfigDto> configDtos);

    /**
     * 设置打标签配置
     * @param corpId
     * @param tagConfigDtos
     */
    void setTagConfig(String corpId, List<TagConfigDto> tagConfigDtos);

    /**
     * 加好友备注设置
     * @param corpId
     * @param dto
     */
    void setAddFriendRemarkConfig(String corpId, AddFriendRemarkConfigDto dto);

    /**
     * 同步生成企微二维码
     * @param req
     * @return
     */
    GenQrcodeResp genQrcode(GenQrcodeReq req);
}
