/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.dto.req;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ScrmSkuItemDto
implements Serializable {
    String productId;
    String skuId;
    String outProductId;
    String outSkuId;
    String thumbImg;
    Long salePrice;
    Long marketPrice;
    Long stockNum = 9999999L;
    String skuCode;
    String barCode;

    public void validate() {
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)this.outProductId) && StringUtils.length((CharSequence)this.outProductId) <= 32 ? 1 : 0) != 0, (Object)"outProductId\u4e0d\u80fd\u4e3a\u7a7a,\u4e14\u6700\u5927\u957f\u5ea6\u4e3a32");
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)this.outSkuId) && StringUtils.length((CharSequence)this.outSkuId) <= 32 ? 1 : 0) != 0, (Object)"outSkuId\u4e0d\u80fd\u4e3a\u7a7a,\u4e14\u6700\u5927\u957f\u5ea6\u4e3a32");
        Preconditions.checkArgument((Objects.nonNull(this.salePrice) && this.salePrice >= 0L && this.salePrice <= 10000000000000L ? 1 : 0) != 0, (Object)"salePrice\u4ee5\u6beb\u4e3a\u5355\u4f4d\uff0c\u4e0d\u8d85\u8fc71000000000");
        if (Objects.nonNull(this.marketPrice)) {
            Preconditions.checkArgument((this.marketPrice >= 0L && this.marketPrice <= 10000000000000L ? 1 : 0) != 0, (Object)"marketPrice\u4ee5\u6beb\u4e3a\u5355\u4f4d\uff0c\u4e0d\u8d85\u8fc71000000000");
            Preconditions.checkArgument((this.marketPrice >= this.salePrice ? 1 : 0) != 0, (Object)"marketPrice\u5fc5\u987b\u6bd4salePrice\u5927");
        }
        Preconditions.checkArgument((Objects.nonNull(this.stockNum) && this.stockNum > 0L ? 1 : 0) != 0, (Object)"stockNum\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public ScrmSkuItemDto() {
    }

    public ScrmSkuItemDto(String productId, String skuId, String outProductId, String outSkuId, String thumbImg, Long salePrice, Long marketPrice, Long stockNum, String skuCode, String barCode) {
        this.productId = productId;
        this.skuId = skuId;
        this.outProductId = outProductId;
        this.outSkuId = outSkuId;
        this.thumbImg = thumbImg;
        this.salePrice = salePrice;
        this.marketPrice = marketPrice;
        this.stockNum = stockNum;
        this.skuCode = skuCode;
        this.barCode = barCode;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getSkuId() {
        return this.skuId;
    }

    public String getOutProductId() {
        return this.outProductId;
    }

    public String getOutSkuId() {
        return this.outSkuId;
    }

    public String getThumbImg() {
        return this.thumbImg;
    }

    public Long getSalePrice() {
        return this.salePrice;
    }

    public Long getMarketPrice() {
        return this.marketPrice;
    }

    public Long getStockNum() {
        return this.stockNum;
    }

    public String getSkuCode() {
        return this.skuCode;
    }

    public String getBarCode() {
        return this.barCode;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public void setSkuId(String skuId) {
        this.skuId = skuId;
    }

    public void setOutProductId(String outProductId) {
        this.outProductId = outProductId;
    }

    public void setOutSkuId(String outSkuId) {
        this.outSkuId = outSkuId;
    }

    public void setThumbImg(String thumbImg) {
        this.thumbImg = thumbImg;
    }

    public void setSalePrice(Long salePrice) {
        this.salePrice = salePrice;
    }

    public void setMarketPrice(Long marketPrice) {
        this.marketPrice = marketPrice;
    }

    public void setStockNum(Long stockNum) {
        this.stockNum = stockNum;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScrmSkuItemDto)) {
            return false;
        }
        ScrmSkuItemDto other = (ScrmSkuItemDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$salePrice = this.getSalePrice();
        Long other$salePrice = other.getSalePrice();
        if (this$salePrice == null ? other$salePrice != null : !((Object)this$salePrice).equals(other$salePrice)) {
            return false;
        }
        Long this$marketPrice = this.getMarketPrice();
        Long other$marketPrice = other.getMarketPrice();
        if (this$marketPrice == null ? other$marketPrice != null : !((Object)this$marketPrice).equals(other$marketPrice)) {
            return false;
        }
        Long this$stockNum = this.getStockNum();
        Long other$stockNum = other.getStockNum();
        if (this$stockNum == null ? other$stockNum != null : !((Object)this$stockNum).equals(other$stockNum)) {
            return false;
        }
        String this$productId = this.getProductId();
        String other$productId = other.getProductId();
        if (this$productId == null ? other$productId != null : !this$productId.equals(other$productId)) {
            return false;
        }
        String this$skuId = this.getSkuId();
        String other$skuId = other.getSkuId();
        if (this$skuId == null ? other$skuId != null : !this$skuId.equals(other$skuId)) {
            return false;
        }
        String this$outProductId = this.getOutProductId();
        String other$outProductId = other.getOutProductId();
        if (this$outProductId == null ? other$outProductId != null : !this$outProductId.equals(other$outProductId)) {
            return false;
        }
        String this$outSkuId = this.getOutSkuId();
        String other$outSkuId = other.getOutSkuId();
        if (this$outSkuId == null ? other$outSkuId != null : !this$outSkuId.equals(other$outSkuId)) {
            return false;
        }
        String this$thumbImg = this.getThumbImg();
        String other$thumbImg = other.getThumbImg();
        if (this$thumbImg == null ? other$thumbImg != null : !this$thumbImg.equals(other$thumbImg)) {
            return false;
        }
        String this$skuCode = this.getSkuCode();
        String other$skuCode = other.getSkuCode();
        if (this$skuCode == null ? other$skuCode != null : !this$skuCode.equals(other$skuCode)) {
            return false;
        }
        String this$barCode = this.getBarCode();
        String other$barCode = other.getBarCode();
        return !(this$barCode == null ? other$barCode != null : !this$barCode.equals(other$barCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScrmSkuItemDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $salePrice = this.getSalePrice();
        result = result * 59 + ($salePrice == null ? 43 : ((Object)$salePrice).hashCode());
        Long $marketPrice = this.getMarketPrice();
        result = result * 59 + ($marketPrice == null ? 43 : ((Object)$marketPrice).hashCode());
        Long $stockNum = this.getStockNum();
        result = result * 59 + ($stockNum == null ? 43 : ((Object)$stockNum).hashCode());
        String $productId = this.getProductId();
        result = result * 59 + ($productId == null ? 43 : $productId.hashCode());
        String $skuId = this.getSkuId();
        result = result * 59 + ($skuId == null ? 43 : $skuId.hashCode());
        String $outProductId = this.getOutProductId();
        result = result * 59 + ($outProductId == null ? 43 : $outProductId.hashCode());
        String $outSkuId = this.getOutSkuId();
        result = result * 59 + ($outSkuId == null ? 43 : $outSkuId.hashCode());
        String $thumbImg = this.getThumbImg();
        result = result * 59 + ($thumbImg == null ? 43 : $thumbImg.hashCode());
        String $skuCode = this.getSkuCode();
        result = result * 59 + ($skuCode == null ? 43 : $skuCode.hashCode());
        String $barCode = this.getBarCode();
        result = result * 59 + ($barCode == null ? 43 : $barCode.hashCode());
        return result;
    }

    public String toString() {
        return "ScrmSkuItemDto(productId=" + this.getProductId() + ", skuId=" + this.getSkuId() + ", outProductId=" + this.getOutProductId() + ", outSkuId=" + this.getOutSkuId() + ", thumbImg=" + this.getThumbImg() + ", salePrice=" + this.getSalePrice() + ", marketPrice=" + this.getMarketPrice() + ", stockNum=" + this.getStockNum() + ", skuCode=" + this.getSkuCode() + ", barCode=" + this.getBarCode() + ")";
    }
}

