package com.kuaike.scrm.common.service.dto.req;

import com.google.common.base.Preconditions;
import lombok.Data;

import java.io.Serializable;
import java.util.Collection;

/**
 * @Date: 2022/10/19 15:36
 * @Author: dayu
 */
@Data
public class ScrmProductQueryReq implements Serializable {

    private Long bizId;

    /**
     * productIds 商品ID
     * outProductIds  商品外部ID 对应的第三方的商品ID
     * <p>
     * 两者不能同时为空， 不能同时存在， 选其一
     */
    private Collection<String> productIds;

    private Collection<String> outProductIds;

    private Integer source;

    public void validate() {
        Preconditions.checkArgument(productIds != null || outProductIds != null, "查询的商品ID不能为空");
        Preconditions.checkArgument(!(productIds != null && outProductIds != null), "查询条件选择其一");
    }
}
