package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author chenjiaqiang
 */
public enum CallTypeEnum implements EnumService {
    MANUAL(0, "人工外呼"),

    AI(1, "AI外呼"),

    VOICE(2, "语音外呼");

    private int value;
    private String name;

    CallTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return name;
    }

    private static final Map<Integer, CallTypeEnum> cache;

    static {
        cache = new HashMap<>();
        for (CallTypeEnum item : CallTypeEnum.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static CallTypeEnum get(Integer value) {
        return cache.get(value);
    }
}
