package com.kuaike.scrm.websocket.service.dto;

import lombok.Data;

import java.io.Serializable;

@Data
public class WsRestResponse<T extends Serializable> implements Serializable {

    private static final long serialVersionUID = 1L;

    private long code;

    private String msg;

    private T data;

    public WsRestResponse() {}

    public WsRestResponse(long code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public WsRestResponse<T> badRequest() {
        this.code = 400;
        return this;
    }

    public WsRestResponse<T> okRequest() {
        this.code = 200;
        return this;
    }

    public WsRestResponse<T> data(T data) {
        this.data = data;
        return this;
    }

    public WsRestResponse<T> msg(String msg) {
        this.msg = msg;
        return this;
    }

    public WsRestResponse<T> code(long code) {
        this.code = code;
        return this;
    }


    public static <T extends Serializable> WsRestResponse<T> ok(T data) {
        return new WsRestResponse<>(0, "", data);
    }
}
