package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum StageType {
    UN_FLOWING(0, "未跟进"),
    FLOWING(1, "跟进中"),
    END(2, "跟进结束");

    private final int value;
    private final String desc;

    StageType(int id, String name) {
        this.value = id;
        this.desc = name;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, StageType> CACHE;

    static {
        CACHE = new HashMap<>(3);
        for (StageType item : StageType.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static StageType get(Integer status) {
        return CACHE.get(status);
    }
}