package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum NetSchoolGoodsTypeEnum {
    COURSE(1, "课程"),
    CLASS(2, "班级");

    private final int value;
    private final String desc;

    NetSchoolGoodsTypeEnum(int id, String name) {
        this.value = id;
        this.desc = name;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, NetSchoolGoodsTypeEnum> CACHE;

    static {
        CACHE = new HashMap<>(3);
        for (NetSchoolGoodsTypeEnum item : NetSchoolGoodsTypeEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static NetSchoolGoodsTypeEnum get(Integer status) {
        return CACHE.get(status);
    }
}