package com.kuaike.scrm.common.service;

import com.kuaike.scrm.common.service.dto.resp.ChannelDto;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 渠道接口
 *
 * @author yanmaoyuan
 * @date 2021/9/14
 */
public interface ScrmChannelService {

    ChannelDto getById(Long bizId, Long id);

    ChannelDto getByNum(Long bizId, String num);

    /**
     * 根据ID批量查询渠道
     *
     * @param bizId 商户ID
     * @param ids 渠道ID
     * @return 渠道列表
     */
    List<ChannelDto> getByIds(Long bizId, Collection<Long> ids);

    /**
     * 根据ID批量查询渠道名称
     *
     * @param bizId 商户ID
     * @param ids 渠道ID
     * @return key:渠道id, value:渠道名
     */
    Map<Long, String> getNameByIds(Long bizId, Collection<Long> ids);

    /**
     * 查询渠道num对应的id
     *
     * @param bizId 商户ID
     * @param nums 渠道num
     * @return key:num, value:id
     */
    Map<String, Long> getIdByNums(Long bizId, Collection<String> nums);

    /**
     * 查询渠道id对应的num
     *
     * @param ids 渠道id
     * @return key:id, value:num
     */
    Map<Long, String> getNumByIds(Long bizId, Collection<Long> ids);

    /**
     * 根据渠道名精确查找渠道信息
     *
     * @param bizId
     * @param name
     * @return
     */
    ChannelDto getByName(Long bizId, String name);

    List<ChannelDto> queryInnerChannels();

    /**
     * 获取高校渠道组下的所有未删除、未禁用的渠道
     */
    List<ChannelDto> queryHighSchoolChannels(Long bizId);

    Map<String, String> getNameByNums(Long bizId, Collection<String> nums);
}