package com.kuaike.scrm.common.service.dto.req;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

/**
 * @author sunwen
 */
@Data
public class CreateContractReqDto implements Serializable {

    private Long bizId;

    private String corpId;

    private Long userId;

    /**
     * 合同类型 1：正常合同 2：废除合同
     */
    private Integer contractType;

    /**
     * 原合同id
     */
    private String originContractId;

    /**
     * 客户id
     */
    private String personalCustomerId;

    private String templateId;

    private Map<String, Object> params;//NOSONAR

    private String idNo;

    private String customerName;

    private Integer businessDateType;

    private Long businessDateId;

    private String businessDataNo;

    public void validateParams() {
        Preconditions.checkArgument(Objects.nonNull(bizId), "商户id不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(corpId), "corpId不能为空");
        if (Objects.isNull(userId)) {
            userId = NumberUtils.LONG_MINUS_ONE;
        }
        Preconditions.checkArgument(Objects.nonNull(contractType), "合同类型不能为空");
        if (NumberUtils.INTEGER_TWO.equals(contractType)) {
            Preconditions.checkArgument(StringUtils.isNotBlank(originContractId), "原合同id不能为空");
        } else {
            originContractId = "";
            Preconditions.checkArgument(StringUtils.isNotBlank(templateId), "模板id不能为空");
        }

        Preconditions.checkArgument(StringUtils.isNotBlank(personalCustomerId), "客户id不能为空");
        Preconditions.checkArgument(MapUtils.isNotEmpty(params), "填充参数不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(customerName), "客户名称不能为空");
        Preconditions.checkArgument(Objects.nonNull(businessDateType), "业务数据类型不能为空");
        Preconditions.checkArgument(Objects.nonNull(businessDateId), "业务数据id不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(businessDataNo), "业务数据编号不能为空");
    }
}
