package com.kuaike.scrm.common.service;

import com.kuaike.scrm.common.service.dto.req.ScrmMarkWeworkTagReqDto;
import com.kuaike.scrm.common.service.dto.resp.AppletResp;
import com.kuaike.scrm.common.service.dto.resp.ContactAssociateResp;
import com.kuaike.scrm.common.service.dto.resp.OfficialResp;
import com.kuaike.scrm.common.service.dto.resp.WeworkContactResp;

import java.util.Collection;
import java.util.List;

/**
 * 根据手机号，查询企业客户的接口
 *
 * @author yanmaoyuan
 * @date 2021/9/24
 */
public interface ScrmContactService {

    /**
     * 根据手机号查询企业客户
     *
     * @param corpId 企业ID
     * @param mobile 手机号
     */
    WeworkContactResp search(String corpId, String mobile);

    /**
     * 根据手机号查询企业客户
     *
     * @param corpId  企业ID
     * @param mobiles 手机号
     */
    List<WeworkContactResp> search(String corpId, Collection<String> mobiles);

    List<ContactAssociateResp> queryContactAssociate(String corpId, String customerNum, List<String> mobiles);

    /**
     * 根据appId查询公众号信息
     *
     * @param appId appId
     * @return
     */
    OfficialResp official(String appId);

    /**
     * 根据appId查询小程序信息
     *
     * @param appId appId
     * @return
     */
    AppletResp miniProgram(String appId);

    /**
     * crm打标签同步企微
     *
     * @param scrmMarkWeworkTagReqDto scrmMarkWeworkTagReqDto
     * @return
     */
    void markWeworkTag(ScrmMarkWeworkTagReqDto scrmMarkWeworkTagReqDto);

    /**
     * 更新外部联系人的订单数量
     **/
    void increaseOrderCountByCustomerNum(String corpId, String customerNum, Long orderStaff);

}