package com.kuaike.scrm.common.service;

import com.kuaike.scrm.common.service.dto.req.AddNoticeReq;
import com.kuaike.scrm.common.service.dto.req.NoticeQueryReq;
import com.kuaike.scrm.common.service.dto.resp.NoticeItemDto;
import com.kuaike.scrm.common.service.dto.resp.notice.FollowAppointmentStatisticItem;

import java.util.List;

public interface NoticeService {

    void addNotice(AddNoticeReq req);

    void dealNotice(Long userId, String num);

    /**
     * 全部已读
     *
     * @param userId
     */
    void dealAll(Long bizId, Long userId);

    List<NoticeItemDto> getNoticeList(NoticeQueryReq req);

    /**
     * 预约待跟进统计
     *
     * @param req
     * @return
     */
    List<FollowAppointmentStatisticItem> followAppointmentStatistics(NoticeQueryReq req);

    /**
     * 跟进预约记录列表
     *
     * @param req
     * @return
     */
    List<NoticeItemDto> followAppointList(NoticeQueryReq req);

    /**
     * 填充历史预约提醒数据的customer_num
     *
     * @param bizId
     */
    void backfill(Long bizId);

    void sendCrmAppointmentNotice();
}
