/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wwlogin.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.setting.dto.req.SetAgentSecretReq;
import com.kuaike.scrm.setting.dto.req.SetCorpSecretReq;
import com.kuaike.scrm.setting.dto.resp.GetAgentTokenCfg;
import com.kuaike.scrm.setting.dto.resp.GetCorpTokenCfg;
import com.kuaike.scrm.setting.service.SettingAgentService;
import com.kuaike.scrm.setting.service.SettingContactService;
import com.kuaike.scrm.setting.service.SettingExternalService;
import com.kuaike.scrm.wwlogin.dto.ChatMenuDto;
import com.kuaike.scrm.wwlogin.dto.req.CreateReq;
import com.kuaike.scrm.wwlogin.dto.resp.ApiAccessibleApps;
import com.kuaike.scrm.wwlogin.dto.resp.ChatMenu;
import com.kuaike.scrm.wwlogin.dto.resp.ChatMenuItem;
import com.kuaike.scrm.wwlogin.dto.resp.CorpApplication;
import com.kuaike.scrm.wwlogin.dto.resp.DefaultApp;
import com.kuaike.scrm.wwlogin.dto.resp.ErrorResult;
import com.kuaike.scrm.wwlogin.dto.resp.MemList;
import com.kuaike.scrm.wwlogin.dto.resp.Member;
import com.kuaike.scrm.wwlogin.dto.resp.OpenapiApp;
import com.kuaike.scrm.wwlogin.dto.resp.Party;
import com.kuaike.scrm.wwlogin.dto.resp.PartyList;
import com.kuaike.scrm.wwlogin.dto.resp.WwResult;
import com.kuaike.scrm.wwlogin.exception.WwBotException;
import com.kuaike.scrm.wwlogin.service.WwbotService;
import com.kuaike.scrm.wwlogin.utils.BotLoginUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Deprecated
public class WwbotServiceImpl
implements WwbotService {
    private static final Logger log = LoggerFactory.getLogger(WwbotServiceImpl.class);
    private static final String CALENDAR_APP_NAME = "\u65e5\u7a0b";
    private static final String EXTERNAL_APP_NAME = "\u5916\u90e8\u8054\u7cfb\u4eba";
    private static final String CONTACT_APP_NAME = "\u901a\u8baf\u5f55\u540c\u6b65\u52a9\u624b";
    @Value(value="${qyapi.agent.name:\u767e\u5bb6\u4e91\u52a9\u624b}")
    private String name;
    @Value(value="${qyapi.agent.desc:\u767e\u5bb6\u4e91\u52a9\u624b\u7684\u81ea\u5efa\u5e94\u7528}")
    private String desc;
    @Value(value="${qyapi.agent.chatMenu}")
    private String chatMenuJson;
    @Value(value="${qyapi.domain.scrm-callback}")
    private String callbackHost;
    @Value(value="${qyapi.domain.scrm-manager}")
    private String redirectDomain;
    @Value(value="http://${qyapi.domain.scrm-manager}")
    private String managerRoot;
    @Value(value="http://${qyapi.domain.scrm-manager}")
    private String homepage;
    @Value(value="${qyapi.agent.logo}")
    private String logoimage;
    @Autowired
    private SettingAgentService settingAgentService;
    @Autowired
    private SettingContactService settingContactService;
    @Autowired
    private SettingExternalService settingExternalService;

    public static URI buildUri(String api, List<NameValuePair> parameters) {
        URI uri;
        try {
            URIBuilder builder = new URIBuilder(api).addParameter("lang", "zh_CN").addParameter("f", "json").addParameter("ajax", "1").addParameter("timeZoneInfo[zone_offset]", "-8").addParameter("random", String.valueOf(Math.random()));
            if (CollectionUtils.isNotEmpty(parameters)) {
                builder.addParameters(parameters);
            }
            uri = builder.build();
        }
        catch (URISyntaxException e) {
            log.error("\u65e0\u6cd5\u521b\u5efa\u81ea\u5efa\u5e94\u7528\uff0c\u7cfb\u4f01\u4e1a\u5fae\u4fe1url\u5f02\u5e38\u3002api:{}", (Object)api);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u521b\u5efa\u81ea\u5efa\u5e94\u7528\u5931\u8d25");
        }
        return uri;
    }

    public static String get(String api, List<NameValuePair> parameters) {
        log.info("GET:{}, parameters:{}", (Object)api, parameters);
        if (CollectionUtils.isEmpty(parameters)) {
            parameters = Lists.newArrayList();
        }
        String d2st = BotLoginUtils.d2st();
        parameters.add(new BasicNameValuePair("_d2st", d2st));
        URI uri = WwbotServiceImpl.buildUri(api, parameters);
        HttpGet request = new HttpGet(uri);
        request.setHeader("content-type", "application/x-www-form-urlencoded");
        return WwbotServiceImpl.send((HttpRequestBase)request);
    }

    public static String post(String api, List<NameValuePair> formdata) {
        log.info("POST:{}, formdata:{}", (Object)api, formdata);
        URI uri = WwbotServiceImpl.buildUri(api, Collections.emptyList());
        HttpPost request = new HttpPost(uri);
        if (CollectionUtils.isEmpty(formdata)) {
            formdata = Lists.newArrayList();
        }
        String d2st = BotLoginUtils.d2st();
        formdata.add(new BasicNameValuePair("_d2st", d2st));
        UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity((Iterable)formdata, StandardCharsets.UTF_8);
        request.setEntity((HttpEntity)formEntity);
        return WwbotServiceImpl.send((HttpRequestBase)request);
    }

    public static String send(HttpRequestBase request) {
        BotLoginUtils.addBasicHeaders((HttpMessage)request);
        BotLoginUtils.addAjaxHeaders((HttpMessage)request);
        request.setHeader("referer", "https://work.weixin.qq.com/wework_admin/frame");
        BotLoginUtils.addCookieHeader((HttpMessage)request);
        RequestConfig config = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
        request.setConfig(config);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        String result = null;
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
            result = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            log.error("Failed send request", (Throwable)e);
        }
        log.info("response: {}", (Object)result);
        return result;
    }

    public <T> T getResult(String json, TypeReference<WwResult<T>> valueType) {
        WwResult wwResult = null;
        try {
            wwResult = (WwResult)JacksonUtil.str2Obj((String)json, valueType);
        }
        catch (IOException e) {
            log.error("Failed parse json:{}", (Object)json, (Object)e);
            return null;
        }
        if (wwResult.getResult() != null) {
            ErrorResult err = wwResult.getResult();
            throw new WwBotException(err);
        }
        return wwResult.getData();
    }

    @Override
    public List<Party> party() {
        log.info("get party, operatorId:{}", (Object)LoginUtils.getCurrentUserId());
        String api = "https://work.weixin.qq.com/wework_admin/contacts/party/cache";
        ArrayList formdata = Lists.newArrayList();
        formdata.add(new BasicNameValuePair("_d2st", BotLoginUtils.d2st()));
        String result = WwbotServiceImpl.post(api, formdata);
        PartyList partyList = this.getResult(result, new TypeReference<WwResult<PartyList>>(){});
        return partyList.getPartyList().getList();
    }

    @Override
    public List<Member> member() {
        log.info("get party, operatorId:{}", (Object)LoginUtils.getCurrentUserId());
        String api = "https://work.weixin.qq.com/wework_admin/contacts/member/cache";
        ArrayList formdata = Lists.newArrayList();
        formdata.add(new BasicNameValuePair("_d2st", BotLoginUtils.d2st()));
        String result = WwbotServiceImpl.post(api, formdata);
        MemList memList = this.getResult(result, new TypeReference<WwResult<MemList>>(){});
        return memList.getMems();
    }

    @Override
    public String create(CreateReq params) {
        log.info("create agent, params:{}, operatorId:{}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        String corpId = (String)BotLoginUtils.getSession().getAttribute("window.settings.encode_corp_id");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)corpId), (Object)"\u7528\u6237\u672a\u767b\u5f55");
        List<String> pids = params.getPids();
        List<String> vids = params.getVids();
        Preconditions.checkArgument((CollectionUtils.isNotEmpty(pids) || CollectionUtils.isNotEmpty(vids) ? 1 : 0) != 0, (Object)"vids\u4e0epids\u4e0d\u53ef\u5168\u4e3a\u7a7a");
        CorpApplication corpApps = this.getCorpApplication();
        List<DefaultApp> defaultApps = corpApps.getDefaultApps();
        List<OpenapiApp> openapiApps = corpApps.getOpenapiApps();
        DefaultApp calendarApp = null;
        if (CollectionUtils.isNotEmpty(defaultApps)) {
            for (DefaultApp app : defaultApps) {
                if (!CALENDAR_APP_NAME.equals(app.getAppName())) continue;
                calendarApp = app;
                log.info("Found {}:{}", (Object)CALENDAR_APP_NAME, (Object)calendarApp);
                break;
            }
        }
        OpenapiApp externalApp = null;
        OpenapiApp contactApp = null;
        OpenapiApp agent = null;
        if (CollectionUtils.isNotEmpty(openapiApps)) {
            for (OpenapiApp app : openapiApps) {
                if (app.getServiceCorpId() != null) {
                    log.info("\u5ffd\u7565\u7b2c\u4e09\u65b9\u5e94\u7528:{}", (Object)app.getName());
                    continue;
                }
                if (app.getAgentId() > 2000000) {
                    if (EXTERNAL_APP_NAME.equals(app.getName())) {
                        externalApp = app;
                        log.info("Found {}:{}", (Object)EXTERNAL_APP_NAME, (Object)externalApp);
                        continue;
                    }
                    if (!CONTACT_APP_NAME.equals(app.getName())) continue;
                    contactApp = app;
                    log.info("Found {}:{}", (Object)CONTACT_APP_NAME, (Object)contactApp);
                    continue;
                }
                if (this.name.equals(app.getName())) {
                    agent = app;
                    log.info("Found {}:{}", (Object)this.name, (Object)agent);
                    break;
                }
                log.info("\u5ffd\u7565\u81ea\u5efa\u5e94\u7528:{}", (Object)app.getName());
            }
        }
        if (agent == null) {
            agent = this.addOpenApiApp(params);
            corpApps = this.getCorpApplication();
            openapiApps = corpApps.getOpenapiApps();
            if (CollectionUtils.isNotEmpty(openapiApps)) {
                for (OpenapiApp app : openapiApps) {
                    if (app.getServiceCorpId() != null || app.getAgentId() > 2000000 || !this.name.equals(app.getName())) continue;
                    agent = app;
                    log.info("Found {}:{}", (Object)this.name, (Object)agent);
                    break;
                }
            }
        } else {
            this.checkAgentInfo(params, agent);
        }
        this.checkApiAccessibleApps(calendarApp, agent);
        this.checkApiAccessibleApps(externalApp, agent);
        GetAgentTokenCfg agentCfg = this.settingAgentService.detail();
        GetCorpTokenCfg externalCfg = this.settingExternalService.detail();
        this.checkAgentId(agent);
        this.checkAgentCallback(agent, agentCfg);
        this.checkAgentHome(agent);
        this.checkAgentChatMenu(agent, corpId);
        this.checkAgentJssdk(agent);
        this.checkAgentWebApp(agent);
        this.checkExternalCallback(externalApp, externalCfg);
        this.checkContactApiOpen(contactApp);
        this.sendTwoFactorAuthOperation(agent.getAppId());
        if (externalApp != null) {
            this.sendTwoFactorAuthOperation(externalApp.getAppId());
        }
        if (contactApp != null) {
            this.sendTwoFactorAuthOperation(contactApp.getAppId());
        }
        return agent.getAppId();
    }

    private CorpApplication getCorpApplication() {
        log.info("get corp application, operatorId:{}", (Object)LoginUtils.getCurrentUserId());
        String api = "https://work.weixin.qq.com/wework_admin/getCorpApplication";
        ArrayList formdata = Lists.newArrayList();
        formdata.add(new BasicNameValuePair("app_type", "0"));
        String result = WwbotServiceImpl.post(api, formdata);
        return this.getResult(result, new TypeReference<WwResult<CorpApplication>>(){});
    }

    private OpenapiApp addOpenApiApp(CreateReq params) {
        List<String> vids;
        log.info("add openapi app, params:{}", (Object)params);
        String api = "https://work.weixin.qq.com/wework_admin/apps/addOpenApiApp";
        ArrayList formdata = Lists.newArrayList();
        formdata.add(new BasicNameValuePair("name", this.name));
        formdata.add(new BasicNameValuePair("description", this.desc));
        formdata.add(new BasicNameValuePair("english_name", ""));
        formdata.add(new BasicNameValuePair("english_description", ""));
        formdata.add(new BasicNameValuePair("logoimage", this.logoimage));
        formdata.add(new BasicNameValuePair("app_open", "true"));
        List<String> pids = params.getPids();
        if (CollectionUtils.isNotEmpty(pids)) {
            for (String string : pids) {
                if (!StringUtils.isNotBlank((CharSequence)string)) continue;
                formdata.add(new BasicNameValuePair("visible_pid[]", string));
            }
        }
        if (CollectionUtils.isNotEmpty(vids = params.getVids())) {
            for (String vid : vids) {
                if (!StringUtils.isNotBlank((CharSequence)vid)) continue;
                formdata.add(new BasicNameValuePair("visible_vid[]", vid));
            }
        }
        String string = WwbotServiceImpl.post(api, formdata);
        return this.getResult(string, new TypeReference<WwResult<OpenapiApp>>(){});
    }

    private List<String> getApiAccessibleApps(String businessId) {
        log.info("get api accessible apps, businessId:{}", (Object)businessId);
        String api = "https://work.weixin.qq.com/wework_admin/apps/getApiAccessibleApps";
        ArrayList parameters = Lists.newArrayList();
        parameters.add(new BasicNameValuePair("businessId", businessId));
        String result = WwbotServiceImpl.get(api, parameters);
        ApiAccessibleApps resp = this.getResult(result, new TypeReference<WwResult<ApiAccessibleApps>>(){});
        return resp.getAuthList().getAppidList();
    }

    private void setApiAccessibleApps(String businessId, List<String> appIds) {
        log.info("set api accessible apps, businessId:{}, appIds:{}", (Object)businessId, appIds);
        String api = "https://work.weixin.qq.com/wework_admin/apps/setApiAccessibleApps";
        ArrayList formdata = Lists.newArrayList();
        formdata.add(new BasicNameValuePair("businessId", businessId));
        for (String appId : appIds) {
            if (!StringUtils.isNotBlank((CharSequence)appId)) continue;
            formdata.add(new BasicNameValuePair("auth_list[appid_list][]", appId));
        }
        String result = WwbotServiceImpl.post(api, formdata);
        this.getResult(result, new TypeReference<WwResult<Map<String, Object>>>(){});
    }

    private void saveOpenApiApp(List<NameValuePair> formdata) {
        log.info("save open api app, formdata:{}", formdata);
        String api = "https://work.weixin.qq.com/wework_admin/apps/saveOpenApiApp";
        String result = WwbotServiceImpl.post(api, formdata);
        this.getResult(result, new TypeReference<WwResult<Map<String, Object>>>(){});
    }

    private void setHomeUrl(List<NameValuePair> formdata) {
        log.info("setHomeUrl, formdata:{}", formdata);
        String api = "https://work.weixin.qq.com/wework_admin/apps/xcx/setting";
        String result = WwbotServiceImpl.post(api, formdata);
        this.getResult(result, new TypeReference<WwResult<Map<String, Object>>>(){});
    }

    private ChatMenu getChatMenu() {
        log.info("getChatMenu");
        String api = "https://work.weixin.qq.com/wework_admin/customer/getChatMenu";
        String result = WwbotServiceImpl.get(api, Collections.emptyList());
        return this.getResult(result, new TypeReference<WwResult<ChatMenu>>(){});
    }

    private List<ChatMenuItem> addChatMenu(OpenapiApp app, String itemName, String itemInfo) {
        log.info("addChatMenu, name:{}, url:{}", (Object)itemName, (Object)itemInfo);
        String api = "https://work.weixin.qq.com/wework_admin/customer/addChatMenu";
        ArrayList formdata = Lists.newArrayList();
        formdata.add(new BasicNameValuePair("banner_list[0][corp_app][app_id]", app.getAppId()));
        formdata.add(new BasicNameValuePair("banner_list[0][corpAppModel][app_open]", "1"));
        formdata.add(new BasicNameValuePair("banner_list[0][corpAppModel][isThirdApp]", "0"));
        formdata.add(new BasicNameValuePair("banner_list[0][corpAppModel][isMiniApp]", "0"));
        formdata.add(new BasicNameValuePair("banner_list[0][corpAppModel][id]", app.getAppId()));
        formdata.add(new BasicNameValuePair("banner_list[0][corpAppModel][logoimage]", app.getImgid()));
        formdata.add(new BasicNameValuePair("banner_list[0][corpAppModel][name]", app.getName()));
        formdata.add(new BasicNameValuePair("banner_list[0][corpAppModel][sm_imgid]", app.getImgid()));
        if (app.getHomeInfo() != null && app.getHomeInfo().getUrl() != null) {
            formdata.add(new BasicNameValuePair("banner_list[0][corpAppModel][has_url]", app.getHomeInfo().getUrl()));
        }
        formdata.add(new BasicNameValuePair("banner_list[0][item_type]", "1"));
        formdata.add(new BasicNameValuePair("banner_list[0][name]", itemName));
        formdata.add(new BasicNameValuePair("banner_list[0][item_name]", itemName));
        formdata.add(new BasicNameValuePair("banner_list[0][item_info]", itemInfo));
        String result = WwbotServiceImpl.post(api, formdata);
        return this.getResult(result, new TypeReference<WwResult<List<ChatMenuItem>>>(){});
    }

    private List<ChatMenuItem> publishChatMenu(List<ChatMenuItem> items) {
        log.info("publish chat menu, items:{}", items);
        String api = "https://work.weixin.qq.com/wework_admin/customer/publishChatMenu";
        ArrayList formdata = Lists.newArrayList();
        int idx = 0;
        int order = 10;
        for (ChatMenuItem item : items) {
            String bannerList = "banner_list[" + idx + "]";
            formdata.add(new BasicNameValuePair(bannerList + "[item_id]", item.getItemId()));
            formdata.add(new BasicNameValuePair(bannerList + "[item_name]", item.getItemName()));
            formdata.add(new BasicNameValuePair(bannerList + "[item_type]", String.valueOf(item.getItemType())));
            if (StringUtils.isNotBlank((CharSequence)item.getItemInfo())) {
                formdata.add(new BasicNameValuePair(bannerList + "[item_info]", item.getItemInfo()));
            }
            formdata.add(new BasicNameValuePair(bannerList + "[order]", String.valueOf(order)));
            if (item.getCorpApp() != null) {
                formdata.add(new BasicNameValuePair(bannerList + "[corp_app][app_id]", item.getCorpApp().getAppId()));
                formdata.add(new BasicNameValuePair(bannerList + "[corp_app][app_open]", "1"));
            }
            if (item.getType() != null) {
                formdata.add(new BasicNameValuePair(bannerList + "[type]", String.valueOf(item.getType())));
            }
            if (StringUtils.isNotBlank((CharSequence)item.getEnItemName())) {
                formdata.add(new BasicNameValuePair(bannerList + "[en_item_name]", item.getEnItemName()));
            }
            if (item.getCreateTime() != null) {
                formdata.add(new BasicNameValuePair(bannerList + "[create_time]", String.valueOf(item.getCreateTime())));
            }
            ++idx;
            order += 10;
        }
        String result = WwbotServiceImpl.post(api, formdata);
        return this.getResult(result, new TypeReference<WwResult<List<ChatMenuItem>>>(){});
    }

    private void checkAndUpdateDomainIcpStatus(String appId) {
        log.info("check and update domain icp status, appId:{}", (Object)appId);
        String api = "https://work.weixin.qq.com/wework_admin/apps/checkAndUpdateDomainIcpStatus";
        ArrayList formdata = Lists.newArrayList();
        formdata.add(new BasicNameValuePair("app_id", appId));
        String result = WwbotServiceImpl.post(api, formdata);
        this.getResult(result, new TypeReference<WwResult<Map<String, Object>>>(){});
    }

    private void checkApiAccessibleApps(DefaultApp app, OpenapiApp agent) {
        log.info("\u914d\u7f6e\u65e5\u7a0b\u53ef\u8c03\u7528\u5e94\u7528");
        if (app == null) {
            log.warn("\u672a\u627e\u5230[{}]\u5e94\u7528\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u624b\u52a8\u914d\u7f6e", (Object)CALENDAR_APP_NAME);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u80fd\u83b7\u53d6\u5230\u65e5\u7a0b\u5e94\u7528\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u624b\u52a8\u914d\u7f6e\u3002");
        }
        String businessId = String.valueOf(app.getBusinessId());
        String appId = agent.getAppId();
        this.addApiAccessibleApps(businessId, appId);
    }

    private void checkApiAccessibleApps(OpenapiApp app, OpenapiApp agent) {
        log.info("\u914d\u7f6e\u5ba2\u6237\u8054\u7cfb\u53ef\u8c03\u7528\u5e94\u7528");
        if (app == null) {
            log.warn("\u672a\u627e\u5230[{}]\u5e94\u7528\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u624b\u52a8\u914d\u7f6e", (Object)EXTERNAL_APP_NAME);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u80fd\u83b7\u53d6\u5230\u5ba2\u6237\u8054\u7cfb\u4eba\u5e94\u7528\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u624b\u52a8\u914d\u7f6e\u3002");
        }
        String businessId = String.valueOf(app.getAgentId());
        String appId = agent.getAppId();
        this.addApiAccessibleApps(businessId, appId);
    }

    private void addApiAccessibleApps(String businessId, String appId) {
        List<String> appIds = this.getApiAccessibleApps(businessId);
        ArrayList setAppIds = null;
        if (CollectionUtils.isEmpty(appIds)) {
            setAppIds = Collections.singletonList(appId);
        } else if (!appIds.contains(appId)) {
            setAppIds = Lists.newArrayList(appIds);
            setAppIds.add(appId);
        }
        if (setAppIds != null) {
            this.setApiAccessibleApps(businessId, setAppIds);
        }
    }

    private void checkAgentInfo(CreateReq params, OpenapiApp app) {
        log.info("\u914d\u7f6e\u53ef\u89c1\u8303\u56f4");
        List<String> vids = params.getVids();
        List<String> pids = params.getPids();
        OpenapiApp.AppPerm perms = app.getAppPerm();
        List<String> eVids = perms.getVids();
        List<String> ePids = perms.getPartyids();
        if (this.equalList(eVids, vids) && this.equalList(ePids, pids)) {
            log.info("\u53ef\u89c1\u8303\u56f4\u6ca1\u6709\u66f4\u65b0\uff0c\u65e0\u9700\u914d\u7f6e");
            return;
        }
        ArrayList formdata = Lists.newArrayList();
        formdata.add(new BasicNameValuePair("name", this.name));
        formdata.add(new BasicNameValuePair("description", this.desc));
        formdata.add(new BasicNameValuePair("english_name", ""));
        formdata.add(new BasicNameValuePair("english_description", ""));
        formdata.add(new BasicNameValuePair("logoimage", this.logoimage));
        formdata.add(new BasicNameValuePair("app_id", app.getAppId()));
        formdata.add(new BasicNameValuePair("app_open", "1"));
        if (CollectionUtils.isNotEmpty(pids)) {
            for (String partyid : pids) {
                if (!StringUtils.isNotBlank((CharSequence)partyid)) continue;
                formdata.add(new BasicNameValuePair("visible_pid[]", partyid));
            }
        }
        if (CollectionUtils.isNotEmpty(vids)) {
            for (String vid : vids) {
                if (!StringUtils.isNotBlank((CharSequence)vid)) continue;
                formdata.add(new BasicNameValuePair("visible_vid[]", vid));
            }
        }
        this.saveOpenApiApp(formdata);
    }

    private boolean equalList(List<String> list, List<String> list1) {
        if (CollectionUtils.isEmpty(list)) {
            return CollectionUtils.isEmpty(list1);
        }
        if (CollectionUtils.isEmpty(list1)) {
            return false;
        }
        list.sort(Comparator.comparing(String::hashCode));
        list1.sort(Comparator.comparing(String::hashCode));
        return list.toString().equals(list1.toString());
    }

    private void checkAgentId(OpenapiApp app) {
        log.info("\u4fdd\u5b58\u81ea\u5efa\u5e94\u7528\u7684agentId");
        this.settingAgentService.setAgentId(app.getAgentId(), app.getAppId());
    }

    private void sendTwoFactorAuthOperation(String appid) {
        log.info("two factor auth operation, operatorId:{}", (Object)LoginUtils.getCurrentUserId());
        String api = "https://work.weixin.qq.com/wework_admin/two_factor_auth_operation/create";
        ArrayList formdata = Lists.newArrayList();
        formdata.add(new BasicNameValuePair("appid", appid));
        formdata.add(new BasicNameValuePair("business_type", "1"));
        formdata.add(new BasicNameValuePair("app_type", "1"));
        formdata.add(new BasicNameValuePair("_d2st", BotLoginUtils.d2st()));
        String result = WwbotServiceImpl.post(api, formdata);
        Map<String, Object> obj = this.getResult(result, new TypeReference<WwResult<Map<String, Object>>>(){});
        if (obj != null) {
            log.info("send secret, appid={}, key={}", (Object)appid, obj.get("key"));
        } else {
            log.info("secret not found: appid={}", (Object)appid);
        }
    }

    private void checkAgentSecret(OpenapiApp app, GetAgentTokenCfg cfg) {
        log.info("\u5c1d\u8bd5\u83b7\u53d6\u81ea\u5efa\u5e94\u7528secret");
        if (StringUtils.isBlank((CharSequence)app.getSecret())) {
            log.info("\u672a\u80fd\u83b7\u53d6\u81ea\u5efa\u5e94\u7528secret\uff0c\u9700\u8981\u624b\u52a8\u914d\u7f6e\u3002");
            return;
        }
        if (app.getAgentId().equals(cfg.getAgentId()) && app.getSecret().equals(cfg.getSecret())) {
            log.info("\u81ea\u5efa\u5e94\u7528secret\u65e0\u9700\u66f4\u65b0");
            return;
        }
        SetAgentSecretReq params = new SetAgentSecretReq();
        params.setAgentId(app.getAgentId());
        params.setSecret(app.getSecret());
        try {
            this.settingAgentService.set(params);
        }
        catch (Exception e) {
            log.error("\u914d\u7f6e\u81ea\u5efa\u5e94\u7528\u5bc6\u94a5\u5931\u8d25", (Throwable)e);
        }
    }

    private void checkAgentCallback(OpenapiApp myApp, GetAgentTokenCfg agentCfg) {
        log.info("\u914d\u7f6e\u81ea\u5efa\u5e94\u7528API\u63a5\u6536\u6d88\u606f");
        if (this.equalCallback(myApp, (GetCorpTokenCfg)agentCfg)) {
            log.info("\u81ea\u5efa\u5e94\u7528API\u63a5\u6536\u6d88\u606f\u56de\u8c03\u65e0\u9700\u66f4\u65b0");
            return;
        }
        ArrayList formdata = Lists.newArrayList();
        formdata.add(new BasicNameValuePair("callback_url", agentCfg.getCallbackUrl()));
        formdata.add(new BasicNameValuePair("url_token", agentCfg.getToken()));
        formdata.add(new BasicNameValuePair("callback_aeskey", agentCfg.getAeskey()));
        formdata.add(new BasicNameValuePair("report_loc_flag", "0"));
        formdata.add(new BasicNameValuePair("is_report_enter", "true"));
        formdata.add(new BasicNameValuePair("report_approval_event", "true"));
        formdata.add(new BasicNameValuePair("customer_event", "true"));
        formdata.add(new BasicNameValuePair("app_id", myApp.getAppId()));
        formdata.add(new BasicNameValuePair("callback_host", this.callbackHost));
        this.saveOpenApiApp(formdata);
    }

    private boolean equalCallback(OpenapiApp app, GetCorpTokenCfg cfg) {
        if (StringUtils.isBlank((CharSequence)app.getCallbackUrl())) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)app.getCallbackHost())) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)app.getUrlToken())) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)app.getCallbackAeskey())) {
            return false;
        }
        if (!Objects.equal((Object)this.callbackHost, (Object)app.getCallbackHost())) {
            return false;
        }
        if (!Objects.equal((Object)cfg.getCallbackUrl(), (Object)app.getCallbackUrl())) {
            return false;
        }
        if (!Objects.equal((Object)cfg.getAeskey(), (Object)app.getCallbackAeskey())) {
            return false;
        }
        return Objects.equal((Object)cfg.getToken(), (Object)app.getUrlToken());
    }

    private void checkAgentHome(OpenapiApp app) {
        log.info("\u914d\u7f6e\u5e94\u7528\u4e3b\u9875");
        if (app.getHomeInfo() != null && this.homepage.equals(app.getHomeInfo().getUrl())) {
            log.info("\u5e94\u7528\u4e3b\u9875\u65e0\u9700\u4fee\u6539");
            return;
        }
        ArrayList formdata = Lists.newArrayList();
        formdata.add(new BasicNameValuePair("app_id", app.getAppId()));
        formdata.add(new BasicNameValuePair("type", "switch2web"));
        formdata.add(new BasicNameValuePair("app_flag", "18"));
        formdata.add(new BasicNameValuePair("url", this.homepage));
        formdata.add(new BasicNameValuePair("app_type", "APP_TYPE_HOME"));
        this.setHomeUrl(formdata);
    }

    private void checkAgentChatMenu(OpenapiApp app, String corpId) {
        log.info("\u914d\u7f6e\u5230\u804a\u5929\u5de5\u5177\u680f");
        List<ChatMenuDto> menus = this.getConfigMenu();
        if (CollectionUtils.isEmpty(menus)) {
            log.info("\u670d\u52a1\u5546\u6ca1\u6709\u914d\u7f6e\u4efb\u4f55\u9875\u9762\uff0c\u65e0\u9700\u914d\u7f6e\u5230\u804a\u5929\u5de5\u5177\u680f\u3002");
            return;
        }
        HashMap map = Maps.newHashMap();
        ChatMenu chatMenu = this.getChatMenu();
        List<ChatMenuItem> items = chatMenu.getPublishBannerBlock();
        if (CollectionUtils.isNotEmpty(items)) {
            for (ChatMenuItem item : items) {
                if (item.getCorpApp() == null || item.getOrder() == null) continue;
                String appId = item.getCorpApp().getAppId();
                if (!app.getAppId().equals(appId)) continue;
                log.info("Found {}:{}", (Object)item.getItemName(), (Object)item.getItemInfo());
                map.put(item.getItemName(), item.getItemInfo());
            }
        }
        for (ChatMenuDto menu : menus) {
            String url = (String)map.remove(menu.getName());
            String menuUrl = this.managerRoot + menu.getUrl().trim() + "?corpId=" + corpId;
            if (url != null) continue;
            this.addChatMenu(app, menu.getName(), menuUrl);
        }
        this.checkChatMenuOrder(app, menus, corpId);
    }

    private void checkChatMenuOrder(OpenapiApp app, List<ChatMenuDto> menus, String corpId) {
        ChatMenu chatMenu = this.getChatMenu();
        List<ChatMenuItem> items = chatMenu.getPublishBannerBlock();
        String appId = app.getAppId();
        boolean isOrdered = true;
        int size = menus.size();
        for (int i = 0; i < size; ++i) {
            String url;
            ChatMenuItem item = items.get(i);
            ChatMenuDto menu = menus.get(i);
            if (item.getCorpApp() == null) {
                isOrdered = false;
                break;
            }
            if (!appId.equals(item.getCorpApp().getAppId())) {
                isOrdered = false;
                break;
            }
            String name = menu.getName().trim();
            if (!item.getItemName().equals(name)) {
                isOrdered = false;
                break;
            }
            String menuUrl = this.managerRoot + menu.getUrl().trim() + "?corpId=" + corpId;
            if (menuUrl.equals(url = item.getItemInfo())) continue;
            isOrdered = false;
            break;
        }
        if (isOrdered) {
            log.info("\u65e0\u9700\u8c03\u6574\u4fa7\u8fb9\u680f\u987a\u5e8f");
            return;
        }
        LinkedList linkedList = Lists.newLinkedList(items);
        HashMap<String, ChatMenuItem> map = new HashMap<String, ChatMenuItem>();
        if (CollectionUtils.isNotEmpty((Collection)linkedList)) {
            for (ChatMenuItem item : linkedList) {
                if (item.getCorpApp() == null || item.getOrder() == null) continue;
                String corpAppId = "";
                if (item.getCorpApp() != null) {
                    corpAppId = item.getCorpApp().getAppId();
                }
                if (!app.getAppId().equals(corpAppId)) continue;
                log.info("Found {}:{}", (Object)item.getItemName(), (Object)item.getItemInfo());
                String name = item.getItemName();
                map.put(corpAppId + "##" + name, item);
            }
        }
        for (int i = size - 1; i >= 0; --i) {
            ChatMenuDto menu = menus.get(i);
            String key = appId + "##" + menu.getName().trim();
            ChatMenuItem item = (ChatMenuItem)map.get(key);
            String menuUrl = this.managerRoot + menu.getUrl().trim() + "?corpId=" + corpId;
            if (item == null) continue;
            linkedList.remove(item);
            linkedList.addFirst(item);
            item.setItemInfo(menuUrl);
        }
        this.publishChatMenu(linkedList);
    }

    private List<ChatMenuDto> getConfigMenu() {
        List list = null;
        try {
            list = (List)JacksonUtil.str2Obj((String)this.chatMenuJson, (TypeReference)new TypeReference<List<ChatMenuDto>>(){});
        }
        catch (IOException e) {
            log.error("Failed parsing chatMenu json:{}", (Object)this.chatMenuJson, (Object)e);
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        return list.stream().filter(it -> StringUtils.isNotBlank((CharSequence)it.getName()) && StringUtils.isNotBlank((CharSequence)it.getUrl())).collect(Collectors.toList());
    }

    private void checkAgentJssdk(OpenapiApp app) {
        log.info("\u914d\u7f6e\u7f51\u9875\u6388\u6743\u53caJS-SDK");
        if (!this.diffJssdk(app)) {
            log.info("\u7f51\u9875\u6388\u6743\u53caJS-SDK\u65e0\u9700\u66f4\u65b0");
            return;
        }
        ArrayList formdata = Lists.newArrayList();
        formdata.add(new BasicNameValuePair("app_id", app.getAppId()));
        formdata.add(new BasicNameValuePair("redirect_domain", this.redirectDomain));
        formdata.add(new BasicNameValuePair("is_check_domain_ownership", "false"));
        formdata.add(new BasicNameValuePair("miniprogram_domains[]", this.redirectDomain));
        formdata.add(new BasicNameValuePair("miniprogram_domains_operate", "true"));
        this.saveOpenApiApp(formdata);
        this.checkAndUpdateDomainIcpStatus(app.getAppId());
    }

    private boolean diffJssdk(OpenapiApp app) {
        if (StringUtils.isBlank((CharSequence)app.getRedirectDomain()) || !app.getRedirectDomain().equals(this.redirectDomain)) {
            log.info("\u68c0\u6d4b\u5230\u672a\u914d\u7f6eOAuth2.0\u7f51\u9875\u6388\u6743\u529f\u80fd\u7684\u56de\u8c03\u57df\u540d");
            return true;
        }
        if (CollectionUtils.isEmpty(app.getMiniprogramDomains()) || !app.getMiniprogramDomains().contains(this.redirectDomain)) {
            log.info("\u68c0\u6d4b\u5230\u672a\u914d\u7f6eJS-SDK\u53ef\u4fe1\u57df\u540d");
            return true;
        }
        return false;
    }

    private void checkAgentWebApp(OpenapiApp app) {
        log.info("\u914d\u7f6eWeb\u7f51\u9875\u626b\u4e00\u626b\u6388\u6743\u56de\u8c03\u57df\u540d");
        if (!this.diffWebApp(app)) {
            log.info("Web\u7f51\u9875\u626b\u4e00\u626b\u6388\u6743\u56de\u8c03\u57df\u540d\u65e0\u9700\u66f4\u65b0");
            return;
        }
        ArrayList formdata = Lists.newArrayList();
        formdata.add(new BasicNameValuePair("app_id", app.getAppId()));
        if (app.getAppFlag() != null) {
            formdata.add(new BasicNameValuePair("app_flag", String.valueOf(app.getAppFlag())));
        }
        formdata.add(new BasicNameValuePair("redirect_domain2", this.redirectDomain));
        formdata.add(new BasicNameValuePair("b_ios", String.valueOf(app.getBIos())));
        formdata.add(new BasicNameValuePair("bundleid", app.getBundleId()));
        formdata.add(new BasicNameValuePair("b_android", String.valueOf(app.getBAndroid())));
        formdata.add(new BasicNameValuePair("signature_android", app.getSignatureAndroid()));
        formdata.add(new BasicNameValuePair("packagename", app.getPackageName()));
        this.saveOpenApiApp(formdata);
    }

    private boolean diffWebApp(OpenapiApp app) {
        if (StringUtils.isBlank((CharSequence)app.getRedirectDomain2()) || !app.getRedirectDomain2().equals(this.redirectDomain)) {
            log.info("\u68c0\u6d4b\u5230\u672a\u914d\u7f6eWeb\u7f51\u9875\u626b\u4e00\u626b\u6388\u6743\u56de\u8c03\u57df\u540d");
            return true;
        }
        return false;
    }

    private void checkExternalCallback(OpenapiApp app, GetCorpTokenCfg cfg) {
        log.info("\u914d\u7f6e\u5ba2\u6237\u8054\u7cfbAPI\u63a5\u6536\u6d88\u606f");
        if (this.equalCallback(app, cfg)) {
            log.info("\u5ba2\u6237\u8054\u7cfbAPI\u63a5\u6536\u6d88\u606f\u56de\u8c03\u65e0\u9700\u66f4\u65b0");
            return;
        }
        ArrayList formdata = Lists.newArrayList();
        formdata.add(new BasicNameValuePair("callback_url", cfg.getCallbackUrl()));
        formdata.add(new BasicNameValuePair("url_token", cfg.getToken()));
        formdata.add(new BasicNameValuePair("callback_aeskey", cfg.getAeskey()));
        formdata.add(new BasicNameValuePair("app_id", app.getAppId()));
        formdata.add(new BasicNameValuePair("callback_host", this.callbackHost));
        this.saveOpenApiApp(formdata);
    }

    private void checkContactApiOpen(OpenapiApp app) {
        log.info("\u5c1d\u8bd5\u5f00\u542f\u901a\u8baf\u5f55\u540c\u6b65\u52a9\u624bAPI\u7f16\u8f91\u529f\u80fd");
        if (this.hasContactApiOpen(app)) {
            log.info("\u901a\u8baf\u5f55\u540c\u6b65\u52a9\u624bAPI\u7f16\u8f91\u529f\u80fd\u5df2\u7ecf\u5f00\u542f\uff0c\u65e0\u9700\u66f4\u65b0\u3002");
            return;
        }
        ArrayList formdata = Lists.newArrayList();
        formdata.add(new BasicNameValuePair("arch_rw_flag", "1"));
        formdata.add(new BasicNameValuePair("b_open_sync_edit", "true"));
        formdata.add(new BasicNameValuePair("app_id", app.getAppId()));
        formdata.add(new BasicNameValuePair("app_open", "true"));
        this.saveOpenApiApp(formdata);
    }

    private boolean hasContactApiOpen(OpenapiApp app) {
        if (app.getAppOpen() == null || app.getAppOpen() == 0) {
            return false;
        }
        return app.getArchRwFlag() != null && app.getArchRwFlag() != 0;
    }

    private void checkContactSecret(OpenapiApp app, GetCorpTokenCfg cfg) {
        log.info("\u5c1d\u8bd5\u83b7\u53d6\u901a\u8baf\u5f55secret");
        if (StringUtils.isBlank((CharSequence)app.getSecret())) {
            log.info("\u672a\u80fd\u83b7\u53d6\u901a\u8baf\u5f55secret\uff0c\u9700\u8981\u624b\u52a8\u914d\u7f6e\u3002");
            return;
        }
        if (app.getSecret().equals(cfg.getSecret())) {
            log.info("\u901a\u8baf\u5f55secret\u65e0\u9700\u66f4\u65b0");
            return;
        }
        SetCorpSecretReq params = new SetCorpSecretReq();
        params.setSecret(app.getSecret());
        try {
            this.settingContactService.set(params);
        }
        catch (Exception e) {
            log.error("\u914d\u7f6e\u901a\u8baf\u5f55secret\u5931\u8d25", (Throwable)e);
        }
    }
}

