/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wwlogin.exception;

import com.kuaike.scrm.wwlogin.dto.resp.ErrorResult;
import org.apache.commons.lang3.StringUtils;

public class WwBotException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private ErrorResult err;
    private Integer errCode;
    private String errMsg;
    private String message;

    public WwBotException(ErrorResult err) {
        this.err = err;
        this.errCode = err.getErrCode();
        this.errMsg = WwBotException.getMessage(err);
        this.message = String.format("error(%d):%s", this.errCode, this.errMsg);
    }

    public ErrorResult getErrorResult() {
        return this.err;
    }

    public Integer getErrCode() {
        return this.errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    private static String getMessage(ErrorResult err) {
        String msg = err.getMessage();
        if (StringUtils.isNotBlank((CharSequence)err.getHumanMessage())) {
            msg = err.getHumanMessage();
        } else if (err.getErrCode() == -3) {
            if (err.getEtype() != null) {
                if ("otherLogin".equals(err.getEtype())) {
                    msg = "\u60a8\u5df2\u7ecf\u5728\u5176\u4ed6\u5730\u65b9\u767b\u5f55";
                }
            } else {
                msg = "\u767b\u5f55\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55";
            }
        }
        return msg;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

