/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wwlogin.utils;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpMessage;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class BotLoginUtils {
    private static final Logger log = LoggerFactory.getLogger(BotLoginUtils.class);
    public static final String WIDNOW_SETTINGS = "window.settings";
    public static final String WIDNOW_SETTINGS_ENCODE_CORP_ID = "window.settings.encode_corp_id";
    public static final String WWRTX_D2ST = "wwrtx.d2st";
    public static final String WXPAY_VID = "wxpay.vid";
    public static final String WWRTX_SID = "wwrtx.sid";
    public static final String WXPAY_CORPID = "wxpay.corpid";
    public static final String WWLOGIN_COOKIE = "wwlogin_cookie";
    public static final String REFER_LOGIN = "https://work.weixin.qq.com/wework_admin/wwqrlogin/login_qrcode?login_type=login_admin&callback=wwqrloginCallback_1620733774250&redirect_uri=https%3A%2F%2Fwork.weixin.qq.com%2Fwework_admin%2Floginpage_wx%3Fpagekey%3D1620733774250850%26from%3Dmyhome&crossorigin=1";
    public static final String REFER_FRAME = "https://work.weixin.qq.com/wework_admin/frame";
    public static final String USER_AGENT = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36";
    public static final String SEC_CH_UA = "\" Not A;Brand\";v=\"99\", \"Chromium\";v=\"90\", \"Google Chrome\";v=\"90\"";

    public static void addBasicHeaders(HttpMessage request) {
        request.setHeader("authority", "work.weixin.qq.com");
        request.setHeader("accept-encoding", "gzip, deflate, br");
        request.setHeader("accept-language", "zh-CN,zh;q=0.9");
        request.setHeader("origin", "https://work.weixin.qq.com");
        request.setHeader("sec-ch-ua", SEC_CH_UA);
        request.setHeader("sec-ch-ua-mobile", "?0");
        request.setHeader("user-agent", USER_AGENT);
    }

    public static void addDocumentHeaders(HttpMessage request) {
        request.setHeader("accept", "accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9");
        request.setHeader("sec-fetch-site", "same-origin");
        request.setHeader("sec-fetch-mode", "navigate");
        request.setHeader("sec-fetch-dest", "document");
    }

    public static void addAjaxHeaders(HttpMessage request) {
        request.setHeader("accept", "application/json, text/javascript, */*; q=0.01");
        request.setHeader("sec-fetch-site", "same-origin");
        request.setHeader("sec-fetch-mode", "cors");
        request.setHeader("sec-fetch-dest", "empty");
        request.setHeader("x-requested-with", "XMLHttpRequest");
    }

    public static void addCookieHeader(HttpMessage request) {
        String cookieStr = BotLoginUtils.getCookieStr();
        if (cookieStr != null) {
            request.addHeader("Cookie", cookieStr);
        }
    }

    public static void clearCookie() {
        HttpSession session = BotLoginUtils.getSession();
        if (session == null) {
            log.warn("session is null");
            return;
        }
        session.removeAttribute(WWLOGIN_COOKIE);
        session.removeAttribute(WWRTX_D2ST);
        session.removeAttribute(WIDNOW_SETTINGS);
        session.removeAttribute(WIDNOW_SETTINGS_ENCODE_CORP_ID);
    }

    public static void cacheCookies(CloseableHttpResponse response) {
        Header[] setCookies = response.getHeaders("Set-Cookie");
        if (setCookies == null) {
            log.info("No Set-Cookie found.");
            return;
        }
        TreeMap map = Maps.newTreeMap();
        for (Header header : setCookies) {
            String[] pair;
            String value = header.getValue();
            String cookieStr = value.split(";")[0];
            if (StringUtils.isBlank((CharSequence)cookieStr) || (pair = cookieStr.split("=")).length < 2) continue;
            map.put(pair[0], pair[1]);
        }
        log.info("Found Set-Cookie: {}", (Object)map);
        HttpSession session = BotLoginUtils.getSession();
        if (session == null) {
            log.info("session is null");
            return;
        }
        String cookieStr = (String)session.getAttribute(WWLOGIN_COOKIE);
        if (cookieStr == null) {
            session.setAttribute(WWLOGIN_COOKIE, (Object)BotLoginUtils.toCookieStr(map));
            session.setAttribute(WWRTX_D2ST, map.get(WWRTX_D2ST));
            return;
        }
        Map<String, String> existsMap = BotLoginUtils.fromCookieStr(cookieStr);
        existsMap.putAll(map);
        session.setAttribute(WWLOGIN_COOKIE, (Object)BotLoginUtils.toCookieStr(existsMap));
        session.setAttribute(WWRTX_D2ST, (Object)existsMap.get(WWRTX_D2ST));
    }

    public static String getCookieStr() {
        HttpSession session = BotLoginUtils.getSession();
        if (session == null) {
            log.warn("session is null");
            return null;
        }
        String cookieStr = (String)session.getAttribute(WWLOGIN_COOKIE);
        return cookieStr;
    }

    public static String d2st() {
        HttpSession session = BotLoginUtils.getSession();
        if (session == null) {
            return null;
        }
        String d2st = (String)session.getAttribute(WWRTX_D2ST);
        return d2st;
    }

    public static Map<String, String> getCookieMap() {
        HttpSession session = BotLoginUtils.getSession();
        if (session == null) {
            log.warn("session is null");
            return Collections.emptyMap();
        }
        String cookieStr = (String)session.getAttribute(WWLOGIN_COOKIE);
        if (cookieStr == null) {
            return Collections.emptyMap();
        }
        Map<String, String> existsMap = BotLoginUtils.fromCookieStr(cookieStr);
        return existsMap;
    }

    public static String toCookieStr(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        int size = map.size();
        int idx = 0;
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<String, String>> entrySet = map.entrySet();
        for (Map.Entry<String, String> e : entrySet) {
            String key = e.getKey();
            String val = e.getValue();
            sb.append(key).append('=').append(val);
            if (++idx >= size) continue;
            sb.append("; ");
        }
        log.info("cookie str:{}", (Object)sb.toString());
        return sb.toString();
    }

    public static Map<String, String> fromCookieStr(String cookieStr) {
        String[] pairs;
        TreeMap map = Maps.newTreeMap();
        for (String cookie : pairs = cookieStr.split(";")) {
            String[] pair = cookie.trim().split("=");
            if (pair.length < 2) continue;
            map.put(pair[0], pair[1]);
        }
        return map;
    }

    public static HttpSession getSession() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes == null) {
            return null;
        }
        if (attributes.getRequest() == null) {
            return null;
        }
        return attributes.getRequest().getSession();
    }
}

