/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.weworkuser.dto;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.utils.DateUtil;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class ContactStatisticParams {
    private String weworkUserId;
    private Date startTime;
    private Date endTime;

    public void checkParams() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.weworkUserId), (Object)"\u6210\u5458id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.startTime != null ? 1 : 0) != 0, (Object)"\u7edf\u8ba1\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.endTime != null ? 1 : 0) != 0, (Object)"\u7edf\u8ba1\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)this.endTime.after(this.startTime), (Object)"\u7edf\u8ba1\u5f00\u59cb\u65f6\u95f4\u8981\u5c0f\u4e8e\u7ed3\u675f\u65f6\u95f4");
        int oneDayTime = 86400000;
        long queryTimeRange = DateUtil.getTheDateBegin((Date)this.endTime) - DateUtil.getTheDateBegin((Date)this.startTime);
        int days = (int)(queryTimeRange / (long)oneDayTime);
        if (days >= 179) {
            this.startTime = DateUtil.getDateAddDay((Date)this.endTime, (int)-179);
        }
    }

    public String getWeworkUserId() {
        return this.weworkUserId;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setWeworkUserId(String weworkUserId) {
        this.weworkUserId = weworkUserId;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContactStatisticParams)) {
            return false;
        }
        ContactStatisticParams other = (ContactStatisticParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$weworkUserId = this.getWeworkUserId();
        String other$weworkUserId = other.getWeworkUserId();
        if (this$weworkUserId == null ? other$weworkUserId != null : !this$weworkUserId.equals(other$weworkUserId)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        return !(this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContactStatisticParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $weworkUserId = this.getWeworkUserId();
        result = result * 59 + ($weworkUserId == null ? 43 : $weworkUserId.hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        return result;
    }

    public String toString() {
        return "ContactStatisticParams(weworkUserId=" + this.getWeworkUserId() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ")";
    }
}

