/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.qyqrcode.service;

import cn.kinyun.wework.sdk.api.external.ContactWayClient;
import cn.kinyun.wework.sdk.entity.external.contactway.ConfigIdResp;
import cn.kinyun.wework.sdk.entity.external.contactway.ContactWay;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.service.QrCodeService;
import com.kuaike.scrm.common.service.dto.AddFriendRemarkConfigDto;
import com.kuaike.scrm.common.service.dto.AddQrcodeDto;
import com.kuaike.scrm.common.service.dto.AutoPassReq;
import com.kuaike.scrm.common.service.dto.FriendWelcomeDto;
import com.kuaike.scrm.common.service.dto.QrConfigDto;
import com.kuaike.scrm.common.service.dto.TagConfigDto;
import com.kuaike.scrm.common.service.dto.WelcomeConfigDto;
import com.kuaike.scrm.common.service.dto.req.qrcode.GenQrcodeReq;
import com.kuaike.scrm.common.service.dto.resp.qrcode.GenQrcodeResp;
import com.kuaike.scrm.dal.qyqrcodetask.entity.QyQrcodeSubTask;
import com.kuaike.scrm.dal.qyqrcodetask.entity.QyQrcodeTask;
import com.kuaike.scrm.dal.qyqrcodetask.mapper.QyQrcodeSubTaskMapper;
import com.kuaike.scrm.dal.qyqrcodetask.mapper.QyQrcodeTaskMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QrcodeServiceImpl
implements QrCodeService {
    private static final Logger log = LoggerFactory.getLogger(QrcodeServiceImpl.class);
    @Value(value="${kafka.topic.task_config_contact_way}")
    private String configContactWayTaskTopic;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Resource
    private QyQrcodeTaskMapper qyQrcodeTaskMapper;
    @Resource
    private QyQrcodeSubTaskMapper qyQrcodeSubTaskMapper;
    @Resource
    private ContactWayClient contactWayClient;
    @Resource
    private WeworkUserMapper weworkUserMapper;

    public void addQrcodeTask(AddQrcodeDto params) {
        log.info("add qrcode task param: {}", (Object)params);
        Long bizId = params.getBizId();
        String corpId = params.getCorpId();
        if (bizId == null || StringUtils.isEmpty((CharSequence)corpId)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "bizId\u548ccorpId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = params.getQrConfigs();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        Integer autoPass = params.getAutoPass();
        for (QrConfigDto configDto : list) {
            if (configDto.getTotalCount() == null || configDto.getTotalCount() <= 0 || CollectionUtils.isEmpty((Collection)configDto.getStateList()) || configDto.getStateList().size() != configDto.getTotalCount().intValue()) continue;
            QyQrcodeTask task = new QyQrcodeTask();
            task.setBizId(bizId);
            task.setCorpId(corpId);
            task.setWeworkUserNum(configDto.getWeworkUserNum());
            task.setQrcodeCount(configDto.getTotalCount());
            task.setAutoPass(autoPass);
            task.setCreateBy(Long.valueOf(-1L));
            task.setCreateTime(new Date());
            task.setUpdateBy(Long.valueOf(-1L));
            task.setUpdateTime(new Date());
            if (configDto.getFriendWelcome() != null) {
                task.setWelcomeJson(JacksonUtil.obj2Str((Object)configDto.getFriendWelcome()));
            } else {
                task.setWelcomeJson("");
            }
            if (CollectionUtils.isEmpty((Collection)configDto.getTagIds())) {
                task.setTagIds("");
            } else {
                task.setTagIds(Joiner.on((String)",").join((Iterable)configDto.getTagIds()));
            }
            this.qyQrcodeTaskMapper.insertSelective((Object)task);
            ArrayList subTasks = Lists.newArrayListWithCapacity((int)configDto.getTotalCount());
            for (int i = 0; i < configDto.getTotalCount(); ++i) {
                QyQrcodeSubTask subTask = new QyQrcodeSubTask();
                subTask.setBizId(bizId);
                subTask.setCorpId(corpId);
                subTask.setTaskId(task.getId());
                subTask.setState((String)configDto.getStateList().get(i));
                subTask.setQrcodeUrl("");
                subTask.setQrConfigId("");
                subTask.setIsSync(Integer.valueOf(0));
                subTask.setCreateBy(Long.valueOf(-1L));
                subTask.setUpdateBy(Long.valueOf(-1L));
                subTasks.add(subTask);
            }
            Lists.partition((List)subTasks, (int)300).forEach(lt -> this.qyQrcodeSubTaskMapper.batchInsert((Collection)lt));
            for (QyQrcodeSubTask subTask : subTasks) {
                String msgKey = "qrcodeSubTask" + subTask.getState();
                this.kafkaTemplate.send(this.configContactWayTaskTopic, (Object)msgKey, (Object)String.valueOf(subTask.getState()));
            }
        }
    }

    public void updateQrcodeAutoPass(AutoPassReq params) {
        log.info("update qrcode auto pass param: {}", (Object)params);
        String corpId = params.getCorpId();
        if (StringUtils.isEmpty((CharSequence)corpId)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "corpId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List weworkUserNums = params.getWeworkUserNums();
        if (CollectionUtils.isEmpty((Collection)weworkUserNums)) {
            return;
        }
        Integer autoPass = params.getAutoPass();
        for (String weworkUserNum : weworkUserNums) {
            List list = this.qyQrcodeTaskMapper.queryTaskByWeworkUserNum(corpId, weworkUserNum);
            for (QyQrcodeTask task : list) {
                if (Objects.equals(task.getAutoPass(), autoPass)) continue;
                task.setAutoPass(autoPass);
                task.setUpdateTime(new Date());
                this.qyQrcodeTaskMapper.updateByPrimaryKeySelective((Object)task);
                this.qyQrcodeSubTaskMapper.updateSubTaskSyncByTaskId(task.getId(), Integer.valueOf(0));
                List subTaskStates = this.qyQrcodeSubTaskMapper.querySubTaskStateByTask(task.getId());
                for (String subTaskState : subTaskStates) {
                    String msgKey = "qrcodeSubTask" + subTaskState;
                    this.kafkaTemplate.send(this.configContactWayTaskTopic, (Object)msgKey, (Object)String.valueOf(subTaskState));
                }
            }
        }
    }

    public void delQrcode(String corpId, List<String> configIds) {
        log.info("del qrcode configIds param: {}", configIds);
        if (CollectionUtils.isEmpty(configIds)) {
            return;
        }
        for (String configId : configIds) {
            QyQrcodeSubTask subTask = new QyQrcodeSubTask();
            subTask.setCorpId(corpId);
            subTask.setQrConfigId(configId);
            subTask = (QyQrcodeSubTask)this.qyQrcodeSubTaskMapper.selectOne((Object)subTask);
            if (subTask == null) continue;
            subTask.setIsSync(Integer.valueOf(0));
            subTask.setIsDeleted(Integer.valueOf(1));
            subTask.setUpdateTime(new Date());
            this.qyQrcodeSubTaskMapper.updateByPrimaryKeySelective((Object)subTask);
            String msgKey = "qrcodeSubTask" + subTask.getState();
            this.kafkaTemplate.send(this.configContactWayTaskTopic, (Object)msgKey, (Object)String.valueOf(subTask.getState()));
        }
    }

    @Transactional
    public void setWelcomeConfig(String corpId, List<WelcomeConfigDto> configDtos) {
        log.info("set qrcode welcome config param: {}", configDtos);
        if (StringUtils.isBlank((CharSequence)corpId)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "corpId\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(configDtos)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u914d\u7f6e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (WelcomeConfigDto configDto : configDtos) {
            String state = configDto.getState();
            if (StringUtils.isEmpty((CharSequence)state)) continue;
            FriendWelcomeDto welcomeDto = configDto.getFriendWelcome();
            String welcomeStr = "";
            if (welcomeDto != null) {
                welcomeStr = JacksonUtil.obj2Str((Object)welcomeDto);
            }
            this.qyQrcodeSubTaskMapper.updateWelcomeByState(corpId, state, welcomeStr);
        }
    }

    @Transactional
    public void setTagConfig(String corpId, List<TagConfigDto> configDtos) {
        log.info("set qrcode tag config param: {}", configDtos);
        if (StringUtils.isBlank((CharSequence)corpId)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "corpId\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(configDtos)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u914d\u7f6e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (TagConfigDto configDto : configDtos) {
            String state = configDto.getState();
            if (StringUtils.isEmpty((CharSequence)state)) continue;
            List tagIdList = configDto.getTagIds();
            String tagIds = "";
            if (CollectionUtils.isNotEmpty((Collection)tagIdList)) {
                tagIds = Joiner.on((String)",").join((Iterable)tagIdList);
            }
            this.qyQrcodeSubTaskMapper.updateTagIdsByState(corpId, state, tagIds);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void setAddFriendRemarkConfig(String corpId, AddFriendRemarkConfigDto dto) {
        log.info("setAddFriendRemarkConfig param: {}", (Object)dto);
        if (StringUtils.isBlank((CharSequence)corpId)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "corpId\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u914d\u7f6e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        dto.validate();
        this.qyQrcodeSubTaskMapper.updateAddFriendRemarkByState(corpId, dto.getState(), dto.getRemark());
    }

    public GenQrcodeResp genQrcode(GenQrcodeReq req) {
        log.info("genQrcodeAsync params:{}", (Object)req);
        req.validate();
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByNum(req.getWeworkUserNum());
        Preconditions.checkArgument((weworkUser != null ? 1 : 0) != 0, (Object)"weworkUserId\u4e0d\u5b58\u5728");
        ContactWay params = new ContactWay();
        params.setType(Integer.valueOf(1));
        params.setScene(Integer.valueOf(2));
        params.setState(req.getState());
        params.setUserIds((List)Lists.newArrayList((Object[])new String[]{weworkUser.getWeworkUserId()}));
        params.setSkipVerify(req.getAutoPass() == 1);
        GenQrcodeResp resp = new GenQrcodeResp();
        try {
            ConfigIdResp configIdResp = this.contactWayClient.create(weworkUser.getCorpId(), params);
            resp.setWeworkUserNum(req.getWeworkUserNum());
            resp.setConfigId(configIdResp.getConfigId());
            resp.setQrCode(configIdResp.getQrCode());
            resp.setState(req.getState());
        }
        catch (WeworkException e) {
            log.error("\u751f\u6210\u4f01\u5fae\u4e8c\u7ef4\u7801\u5931\u8d25", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u751f\u6210\u4f01\u5fae\u4e8c\u7ef4\u7801\u5f02\u5e38," + e.getErrorMsg());
        }
        return resp;
    }
}

