/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.corp.service.impl;

import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.dal.agent.mapper.AgentWeworkUserMapper;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.wework.corp.service.WeworkCorpService;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CachePut;
import org.springframework.stereotype.Service;

@Service
public class WeworkCorpServiceImp
implements WeworkCorpService {
    private static final Logger log = LoggerFactory.getLogger(WeworkCorpServiceImp.class);
    @Resource
    private BusinessCustomerMapper businessCustomerMapper;
    @Resource
    private WeworkCorpMapper weworkCorpMapper;
    @Resource
    private AgentWeworkUserMapper agentWeworkUserMapper;

    @Override
    public WeworkCorp getByCorpId(String corpId) {
        return this.weworkCorpMapper.getByCorpId(corpId);
    }

    @Override
    public String getDecryptCorpId(String corpId, Integer isAgent, Long bizId) {
        String decryptCorpId = corpId;
        if (Objects.isNull(isAgent)) {
            WeworkCorp corp = this.weworkCorpMapper.getByCorpId(corpId);
            if (YnEnum.YES.getValue().equals(corp.getIsNewDkf())) {
                decryptCorpId = this.agentWeworkUserMapper.queryDecryptCorpId(corp.getBizId());
            }
            return decryptCorpId;
        }
        if (YnEnum.YES.getValue().equals(isAgent)) {
            if (Objects.isNull(bizId)) {
                WeworkCorp corp = this.weworkCorpMapper.getByCorpId(corpId);
                bizId = corp.getBizId();
            }
            decryptCorpId = this.agentWeworkUserMapper.queryDecryptCorpId(bizId);
        }
        return decryptCorpId;
    }

    @Override
    public List<String> getCorpIds() {
        return this.businessCustomerMapper.getCorpIds();
    }

    @Override
    @CachePut(value={"corpId2BizId"}, key="#corp.corpId")
    public void insert(WeworkCorp corp) {
        this.weworkCorpMapper.insertSelective((Object)corp);
    }
}

