/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.contact.support;

import cn.kinyun.crm.common.service.CrmLeadsService;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsInfoReq;
import cn.kinyun.customer.center.dto.req.CustomerDetailReq;
import cn.kinyun.customer.center.dto.req.ExtendFieldDto;
import cn.kinyun.customer.center.dto.req.QueryOrderListReq;
import cn.kinyun.customer.center.dto.req.order.AddressReq;
import cn.kinyun.customer.center.dto.req.order.LogisticsReq;
import cn.kinyun.customer.center.dto.req.order.OrderRecordReq;
import cn.kinyun.customer.center.dto.req.order.OrderReq;
import cn.kinyun.customer.center.dto.req.order.OrderSkuListReq;
import cn.kinyun.customer.center.dto.req.order.OrderSubmitReq;
import cn.kinyun.customer.center.dto.req.order.SetOrderRefundInfoReq;
import cn.kinyun.customer.center.dto.resp.DynamicFieldDto;
import cn.kinyun.customer.center.dto.resp.EntryOrderConfigresp;
import cn.kinyun.customer.center.dto.resp.LogisticsResp;
import cn.kinyun.customer.center.dto.resp.OrderListResp;
import cn.kinyun.customer.center.dto.resp.OrderPayRecordResp;
import cn.kinyun.customer.center.dto.resp.OrderSkuResp;
import cn.kinyun.customer.center.dto.resp.PageOrderListResp;
import cn.kinyun.customer.center.dto.resp.RefundOrderListResp;
import cn.kinyun.customer.center.enums.OrderEntryMethodEnum;
import cn.kinyun.customer.center.enums.PayChannelType;
import cn.kinyun.customer.center.enums.PayStatusEnum;
import cn.kinyun.customer.center.enums.RefundStatusEnum;
import cn.kinyun.customer.center.enums.RefundTypeEnum;
import cn.kinyun.customer.center.enums.electricity.OrderStatusEnum;
import cn.kinyun.customer.center.enums.electricity.PayOrderStatusEnum;
import cn.kinyun.customer.center.service.CcCustomerOrderService;
import cn.kinyun.customer.center.service.CcCustomerOrderSettingService;
import cn.kinyun.customer.center.service.OrderCenterService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.GoodsOrderSource;
import com.kuaike.scrm.common.enums.SettingEnum;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.excel.ExcelHeader;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.ScrmSkuService;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.service.dto.req.ScrmProductQueryReq;
import com.kuaike.scrm.common.service.dto.req.SettingReqDto;
import com.kuaike.scrm.common.service.dto.resp.ScrmSkuProductResp;
import com.kuaike.scrm.common.service.dto.resp.SettingRespDto;
import com.kuaike.scrm.common.utils.BackendExcelUtils;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.common.utils.ObjectIdUtil;
import com.kuaike.scrm.common.utils.PriceUtils;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.payorder.entity.PayOrder;
import com.kuaike.scrm.dal.payorder.entity.PayRecord;
import com.kuaike.scrm.dal.payorder.mapper.PayOrderMapper;
import com.kuaike.scrm.dal.payorder.mapper.PayRecordMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.shop.entity.ShopSpu;
import com.kuaike.scrm.dal.shop.mapper.ShopSpuMapper;
import com.kuaike.scrm.dal.system.entity.Organization;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.wework.contact.dto.CustomerOrderDto;
import com.kuaike.scrm.wework.contact.dto.ExcelCustomerOrderDto;
import com.kuaike.scrm.wework.contact.dto.KeyName;
import com.kuaike.scrm.wework.contact.dto.OrderAssignUpdateReq;
import com.kuaike.scrm.wework.contact.remote.ScrmOrderQueryReq;
import com.kuaike.scrm.wework.contact.remote.ScrmOrderResp;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class CustomerOrderSupport {
    private static final Logger log = LoggerFactory.getLogger(CustomerOrderSupport.class);
    @Resource
    public CcCustomerOrderService ccCustomerOrderService;
    @Resource
    private CcCustomerOrderSettingService ccCustomerOrderSettingService;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private SettingService settingService;
    @Resource
    private OrderCenterService orderCenterService;
    @Resource
    private UserMapper userMapper;
    @Resource
    private OrganizationMapper organizationMapper;
    @Lazy
    @Autowired
    private ScrmSkuService scrmSkuService;
    @Autowired
    private PayRecordMapper payRecordMapper;
    @Autowired
    private UserRoleCommonService userRoleCommonService;
    @Autowired
    private ObjectIdUtil objectIdUtil;
    @Autowired
    private PayOrderMapper payOrderMapper;
    @Autowired
    private CrmLeadsService crmLeadsService;
    @Autowired
    private ShopSpuMapper shopSpuMapper;
    @Autowired
    private ScrmBizService scrmBizService;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;

    public void addRefundReason(String refundWayName) {
        if (StringUtils.isBlank((CharSequence)refundWayName)) {
            return;
        }
        SettingReqDto settingReq = new SettingReqDto();
        settingReq.setParamName(SettingEnum.REFUND_WAY.getName());
        settingReq.setStatus(YnEnum.YES.getValue());
        settingReq.setParamValue(refundWayName);
        this.settingService.modSetting(settingReq);
    }

    public List<String> listRefundReason(Long bizId, String refundName) {
        List settingList;
        if (bizId == null) {
            bizId = LoginUtils.getCurrentUserBizId();
        }
        if (CollectionUtils.isEmpty((Collection)(settingList = this.settingService.getSettingList(bizId, refundName, Integer.valueOf(SettingEnum.REFUND_WAY.getId()))))) {
            return Lists.newArrayList();
        }
        return settingList.stream().map(SettingRespDto::getParamValue).collect(Collectors.toList());
    }

    public void customerOrderAdd(CustomerOrderDto orderDto) {
        log.info("\u8ba2\u5355\u65b0\u589e\u53c2\u6570\uff1a:{}", (Object)JSON.toJSONString((Object)orderDto));
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        orderDto.setCreateBy(currentUser.getId());
        this.addParamCheck(orderDto);
        this.setServicePeriod(orderDto);
        String skuNo = "";
        skuNo = StringUtils.isNotBlank((CharSequence)orderDto.getOrderSkuListReqs().get(0).getProductId()) ? orderDto.getOrderSkuListReqs().get(0).getProductId() : orderDto.getOrderSkuListReqs().get(0).getSkuNo();
        this.paddingNetSchoolIdAndPayGroupKey(orderDto, skuNo, currentUser.getBizId());
        EntryOrderConfigresp orderConfigResp = this.queryAddOrderDynamicSetting(orderDto.getBizId(), orderDto.getCorpId());
        this.dynamicParamCheck(orderConfigResp, orderDto);
        try {
            this.submit(orderDto, orderConfigResp);
        }
        catch (BusinessException businessException) {
            log.error("add order Exception:", (Throwable)businessException);
            throw businessException;
        }
        catch (Exception exception) {
            log.error("add order Exception:", (Throwable)exception);
            String tipMsg = "\u8ba2\u5355\u65b0\u589e\u5f02\u5e38";
            if (exception instanceof IllegalArgumentException) {
                tipMsg = exception.getMessage();
            }
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, tipMsg);
        }
    }

    private void submit(CustomerOrderDto orderDto, EntryOrderConfigresp orderConfigResp) {
        OrderReq orderReq = this.convertOrderDtoToOrderReq(orderDto, orderConfigResp);
        boolean isOpenCrm = this.scrmBizService.isOpenCrm(orderDto.getBizId());
        boolean exists = false;
        if (isOpenCrm) {
            exists = this.isNewLeads(orderDto.getCorpId(), orderDto.getCustomerMobile());
            orderReq.setNewLeads(Integer.valueOf(!exists ? 1 : 0));
        }
        this.ccCustomerOrderService.addOrderManuel(orderReq);
        QueryOrderListReq params = new QueryOrderListReq();
        params.setBizId(orderDto.getBizId());
        params.setOrderNo(orderDto.getOrderNo());
        PageOrderListResp pageOrderListResp = this.ccCustomerOrderService.orderList(params);
        OrderListResp orderListResp = new OrderListResp();
        if (pageOrderListResp != null && CollectionUtils.isNotEmpty((Collection)pageOrderListResp.getList())) {
            orderListResp = (OrderListResp)pageOrderListResp.getList().get(0);
        }
        OrderSubmitReq orderSubmitReq = this.buildOrderSubmitReq(orderDto, orderListResp);
        List orderRecordReqs = orderSubmitReq.getOrderRecordReqs();
        for (OrderRecordReq recordReq : orderRecordReqs) {
            recordReq.setNewLeads(Integer.valueOf(!exists ? 1 : 0));
        }
        this.orderCenterService.submit(orderSubmitReq);
        List orderRefundInfoReqs = orderSubmitReq.getOrderRefundInfoReqs();
        if (CollectionUtils.isNotEmpty((Collection)orderRefundInfoReqs)) {
            List refundWays = orderRefundInfoReqs.stream().map(SetOrderRefundInfoReq::getRefundWay).collect(Collectors.toList());
            for (String refundWay : refundWays) {
                this.addRefundReason(refundWay);
            }
        }
    }

    private boolean isNewLeads(String corpId, String mobile) {
        boolean exists = false;
        if (StringUtils.isBlank((CharSequence)mobile)) {
            return exists;
        }
        CrmLeadsInfoReq req = new CrmLeadsInfoReq();
        req.setCorpId(corpId);
        req.setMobile(mobile);
        try {
            exists = this.crmLeadsService.exists(req);
        }
        catch (Exception e) {
            log.error("crm leads exists error: ", (Throwable)e);
        }
        return exists;
    }

    private OrderSubmitReq buildOrderSubmitReq(CustomerOrderDto orderDto, OrderListResp orderListResp) {
        OrderSubmitReq orderSubmitReq = new OrderSubmitReq();
        orderSubmitReq.setSource(orderDto.getSource());
        orderSubmitReq.setBizId(orderSubmitReq.getBizId());
        orderSubmitReq.setOrderRecordReqs(this.buildOrderRecord(orderDto, orderListResp.getPayRecordList()));
        orderSubmitReq.setLeadsReq(this.buildLeads(orderDto));
        orderSubmitReq.setOrderRefundInfoReqs(this.buildRefund(orderDto, orderListResp.getRefundOrderList()));
        orderSubmitReq.setAddressReq(this.buildAddress(orderDto));
        orderSubmitReq.setLogisticsReqs(this.buildLogistics(orderDto));
        return orderSubmitReq;
    }

    private List<SetOrderRefundInfoReq> buildRefund(CustomerOrderDto orderDto, List<RefundOrderListResp> refundOrderList) {
        List<Object> orderRefundInfoReqs;
        block4: {
            block3: {
                orderRefundInfoReqs = orderDto.getOrderRefundInfoReqs();
                List<Object> refundNums = Lists.newArrayList();
                if (CollectionUtils.isNotEmpty(refundOrderList)) {
                    refundNums = refundOrderList.stream().map(RefundOrderListResp::getNum).collect(Collectors.toList());
                }
                if (!CollectionUtils.isNotEmpty(orderRefundInfoReqs)) break block3;
                orderRefundInfoReqs = orderRefundInfoReqs.stream().map(item -> {
                    item.setOrderNo(orderDto.getOrderNo());
                    item.setRefundStatus(Integer.valueOf(RefundStatusEnum.REFUNDED.getValue()));
                    item.setEntry(Integer.valueOf(1));
                    item.setBizId(orderDto.getBizId());
                    return item;
                }).collect(Collectors.toList());
                List nowRefundNums = orderRefundInfoReqs.stream().map(SetOrderRefundInfoReq::getNum).collect(Collectors.toList());
                for (String string : refundNums) {
                    if (nowRefundNums.contains(string)) continue;
                    SetOrderRefundInfoReq refundInfoReq = new SetOrderRefundInfoReq();
                    refundInfoReq.setOrderNo(orderDto.getOrderNo());
                    refundInfoReq.setSource(orderDto.getSource());
                    refundInfoReq.setBizId(orderDto.getBizId());
                    refundInfoReq.setIsDeleted(Integer.valueOf(1));
                    refundInfoReq.setEntry(Integer.valueOf(1));
                    refundInfoReq.setNum(string);
                    orderRefundInfoReqs.add(refundInfoReq);
                }
                break block4;
            }
            orderRefundInfoReqs = Lists.newArrayList();
            if (!CollectionUtils.isNotEmpty(refundOrderList)) break block4;
            for (RefundOrderListResp item2 : refundOrderList) {
                SetOrderRefundInfoReq setOrderRefundInfoReq = new SetOrderRefundInfoReq();
                setOrderRefundInfoReq.setOrderNo(orderDto.getOrderNo());
                setOrderRefundInfoReq.setSource(orderDto.getSource());
                setOrderRefundInfoReq.setBizId(orderDto.getBizId());
                setOrderRefundInfoReq.setIsDeleted(Integer.valueOf(1));
                setOrderRefundInfoReq.setEntry(Integer.valueOf(1));
                setOrderRefundInfoReq.setNum(item2.getNum());
                orderRefundInfoReqs.add(setOrderRefundInfoReq);
            }
        }
        return orderRefundInfoReqs;
    }

    private List<OrderRecordReq> buildOrderRecord(CustomerOrderDto orderDto, List<OrderPayRecordResp> payRecordList) {
        List<Object> orderRecordReqs;
        block5: {
            block4: {
                orderRecordReqs = orderDto.getOrderRecordReqs();
                if (orderDto.getTradeAmount() == null) {
                    orderDto.setTradeAmount(0L);
                }
                List<Object> payNums = Lists.newArrayList();
                if (CollectionUtils.isNotEmpty(payRecordList)) {
                    payNums = payRecordList.stream().map(OrderPayRecordResp::getNum).collect(Collectors.toList());
                }
                if (!CollectionUtils.isNotEmpty(orderRecordReqs)) break block4;
                orderRecordReqs = orderRecordReqs.stream().map(item -> {
                    item.setOrderNo(orderDto.getOrderNo());
                    item.setSource(orderDto.getSource());
                    item.setBizId(orderDto.getBizId());
                    item.setEntry(Integer.valueOf(1));
                    if (item.getPayAmount() != null) {
                        orderDto.setTradeAmount(item.getPayAmount() + orderDto.getTradeAmount());
                    }
                    return item;
                }).collect(Collectors.toList());
                List nowPayNums = orderRecordReqs.stream().map(OrderRecordReq::getNum).collect(Collectors.toList());
                for (String string : payNums) {
                    if (nowPayNums.contains(string)) continue;
                    OrderRecordReq orderRecordReq = new OrderRecordReq();
                    orderRecordReq.setOrderNo(orderDto.getOrderNo());
                    orderRecordReq.setSource(orderDto.getSource());
                    orderRecordReq.setBizId(orderDto.getBizId());
                    orderRecordReq.setEntry(Integer.valueOf(1));
                    orderRecordReq.setIsDeleted(Integer.valueOf(1));
                    orderRecordReq.setNum(string);
                    orderRecordReqs.add(orderRecordReq);
                }
                break block5;
            }
            orderRecordReqs = Lists.newArrayList();
            if (!CollectionUtils.isNotEmpty(payRecordList)) break block5;
            for (OrderPayRecordResp item2 : payRecordList) {
                OrderRecordReq orderRecordReq = new OrderRecordReq();
                orderRecordReq.setOrderNo(orderDto.getOrderNo());
                orderRecordReq.setSource(orderDto.getSource());
                orderRecordReq.setBizId(orderDto.getBizId());
                orderRecordReq.setEntry(Integer.valueOf(1));
                orderRecordReq.setIsDeleted(Integer.valueOf(1));
                orderRecordReq.setNum(item2.getNum());
                orderRecordReqs.add(orderRecordReq);
            }
        }
        return orderRecordReqs;
    }

    private List<LogisticsReq> buildLogistics(CustomerOrderDto orderDto) {
        LogisticsReq logisticsReq = orderDto.getLogisticsReq();
        if (Objects.nonNull(logisticsReq)) {
            logisticsReq.setBizId(orderDto.getBizId());
            logisticsReq.setOrderNo(orderDto.getOrderNo());
            return Lists.newArrayList((Object[])new LogisticsReq[]{logisticsReq});
        }
        return Lists.newArrayList();
    }

    private CustomerDetailReq buildLeads(CustomerOrderDto orderDto) {
        CustomerDetailReq customerDetailReq = new CustomerDetailReq();
        customerDetailReq.setBizId(orderDto.getBizId());
        customerDetailReq.setMobile(orderDto.getCustomerMobile());
        customerDetailReq.setName(orderDto.getCustomerName());
        if (Objects.nonNull(orderDto.getUserId()) && orderDto.getUserId() == -1L) {
            customerDetailReq.setUserId(null);
        } else {
            customerDetailReq.setUserId(orderDto.getUserId());
        }
        customerDetailReq.setUserId(orderDto.getUserId());
        customerDetailReq.setTradeAmount(orderDto.getTradeAmount());
        log.info("buildLeads:requ:{}", (Object)JSON.toJSONString((Object)customerDetailReq));
        return customerDetailReq;
    }

    private AddressReq buildAddress(CustomerOrderDto orderDto) {
        AddressReq addressReq = new AddressReq();
        addressReq.setDeliveryAddress(orderDto.getReceiveAddress());
        addressReq.setBizId(orderDto.getBizId());
        return addressReq;
    }

    public List<CustomerOrderDto> importExcelFile(InputStream inp, String source) {
        try {
            List excelWorkbook = BackendExcelUtils.parseExcelStreamToList((InputStream)inp, ExcelCustomerOrderDto.class, this.buildImportExcelHeader());
            List<CustomerOrderDto> customerOrderDtos = this.convertExcelOrderToCustomerOrder(excelWorkbook, source);
            log.info("\u5bfc\u51fa\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)excelWorkbook));
            this.butchInsertCustomerOrderDto(customerOrderDtos);
            return customerOrderDtos;
        }
        catch (BusinessException businessException) {
            throw businessException;
        }
        catch (IllegalArgumentException e) {
            log.error("\u5bfc\u5165\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bfc\u5165\u8ba2\u5355\u6570\u636e\u5f02\u5e38");
        }
    }

    public List<CustomerOrderDto> convertExcelOrderToCustomerOrder(List<ExcelCustomerOrderDto> excelOrderList, String source) {
        if (CollectionUtils.isEmpty(excelOrderList)) {
            return Lists.newArrayList();
        }
        List filterExcelOrderList = excelOrderList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getSkuNo())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filterExcelOrderList)) {
            return Lists.newArrayList();
        }
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        EntryOrderConfigresp orderConfigResp = this.queryAddOrderDynamicSetting(currentUser.getBizId(), currentUser.getCorpId());
        List productIds = filterExcelOrderList.stream().map(ExcelCustomerOrderDto::getSkuNo).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        ScrmProductQueryReq productQueryReq = new ScrmProductQueryReq();
        productQueryReq.setProductIds(productIds);
        productQueryReq.setBizId(currentUser.getBizId());
        List scrmSkuProducts = this.scrmSkuService.queryProductListById(productQueryReq);
        Map productRespMap = scrmSkuProducts.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getProductId())).collect(Collectors.toMap(ScrmSkuProductResp::getProductId, Function.identity()));
        Map outProductRespMap = scrmSkuProducts.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getOutProductId())).collect(Collectors.toMap(ScrmSkuProductResp::getOutProductId, Function.identity()));
        return filterExcelOrderList.stream().map(item -> {
            User user;
            CustomerOrderDto customerOrderDto = new CustomerOrderDto();
            item.setBizId(currentUser.getBizId());
            item.setCorpId(currentUser.getCorpId());
            item.setSource(source);
            customerOrderDto.setPayStatus(PayStatusEnum.PAID.getValue());
            ScrmSkuProductResp scrmSkuProductResp = (ScrmSkuProductResp)productRespMap.get(item.getSkuNo());
            if (Objects.isNull(scrmSkuProductResp) && Objects.isNull(scrmSkuProductResp = (ScrmSkuProductResp)outProductRespMap.get(item.getSkuNo()))) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, " \u5546\u54c1\u7f16\u53f7\u4e3a:" + item.getSkuNo() + " \u672a\u627e\u5230");
            }
            ArrayList orderSkuInfo = Lists.newArrayList();
            OrderSkuListReq orderSkuListReq = new OrderSkuListReq();
            orderSkuListReq.setSkuName(scrmSkuProductResp.getTitle());
            orderSkuListReq.setSkuNo(scrmSkuProductResp.getProductId());
            orderSkuListReq.setBizId(currentUser.getBizId());
            orderSkuListReq.setTotalPrice(null);
            orderSkuListReq.setSkuAmount(null);
            String imagesUrls = Optional.ofNullable(scrmSkuProductResp.getHeadImgs()).map(images -> String.join((CharSequence)",", images)).orElse(null);
            orderSkuListReq.setSkuImgUrl(imagesUrls);
            orderSkuListReq.setBizId(customerOrderDto.getBizId());
            Long goodsNum = Optional.ofNullable(item.getGoodsNum()).orElse(1L);
            orderSkuListReq.setGoodsNum(goodsNum);
            orderSkuInfo.add(orderSkuListReq);
            customerOrderDto.setOrderSkuListReqs(orderSkuInfo);
            BeanUtils.copyProperties((Object)item, (Object)customerOrderDto);
            customerOrderDto.setCreateBy(currentUser.getId());
            LogisticsReq logisticsReq = new LogisticsReq();
            logisticsReq.setOrderNo(item.getOrderNo());
            logisticsReq.setBizId(currentUser.getBizId());
            logisticsReq.setCompanyName(item.getCompanyName());
            logisticsReq.setTrackingNo(item.getTrackingNo());
            customerOrderDto.setLogisticsReq(logisticsReq);
            OrderRecordReq orderRecordReq = new OrderRecordReq();
            orderRecordReq.setBizId(item.getBizId());
            orderRecordReq.setOrderNo(item.getOrderNo());
            orderRecordReq.setSource(item.getSource());
            orderRecordReq.setPayNo(item.getPayNo());
            orderRecordReq.setChannelType(item.getPaidChannelType());
            PayChannelType byDesc = PayChannelType.getByDesc((String)item.getPaidChannelTypeName());
            if (Objects.nonNull(byDesc)) {
                orderRecordReq.setChannelType(byDesc.getValue());
            }
            orderRecordReq.setPayAmount(item.getPaidAmount());
            customerOrderDto.setOrderRecordReqs(Lists.newArrayList((Object[])new OrderRecordReq[]{orderRecordReq}));
            String userMobile = customerOrderDto.getUserMobile();
            if (StringUtils.isNotBlank((CharSequence)userMobile) && MobileUtils.isPhone((String)userMobile) && Objects.nonNull(user = this.userMapper.selectUserByMobileAndCorpId(userMobile, item.getCorpId()))) {
                customerOrderDto.setUserId(user.getId());
            }
            customerOrderDto.setQqWechat(item.getQqWechat());
            ArrayList orderRefundInfoReqs = Lists.newArrayList();
            if (StringUtils.isNotBlank((CharSequence)item.getRefundNo())) {
                SetOrderRefundInfoReq refundInfoReq = new SetOrderRefundInfoReq();
                refundInfoReq.setBizId(item.getBizId());
                refundInfoReq.setOrderNo(item.getOrderNo());
                refundInfoReq.setSource(item.getSource());
                refundInfoReq.setRefundNo(item.getRefundNo());
                refundInfoReq.setRefundSerialNo(item.getRefundSerialNo());
                RefundTypeEnum refundTypeEnum = RefundTypeEnum.getByDesc((String)item.getRefundTypeName());
                if (Objects.nonNull(refundTypeEnum)) {
                    refundInfoReq.setRefundType(Integer.valueOf(refundTypeEnum.getValue()));
                }
                refundInfoReq.setRefundWay(item.getRefundWay());
                refundInfoReq.setReason(item.getRefundReason());
                refundInfoReq.setRefundAmount(item.getRefundAmount());
                orderRefundInfoReqs.add(refundInfoReq);
            }
            customerOrderDto.setOrderRefundInfoReqs(orderRefundInfoReqs);
            customerOrderDto.setOrderStatus(OrderStatusEnum.HAD_PAY.getValue());
            customerOrderDto.setRealServicePeriod(item.getRealServicePeriod());
            customerOrderDto.setFreeServicePeriod(item.getFreeServicePeriod());
            customerOrderDto.setValidateDateBegin(item.getValidateDateBegin());
            customerOrderDto.setValidateDateEnd(item.getValidateDateEnd());
            this.addParamCheck(customerOrderDto);
            this.setServicePeriod(customerOrderDto);
            this.dynamicParamCheck(orderConfigResp, customerOrderDto);
            return customerOrderDto;
        }).collect(Collectors.toList());
    }

    public List<ScrmOrderResp> queryOrderList(ScrmOrderQueryReq queryReq) {
        QueryOrderListReq queryOrderListReq = new QueryOrderListReq();
        BeanUtils.copyProperties((Object)queryReq, (Object)queryOrderListReq);
        queryOrderListReq.setPageDto(queryReq.getPageDto());
        PageOrderListResp pageOrderListResp = this.ccCustomerOrderService.orderList(queryOrderListReq);
        List respList = pageOrderListResp.getList();
        if (CollectionUtils.isEmpty((Collection)respList)) {
            return Lists.newArrayList();
        }
        boolean needEncryptMobile = this.isNeedEncryptMobile();
        return respList.stream().map(item -> {
            List payRecordList;
            List logisticsList;
            List refundOrderList;
            ScrmOrderResp scrmOrderResp = new ScrmOrderResp();
            BeanUtils.copyProperties((Object)item, (Object)scrmOrderResp);
            if (needEncryptMobile && StringUtils.isNotBlank((CharSequence)scrmOrderResp.getCustomerMobile())) {
                scrmOrderResp.setCustomerMobile(scrmOrderResp.getCustomerMobile());
            }
            if (CollectionUtils.isNotEmpty((Collection)(refundOrderList = item.getRefundOrderList()))) {
                long totalRefundAmount = refundOrderList.stream().mapToLong(RefundOrderListResp::getRefundAmount).sum();
                String totalRefundStr = PriceUtils.priceToStr((Long)totalRefundAmount, (Integer)4);
                scrmOrderResp.setTotalRefundPriceStr(totalRefundStr);
            }
            if (CollectionUtils.isNotEmpty((Collection)(logisticsList = item.getLogisticsList()))) {
                String trackIngNo = logisticsList.stream().map(LogisticsResp::getTrackingNo).filter(StringUtils::isNotBlank).collect(Collectors.joining(","));
                String companyName = logisticsList.stream().map(LogisticsResp::getCompanyName).filter(StringUtils::isNotBlank).collect(Collectors.joining(","));
                scrmOrderResp.setCompanyName(companyName);
                scrmOrderResp.setTrackingNo(trackIngNo);
            }
            if (CollectionUtils.isNotEmpty((Collection)(payRecordList = item.getPayRecordList()))) {
                long totalPay = payRecordList.stream().filter(pr -> Objects.equals(PayStatusEnum.PAID.getValue(), pr.getPayStatus())).mapToLong(OrderPayRecordResp::getPayAmount).sum();
                scrmOrderResp.setPaidAmount(totalPay);
                scrmOrderResp.setPaidTypeDesc(item.getPaidTypeDesc());
            }
            return scrmOrderResp;
        }).collect(Collectors.toList());
    }

    public void orderDel(CustomerOrderDto orderDto) {
        log.info("\u5220\u9664\u8ba2\u5355\u4fe1\u606f\uff0corderNo:{},operatorId:{}", (Object)orderDto.getOrderNo(), (Object)LoginUtils.getCurrentUser().getId());
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)orderDto.getOrderNo()), (Object)"\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        OrderReq orderReq = this.convertOrderDtoToOrderReq(orderDto, null);
        int payRecordCount = this.payRecordMapper.queryPayRecordCountByOrderNo(orderDto.getOrderNo());
        if (payRecordCount > 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8ba2\u5355\u5b58\u5728\u652f\u4ed8\u4fe1\u606f\u4e0d\u80fd\u5220\u9664");
        }
        this.ccCustomerOrderService.delOrder(orderReq);
    }

    public EntryOrderConfigresp queryAddOrderDynamicSetting(Long bizId, String corpId) {
        return this.ccCustomerOrderSettingService.getOrderSetting(bizId, corpId);
    }

    public void butchInsertCustomerOrderDto(List<CustomerOrderDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        EntryOrderConfigresp configResp = this.queryAddOrderDynamicSetting(currentUser.getBizId(), currentUser.getCorpId());
        for (CustomerOrderDto customerOrderDto : dtoList) {
            this.paddingNetSchoolIdAndPayGroupKey(customerOrderDto, customerOrderDto.getSkuNo(), currentUser.getBizId());
        }
        for (CustomerOrderDto customerOrderDto : dtoList) {
            this.submit(customerOrderDto, configResp);
        }
    }

    public void dynamicParamCheck(EntryOrderConfigresp orderConfigResp, CustomerOrderDto orderDto) {
        if (Objects.isNull(orderConfigResp)) {
            return;
        }
        if (YnEnum.YES.getValue().equals(orderConfigResp.getMobileRequire())) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)orderDto.getCustomerMobile()), (Object)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (YnEnum.YES.getValue().equals(orderConfigResp.getOrderTimeRequire())) {
            Preconditions.checkArgument((boolean)Objects.nonNull(orderDto.getOrderCreateTime()), (Object)"\u8ba2\u5355\u521b\u5efa\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (YnEnum.YES.getValue().equals(orderConfigResp.getNameRequire())) {
            Preconditions.checkArgument((boolean)Objects.nonNull(orderDto.getCustomerName()), (Object)"\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public List<ExcelHeader> buildImportExcelHeader() {
        ArrayList excelHeaders = Lists.newArrayList();
        excelHeaders.add(new ExcelHeader("customerName", "\u5ba2\u6237\u540d\u79f0"));
        excelHeaders.add(new ExcelHeader("customerMobile", "*\u5ba2\u6237\u624b\u673a\u53f7", "###0"));
        excelHeaders.add(new ExcelHeader("qqWechat", "\u5ba2\u6237qq\u6216\u5fae\u4fe1"));
        excelHeaders.add(new ExcelHeader("orderNo", "*\u8ba2\u5355\u7f16\u53f7"));
        excelHeaders.add(new ExcelHeader("orderCreateTime", "\u4e0b\u5355\u65f6\u95f4", "yyyy-MM-dd HH:mm:ss"));
        excelHeaders.add(new ExcelHeader("realServicePeriod", "*\u670d\u52a1\u5468\u671f\uff08\u5b9e\u9645\uff09"));
        excelHeaders.add(new ExcelHeader("freeServicePeriod", "*\u670d\u52a1\u5468\u671f\uff08\u8d60\u9001\uff09"));
        excelHeaders.add(new ExcelHeader("validateDateBegin", "*\u8bfe\u7a0b\u6709\u6548\u8d77\u59cb\u65f6\u95f4", "yyyy-MM-dd"));
        excelHeaders.add(new ExcelHeader("validateDateEnd", "*\u8bfe\u7a0b\u6709\u6548\u7ed3\u675f\u65f6\u95f4", "yyyy-MM-dd"));
        excelHeaders.add(new ExcelHeader("skuNo", "*\u5546\u54c1\u7f16\u53f7"));
        excelHeaders.add(new ExcelHeader("goodsNum", "\u5546\u54c1\u6570\u91cf", "###0"));
        excelHeaders.add(new ExcelHeader("orderAmount", "*\u8ba2\u5355\u91d1\u989d", Boolean.TRUE));
        excelHeaders.add(new ExcelHeader("discountAmount", "\u4f18\u60e0\u91d1\u989d", Boolean.TRUE));
        excelHeaders.add(new ExcelHeader("shouldPayAmount", "\u5e94\u4ed8\u91d1\u989d", Boolean.TRUE));
        excelHeaders.add(new ExcelHeader("paidAmount", "*\u5b9e\u4ed8\u91d1\u989d", Boolean.TRUE));
        excelHeaders.add(new ExcelHeader("paidChannelTypeName", "\u652f\u4ed8\u65b9\u5f0f"));
        excelHeaders.add(new ExcelHeader("payNo", "\u652f\u4ed8\u6d41\u6c34\u53f7", "###0"));
        excelHeaders.add(new ExcelHeader("refundAmount", "\u9000\u6b3e\u91d1\u989d", Boolean.TRUE));
        excelHeaders.add(new ExcelHeader("refundNo", "\u9000\u6b3e\u5355", "###0"));
        excelHeaders.add(new ExcelHeader("refundWay", "\u9000\u6b3e\u65b9\u5f0f", "###0"));
        excelHeaders.add(new ExcelHeader("refundReason", "\u9000\u6b3e\u539f\u56e0", "###0"));
        excelHeaders.add(new ExcelHeader("refundSerialNo", "\u9000\u6b3e\u6d41\u6c34\u53f7", "###0"));
        excelHeaders.add(new ExcelHeader("userMobile", "\u6210\u5355\u4eba\u624b\u673a\u53f7", "###0"));
        excelHeaders.add(new ExcelHeader("remark", "\u5907\u6ce8"));
        return excelHeaders;
    }

    public List<ExcelHeader> buildExportExcelHeader() {
        ArrayList excelHeaders = Lists.newArrayList();
        excelHeaders.add(new ExcelHeader("orderNo", "*\u8ba2\u5355\u7f16\u53f7"));
        excelHeaders.add(new ExcelHeader("orderTime", "\u4e0b\u5355\u65f6\u95f4"));
        excelHeaders.add(new ExcelHeader("sourceDesc", "\u8ba2\u5355\u6765\u6e90"));
        excelHeaders.add(new ExcelHeader("skuNames", "*\u5546\u54c1\u540d"));
        excelHeaders.add(new ExcelHeader("orderAmount", "\u8ba2\u5355\u91d1\u989d", Boolean.TRUE));
        excelHeaders.add(new ExcelHeader("discountAmount", "\u4f18\u60e0\u91d1\u989d", Boolean.TRUE));
        excelHeaders.add(new ExcelHeader("paidAmount", "\u5b9e\u4ed8\u91d1\u989d", Boolean.TRUE));
        excelHeaders.add(new ExcelHeader("shouldPayAmount", "\u5e94\u4ed8\u91d1\u989d", Boolean.TRUE));
        excelHeaders.add(new ExcelHeader("paidTypeDesc", "\u652f\u4ed8\u65b9\u5f0f"));
        excelHeaders.add(new ExcelHeader("customerName", "\u5ba2\u6237\u540d\u79f0"));
        excelHeaders.add(new ExcelHeader("customerMobile", "\u5ba2\u6237\u624b\u673a\u53f7"));
        excelHeaders.add(new ExcelHeader("userName", "\u6210\u5355\u4eba"));
        excelHeaders.add(new ExcelHeader("achieveDepartDesc", "\u4e1a\u7ee9\u5f52\u5c5e\u90e8\u95e8"));
        excelHeaders.add(new ExcelHeader("entryUser", "\u5f55\u5165\u4eba"));
        excelHeaders.add(new ExcelHeader("entryTime", "\u5f55\u5165\u65f6\u95f4"));
        excelHeaders.add(new ExcelHeader("remark", "\u5907\u6ce8"));
        excelHeaders.add(new ExcelHeader("totalRefundPriceStr", "\u9000\u6b3e\u91d1\u989d"));
        excelHeaders.add(new ExcelHeader("studentTypeName", "\u5ba2\u6237\u6765\u6e90"));
        excelHeaders.add(new ExcelHeader("channelName", "\u5ba2\u6237\u6e20\u9053"));
        return excelHeaders;
    }

    public List<KeyName<Integer>> getPaidChannelType() {
        return Arrays.stream(PayChannelType.values()).map(item -> {
            KeyName<Integer> keyName = new KeyName<Integer>();
            keyName.setKey(item.getValue());
            keyName.setName(item.getDesc());
            return keyName;
        }).collect(Collectors.toList());
    }

    private void addParamCheck(CustomerOrderDto orderDto) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)orderDto.getOrderNo()), (Object)"\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isBlank((CharSequence)orderDto.getId())) {
            Preconditions.checkArgument((this.checkOrderExist(orderDto.getOrderNo()) == false ? 1 : 0) != 0, (Object)("\u5f53\u524d\u8ba2\u5355\u53f7\uff1a " + orderDto.getOrderNo() + "\u5df2\u5b58\u5728"));
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)orderDto.getSource()), (Object)"\u8ba2\u5355\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((orderDto.getRealServicePeriod() != null && orderDto.getRealServicePeriod() >= 0 ? 1 : 0) != 0, (Object)"\u5b9e\u9645\u670d\u52a1\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((orderDto.getFreeServicePeriod() != null && orderDto.getFreeServicePeriod() >= 0 ? 1 : 0) != 0, (Object)"\u8d60\u9001\u670d\u52a1\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((orderDto.getValidateDateBegin() != null ? 1 : 0) != 0, (Object)"\u8bfe\u7a0b\u6709\u6548\u8d77\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((orderDto.getValidateDateEnd() != null ? 1 : 0) != 0, (Object)"\u8bfe\u7a0b\u6709\u6548\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)orderDto.getValidateDateEnd().after(orderDto.getValidateDateBegin()), (Object)"\u8bfe\u7a0b\u6709\u6548\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u8d77\u59cb\u65f6\u95f4");
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)orderDto.getSkuName()) || CollectionUtils.isNotEmpty(orderDto.getOrderSkuListReqs()) || CollectionUtils.isNotEmpty(orderDto.getSkuNames()) ? 1 : 0) != 0, (Object)"\u8d2d\u4e70\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(orderDto.getOrderAmount()), (Object)"\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotBlank((CharSequence)orderDto.getCustomerMobile())) {
            Preconditions.checkArgument((boolean)MobileUtils.isPhone((String)orderDto.getCustomerMobile()), (Object)("\u7528\u6237\u624b\u673a\u53f7\uff1a" + orderDto.getCustomerMobile() + "\u683c\u5f0f\u4e0d\u6b63\u786e"));
        }
        if (orderDto.getOrderStatus() != null && orderDto.getOrderStatus().intValue() != PayOrderStatusEnum.WAIT_PAY.getValue()) {
            List<OrderRecordReq> orderRecordReqs = orderDto.getOrderRecordReqs();
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(orderRecordReqs), (Object)"\u8ba2\u5355\u652f\u4ed8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            for (OrderRecordReq orderRecordReq : orderRecordReqs) {
                Preconditions.checkArgument((boolean)Objects.nonNull(orderRecordReq.getPayAmount()), (Object)"\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        List<OrderSkuListReq> orderSkuListReqs = orderDto.getOrderSkuListReqs();
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(orderSkuListReqs), (Object)"\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        for (OrderSkuListReq ork : orderSkuListReqs) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)ork.getSkuName()), (Object)"\u5546\u54c1\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)ork.getSkuNo()), (Object)"\u5546\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)Objects.nonNull(ork.getGoodsNum()), (Object)"\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((CharSequence)orderDto.getUserMobile())) {
            Preconditions.checkArgument((boolean)MobileUtils.isPhone((String)orderDto.getUserMobile()), (Object)("\u6210\u5355\u4eba\u624b\u673a\u53f7\uff1a" + orderDto.getUserMobile() + "\u683c\u5f0f\u4e0d\u6b63\u786e"));
        }
        if (CollectionUtils.isNotEmpty(orderDto.getPaymentVoucherUrlList())) {
            Preconditions.checkArgument((orderDto.getPaymentVoucherUrlList().size() <= 5 ? 1 : 0) != 0, (Object)"\u652f\u4ed8\u51ed\u8bc1\u6700\u591a\u53ea\u80fd\u4e0a5\u6761");
        }
        PayOrder payOrder = this.payOrderMapper.queryByOrderNo(orderDto.getOrderNo());
        PayRecord latestPayRecord = this.payRecordMapper.queryLatestPayRecordByOrderNo(orderDto.getOrderNo());
        if (Objects.nonNull(latestPayRecord) && Objects.nonNull(payOrder) && Objects.equals(PayStatusEnum.UNPAID.getValue(), latestPayRecord.getStatus())) {
            Preconditions.checkArgument((!Objects.equals(payOrder.getTotalAmount(), orderDto.getOrderAmount()) ? 1 : 0) != 0, (Object)"\u5f85\u652f\u4ed8\u8ba2\u5355\u6682\u4e0d\u652f\u6301\u91d1\u989d\u4fee\u6539\uff0c\u60a8\u53ef\u4ee5\u91cd\u65b0\u4e0b\u5355");
        }
    }

    private void setServicePeriod(CustomerOrderDto orderDto) {
        Date now = new Date();
        Date realStartTime = orderDto.getOrderCreateTime() != null ? orderDto.getOrderCreateTime() : now;
        orderDto.setRealServicePeriodTime(DateUtil.addMonthsToDate((Date)realStartTime, (Integer)orderDto.getRealServicePeriod()));
        orderDto.setFreeServicePeriodTime(DateUtil.addMonthsToDate((Date)now, (Integer)orderDto.getFreeServicePeriod()));
    }

    private Boolean checkOrderExist(String orderNo) {
        Boolean exist = false;
        try {
            exist = this.ccCustomerOrderService.checkOrderExist(orderNo);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u6821\u9a8c\u8ba2\u5355\u53f7\u662f\u5426\u5b58\u5728\u63a5\u53e3\u5931\u8d25\uff1a:", (Throwable)e);
            exist = false;
        }
        return exist;
    }

    private OrderReq convertOrderDtoToOrderReq(CustomerOrderDto orderDto, EntryOrderConfigresp orderConfigResp) {
        OrderReq orderReq = new OrderReq();
        BeanUtils.copyProperties((Object)orderDto, (Object)orderReq);
        if (orderReq.getIsContainPhysical() == null) {
            orderReq.setIsContainPhysical(Boolean.valueOf(false));
        }
        orderReq.setEntryMethod(OrderEntryMethodEnum.MANUAL.getValue());
        orderReq.setCreateTime(orderDto.getOrderCreateTime());
        orderReq.setDynamicColValue(this.buildDynamicColValue(orderDto, orderConfigResp));
        String comineUrl = CollectionUtils.isNotEmpty(orderDto.getPaymentVoucherUrlList()) ? String.join((CharSequence)",", orderDto.getPaymentVoucherUrlList()) : null;
        orderReq.setPaymentVoucherUrl(comineUrl);
        orderReq.setDeliveryAddress(orderDto.getReceiveAddress());
        orderReq.setUserId(Long.valueOf(Objects.isNull(orderDto.getUserId()) ? -1L : orderDto.getUserId()));
        if (CollectionUtils.isNotEmpty(orderDto.getOrderSkuListReqs())) {
            for (OrderSkuListReq req : orderDto.getOrderSkuListReqs()) {
                if (GoodsOrderSource.isFromSystem((String)req.getSource()) || !StringUtils.isNotBlank((CharSequence)req.getOutProductId())) continue;
                req.setSkuNo(req.getOutProductId());
            }
        }
        orderReq.setOrderSkuListReqs(orderDto.getOrderSkuListReqs());
        orderReq.setStatus(orderDto.getOrderStatus());
        orderReq.setSchoolId(orderDto.getNetSchoolId());
        orderReq.setPayGroupKey(orderDto.getPayGroupKey());
        log.info("build add order param:{}", (Object)JSON.toJSONString((Object)orderReq));
        return orderReq;
    }

    private List<ExtendFieldDto> buildDynamicColValue(CustomerOrderDto orderDto, EntryOrderConfigresp orderConfigResp) {
        if (Objects.isNull(orderConfigResp)) {
            log.warn("\u540e\u7aef\u6ca1\u6709\u8ba2\u5355\u914d\u7f6e\u9879");
            return Lists.newArrayList();
        }
        log.info("\u524d\u7aef\u4f20\u5165\u7684\u52a8\u6001\u5b57\u6bb5\uff1a:{}; \u6570\u636e\u5e93\u89e3\u6790\u7684\u52a8\u6001\u5b57\u6bb5\uff1a{}", orderDto.getDynamicFieldValue(), (Object)orderConfigResp.getExtendField());
        if (CollectionUtils.isEmpty((Collection)orderConfigResp.getExtendField())) {
            log.warn("\u540e\u7aef\u6ca1\u6709\u914d\u7f6e\u52a8\u6001\u5b57\u6bb5\u5c5e\u6027\uff1a{}", (Object)JSON.toJSONString((Object)orderConfigResp));
            return Lists.newArrayList();
        }
        List dynamicKeys = orderConfigResp.getExtendField().stream().map(DynamicFieldDto::getKey).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(orderDto.getDynamicFieldValue()) || CollectionUtils.isEmpty(dynamicKeys)) {
            return Lists.newArrayList();
        }
        List<ExtendFieldDto> dynamicColValue = orderDto.getDynamicFieldValue().stream().map(item -> {
            if (dynamicKeys.contains(item.getKey()) && StringUtils.isNotBlank((CharSequence)item.getValue())) {
                return item;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        log.info("add order orderNo:{},dynamicFiledValue:{}", (Object)orderDto.getOrderNo(), (Object)JSON.toJSONString(dynamicColValue));
        return dynamicColValue;
    }

    private boolean isNeedEncryptMobile() {
        return this.settingService.getMobileEncrypt(LoginUtils.getCurrentUserBizId());
    }

    public OrderListResp orderDetail(CustomerOrderDto param) {
        Map nameByIds;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)param.getId()), (Object)"\u8ba2\u5355num \u4e0d\u80fd\u4e3a\u7a7a");
        OrderListResp orderListResp = this.ccCustomerOrderService.customerOrdDetail(param.getId());
        if (Objects.isNull(orderListResp)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5f53\u524d\u8ba2\u5355\u4fe1\u606f\u672a\u627e\u5230");
        }
        if (Objects.nonNull(orderListResp.getAchieveDepartId()) && MapUtils.isNotEmpty((Map)(nameByIds = this.nodeService.getNameByIds(orderListResp.getBizId(), (Collection)Sets.newHashSet((Object[])new Long[]{orderListResp.getAchieveDepartId()}))))) {
            orderListResp.setAchieveDepartDesc((String)nameByIds.get(orderListResp.getAchieveDepartId()));
        }
        orderListResp.setConsultantName(this.userMapper.getUserNameByUserId(orderListResp.getConsultantId()));
        Set skuNos = orderListResp.getSkuList().stream().map(OrderSkuResp::getSkuNo).collect(Collectors.toSet());
        List shopSpus = this.shopSpuMapper.selectByProductIds(skuNos);
        if (CollectionUtils.isNotEmpty((Collection)shopSpus)) {
            Map productId2ShopSpuMap = shopSpus.stream().collect(Collectors.toMap(ShopSpu::getProductId, Functions.identity()));
            for (OrderSkuResp resp : orderListResp.getSkuList()) {
                ShopSpu shopSpu = (ShopSpu)productId2ShopSpuMap.get(resp.getSkuNo());
                if (shopSpu == null) continue;
                resp.setSource(shopSpu.getSource());
                resp.setNeedAddress(JSONObject.parseObject((String)shopSpu.getSpuBody()).getInteger("needAddress"));
                if (StringUtils.isNotBlank((CharSequence)shopSpu.getCourseFormat())) {
                    resp.setCourseFormats(Arrays.asList(shopSpu.getCourseFormat().split(",")));
                }
                if (!StringUtils.isNotBlank((CharSequence)shopSpu.getLivePlatform())) continue;
                resp.setLivePlatforms(Arrays.asList(shopSpu.getLivePlatform().split(",")));
            }
        }
        return orderListResp;
    }

    public void orderAssignUpdate(OrderAssignUpdateReq req) {
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)req.getAssignUserId()) || StringUtils.isNotBlank((CharSequence)req.getAssignDeptId()) ? 1 : 0) != 0, (Object)"\u4e1a\u7ee9\u5f52\u5c5e\u4e0d\u80fd\u4e3a\u7a7a");
        Long assignUserId = null;
        Long bizId = null;
        if (StringUtils.isNotBlank((CharSequence)req.getAssignUserId())) {
            User user = this.userMapper.getUserByNum(req.getAssignUserId());
            Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"\u4e1a\u7ee9\u5f52\u5c5e\u4eba\u4e0d\u5b58\u5728");
            bizId = user.getBizId();
            assignUserId = user.getId();
        }
        Long assignDeptId = null;
        if (StringUtils.isNotBlank((CharSequence)req.getAssignDeptId())) {
            Organization organization = this.organizationMapper.getByNum(req.getAssignDeptId());
            Preconditions.checkArgument((organization != null ? 1 : 0) != 0, (Object)"\u4e1a\u7ee9\u5f52\u5c5e\u90e8\u95e8\u4e0d\u5b58\u5728");
            bizId = organization.getBizId();
            assignDeptId = organization.getId();
        }
        this.ccCustomerOrderService.batchUpdate(bizId, req.getOrderNos(), assignUserId, assignDeptId);
    }

    public String getOrderNo() {
        return "dd" + this.objectIdUtil.generateId();
    }

    public void setOrderOpParams(List<OrderListResp> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Set manageUserIds = this.userRoleCommonService.getManageUserIds();
        List orderNos = list.stream().map(OrderListResp::getOrderNo).collect(Collectors.toList());
        Map recordCountMap = this.payRecordMapper.queryPayRecordCountMap(orderNos);
        for (OrderListResp order : list) {
            order.setEnableEdit(false);
            order.setEnableDel(false);
            order.setUseInnerPay(false);
            if (recordCountMap.getOrDefault(order.getOrderNo(), 0) > 0) {
                order.setUseInnerPay(true);
            }
            if (order.getIsEntry() == null || order.getIsEntry() != 1) continue;
            if (manageUserIds.contains(order.getCreateBy()) && !order.isUseInnerPay()) {
                order.setEnableDel(true);
            }
            if (!userInfo.getId().equals(order.getCreateBy()) || order.isUseInnerPay()) continue;
            order.setEnableEdit(true);
        }
    }

    private void paddingNetSchoolIdAndPayGroupKey(CustomerOrderDto orderDto, String skuNo, Long operatorBizId) {
        ShopSpu shopSpu = this.shopSpuMapper.queryByProductId(skuNo);
        String corpId = this.businessCustomerMapper.getCorpIdById(shopSpu.getBizId());
        orderDto.setNetSchoolId(shopSpu.getNetSchoolId());
        orderDto.setBizId(shopSpu.getBizId());
        orderDto.setCorpId(corpId);
        boolean isMainBiz = this.scrmBizService.isMainBiz(shopSpu.getBizId());
        String payGroupKey = this.organizationMapper.selectPayGroupKeyByBizIdAndSchoolId(shopSpu.getBizId(), shopSpu.getNetSchoolId());
        if (StringUtils.isBlank((CharSequence)payGroupKey)) {
            log.info("paddingNetSchoolIdAndPayGroupKey,payGroupKey is null,bizId:{},productId:{},netSchoolId:{}", new Object[]{shopSpu.getBizId(), skuNo, shopSpu.getNetSchoolId()});
            if (!isMainBiz) {
                payGroupKey = this.organizationMapper.selectPayGroupKeyByBizIdAndSchoolId(this.scrmBizService.getMainBizId(), shopSpu.getNetSchoolId());
            }
            if (StringUtils.isBlank((CharSequence)payGroupKey)) {
                log.info("paddingNetSchoolIdAndPayGroupKey,payGroupKey is null,bizId:{},productId:{},netSchoolId:{}", new Object[]{operatorBizId, skuNo, shopSpu.getNetSchoolId()});
                String errorMsg = "\u6821\u533a\u672a\u914d\u7f6e\u652f\u4ed8\u5546\u6237\uff0c\u8bf7\u5148\u914d\u7f6e\u540e\uff0c\u518d\u5f55\u5165\u8ba2\u5355";
                if (shopSpu.getNetSchoolId() != null) {
                    errorMsg = errorMsg + ":" + shopSpu.getBizId() + ":" + shopSpu.getNetSchoolId();
                }
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, errorMsg);
            }
        }
        orderDto.setPayGroupKey(payGroupKey);
    }

    public void setSpuInfo(List<OrderListResp> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        HashSet skuNos = Sets.newHashSet();
        for (OrderListResp orderListResp : list) {
            Set skuNosList;
            if (CollectionUtils.isEmpty((Collection)orderListResp.getSkuList()) || !CollectionUtils.isNotEmpty(skuNosList = orderListResp.getSkuList().stream().map(OrderSkuResp::getSkuNo).filter(StringUtils::isNotBlank).collect(Collectors.toSet()))) continue;
            skuNos.addAll(skuNosList);
        }
        if (CollectionUtils.isEmpty((Collection)skuNos)) {
            return;
        }
        log.info("setSpuInfo: skuNos:{}", (Object)skuNos);
        List shopSpus = this.shopSpuMapper.selectByProductIds((Collection)skuNos);
        if (CollectionUtils.isEmpty((Collection)shopSpus)) {
            log.info("setSpuInfo: no spu found:{}", (Object)skuNos);
            return;
        }
        Map<String, ShopSpu> productId2ShopSpuMap = shopSpus.stream().collect(Collectors.toMap(ShopSpu::getProductId, a -> a, (u, v) -> v));
        for (OrderListResp orderListResp : list) {
            if (CollectionUtils.isEmpty((Collection)orderListResp.getSkuList())) continue;
            for (OrderSkuResp orderSkuResp : orderListResp.getSkuList()) {
                ShopSpu shopSpu;
                if (StringUtils.isBlank((CharSequence)orderSkuResp.getSkuNo()) || (shopSpu = productId2ShopSpuMap.get(orderSkuResp.getSkuNo())) == null) continue;
                orderSkuResp.setGoodsType(shopSpu.getNetSchoolGoodsType());
                if (StringUtils.isNotBlank((CharSequence)shopSpu.getCourseFormat())) {
                    orderSkuResp.setCourseFormats(Arrays.asList(shopSpu.getCourseFormat().split(",")));
                }
                if (!StringUtils.isNotBlank((CharSequence)shopSpu.getLivePlatform())) continue;
                orderSkuResp.setLivePlatforms(Arrays.asList(shopSpu.getLivePlatform().split(",")));
            }
        }
    }
}

