/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.contact.service.impl;

import com.alibaba.fastjson.JSON;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.enums.ExportTaskType;
import com.kuaike.scrm.common.excel.ExcelHeader;
import com.kuaike.scrm.common.utils.BackendExcelUtils;
import com.kuaike.scrm.dal.exporttask.entity.ExportTask;
import com.kuaike.scrm.dal.exporttask.mapper.ExportTaskMapper;
import com.kuaike.scrm.wework.contact.remote.ScrmOrderQueryReq;
import com.kuaike.scrm.wework.contact.service.impl.AbstractExportService;
import com.kuaike.scrm.wework.contact.support.CustomerOrderSupport;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="orderExport")
public class OrderExportServiceImpl
extends AbstractExportService {
    private static final Logger log = LoggerFactory.getLogger(OrderExportServiceImpl.class);
    @Autowired
    private ExportTaskMapper exportTaskMapper;
    @Autowired
    private CustomerOrderSupport customerOrderSupport;

    @Override
    protected Runnable buildTask(ExportTask task, String json) {
        return () -> {
            if (Objects.isNull(task)) {
                log.error("build status is null");
                return;
            }
            try {
                log.info("run task num: {},json:{}", (Object)task.getNum(), (Object)json);
                String filePath = this.createExportFile(task, json);
                task.setFilePath(filePath);
            }
            catch (BusinessException e) {
                log.error("build task error: ", (Throwable)e);
                task.setErrorMsg(e.getMessage());
            }
            catch (Exception e) {
                log.error("build task error: ", (Throwable)e);
                task.setErrorMsg("\u521b\u5efa\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            }
            finally {
                task.setStatus(Integer.valueOf(2));
                task.setUpdateTime(new Date());
                this.exportTaskMapper.updateByPrimaryKeySelective((Object)task);
            }
        };
    }

    private String createExportFile(ExportTask task, String json) {
        String corpId = task.getCorpId();
        this.createCorpDir(corpId);
        PageDto pageDto = new PageDto();
        pageDto.setPageNum(Integer.valueOf(1));
        pageDto.setPageSize(Integer.valueOf(100));
        return this.exportExcel(corpId, task.getBizId(), json, pageDto, task.getIsSystemAdmin(), task.getExcludeBizIds());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String exportExcel(String corpId, Long bizId, String queryJSON, PageDto pageDto, Boolean isSystemAdmin, List<Long> excludeBizIds) {
        String url = null;
        String filePath = null;
        try {
            List<ExcelHeader> excelHeaders = this.customerOrderSupport.buildExportExcelHeader();
            ScrmOrderQueryReq queryParam = (ScrmOrderQueryReq)JSON.parseObject((String)queryJSON, ScrmOrderQueryReq.class);
            queryParam.setBizId(bizId);
            queryParam.setPageDto(pageDto);
            queryParam.setIsSystemAdmin(isSystemAdmin);
            queryParam.setExcludeBizIds(excludeBizIds);
            filePath = this.createFilePath(corpId, ExportTaskType.ORDER_EXPORT, null);
            BackendExcelUtils.doButchListToExcel((String)filePath, (Serializable)queryParam, param -> this.customerOrderSupport.queryOrderList((ScrmOrderQueryReq)param), excelHeaders, (String)"\u8ba2\u5355\u5bfc\u51fa", (Boolean)true);
            File file = new File(filePath);
            if (file.exists()) {
                url = this.uploadOss(corpId, file);
            }
        }
        catch (BusinessException e) {
            try {
                log.error("\u5bfc\u51fa\u6587\u4ef6\u5f02\u5e38\uff1aexception:{}", (Object)e.getMessage());
                throw e;
                catch (IOException e2) {
                    log.error("createExportFile IOException error: ", (Throwable)e2);
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "json\u683c\u5f0f\u9519\u8bef");
                }
                catch (Exception e3) {
                    log.error("createExportFile error: ", (Throwable)e3);
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u521b\u5efa\u6587\u4ef6\u5931\u8d25");
                }
            }
            catch (Throwable throwable) {
                if (!StringUtils.isNotBlank(filePath)) throw throwable;
                File file = new File(filePath);
                if (!file.exists()) throw throwable;
                file.deleteOnExit();
                throw throwable;
            }
        }
        if (!StringUtils.isNotBlank((CharSequence)filePath)) return url;
        File file = new File(filePath);
        if (!file.exists()) return url;
        file.deleteOnExit();
        return url;
    }
}

