/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.chatroom.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.wework.dto.RoomMemberQueryParams;
import com.kuaike.scrm.dal.wework.entity.WeworkChatRoomRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.wework.chatroom.dto.request.RoomMemberReqDto;
import com.kuaike.scrm.wework.chatroom.dto.response.RoomMemberRespDto;
import com.kuaike.scrm.wework.chatroom.service.RoomMemberService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RoomMemberServiceImpl
implements RoomMemberService {
    private static final Logger log = LoggerFactory.getLogger(RoomMemberServiceImpl.class);
    public static final int IS_CUSTOMER_YES = 1;
    public static final int IS_CUSTOMER_NO = 0;
    @Autowired
    private WeworkChatRoomRelationMapper weworkChatRoomRelationMapper;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Resource
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private UserRoleCommonService userRoleCommonService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;

    @Override
    public List<RoomMemberRespDto> queryMemberList(RoomMemberReqDto reqDto) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        reqDto.validateListParams(currentUserInfo);
        log.info("queryMemberList: reqDto:{}, bizId:{}, corpId:{}", new Object[]{reqDto, currentUserInfo.getBizId(), currentUserInfo.getCorpId()});
        RoomMemberQueryParams params = reqDto.convertToQueryCondition(currentUserInfo.getBizId(), currentUserInfo.getCorpId(), reqDto.getWeworkRoomId());
        List roomRelations = this.weworkChatRoomRelationMapper.getListByCondition(params);
        if (CollectionUtils.isEmpty((Collection)roomRelations)) {
            log.warn("queryMemberList: \u6839\u636e\u67e5\u8be2\u6761\u4ef6:{}\u672a\u83b7\u53d6\u5230\u8bb0\u5f55", (Object)params);
            return Collections.emptyList();
        }
        int count = this.weworkChatRoomRelationMapper.getCountByCondition(params);
        if (Objects.nonNull(reqDto.getPageDto())) {
            reqDto.getPageDto().setCount(Integer.valueOf(count));
            reqDto.getPageDto().setCurPageCount(Integer.valueOf(roomRelations.size()));
        }
        Set memberIds = roomRelations.stream().map(WeworkChatRoomRelation::getMemberId).collect(Collectors.toSet());
        Map<String, WeworkContact> weworkContactMap = this.weworkContactMapper.queryWeworkContactList(currentUserInfo.getCorpId(), memberIds).stream().collect(Collectors.toMap(WeworkContact::getContactId, a -> a, (k1, k2) -> k2));
        Map<String, WeworkUser> weworkUserMap = this.weworkUserMapper.queryWeworkUserInfoList(currentUserInfo.getCorpId(), memberIds).stream().collect(Collectors.toMap(WeworkUser::getWeworkUserId, a -> a, (k1, k2) -> k2));
        Map weworkUserId2NumMap = this.weworkUserMapper.selectWeworkUserIdAndNumByWeworkUserIds(currentUserInfo.getCorpId(), memberIds);
        log.info("queryMemberList: weworkUserId2NumMap:{}", (Object)weworkUserId2NumMap);
        Set managerUserIds = this.userRoleCommonService.getManageUserIds();
        Set<Object> managerWeworkUserIds = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty((Collection)managerUserIds)) {
            List users = this.userMapper.getUserInfoByIds((Collection)managerUserIds);
            managerWeworkUserIds = users.stream().map(User::getWeworkUserId).collect(Collectors.toSet());
        }
        log.info("queryMemberList: \u7ba1\u7406\u7684\u6210\u5458id:{}", (Object)managerUserIds);
        Map<Object, Object> contactRelationMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)managerUserIds)) {
            List contactRelations = this.weworkContactRelationMapper.selectByCorpIdAndContactIdsAndWeworkUserIds(currentUserInfo.getCorpId(), memberIds, (Collection)managerWeworkUserIds);
            contactRelationMap = contactRelations.stream().filter(a -> Objects.nonNull(a.getIsDeleted()) && a.getIsDeleted() == 0).collect(Collectors.toMap(WeworkContactRelation::getContactId, a -> a, (k, v) -> v));
        }
        return this.buildMemberList(roomRelations, weworkContactMap, weworkUserMap, weworkUserId2NumMap, managerWeworkUserIds, contactRelationMap, currentUserInfo.getBizId());
    }

    private List<RoomMemberRespDto> buildMemberList(List<WeworkChatRoomRelation> roomRelations, Map<String, WeworkContact> contactMap, Map<String, WeworkUser> weworkUserMap, Map<String, String> weworkUserId2NumMap, Set<String> managerWeworkUserIds, Map<String, WeworkContactRelation> contactRelationMap, Long bizId) {
        ArrayList channelRespDtos = Lists.newArrayList();
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        String curCorpName = this.weworkCorpMapper.getByCorpId(currentUserInfo.getCorpId()).getCorpName();
        for (WeworkChatRoomRelation relation : roomRelations) {
            RoomMemberRespDto dto = new RoomMemberRespDto();
            dto.setBizId(bizId);
            dto.setIsAdmin(relation.getIsAdmin());
            dto.setIsOwner(relation.getIsOwner());
            dto.setType(relation.getType());
            dto.setJoinTime(relation.getJoinTime());
            dto.setJoinScene(relation.getJoinScene());
            dto.setHasPermissionSee(NumberUtils.INTEGER_ZERO);
            dto.setGroupNickname(relation.getGroupNickname());
            if (MapUtils.isNotEmpty(contactMap) && contactMap.containsKey(relation.getMemberId())) {
                WeworkContact weworkContact = contactMap.get(relation.getMemberId());
                dto.setIsCustomer(1);
                dto.setCorpName(weworkContact.getCorpName());
                dto.setNickname(weworkContact.getName());
                dto.setMemberId(relation.getMemberId());
                dto.setCustomerNum(weworkContact.getCustomerNum());
                dto.setAvatar(weworkContact.getAvatar());
                if (contactRelationMap.containsKey(relation.getMemberId())) {
                    dto.setHasPermissionSee(NumberUtils.INTEGER_ONE);
                }
            } else if (MapUtils.isNotEmpty(weworkUserMap) && weworkUserMap.containsKey(relation.getMemberId())) {
                WeworkUser weworkUser = weworkUserMap.get(relation.getMemberId());
                dto.setIsCustomer(0);
                dto.setAvatar(weworkUser.getAvatar());
                dto.setCorpName(curCorpName);
                dto.setNickname(weworkUser.getName());
                dto.setIsDimission(weworkUser.getIsDeleted());
                if (MapUtils.isNotEmpty(weworkUserId2NumMap) && weworkUserId2NumMap.containsKey(relation.getMemberId())) {
                    dto.setMemberId(weworkUserId2NumMap.get(relation.getMemberId()));
                } else {
                    log.error("buildMemberList: \u6210\u5458weworkUserId\u4e0d\u80fd\u67e5\u8be2\u5230weworkUserNum!!!");
                }
                if (managerWeworkUserIds.contains(relation.getMemberId())) {
                    dto.setHasPermissionSee(NumberUtils.INTEGER_ONE);
                }
            } else {
                dto.setIsCustomer(0);
                dto.setMemberId(relation.getMemberId());
                dto.setNickname(relation.getName());
            }
            if (!(contactMap.containsKey(relation.getMemberId()) || weworkUserMap.containsKey(relation.getMemberId()) || weworkUserId2NumMap.containsKey(relation.getMemberId()))) {
                dto.setMemberId(relation.getMemberId());
            }
            channelRespDtos.add(dto);
        }
        return channelRespDtos;
    }
}

