/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.tab.service.impl;

import cn.kinyun.customer.center.service.CcCustomerNumService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.utils.AES256Util;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.biz.entity.BizApiConfig;
import com.kuaike.scrm.dal.biz.mapper.BizApiConfigMapper;
import com.kuaike.scrm.dal.wework.dto.WeworkTabSettingDto;
import com.kuaike.scrm.dal.wework.dto.WeworkTabUseDto;
import com.kuaike.scrm.dal.wework.dto.WeworkTabUseModDto;
import com.kuaike.scrm.dal.wework.entity.TabUrlParamsConfig;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkTabSetting;
import com.kuaike.scrm.dal.wework.entity.WeworkTabUse;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.TabUrlParamsConfigMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkTabSettingMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkTabUseMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.wework.tab.dto.SecretParamDto;
import com.kuaike.scrm.wework.tab.dto.SecretParamReq;
import com.kuaike.scrm.wework.tab.dto.TabUrlParamsConfigDto;
import com.kuaike.scrm.wework.tab.dto.WeworkTabReq;
import com.kuaike.scrm.wework.tab.dto.WeworkTabSettingReq;
import com.kuaike.scrm.wework.tab.dto.WeworkTabSettingResp;
import com.kuaike.scrm.wework.tab.service.WeworkTabSettingService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WeworkTabSettingServiceImpl
implements WeworkTabSettingService {
    private static final Logger log = LoggerFactory.getLogger(WeworkTabSettingServiceImpl.class);
    @Autowired
    private WeworkTabSettingMapper tabSettingMapper;
    @Autowired
    private WeworkTabUseMapper tabUseMapper;
    @Autowired
    private BizApiConfigMapper bizApiConfigMapper;
    @Autowired
    private TabUrlParamsConfigMapper tabUrlParamsConfigMapper;
    @Autowired
    private IdGen idGen;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private CcCustomerNumService ccCustomerNumService;
    @Autowired
    private ScrmBizService scrmBizService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOrMod(WeworkTabReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("addOrMod get userID = #{}, and bizId = #{}, and corpId = #{}, and req = #{}", new Object[]{userInfo.getId(), userInfo.getBizId(), userInfo.getCorpId(), req});
        ArrayList addList = Lists.newArrayList();
        ArrayList modList = Lists.newArrayList();
        for (WeworkTabSettingReq settingReq : req.getHandleData()) {
            settingReq.validate();
            if (StringUtils.isNotBlank((CharSequence)settingReq.getId())) {
                modList.add(settingReq);
                continue;
            }
            addList.add(settingReq);
        }
        if (req.getHandleType() == 0) {
            Object settingDtos;
            if (CollectionUtils.isNotEmpty((Collection)addList)) {
                settingDtos = this.setSettingDtoList(addList, userInfo, true);
                log.info("addOrMod addTabSetting settingDtos: {}", settingDtos);
                this.tabSettingMapper.insertTabSettings((List)settingDtos);
                List createBys = this.tabUseMapper.selectCreateBy(userInfo.getCorpId());
                log.info("addOrMod addTabSetting createBys: {}", (Object)createBys);
                if (CollectionUtils.isNotEmpty((Collection)createBys)) {
                    ArrayList addTabUseDtoList = Lists.newArrayList();
                    Map createByCountMap = this.tabUseMapper.queryCountByCreate(createBys, userInfo.getCorpId());
                    log.info("addOrMod addTabSetting createByCountMap: {}", (Object)createByCountMap);
                    for (int i = 0; i < settingDtos.size(); ++i) {
                        for (Long createBy : createBys) {
                            WeworkTabSettingDto settingDto = (WeworkTabSettingDto)settingDtos.get(i);
                            WeworkTabUseDto tabUseDto = new WeworkTabUseDto();
                            tabUseDto.setNum(this.idGen.getNum());
                            tabUseDto.setTabNum(settingDto.getNum());
                            tabUseDto.setBizId(userInfo.getBizId());
                            tabUseDto.setCorpId(userInfo.getCorpId());
                            tabUseDto.setCreateBy(createBy);
                            Integer seq = (Integer)createByCountMap.get(createBy) + i + 1;
                            tabUseDto.setTabSeq(seq);
                            addTabUseDtoList.add(tabUseDto);
                        }
                    }
                    log.info("addOrMod addTab getAddTabUseDtoList : {}", (Object)addTabUseDtoList);
                    if (CollectionUtils.isNotEmpty((Collection)addTabUseDtoList)) {
                        this.tabUseMapper.insertTabUseList((List)addTabUseDtoList);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)modList)) {
                settingDtos = this.setSettingDtoList(modList, userInfo, false);
                log.info("addOrMod modTabSetting settingDtos: {}", settingDtos);
                this.tabSettingMapper.updateTabSetting((List)settingDtos);
            }
            if (CollectionUtils.isNotEmpty(req.getDeleteIds())) {
                for (String deleteId : req.getDeleteIds()) {
                    Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)deleteId), (Object)"\u5220\u9664ID\u4e0d\u80fd\u4e3a\u7a7a");
                }
                log.info("addOrMod delIdS : {}", req.getDeleteIds());
                this.tabSettingMapper.delTabSetting(req.getDeleteIds(), userInfo.getCorpId());
            }
        } else if (CollectionUtils.isNotEmpty((Collection)modList)) {
            List tabNums = modList.stream().map(WeworkTabSettingReq::getId).collect(Collectors.toList());
            List tabUseList = this.tabUseMapper.queryTabUseList(tabNums, userInfo.getId(), userInfo.getCorpId());
            if (CollectionUtils.isNotEmpty((Collection)tabUseList)) {
                Map<String, WeworkTabUse> tabUseMap = tabUseList.stream().collect(Collectors.toMap(WeworkTabUse::getTabNum, a -> a));
                log.info("addOrMod get tabUseMap : {}", tabUseMap);
                ArrayList addTabUseDtoList = Lists.newArrayList();
                ArrayList modTabUseDtoList = Lists.newArrayList();
                for (WeworkTabSettingReq settingReq : modList) {
                    String tabNum = settingReq.getId();
                    WeworkTabUse tabUse = tabUseMap.get(tabNum);
                    if (Objects.isNull(tabUse)) {
                        WeworkTabUseDto tabUseDto = this.setTabUseDto(settingReq, userInfo);
                        addTabUseDtoList.add(tabUseDto);
                        continue;
                    }
                    WeworkTabUseModDto modDto = new WeworkTabUseModDto();
                    modDto.setId(tabUse.getId());
                    modDto.setTabSeq(settingReq.getTabSeq());
                    modDto.setUpdateBy(userInfo.getId());
                    modTabUseDtoList.add(modDto);
                }
                log.info("addOrMod mod getAddTabUseDtoList : {}", (Object)addTabUseDtoList);
                log.info("addOrMod mod getModTabUseDtoList : {}", (Object)modTabUseDtoList);
                if (CollectionUtils.isNotEmpty((Collection)addTabUseDtoList)) {
                    this.tabUseMapper.insertTabUseList((List)addTabUseDtoList);
                }
                if (CollectionUtils.isNotEmpty((Collection)modTabUseDtoList)) {
                    this.tabUseMapper.updateTabUseList((List)modTabUseDtoList);
                }
            } else {
                ArrayList tabUseDtoList = Lists.newArrayList();
                for (WeworkTabSettingReq settingReq : modList) {
                    WeworkTabUseDto tabUseDto = this.setTabUseDto(settingReq, userInfo);
                    tabUseDtoList.add(tabUseDto);
                }
                log.info("addOrMod add getAddTabUseDtoList : {}", (Object)tabUseDtoList);
                this.tabUseMapper.insertTabUseList((List)tabUseDtoList);
            }
        }
    }

    private WeworkTabUseDto setTabUseDto(WeworkTabSettingReq settingReq, CurrentUserInfo userInfo) {
        WeworkTabUseDto tabUseDto = new WeworkTabUseDto();
        tabUseDto.setNum(this.idGen.getNum());
        tabUseDto.setTabNum(settingReq.getId());
        tabUseDto.setTabSeq(settingReq.getTabSeq());
        tabUseDto.setBizId(userInfo.getBizId());
        tabUseDto.setCorpId(userInfo.getCorpId());
        tabUseDto.setCreateBy(userInfo.getId());
        return tabUseDto;
    }

    @Override
    public List<WeworkTabSettingResp> tabSettingList(WeworkTabReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("tabSettingList get userID = #{}, and bizId = #{}, and corpId = #{}", new Object[]{userInfo.getId(), userInfo.getBizId(), userInfo.getCorpId()});
        List settings = this.tabSettingMapper.querySettingList(userInfo.getCorpId());
        if (CollectionUtils.isEmpty((Collection)settings)) {
            return Collections.emptyList();
        }
        List tabNums = settings.stream().map(WeworkTabSetting::getNum).collect(Collectors.toList());
        ArrayList resps = Lists.newArrayList();
        if (req.getHandleType() == 0) {
            for (WeworkTabSetting setting : settings) {
                WeworkTabSettingResp resp = new WeworkTabSettingResp();
                resp.setId(setting.getNum());
                resp.setTabName(setting.getTabName());
                resp.setTabSeq(setting.getTabSeq());
                resp.setStatus(setting.getStatus());
                resp.setTabType(setting.getTabType());
                resp.setUrl(setting.getUrl());
                resps.add(resp);
            }
        } else {
            List tabUseList = this.tabUseMapper.queryTabUseList(tabNums, userInfo.getId(), userInfo.getCorpId());
            Map<String, WeworkTabUse> tabUseMap = tabUseList.stream().collect(Collectors.toMap(WeworkTabUse::getTabNum, a -> a));
            log.info("tabSettingList get tabUseMap : {}", tabUseMap);
            for (WeworkTabSetting setting : settings) {
                WeworkTabSettingResp resp = new WeworkTabSettingResp();
                resp.setId(setting.getNum());
                resp.setTabName(setting.getTabName());
                WeworkTabUse tabUse = tabUseMap.get(setting.getNum());
                if (Objects.isNull(tabUse)) {
                    resp.setTabSeq(setting.getTabSeq());
                } else {
                    resp.setTabSeq(tabUse.getTabSeq());
                }
                resp.setStatus(setting.getStatus());
                resp.setTabType(setting.getTabType());
                resp.setUrl(setting.getUrl());
                resps.add(resp);
            }
        }
        return resps;
    }

    private List<WeworkTabSettingDto> setSettingDtoList(List<WeworkTabSettingReq> reqs, CurrentUserInfo userInfo, boolean isAdd) {
        ArrayList settingDtos = Lists.newArrayList();
        for (WeworkTabSettingReq req : reqs) {
            WeworkTabSettingDto dto = new WeworkTabSettingDto();
            if (isAdd) {
                dto.setNum(this.idGen.getNum());
                dto.setCreateBy(userInfo.getId());
                dto.setTabType(Integer.valueOf(2));
            } else {
                dto.setNum(req.getId());
                dto.setUpdateBy(userInfo.getId());
            }
            dto.setTabName(req.getTabName());
            dto.setTabSeq(req.getTabSeq());
            dto.setStatus(req.getStatus());
            dto.setUrl(req.getUrl());
            dto.setBizId(userInfo.getBizId());
            dto.setCorpId(userInfo.getCorpId());
            settingDtos.add(dto);
        }
        return settingDtos;
    }

    @Override
    public void delSystemTabs(Long bizId, String corpId, List<String> tabNames) {
        if (CollectionUtils.isEmpty(tabNames)) {
            log.info("delSystemTabs tabName is null, corpId: {}", (Object)corpId);
            return;
        }
        ArrayList delTabIdS = Lists.newArrayList();
        for (int i = 0; i < tabNames.size(); ++i) {
            String tabName = tabNames.get(i);
            if (!StringUtils.isNotBlank((CharSequence)tabName)) continue;
            WeworkTabSetting querySetting = this.tabSettingMapper.querySetting(corpId, tabName);
            if (Objects.nonNull(querySetting)) {
                log.info("delSystemTabs tabName: {}, tabId: {}", (Object)tabName, (Object)querySetting.getNum());
                delTabIdS.add(querySetting.getNum());
                continue;
            }
            log.info("delSystemTabs tabName: {}, is not exist", (Object)corpId);
        }
        if (CollectionUtils.isNotEmpty((Collection)delTabIdS)) {
            log.info("delSystemTabs delTabIdS: {}, ", (Object)delTabIdS);
            this.tabSettingMapper.delTabSetting((List)delTabIdS, corpId);
        }
    }

    @Override
    public void addSystemTab(Long bizId, String corpId, String tabName) {
        List tabSettingList = this.tabSettingMapper.querySettingList(corpId);
        if (CollectionUtils.isEmpty((Collection)tabSettingList)) {
            log.info("addSystemTab tabSettingList is empty, corpId: {}", (Object)corpId);
            return;
        }
        List tabSettings = tabSettingList.stream().map(WeworkTabSetting::getTabName).collect(Collectors.toList());
        WeworkTabReq req = new WeworkTabReq();
        req.setHandleType(0);
        ArrayList settingReqs = Lists.newArrayList();
        WeworkTabSettingReq settingReq = new WeworkTabSettingReq();
        settingReq.setTabName(tabName);
        settingReq.setTabSeq(tabSettings.size() + 1);
        settingReq.setStatus(1);
        settingReqs.add(settingReq);
        req.setHandleData(settingReqs);
        this.addOrMod(req);
        log.info("addSystemTab add success tabName: {}, corpId: {}", (Object)tabName, (Object)corpId);
    }

    @Override
    public String getSecretParams(SecretParamReq params) {
        Preconditions.checkArgument((params != null && StringUtils.isNotEmpty((CharSequence)params.getContactId()) ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        SecretParamDto paramDto = new SecretParamDto();
        paramDto.setBizId(userInfo.getBizId());
        paramDto.setCorpId(userInfo.getCorpId());
        paramDto.setWeworkUserId(userInfo.getWeworkUserNum());
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByNum(userInfo.getWeworkUserNum());
        if (weworkUser != null) {
            paramDto.setWeworkUserMobile(weworkUser.getMobile());
        }
        paramDto.setContactId(params.getContactId());
        TabUrlParamsConfigDto paramsConfig = this.getTabUrlParamsConfig();
        if (paramsConfig == null) {
            return null;
        }
        paramDto.setWxId(paramsConfig.getWxId());
        paramDto.setWxKey(paramsConfig.getWxKey());
        paramDto.setWxSecretKey(paramsConfig.getWxSecretKey());
        List contactMobiles = this.ccCustomerNumService.getMobilesByContactId(userInfo.getBizId(), params.getContactId());
        paramDto.setContactMobiles(contactMobiles);
        WeworkContact contact = this.weworkContactMapper.queryWeworkContact(userInfo.getBizId(), userInfo.getCorpId(), params.getContactId());
        if (contact != null) {
            paramDto.setUnionId(contact.getUnionid());
        }
        BizApiConfig bizApiConfig = new BizApiConfig();
        bizApiConfig.setBizId(this.scrmBizService.getMainBizId());
        bizApiConfig = (BizApiConfig)this.bizApiConfigMapper.selectOne((Object)bizApiConfig);
        if (bizApiConfig == null || StringUtils.isEmpty((CharSequence)bizApiConfig.getSecret())) {
            return null;
        }
        String str = JacksonUtil.obj2Str((Object)paramDto);
        try {
            String secretStr = AES256Util.encode((String)str, (String)bizApiConfig.getSecret());
            return "params=" + secretStr;
        }
        catch (Exception e) {
            log.error("tab url get secret params error: ", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u751f\u6210\u52a0\u5bc6\u53c2\u6570\u5931\u8d25");
        }
    }

    @Override
    public void setTabUrlParamsConfig(TabUrlParamsConfigDto params) {
        log.info("setTabUrlParamsConfig params: {}", (Object)params);
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        params.checkParams();
        TabUrlParamsConfig config = new TabUrlParamsConfig();
        config.setBizId(userInfo.getBizId());
        config.setCorpId(userInfo.getCorpId());
        config.setConfigType(Integer.valueOf(1));
        config = (TabUrlParamsConfig)this.tabUrlParamsConfigMapper.selectOne((Object)config);
        if (config == null) {
            config = new TabUrlParamsConfig();
            config.setBizId(userInfo.getBizId());
            config.setCorpId(userInfo.getCorpId());
            config.setConfigType(Integer.valueOf(1));
            config.setCreateBy(userInfo.getId());
            config.setCreateTime(new Date());
        }
        config.setUrl(params.getUrl());
        config.setConfigJson(JacksonUtil.obj2Str((Object)params));
        config.setUpdateBy(userInfo.getId());
        config.setUpdateTime(new Date());
        if (config.getId() == null) {
            this.tabUrlParamsConfigMapper.insertSelective((Object)config);
        } else {
            this.tabUrlParamsConfigMapper.updateByPrimaryKeySelective((Object)config);
        }
    }

    @Override
    public TabUrlParamsConfigDto getTabUrlParamsConfig() {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        TabUrlParamsConfig config = new TabUrlParamsConfig();
        config.setBizId(userInfo.getBizId());
        config.setCorpId(userInfo.getCorpId());
        config.setConfigType(Integer.valueOf(1));
        config = (TabUrlParamsConfig)this.tabUrlParamsConfigMapper.selectOne((Object)config);
        TabUrlParamsConfigDto configDto = null;
        if (config != null) {
            try {
                configDto = (TabUrlParamsConfigDto)JacksonUtil.str2Obj((String)config.getConfigJson(), TabUrlParamsConfigDto.class);
            }
            catch (IOException e) {
                log.error("getTabUrlParamsConfig error, corpId: {}", (Object)userInfo.getCorpId(), (Object)e);
            }
        } else if (!this.scrmBizService.isMainBiz(userInfo.getBizId()).booleanValue()) {
            TabUrlParamsConfig mainBizConfig = new TabUrlParamsConfig();
            mainBizConfig.setBizId(this.scrmBizService.getMainBizId());
            mainBizConfig.setConfigType(Integer.valueOf(1));
            mainBizConfig = (TabUrlParamsConfig)this.tabUrlParamsConfigMapper.selectOne((Object)mainBizConfig);
            if (mainBizConfig != null) {
                try {
                    configDto = (TabUrlParamsConfigDto)JacksonUtil.str2Obj((String)mainBizConfig.getConfigJson(), TabUrlParamsConfigDto.class);
                }
                catch (IOException e) {
                    log.error("getTabUrlParamsConfig error, bizId: {}", (Object)this.scrmBizService.getMainBizId(), (Object)e);
                }
            }
        }
        return configDto;
    }
}

