/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.license.impl;

import cn.kinyun.wework.sdk.api.license.LicenseAccountClient;
import cn.kinyun.wework.sdk.api.license.LicenseAppClient;
import cn.kinyun.wework.sdk.api.license.LicenseSettingClient;
import cn.kinyun.wework.sdk.entity.license.account.ActivatedAccountDto;
import cn.kinyun.wework.sdk.entity.license.account.ActiveInfoDto;
import cn.kinyun.wework.sdk.entity.license.account.ActiveUserInfoDto;
import cn.kinyun.wework.sdk.entity.license.account.GetActiveInfoByCodeReq;
import cn.kinyun.wework.sdk.entity.license.account.GetActiveInfoByCodeResp;
import cn.kinyun.wework.sdk.entity.license.account.GetActiveInfoByUserReq;
import cn.kinyun.wework.sdk.entity.license.account.GetActiveInfoByUserResp;
import cn.kinyun.wework.sdk.entity.license.account.ListActivatedAccountReq;
import cn.kinyun.wework.sdk.entity.license.account.ListActivatedAccountResp;
import cn.kinyun.wework.sdk.entity.license.account.MergeInfoDto;
import cn.kinyun.wework.sdk.entity.license.account.ShareInfoDto;
import cn.kinyun.wework.sdk.entity.license.app.GetAppLicenseInfoReq;
import cn.kinyun.wework.sdk.entity.license.app.GetAppLicenseInfoResp;
import cn.kinyun.wework.sdk.entity.license.app.TrailInfoDto;
import cn.kinyun.wework.sdk.entity.license.setting.GetAutoActiveStatusResp;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.scrm.common.enums.BizStatus;
import com.kuaike.scrm.common.enums.LicenseStatusEnum;
import com.kuaike.scrm.common.enums.LicenseTypeEnum;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.entity.WeworkLicenseActiveInfo;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkLicenseActiveInfoMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.wework.license.CorpLicenseInfo;
import com.kuaike.scrm.wework.license.WeworkLicenseActiveInfoService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WeworkLicenseActiveInfoServiceImpl
implements WeworkLicenseActiveInfoService {
    private static final Logger log = LoggerFactory.getLogger(WeworkLicenseActiveInfoServiceImpl.class);
    @Value(value="${qyapi.corp.id}")
    private String provierCorpId;
    @Value(value="${qyapi.customized.id}")
    private String customizedSuitId;
    @Autowired
    private LicenseAccountClient licenseAccountClient;
    @Autowired
    private LicenseAppClient licenseAppClient;
    @Autowired
    private LicenseSettingClient licenseSettingClient;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private WeworkLicenseActiveInfoMapper weworkLicenseActiveInfoMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private UserMapper userMapper;
    private static final String LICENSE_STATUS_CACHE_KEY = "LICENSE_STATUS_CACHE_KEY_";

    @Override
    public void fetchAll() {
        List corpList = this.weworkCorpMapper.selectAllAuthed();
        if (CollectionUtils.isEmpty((Collection)corpList)) {
            log.info("no authed corp found");
            return;
        }
        for (WeworkCorp weworkCorp : corpList) {
            try {
                this.fetch(weworkCorp);
            }
            catch (Exception e) {
                log.error("fetch weworkLicenseAccount error: authCorpId:{};errorMsg:{}", (Object)weworkCorp.getAuthCorpId(), (Object)e.getMessage());
            }
        }
    }

    private void fetchCorpLicenseInfo(WeworkCorp weworkCorp) {
        if (Objects.isNull(weworkCorp)) {
            return;
        }
        String corpId = Optional.ofNullable(weworkCorp.getAuthCorpId()).orElse(weworkCorp.getCorpId());
        CorpLicenseInfo licenseSetting = this.getCorpLicenseInfo(corpId);
        weworkCorp.setLicenseStatus(Objects.nonNull(licenseSetting.getLicenseStatus()) ? licenseSetting.getLicenseStatus() : weworkCorp.getLicenseStatus());
        weworkCorp.setLicenseTrailStartTime(Objects.nonNull(licenseSetting.getTrailStartTime()) ? licenseSetting.getTrailStartTime() : weworkCorp.getLicenseTrailStartTime());
        weworkCorp.setLicenseTrailEndTime(Objects.nonNull(licenseSetting.getTrailEndTime()) ? licenseSetting.getTrailEndTime() : weworkCorp.getLicenseTrailEndTime());
        weworkCorp.setLicenseCheckTime(Objects.nonNull(licenseSetting.getLicenseCheckTime()) ? licenseSetting.getLicenseCheckTime() : weworkCorp.getLicenseCheckTime());
        weworkCorp.setAutoActiveLicense(Objects.nonNull(licenseSetting.getAutoActiveStatus()) ? licenseSetting.getAutoActiveStatus() : weworkCorp.getAutoActiveLicense());
        this.weworkCorpMapper.updateByPrimaryKeySelective((Object)weworkCorp);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void fetch(WeworkCorp weworkCorp) {
        if (Objects.isNull(weworkCorp)) {
            return;
        }
        BusinessCustomer biz = this.businessCustomerMapper.getByCorpId(weworkCorp.getCorpId());
        if (Objects.isNull(biz)) {
            log.warn("\u627e\u4e0d\u5230\u4f01\u4e1a\u5bf9\u5e94\u7684\u5546\u6237id, corpId={}; ", (Object)weworkCorp.getCorpId());
            return;
        }
        if (BizStatus.INVALID.getValue() == biz.getStatus().intValue()) {
            log.warn("\u5f53\u524d\u5546\u6237\u5df2\u8fc7\u671f\uff1acorpId:{},expireTime:{}", (Object)weworkCorp.getCorpId(), (Object)JSON.toJSONString((Object)biz.getExpireDate()));
            return;
        }
        try {
            boolean shouldFetchCorp = this.fetchUserLicenseInfo(biz, weworkCorp);
            if (shouldFetchCorp) {
                this.fetchCorpLicenseInfo(weworkCorp);
            }
            log.info("authCorpId:{},fetch license end:", (Object)weworkCorp.getAuthCorpId());
        }
        catch (Exception e) {
            log.error("fetch license error:", (Throwable)e);
        }
    }

    private boolean fetchUserLicenseInfo(BusinessCustomer bc, WeworkCorp weworkCorp) {
        String corpId = Optional.ofNullable(weworkCorp.getAuthCorpId()).orElse(weworkCorp.getCorpId());
        List<ActivatedAccountDto> accountDtos = this.licenseAcountList(corpId);
        if (CollectionUtils.isEmpty(accountDtos)) {
            return false;
        }
        List activeInfos = this.weworkLicenseActiveInfoMapper.getByCorpId(bc.getCorpId());
        List accountLicenseUserIds = accountDtos.stream().map(item -> item.getUserId()).collect(Collectors.toList());
        HashMap openWeworkUserIds = Maps.newHashMap();
        ArrayList toUpdateAccountInfos = Lists.newArrayList();
        List toDeleteDbInfo = activeInfos.stream().filter(item -> !accountLicenseUserIds.contains(item.getAuthUserId())).collect(Collectors.toList());
        for (WeworkLicenseActiveInfo toDelete : toDeleteDbInfo) {
            openWeworkUserIds.put(toDelete.getAuthUserId(), 1);
            toDelete.setStatus(Integer.valueOf(-1));
            toUpdateAccountInfos.add(toDelete);
        }
        Map<String, List<WeworkLicenseActiveInfo>> activeInfoMap = activeInfos.stream().collect(Collectors.groupingBy(item -> item.getAuthUserId() + "_" + item.getType()));
        ArrayList toAddAccountInfos = Lists.newArrayList();
        for (ActivatedAccountDto dto : accountDtos) {
            WeworkLicenseActiveInfo entity = new WeworkLicenseActiveInfo();
            String mapKey = dto.getUserId() + "_" + dto.getType();
            List<WeworkLicenseActiveInfo> existActiveInfo = activeInfoMap.get(mapKey);
            if (CollectionUtils.isNotEmpty(existActiveInfo)) {
                entity = existActiveInfo.get(0);
                toUpdateAccountInfos.add(entity);
            } else {
                toAddAccountInfos.add(entity);
            }
            entity.setBizId(bc.getId());
            entity.setCorpId(bc.getCorpId());
            entity.setActiveTime(new Date(dto.getActiveTime() * 1000L));
            entity.setExpireTime(new Date(dto.getExpireTime() * 1000L));
            entity.setAuthUserId(dto.getUserId());
            entity.setType(dto.getType());
            GetActiveInfoByUserResp activeInfoByUserResp = this.licenseAccountDetailByUserId(corpId, dto.getUserId());
            if (Objects.isNull(activeInfoByUserResp)) {
                log.error("\u672a\u627e\u5230\u5bf9\u5e94wework_user_id :{}\u7684 \u4e92\u901a\u4fe1\u606f", (Object)dto.getUserId());
                continue;
            }
            entity.setStatus(activeInfoByUserResp.getActiveStatus());
            List activeInfoList = activeInfoByUserResp.getActiveInfoList();
            if (CollectionUtils.isEmpty((Collection)activeInfoList)) continue;
            for (ActiveUserInfoDto activeUserInfoDto : activeInfoList) {
                ShareInfoDto shareInfo;
                GetActiveInfoByCodeReq codeReq = new GetActiveInfoByCodeReq();
                codeReq.setCorpId(bc.getCorpId());
                codeReq.setActiveCode(activeUserInfoDto.getActiveCode());
                ActiveInfoDto activeInfoDto = this.licenseAccountDetaiByCode(corpId, activeUserInfoDto.getActiveCode());
                if (Objects.isNull(activeInfoDto)) {
                    log.error("corpId:{} \u672a\u627e\u5230\u5bf9\u5e94 ;activeCode:{} \u7684 \u4e92\u901a\u4fe1\u606f ", (Object)bc.getCorpId(), (Object)activeUserInfoDto.getActiveCode());
                    continue;
                }
                if (!dto.getType().equals(activeInfoDto.getType())) continue;
                MergeInfoDto mergeInfo = activeInfoDto.getMergeInfo();
                if (Objects.nonNull(mergeInfo)) {
                    entity.setFromActiveCode(mergeInfo.getFromActiveCode());
                    entity.setToActiveCode(mergeInfo.getToActiveCode());
                }
                if (Objects.nonNull(shareInfo = activeInfoDto.getShareInfo())) {
                    entity.setFromCorpId(shareInfo.getFromCorpId());
                    entity.setToCorpId(shareInfo.getToCorpId());
                }
                if (StringUtils.isNotBlank((CharSequence)activeInfoDto.getUserId())) {
                    entity.setAuthUserId(activeInfoDto.getUserId());
                }
                entity.setActiveCode(activeInfoDto.getActiveCode());
                entity.setStatus(activeInfoDto.getStatus());
                if (LicenseTypeEnum.INTERWORKING_ACCOUNT.getValue() == entity.getType().intValue()) {
                    openWeworkUserIds.put(entity.getAuthUserId(), activeInfoDto.getStatus());
                }
                Date createTime = Optional.ofNullable(activeInfoDto.getCreateTime()).map(item -> new Date(item * 1000L)).orElse(new Date());
                entity.setCreateTime(createTime);
                entity.setCreateBy(Long.valueOf(-1L));
                entity.setUpdateBy(Long.valueOf(-1L));
                entity.setUpdateTime(new Date());
            }
        }
        log.info("corpId:{}, add    license size:{}", (Object)bc.getCorpId(), (Object)CollectionUtils.size((Object)toAddAccountInfos));
        log.info("corpId:{}, update license size:{}", (Object)bc.getCorpId(), (Object)CollectionUtils.size((Object)toUpdateAccountInfos));
        if (CollectionUtils.isNotEmpty((Collection)toAddAccountInfos)) {
            this.weworkLicenseActiveInfoMapper.batchInsert((List)toAddAccountInfos);
        }
        for (WeworkLicenseActiveInfo update : toUpdateAccountInfos) {
            this.weworkLicenseActiveInfoMapper.updateByPrimaryKeySelective((Object)update);
        }
        HashMap licenseStatusMap = Maps.newHashMap();
        if (MapUtils.isNotEmpty((Map)openWeworkUserIds)) {
            List weworkUsers = this.weworkUserMapper.queryWeworkUserInfoListByAuthUserIds(bc.getCorpId(), openWeworkUserIds.keySet());
            Map<String, String> weworkUserIdMaps = weworkUsers.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getAuthUserId())).collect(Collectors.toMap(WeworkUser::getWeworkUserId, WeworkUser::getAuthUserId));
            Set<String> weworkUserIds = weworkUserIdMaps.keySet();
            Map userIds = this.userMapper.queryUserIdByWeworkUserId(bc.getId(), weworkUserIds);
            if (MapUtils.isEmpty((Map)userIds)) {
                return true;
            }
            for (String weworkUserId : weworkUserIds) {
                Long userId = (Long)userIds.get(weworkUserId);
                User user = new User();
                user.setId(userId);
                String authUserId = weworkUserIdMaps.get(weworkUserId);
                if (StringUtils.isBlank((CharSequence)authUserId)) continue;
                Integer licenseStatus = (Integer)openWeworkUserIds.get(authUserId);
                user.setLicenseStatus(licenseStatus);
                this.userMapper.updateByPrimaryKeySelective((Object)user);
            }
            for (WeworkUser weworkUser : weworkUsers) {
                Integer licenseStatus;
                if (StringUtils.isBlank((CharSequence)weworkUser.getAuthUserId()) || Objects.isNull(licenseStatus = (Integer)openWeworkUserIds.get(weworkUser.getAuthUserId()))) continue;
                WeworkUser newWeworkUser = new WeworkUser();
                newWeworkUser.setId(weworkUser.getId());
                newWeworkUser.setLicenseStatus(licenseStatus);
                licenseStatusMap.put(weworkUser.getWeworkUserId(), licenseStatus);
                this.weworkUserMapper.updateByPrimaryKeySelective((Object)newWeworkUser);
            }
        }
        try {
            if (MapUtils.isEmpty((Map)licenseStatusMap)) {
                return true;
            }
            String key = LICENSE_STATUS_CACHE_KEY + bc.getCorpId();
            this.redisTemplate.opsForHash().putAll((Object)key, (Map)licenseStatusMap);
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5c  redisTemplate.opsForHash().putAll error: key:{}", (Object)LICENSE_STATUS_CACHE_KEY, (Object)e);
        }
        return true;
    }

    @Override
    public Set<String> getHasBindingLicenseWeworkUserId(String corpId) {
        if (StringUtils.isBlank((CharSequence)corpId)) {
            return Sets.newHashSet();
        }
        String key = LICENSE_STATUS_CACHE_KEY + corpId;
        HashOperations hashOps = this.redisTemplate.opsForHash();
        Set<Object> weworkUserIds = Sets.newHashSet();
        try {
            Map entries = hashOps.entries((Object)key);
            weworkUserIds = entries.keySet().stream().filter(item -> ((Integer)entries.get(item)).intValue() == LicenseStatusEnum.BINDING.getValue()).collect(Collectors.toSet());
        }
        catch (Exception e) {
            log.error("\u6267\u884credis error:key {}", (Object)key, (Object)e);
        }
        if (CollectionUtils.isNotEmpty((Collection)weworkUserIds)) {
            return weworkUserIds;
        }
        return this.weworkUserMapper.queryWeworkUserIdByLicenseStatus(corpId, Integer.valueOf(LicenseStatusEnum.BINDING.getValue()));
    }

    @Override
    public boolean getWeworkUserLicenseStatus(String corpId, String weworkUserId) {
        boolean result = false;
        if (StringUtils.isBlank((CharSequence)weworkUserId) || StringUtils.isBlank((CharSequence)corpId)) {
            log.info("\u83b7\u53d6\u4f01\u5fae\u5fae\u4fe1\u4e92\u901a param:corpId{};weworkUserId:{};result:{}", new Object[]{corpId, weworkUserId, false});
            return false;
        }
        String key = LICENSE_STATUS_CACHE_KEY + corpId;
        HashOperations hashOps = this.redisTemplate.opsForHash();
        Integer licenseStatus = null;
        try {
            licenseStatus = (Integer)hashOps.get((Object)key, (Object)weworkUserId);
        }
        catch (Exception e) {
            log.error("\u6267\u884credis error:key {}", (Object)key, (Object)e);
        }
        if (Objects.nonNull(licenseStatus)) {
            result = licenseStatus.intValue() == LicenseStatusEnum.BINDING.getValue();
            log.info("\u83b7\u53d6\u4f01\u5fae\u5fae\u4fe1\u4e92\u901a param:corpId{};weworkUserId:{};result:{}", new Object[]{corpId, weworkUserId, result});
            return result;
        }
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserInfo(corpId, weworkUserId);
        LicenseStatusEnum licenseStatusEnum = Optional.ofNullable(weworkUser).filter(item -> Objects.nonNull(item.getLicenseStatus())).map(WeworkUser::getLicenseStatus).map(LicenseStatusEnum::get).orElse(LicenseStatusEnum.UNBIND);
        result = licenseStatusEnum.getValue() == LicenseStatusEnum.BINDING.getValue();
        log.info("\u83b7\u53d6\u4f01\u5fae\u5fae\u4fe1\u4e92\u901a param:corpId{};weworkUserId:{};result:{}", new Object[]{corpId, weworkUserId, result});
        return result;
    }

    @Override
    public List<ActivatedAccountDto> licenseAcountList(@NonNull String corpId) {
        if (corpId == null) {
            throw new NullPointerException("corpId is marked non-null but is null");
        }
        ArrayList results = Lists.newArrayList();
        ListActivatedAccountReq params = new ListActivatedAccountReq();
        params.setCorpId(corpId);
        params.setLimit(Integer.valueOf(100));
        String cursor = null;
        do {
            try {
                ListActivatedAccountResp resp = this.licenseAccountClient.listActivatedAccount(this.provierCorpId, params);
                List list = resp.getAccountList();
                if (!CollectionUtils.isNotEmpty((Collection)list)) break;
                results.addAll(list);
                if (StringUtils.isNotBlank((CharSequence)resp.getNextCursor())) {
                    cursor = resp.getNextCursor();
                    params.setCursor(cursor);
                    continue;
                }
                cursor = null;
                params.setCursor(null);
            }
            catch (WeworkException e) {
                log.error("corpId:{}, {},  params:{}", new Object[]{corpId, e.getMessage(), params, e});
                throw e;
            }
            catch (Exception e) {
                log.error("corpId:{}, failed to license account,  params:{}", new Object[]{corpId, params, e});
                throw e;
            }
        } while (StringUtils.isNotBlank((CharSequence)cursor));
        log.info("corpId:{} ,fetch license account list:{}", (Object)corpId, (Object)JSON.toJSONString((Object)results));
        return results;
    }

    @Override
    public GetActiveInfoByUserResp licenseAccountDetailByUserId(String corpId, String weworkUserId) {
        GetActiveInfoByUserReq param = new GetActiveInfoByUserReq();
        param.setCorpId(corpId);
        param.setUserId(weworkUserId);
        GetActiveInfoByUserResp resp = null;
        try {
            resp = this.licenseAccountClient.getActiveInfoByUser(this.provierCorpId, param);
        }
        catch (Exception e) {
            log.error(" corpId:{}, failed tolicenseAccountClient.getActiveInfoByUser , params:{}", new Object[]{corpId, param, e});
        }
        return resp;
    }

    private ActiveInfoDto licenseAccountDetaiByCode(String corpId, String activeCode) {
        GetActiveInfoByCodeReq codeReq = new GetActiveInfoByCodeReq();
        codeReq.setCorpId(corpId);
        codeReq.setActiveCode(activeCode);
        ActiveInfoDto activeInfoDto = null;
        try {
            GetActiveInfoByCodeResp resp = this.licenseAccountClient.getActiveInfoByCode(this.provierCorpId, codeReq);
            activeInfoDto = resp.getActiveInfo();
        }
        catch (Exception e) {
            log.error(" corpId:{},  failed to licenseAccountClient.getActiveInfoByCode ,params:{}", new Object[]{corpId, codeReq, e});
        }
        return activeInfoDto;
    }

    @Override
    public CorpLicenseInfo getCorpLicenseInfo(String corpId) {
        GetAppLicenseInfoReq param = new GetAppLicenseInfoReq();
        param.setCorpId(corpId);
        param.setSuiteId(this.customizedSuitId);
        CorpLicenseInfo result = new CorpLicenseInfo();
        GetAppLicenseInfoResp appLicenseInfoResp = null;
        try {
            appLicenseInfoResp = this.licenseAppClient.getAppLicenseInfo(this.provierCorpId, param);
            log.info("corpId:{} ,get licenseAppClient.getAppLicenseInfo result:{}", (Object)corpId, (Object)JSON.toJSONString((Object)appLicenseInfoResp));
        }
        catch (Exception e) {
            log.error(" corpId:{}, licenseAppClient.GetAppLicenseInfo \u5f02\u5e38\uff1aparam:{},", new Object[]{corpId, JSON.toJSONString((Object)param), e});
        }
        if (Objects.nonNull(appLicenseInfoResp)) {
            result.setLicenseStatus(appLicenseInfoResp.getLicenseStatus());
            TrailInfoDto trialInfo = appLicenseInfoResp.getTrailInfo();
            if (Objects.nonNull(trialInfo)) {
                result.setTrailStartTime(Optional.ofNullable(trialInfo.getStartTime()).map(item -> new Date(item * 1000L)).get());
                result.setTrailEndTime(Optional.ofNullable(trialInfo.getEndTime()).map(item -> new Date(item * 1000L)).get());
            }
            result.setLicenseCheckTime(Optional.ofNullable(appLicenseInfoResp.getLicenseCheckTime()).map(item -> new Date(item * 1000L)).get());
        }
        GetAutoActiveStatusResp autoResp = null;
        try {
            autoResp = this.licenseSettingClient.getAutoActiveStatus(corpId);
            log.info(" corpId:{}, get licenseSettingClient.getAutoActiveStatus result:{}", (Object)corpId, (Object)JSON.toJSONString((Object)autoResp));
        }
        catch (Exception e) {
            log.error(" corpId:{},  licenseAppClient.GetAppLicenseInfo \u5f02\u5e38\uff1a", (Object)corpId, (Object)e);
        }
        if (Objects.nonNull(autoResp)) {
            result.setAutoActiveStatus(autoResp.getAutoActiveStatus());
        }
        log.info(" corpId:{}, getCorpLicenseInfo result:{}", (Object)corpId, (Object)JSON.toJSONString((Object)result));
        return result;
    }
}

