/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.contacttag.service.impl;

import cn.kinyun.wework.sdk.api.external.ExternalTagClient;
import cn.kinyun.wework.sdk.entity.external.croptag.MarkTagParams;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.enums.AttachTagTaskStatus;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.common.utils.ThreadPoolMonitorUtils;
import com.kuaike.scrm.dal.wework.dto.WeworkUserContactDto;
import com.kuaike.scrm.dal.weworktag.entity.AttachTagTask;
import com.kuaike.scrm.dal.weworktag.entity.WeworkContactTag;
import com.kuaike.scrm.dal.weworktag.mapper.AttachTagSubTaskMapper;
import com.kuaike.scrm.dal.weworktag.mapper.AttachTagTaskMapper;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkContactTagMapper;
import com.kuaike.scrm.wework.contact.service.ContactTagSyncService;
import com.kuaike.scrm.wework.contacttag.service.HandleAttachTagTaskService;
import com.kuaike.scrm.wework.weworkuser.service.WeworkUserService;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HandleAttachTagTaskServiceImpl
implements HandleAttachTagTaskService {
    private static final Logger log = LoggerFactory.getLogger(HandleAttachTagTaskServiceImpl.class);
    @Resource
    private AttachTagTaskMapper attachTagTaskMapper;
    @Resource
    private AttachTagSubTaskMapper attachTagSubTaskMapper;
    @Autowired
    private ExternalTagClient externalTagClient;
    @Autowired
    private WeworkUserService weworkUserService;
    @Autowired
    private WeworkContactTagMapper weworkContactTagMapper;
    @Autowired
    private ContactTagSyncService contactTagSyncService;
    private ExecutorService executeService = new ThreadPoolExecutor(5, 5, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), (ThreadFactory)new NamedThreadFactory("HandleAttachTagTaskExecuteService"));

    @PostConstruct
    public void init() {
        ThreadPoolMonitorUtils.addToMonitor((ExecutorService)this.executeService);
    }

    @Override
    public void handleTask(Long taskId) {
        log.info("handleTask taskId: {}", (Object)taskId);
        if (taskId == null) {
            return;
        }
        AttachTagTask task = (AttachTagTask)this.attachTagTaskMapper.selectByPrimaryKey((Object)taskId);
        if (task == null) {
            log.warn("AttachTagTask is null taskId: {}", (Object)taskId);
            return;
        }
        if (task.getStatus().intValue() != AttachTagTaskStatus.NOT_RUN.getValue()) {
            log.warn("task is run or finish taskId: {}", (Object)taskId);
            return;
        }
        this.attachTagTaskMapper.updateTaskStatus(taskId, Integer.valueOf(AttachTagTaskStatus.IS_RUNNING.getValue()));
        String corpId = task.getCorpId();
        List addTags = null;
        List rmTags = null;
        try {
            addTags = JacksonUtil.str2List((String)task.getAddTags(), String.class);
            rmTags = JacksonUtil.str2List((String)task.getRmTags(), String.class);
        }
        catch (IOException e) {
            this.attachTagTaskMapper.updateTaskStatus(taskId, Integer.valueOf(AttachTagTaskStatus.FINISH.getValue()));
            log.error("json parse error, addTags: {}, rmTags: {}", new Object[]{task.getAddTags(), task.getRmTags(), e});
        }
        if (CollectionUtils.isEmpty((Collection)addTags) && CollectionUtils.isEmpty((Collection)rmTags)) {
            log.info("attach task addTags and rmTags is empty taskId: {}", (Object)taskId);
            this.attachTagTaskMapper.updateTaskStatus(taskId, Integer.valueOf(AttachTagTaskStatus.FINISH.getValue()));
            return;
        }
        List contactDtoList = this.attachTagSubTaskMapper.querySubTaskList(taskId);
        for (WeworkUserContactDto contactDto : contactDtoList) {
            String weworkUserId = this.weworkUserService.getWeworkUserIdByNum(contactDto.getWeworkUserNum());
            String contactId = contactDto.getContactId();
            MarkTagParams markTagParams = new MarkTagParams();
            markTagParams.setUserId(weworkUserId);
            markTagParams.setExternalUserId(contactId);
            markTagParams.setAddTagIds(addTags);
            markTagParams.setRemoveTagIds(rmTags);
            log.info("markTag attach tag corpId: {}, contactId: {}", (Object)corpId, (Object)contactId);
            this.executeService.submit(this.buildTask(markTagParams, taskId, corpId, contactDto.getWeworkUserNum()));
            List contactTags = this.weworkContactTagMapper.queryByCorpIdAndContactIdsFilterWeworkUserIds(corpId, (List)Lists.newArrayList((Object[])new String[]{contactId}));
            Set existTagIds = contactTags.stream().map(WeworkContactTag::getTagId).collect(Collectors.toSet());
            HashSet allTagIds = Sets.newHashSet();
            if (CollectionUtils.isNotEmpty((Collection)addTags)) {
                allTagIds.addAll(addTags);
            }
            allTagIds.addAll(existTagIds);
            log.info("handleTask allTagIds: {}", (Object)allTagIds);
            if (CollectionUtils.isNotEmpty((Collection)rmTags)) {
                allTagIds.removeAll(rmTags);
            }
            this.contactTagSyncService.syncTag2Crm(task.getBizId(), contactId, allTagIds, weworkUserId);
        }
        this.attachTagTaskMapper.updateTaskStatus(taskId, Integer.valueOf(AttachTagTaskStatus.FINISH.getValue()));
    }

    private Runnable buildTask(MarkTagParams markTagParams, Long taskId, String corpId, String weworkUserNum) {
        return () -> {
            try {
                log.info("markTag attach tag corpId: {}", (Object)corpId);
                this.externalTagClient.markTag(corpId, markTagParams);
                this.attachTagSubTaskMapper.updateSubTaskStatus(taskId, weworkUserNum, markTagParams.getExternalUserId(), Integer.valueOf(1), null);
            }
            catch (Exception e) {
                log.error("attach tag error", (Throwable)e);
                this.attachTagSubTaskMapper.updateSubTaskStatus(taskId, weworkUserNum, markTagParams.getExternalUserId(), Integer.valueOf(2), e.getMessage());
            }
        };
    }
}

