/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.contact.service.impl;

import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.wework.sdk.api.external.ExternalContactClient;
import cn.kinyun.wework.sdk.api.external.ExternalTagClient;
import cn.kinyun.wework.sdk.entity.external.contact.ExternalContactRemark;
import cn.kinyun.wework.sdk.entity.external.croptag.MarkTagParams;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.enums.AddWeworkStatusEnum;
import com.kuaike.scrm.common.service.ExternalContactModService;
import com.kuaike.scrm.common.service.ScrmContactService;
import com.kuaike.scrm.common.service.dto.req.ModMobileSyncReq;
import com.kuaike.scrm.common.service.dto.req.ScrmMarkWeworkTagReqDto;
import com.kuaike.scrm.common.service.dto.resp.AppletResp;
import com.kuaike.scrm.common.service.dto.resp.ContactAssociateResp;
import com.kuaike.scrm.common.service.dto.resp.DeletedWeworkContactResp;
import com.kuaike.scrm.common.service.dto.resp.OfficialResp;
import com.kuaike.scrm.common.service.dto.resp.WeworkContactResp;
import com.kuaike.scrm.common.service.dto.resp.WeworkRoomAssociateDto;
import com.kuaike.scrm.common.service.dto.resp.WeworkUserAssociateDto;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.contactanalyse.entity.WeworkContactLog;
import com.kuaike.scrm.dal.contactanalyse.mapper.WeworkContactLogMapper;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMapper;
import com.kuaike.scrm.dal.shop.entity.AppletInfo;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import com.kuaike.scrm.dal.wework.dto.WeworkRoomDto;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMobileMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworktag.entity.WeworkContactTag;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkContactTagMapper;
import com.kuaike.scrm.wework.contact.dto.ContactAssocaiteReqDto;
import com.kuaike.scrm.wework.contact.dto.ContactAssociateRespDto;
import com.kuaike.scrm.wework.contact.dto.WeworkUserDto;
import com.kuaike.scrm.wework.contact.service.ContactCenterService;
import com.kuaike.scrm.wework.contact.service.ContactTagSyncService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScrmContactServiceImpl
implements ScrmContactService {
    private static final Logger log = LoggerFactory.getLogger(ScrmContactServiceImpl.class);
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private ContactCenterService contactCenterService;
    @Autowired
    private OfficialAccountMapper officialAccountMapper;
    @Autowired
    private AppletInfoMapper appletInfoMapper;
    @Autowired
    private ExternalTagClient externalTagClient;
    @Autowired
    private ExternalContactModService externalContactModService;
    @Resource
    private WeworkContactMobileMapper weworkContactMobileMapper;
    @Resource
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Resource
    private ExternalContactClient externalContactClient;
    @Autowired
    private IdGen idGen;
    @Autowired
    private CcCustomerNumService ccCustomerNumService;
    @Resource
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private WeworkContactTagMapper weworkContactTagMapper;
    @Autowired
    private ContactTagSyncService contactTagSyncService;
    @Resource
    private WeworkContactLogMapper weworkContactLogMapper;

    public WeworkContactResp search(String corpId, String mobile) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{corpId, mobile})) {
            return null;
        }
        WeworkContact weworkContact = this.weworkContactMapper.getByCorpIdAndMobile(corpId, mobile);
        if (weworkContact == null) {
            return null;
        }
        return this.newWeworkContactResp(weworkContact);
    }

    public List<WeworkContactResp> search(String corpId, Collection<String> mobiles) {
        if (StringUtils.isBlank((CharSequence)corpId)) {
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(mobiles)) {
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty((Collection)(mobiles = (Collection)mobiles.stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet())))) {
            return Collections.emptyList();
        }
        List list = this.weworkContactMapper.getByCorpIdAndMobiles(corpId, mobiles);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        return list.stream().map(this::newWeworkContactResp).collect(Collectors.toList());
    }

    public List<ContactAssociateResp> queryContactAssociate(String corpId, String customerNum, List<String> mobiles) {
        ContactAssocaiteReqDto reqDto = new ContactAssocaiteReqDto();
        reqDto.setCorpId(corpId);
        reqDto.setCustomerNum(customerNum);
        reqDto.setMobiles(mobiles);
        BusinessCustomer businessCustomer = this.businessCustomerMapper.selectByCorpId(corpId);
        if (businessCustomer == null) {
            log.error("queryContactAssociate,businessCustomer is null");
            return Collections.emptyList();
        }
        reqDto.setBizId(businessCustomer.getId());
        List<ContactAssociateRespDto> respDtos = this.contactCenterService.queryContactAssociate(reqDto);
        if (CollectionUtils.isNotEmpty(respDtos)) {
            ArrayList associateResps = Lists.newArrayList();
            for (ContactAssociateRespDto respDto : respDtos) {
                ContactAssociateResp associateResp = new ContactAssociateResp();
                associateResps.add(associateResp);
                if (respDto.getContactRespDto() != null) {
                    WeworkContactResp contactResp = new WeworkContactResp();
                    BeanUtils.copyProperties((Object)respDto.getContactRespDto(), (Object)contactResp);
                    associateResp.setContactResp(contactResp);
                }
                if (CollectionUtils.isNotEmpty(respDto.getWeworkRooms())) {
                    ArrayList roomAssociateDtos = Lists.newArrayList();
                    for (WeworkRoomDto roomDto : respDto.getWeworkRooms()) {
                        WeworkRoomAssociateDto roomAssociateDto = new WeworkRoomAssociateDto();
                        BeanUtils.copyProperties((Object)roomDto, (Object)roomAssociateDto);
                        roomAssociateDtos.add(roomAssociateDto);
                    }
                    associateResp.setWeworkRooms((List)roomAssociateDtos);
                }
                if (!CollectionUtils.isNotEmpty(respDto.getWeworkUsers())) continue;
                ArrayList userAssociateDtos = Lists.newArrayList();
                for (WeworkUserDto userDto : respDto.getWeworkUsers()) {
                    WeworkUserAssociateDto userAssociateDto = new WeworkUserAssociateDto();
                    BeanUtils.copyProperties((Object)userDto, (Object)userAssociateDto);
                    userAssociateDtos.add(userAssociateDto);
                }
                associateResp.setWeworkUsers((List)userAssociateDtos);
            }
            return associateResps;
        }
        return null;
    }

    public OfficialResp official(String appId) {
        OfficialAccount officialAccount = this.officialAccountMapper.getByAppId(appId);
        OfficialResp officialResp = new OfficialResp();
        if (ObjectUtils.allNotNull((Object[])new Object[]{officialAccount})) {
            BeanUtils.copyProperties((Object)officialAccount, (Object)officialResp);
        }
        return officialResp;
    }

    public AppletResp miniProgram(String appId) {
        AppletInfo appletInfo = this.appletInfoMapper.getByAppId(appId);
        AppletResp appletResp = new AppletResp();
        if (ObjectUtils.allNotNull((Object[])new Object[]{appletInfo})) {
            BeanUtils.copyProperties((Object)appletInfo, (Object)appletResp);
        }
        return appletResp;
    }

    public void markWeworkTag(ScrmMarkWeworkTagReqDto scrmMarkWeworkTagReqDto) {
        log.info("markWeworkTag, scrmMarkWeworkTagReqDto:{}", (Object)scrmMarkWeworkTagReqDto);
        if (StringUtils.isBlank((CharSequence)scrmMarkWeworkTagReqDto.getCorpId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "corpId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        List addTagIds = scrmMarkWeworkTagReqDto.getAddTagIds();
        List removeTagIds = scrmMarkWeworkTagReqDto.getRemoveTagIds();
        if (CollectionUtils.isEmpty((Collection)addTagIds) && CollectionUtils.isEmpty((Collection)removeTagIds)) {
            log.warn("addTagIds and removeTagIds is empty,return");
            return;
        }
        String contactId = scrmMarkWeworkTagReqDto.getContactId();
        List weworkUserIds = scrmMarkWeworkTagReqDto.getWeworkUserIds();
        if (StringUtils.isBlank((CharSequence)contactId)) {
            log.warn("contactId is blank,return");
            return;
        }
        if (CollectionUtils.isEmpty((Collection)weworkUserIds)) {
            log.warn("weworkUserIds is empty,return");
            return;
        }
        String corpId = scrmMarkWeworkTagReqDto.getCorpId();
        Long bizId = this.businessCustomerMapper.getBizId(corpId);
        try {
            for (String weworkUserId : weworkUserIds) {
                MarkTagParams req = new MarkTagParams();
                req.setUserId(weworkUserId);
                req.setExternalUserId(contactId);
                req.setAddTagIds(addTagIds);
                req.setRemoveTagIds(removeTagIds);
                this.externalTagClient.markTag(corpId, req);
                List contactTags = this.weworkContactTagMapper.queryByCorpIdAndContactIdsFilterWeworkUserIds(corpId, (List)Lists.newArrayList((Object[])new String[]{contactId}));
                Set existTagIds = contactTags.stream().map(WeworkContactTag::getTagId).collect(Collectors.toSet());
                HashSet allTagIds = Sets.newHashSet();
                allTagIds.addAll(addTagIds);
                allTagIds.addAll(existTagIds);
                if (CollectionUtils.isNotEmpty((Collection)removeTagIds)) {
                    allTagIds.removeAll(removeTagIds);
                }
                this.contactTagSyncService.syncTag2Crm(bizId, contactId, allTagIds, weworkUserId);
            }
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5ba2\u6237\u4f01\u4e1a\u6807\u7b7e\u5931\u8d25, {}, params:{}", (Object)e.getMessage(), (Object)scrmMarkWeworkTagReqDto);
        }
    }

    public List<String> filterContactIdByWeworkUserNum(String weworkUserNum, List<String> contactIds) {
        if (StringUtils.isBlank((CharSequence)weworkUserNum)) {
            throw new IllegalArgumentException("weworkUserNum \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(contactIds)) {
            return Collections.emptyList();
        }
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByNum(weworkUserNum);
        if (weworkUser == null) {
            return Collections.emptyList();
        }
        List relationList = this.weworkContactRelationMapper.selectByCorpIdAndContactIds(weworkUser.getCorpId(), contactIds, weworkUser.getWeworkUserId());
        ArrayList result = Lists.newArrayList();
        for (WeworkContactRelation rel : relationList) {
            if (rel.getIsDeleted() != 0) continue;
            result.add(rel.getContactId());
        }
        return result;
    }

    private WeworkContactResp newWeworkContactResp(WeworkContact weworkContact) {
        WeworkContactResp resp = new WeworkContactResp();
        resp.setCorpId(weworkContact.getCorpId());
        resp.setContactId(weworkContact.getContactId());
        resp.setName(weworkContact.getName());
        resp.setAvatar(weworkContact.getAvatar());
        resp.setMobile(weworkContact.getMobile());
        resp.setGender(weworkContact.getGender());
        resp.setType(weworkContact.getType());
        resp.setCorpName(weworkContact.getCorpName());
        return resp;
    }

    @Transactional(rollbackFor={Exception.class})
    public void modMobileByAllWeworkUserIds(ModMobileSyncReq req) {
        String corpId = req.getCorpId();
        String contactId = req.getContactId();
        List mobiles = req.getMobiles();
        log.info("modMobileByAllWeworkUserIds corpId: {}, contactId: {}, mobile: {}", new Object[]{corpId, contactId, mobiles});
        List relations = this.weworkContactRelationMapper.queryListByContactId(corpId, contactId);
        if (CollectionUtils.isEmpty((Collection)relations)) {
            log.info("modMobileByAllWeworkUserIds relations get is empty, contactId: {}, corpId: {}", (Object)contactId, (Object)corpId);
            return;
        }
        for (WeworkContactRelation relation : relations) {
            Set existMobiles = this.weworkContactMobileMapper.selectContactMobilesByParams(corpId, relation.getWeworkUserId(), contactId);
            List newMobiles = Lists.newArrayList();
            if (existMobiles != null) {
                log.info("modMobileByAllWeworkUserIds get existMobile: {}, weworkUserId: {}, contactId: {}", new Object[]{existMobiles, relation.getWeworkUserId(), contactId});
                existMobiles.remove("");
                if (existMobiles.size() >= 5) continue;
                newMobiles.addAll(existMobiles);
            }
            newMobiles.addAll(mobiles);
            if (newMobiles.size() > 5) {
                newMobiles = newMobiles.subList(0, 4);
            }
            ExternalContactRemark remark = new ExternalContactRemark();
            remark.setUserId(relation.getWeworkUserId());
            remark.setExternalUserId(contactId);
            remark.setRemarkMobiles(newMobiles);
            log.info("modMobileByAllWeworkUserIds externalContactClient req: {}, corpId: {}", (Object)remark, (Object)corpId);
            try {
                this.externalContactClient.remark(corpId, remark);
            }
            catch (Exception e) {
                log.error("\u4fee\u6539\u5ba2\u6237\u5907\u6ce8\u4fe1\u606f\u5931\u8d25, {}, params:{}", (Object)e.getMessage(), (Object)remark);
            }
        }
    }

    public Map<String, String> getCustomerNumByWeworkDigitIds(Long bizId, Collection<String> weworkDigitIds) {
        log.info("getCustomerNumByWeworkDigitIds bizId: {}, weworkDigitIds: {}", (Object)bizId, weworkDigitIds);
        if (CollectionUtils.isEmpty(weworkDigitIds)) {
            return Maps.newHashMap();
        }
        Map contactIdMap = this.weworkContactMapper.queryContactIdByWeworkDigitId(bizId, weworkDigitIds);
        if (MapUtils.isEmpty((Map)contactIdMap)) {
            return Maps.newHashMap();
        }
        Map customerNumMap = this.ccCustomerNumService.butchGetCustomerNumByContactId(bizId, weworkDigitIds);
        if (MapUtils.isEmpty((Map)customerNumMap)) {
            return Maps.newHashMap();
        }
        HashMap result = Maps.newHashMap();
        for (Map.Entry item : contactIdMap.entrySet()) {
            result.put(item.getKey(), customerNumMap.get(item.getValue()));
        }
        return result;
    }

    public Map<String, String> getWeworkDigitIdsByCustomerNum(Long bizId, Collection<String> customerNums) {
        log.info("getWeworkDigitIdsByCustomerNum bizId: {}, customerNums: {}", (Object)bizId, customerNums);
        if (CollectionUtils.isEmpty(customerNums)) {
            return Maps.newHashMap();
        }
        Map weworkContactIdMap = this.ccCustomerNumService.getWeworkContactId(bizId, customerNums);
        if (MapUtils.isEmpty((Map)weworkContactIdMap)) {
            return Maps.newHashMap();
        }
        Map weworkDigitIdMap = this.weworkContactMapper.queryWeworkDigitIdByContactId(bizId, weworkContactIdMap.values());
        if (MapUtils.isEmpty((Map)weworkDigitIdMap)) {
            return Maps.newHashMap();
        }
        HashMap result = Maps.newHashMap();
        for (Map.Entry item : weworkContactIdMap.entrySet()) {
            result.put(item.getKey(), weworkDigitIdMap.get(item.getValue()));
        }
        return result;
    }

    public String getContactIdByUnionId(String corpId, String unionId) {
        log.info("getContactIdByUnionId corpId:{},unionId:{}", (Object)corpId, (Object)unionId);
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{corpId, unionId})) {
            return null;
        }
        WeworkContact weworkContact = this.weworkContactMapper.selectByCorpIdAndUnionId(corpId, unionId);
        return weworkContact == null ? null : weworkContact.getContactId();
    }

    public List<ContactAssociateResp> queryContactInfoByContactIds(Long bizId, Collection<String> contactIds) {
        log.info("queryContactInfoByContactIds,bizId:{},contactIds:{}", (Object)bizId, contactIds);
        if (CollectionUtils.isEmpty(contactIds)) {
            return Collections.emptyList();
        }
        if (bizId == null) {
            return Collections.emptyList();
        }
        List weworkContacts = this.weworkContactMapper.queryWeworkContactByContactIds(bizId, contactIds);
        if (CollectionUtils.isEmpty((Collection)weworkContacts)) {
            return Collections.emptyList();
        }
        HashMap<String, List> contactIdAssociateMap = new HashMap<String, List>();
        List weworkContactRelations = this.weworkContactRelationMapper.queryByBizIdAndContactIds(bizId, contactIds);
        if (CollectionUtils.isNotEmpty((Collection)weworkContactRelations)) {
            Set weworkUserIds = weworkContactRelations.stream().map(WeworkContactRelation::getWeworkUserId).collect(Collectors.toSet());
            String corpId = ((WeworkContactRelation)weworkContactRelations.get(0)).getCorpId();
            Map weworkUserIdAndNumMap = this.weworkUserMapper.queryUserNumIdMap(corpId, weworkUserIds);
            for (WeworkContactRelation weworkContactRelation : weworkContactRelations) {
                String contactId = weworkContactRelation.getContactId();
                List orDefault = contactIdAssociateMap.getOrDefault(contactId, new ArrayList());
                WeworkUserAssociateDto dto = new WeworkUserAssociateDto();
                dto.setWeworkUserId(weworkContactRelation.getWeworkUserId());
                dto.setWeworkUserNum((String)weworkUserIdAndNumMap.get(weworkContactRelation.getWeworkUserId()));
                int addWeworkStatus = AddWeworkStatusEnum.ADD.getValue();
                if (NumberUtils.INTEGER_ONE.equals(weworkContactRelation.getIsDeleted()) || NumberUtils.INTEGER_ONE.equals(weworkContactRelation.getIsZombieFans())) {
                    addWeworkStatus = AddWeworkStatusEnum.DEL.getValue();
                }
                dto.setAddWeworkStatus(Integer.valueOf(addWeworkStatus));
                dto.setAddTime(weworkContactRelation.getAddTime());
                dto.setDelTime(weworkContactRelation.getDeletedTime());
                orDefault.add(dto);
                contactIdAssociateMap.put(contactId, orDefault);
            }
        }
        ArrayList<ContactAssociateResp> respList = new ArrayList<ContactAssociateResp>();
        for (WeworkContact weworkContact : weworkContacts) {
            String contactId = weworkContact.getContactId();
            ContactAssociateResp resp = new ContactAssociateResp();
            WeworkContactResp contactResp = this.newWeworkContactResp(weworkContact);
            List weworkUserAssociateDtoList = (List)contactIdAssociateMap.get(contactId);
            resp.setContactResp(contactResp);
            resp.setWeworkUsers(weworkUserAssociateDtoList);
            respList.add(resp);
        }
        return respList;
    }

    public List<String> queryWeworkUserIdsByContactId(Long bizId, String contactId) {
        log.info("getTagIdsByContact bizId: {}, contactId: {}", (Object)bizId, (Object)contactId);
        String corpId = this.businessCustomerMapper.getCorpIdById(bizId);
        List<Object> weworkUserIds = Lists.newArrayList();
        List relationList = this.weworkContactRelationMapper.queryListByContactIdIncloudZoomFans(corpId, contactId);
        if (CollectionUtils.isNotEmpty((Collection)relationList)) {
            weworkUserIds = relationList.stream().map(WeworkContactRelation::getWeworkUserId).collect(Collectors.toList());
        }
        return weworkUserIds;
    }

    public Map<String, Set<String>> queryIsAddedFriendByContactIdsAndAddTime(Long bizId, Collection<String> contactIds, Date startTime, Date endTime) {
        log.info("queryIsAddedFriendByContactIdsAndAddTime,bizId:{},contactIds:{},startTime:{},endTime:{}", new Object[]{bizId, contactIds, startTime, endTime});
        if (bizId == null || CollectionUtils.isEmpty(contactIds) || startTime == null && endTime == null) {
            return Collections.emptyMap();
        }
        List weworkContactRelations = this.weworkContactRelationMapper.queryIsAddedFriendByContactIdsAndAddTime(bizId, contactIds, startTime, endTime);
        if (CollectionUtils.isEmpty((Collection)weworkContactRelations)) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<String>> contactIdWeworkUserIdsMap = new HashMap<String, Set<String>>();
        for (WeworkContactRelation weworkContactRelation : weworkContactRelations) {
            String contactId = weworkContactRelation.getContactId();
            String weworkUserId = weworkContactRelation.getWeworkUserId();
            Set orDefault = contactIdWeworkUserIdsMap.getOrDefault(contactId, new HashSet());
            orDefault.add(weworkUserId);
            contactIdWeworkUserIdsMap.put(contactId, orDefault);
        }
        return contactIdWeworkUserIdsMap;
    }

    public List<DeletedWeworkContactResp> queryDeletedByTimeRange(Long bizId, Date startTime, Date endTime, Collection<String> weworkUserNums) {
        log.info("queryDeletedByTimeRange,bizId:{},startTime:{},endTime:{},weworkUserNums:{}", new Object[]{bizId, startTime, endTime, weworkUserNums});
        if (bizId == null || startTime == null || endTime == null) {
            return Collections.emptyList();
        }
        List weworkContactLogs = this.weworkContactLogMapper.queryDeletedByTime(bizId, startTime, endTime, weworkUserNums);
        if (CollectionUtils.isEmpty((Collection)weworkContactLogs)) {
            log.info("queryDeletedByTimeRange,bizId:{},weworkContactLogs is empty", (Object)bizId);
            return Collections.emptyList();
        }
        Set queryWeworkUserNums = weworkContactLogs.stream().map(WeworkContactLog::getWeworkUserNum).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(queryWeworkUserNums)) {
            log.info("queryDeletedByTimeRange,bizId:{},queryWeworkUserNums is empty", (Object)bizId);
            return Collections.emptyList();
        }
        Map weworkUserNumMap = this.weworkUserMapper.queryWeworkUserIdMapByNums(queryWeworkUserNums);
        ArrayList<DeletedWeworkContactResp> respList = new ArrayList<DeletedWeworkContactResp>();
        for (WeworkContactLog weworkContactLog : weworkContactLogs) {
            String contactId;
            String weworkUserNum = weworkContactLog.getWeworkUserNum();
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{weworkUserNum, contactId = weworkContactLog.getContactId()})) continue;
            String weworkUserId = (String)weworkUserNumMap.get(weworkUserNum);
            DeletedWeworkContactResp resp = new DeletedWeworkContactResp();
            resp.setContactId(contactId);
            resp.setWeworkUserNum(weworkUserNum);
            resp.setWeworkUserId(weworkUserId);
            respList.add(resp);
        }
        return respList;
    }
}

