/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.chatroom.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.dto.resp.IdAndNameDto;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.BDataValueDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.OrgService;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.contactanalyse.mapper.WeworkRoomJoinQuitLogMapper;
import com.kuaike.scrm.dal.wework.dto.ChatRoomListQuery;
import com.kuaike.scrm.dal.wework.dto.WeworkChatroomDto;
import com.kuaike.scrm.dal.wework.entity.WeworkChatRoom;
import com.kuaike.scrm.dal.wework.entity.WeworkChatRoomCriteria;
import com.kuaike.scrm.dal.wework.entity.WeworkChatRoomRemark;
import com.kuaike.scrm.dal.wework.entity.WeworkChatRoomRemarkRelation;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomRemarkMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomRemarkRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentUserMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.wework.chatroom.dto.request.QueryChatRoomListReq;
import com.kuaike.scrm.wework.chatroom.dto.request.RoomAttachRemarkReqDto;
import com.kuaike.scrm.wework.chatroom.dto.request.RoomRemarkReqDto;
import com.kuaike.scrm.wework.chatroom.dto.request.UserChatroomQuery;
import com.kuaike.scrm.wework.chatroom.dto.response.ChatRoomRespDto;
import com.kuaike.scrm.wework.chatroom.service.ChatRoomService;
import com.kuaike.scrm.wework.weworkuser.service.WeworkUserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ChatRoomServiceImpl
implements ChatRoomService {
    private static final Logger log = LoggerFactory.getLogger(ChatRoomServiceImpl.class);
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Resource
    private WeworkChatRoomRelationMapper weworkChatRoomRelationMapper;
    @Resource
    private WeworkChatRoomMapper weworkChatRoomMapper;
    @Autowired
    private WeworkUserService weworkUserService;
    @Resource
    private WeworkRoomJoinQuitLogMapper weworkRoomJoinQuitLogMapper;
    @Resource
    private WeworkChatRoomRemarkRelationMapper weworkChatRoomRemarkRelationMapper;
    @Resource
    private WeworkChatRoomRemarkMapper weworkChatRoomRemarkMapper;
    @Resource
    private NodeService nodeService;
    @Resource
    private OrgService orgService;
    @Resource
    private WeworkDepartmentUserMapper weworkDepartmentUserMapper;

    @Override
    public List<WeworkChatRoom> selectRoomList(String corpId, Long bizId, Collection<String> roomIds) {
        if (CollectionUtils.isEmpty(roomIds)) {
            return Lists.newArrayList();
        }
        WeworkChatRoomCriteria chatRoomCriteria = new WeworkChatRoomCriteria();
        WeworkChatRoomCriteria.Criteria criteria = chatRoomCriteria.createCriteria().andWeworkRoomIdIn((List)Lists.newArrayList(roomIds));
        if (Objects.nonNull(bizId)) {
            criteria.andBizIdEqualTo(bizId);
        }
        if (StringUtils.isNotBlank((CharSequence)corpId)) {
            criteria.andCorpIdEqualTo(corpId);
        }
        return this.weworkChatRoomMapper.selectByExample((Object)chatRoomCriteria);
    }

    @Override
    public List<WeworkChatRoom> queryListByWeworkUserIdNameQuery(String corpId, Long bizId, String weworkUserId, String query) {
        if (StringUtils.isNotBlank((CharSequence)query)) {
            return Lists.newArrayList();
        }
        return this.weworkChatRoomMapper.queryListByWeworkUserIdNameQuery(corpId, bizId, weworkUserId, query);
    }

    @Override
    public List<ChatRoomRespDto> roomList(QueryChatRoomListReq params) {
        List chatRoomList;
        log.info("roomList params: {}", (Object)params);
        if (params == null) {
            return null;
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        Set<String> managerWeworkUserIds = this.weworkUserService.queryCurManagerWeworkUser();
        if (CollectionUtils.isEmpty(managerWeworkUserIds)) {
            return Lists.newArrayList();
        }
        HashSet<String> weworkUserIdsByParams = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(params.getWeworkUserIds())) {
            Map<String, String> weworkUserNumAndWeworkUserIdMap = this.weworkUserService.getWeworkUserIdMapByNums(params.getWeworkUserIds());
            Collection<String> weworkUserIdByParams = weworkUserNumAndWeworkUserIdMap.values();
            weworkUserIdsByParams.addAll(weworkUserIdByParams);
        }
        if (CollectionUtils.isNotEmpty(params.getDeptIds())) {
            Set subOrgIds = this.nodeService.getPosterityIds(params.getDeptIds(), userInfo.getBizId());
            Set deptIds = this.orgService.getDepartmentIds(subOrgIds);
            Set weworkUserIdByDeptParams = this.weworkDepartmentUserMapper.selectWeworkUserId(userInfo.getCorpId(), (Collection)deptIds);
            weworkUserIdsByParams.addAll(weworkUserIdByDeptParams);
        }
        if (CollectionUtils.isNotEmpty(params.getDeptIds()) || CollectionUtils.isNotEmpty(params.getWeworkUserIds())) {
            managerWeworkUserIds.retainAll(weworkUserIdsByParams);
            if (CollectionUtils.isEmpty(managerWeworkUserIds)) {
                log.info("roomList,\u6839\u636e\u7ba1\u7406\u6743\u9650\u4e0e\u5458\u5de5\u90e8\u95e8\u7b5b\u9009\u7ed3\u679c\u6c42\u4ea4\u96c6\u4e3a\u7a7a");
                return Collections.emptyList();
            }
        }
        ChatRoomListQuery queryParams = new ChatRoomListQuery();
        queryParams.setCorpId(corpId);
        queryParams.setName(params.getName());
        queryParams.setIsDismiss(params.getIsDismiss());
        queryParams.setWeworkRoomIds(params.getWeworkRoomIds());
        queryParams.setWeworkUserIds(managerWeworkUserIds);
        queryParams.setPageDto(params.getPageDto());
        if (Objects.nonNull(params.getBuildRoomStartTime())) {
            queryParams.setBuildRoomStartTime(params.getBuildRoomStartTime());
        }
        if (Objects.nonNull(params.getBuildRoomEndTime())) {
            queryParams.setBuildRoomEndTime(params.getBuildRoomEndTime());
        }
        if (CollectionUtils.isNotEmpty(params.getRemarkIds())) {
            Set remarkRoomIds = this.weworkChatRoomRemarkRelationMapper.selectRoomIdsByRemarkIds(params.getRemarkIds());
            if (CollectionUtils.isEmpty((Collection)remarkRoomIds)) {
                log.info("\u6839\u636eremarkIds:{}\u672a\u67e5\u8be2\u5230\u7fa4id", (Object)remarkRoomIds);
                return Collections.emptyList();
            }
            queryParams.setRemarkRoomIds(remarkRoomIds);
        }
        if (params.getPageDto() != null) {
            int total = this.weworkChatRoomMapper.queryChatRoomCount(queryParams);
            params.getPageDto().setCount(Integer.valueOf(total));
        }
        if (CollectionUtils.isEmpty((Collection)(chatRoomList = this.weworkChatRoomMapper.queryChatRoomList(queryParams)))) {
            return Lists.newArrayList();
        }
        Set weworkUserSet = chatRoomList.stream().map(WeworkChatRoom::getOwner).collect(Collectors.toSet());
        Map weworkUserNameMap = this.weworkUserMapper.queryWeworkUserNameMap(corpId, weworkUserSet);
        Set roomIdSet = chatRoomList.stream().map(WeworkChatRoom::getWeworkRoomId).collect(Collectors.toSet());
        Map roomMemberCountMap = this.weworkChatRoomRelationMapper.getRoomIdAndMemberCountByCorpIdAndRoomIds(corpId, roomIdSet);
        Date beginOfDay = new Date(DateUtil.getTheDateBegin((Date)new Date()));
        Map joinRooms = this.weworkRoomJoinQuitLogMapper.getRoomIdAndTodayJoinCountByCorpIdAndRoomIds(corpId, roomIdSet, beginOfDay);
        Map quitRooms = this.weworkRoomJoinQuitLogMapper.getRoomIdAndTodayQuitCountByCorpIdAndRoomIds(corpId, roomIdSet, beginOfDay);
        List remarkRelations = this.weworkChatRoomRemarkRelationMapper.selectByCorpIdAndRoomIds(corpId, roomIdSet);
        Map<Object, Object> roomId2RoomRemarkMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)remarkRelations)) {
            roomId2RoomRemarkMap = remarkRelations.stream().collect(Collectors.groupingBy(WeworkChatRoomRemarkRelation::getWeworkRoomId));
        }
        ArrayList result = Lists.newArrayList();
        for (WeworkChatRoom weworkChatRoom : chatRoomList) {
            String roomId = weworkChatRoom.getWeworkRoomId();
            ChatRoomRespDto roomRespDto = new ChatRoomRespDto();
            roomRespDto.setWeworkRoomId(roomId);
            roomRespDto.setName(weworkChatRoom.getName());
            roomRespDto.setNotice(weworkChatRoom.getNotice());
            roomRespDto.setOwnerId(weworkChatRoom.getOwner());
            roomRespDto.setIsDismiss(weworkChatRoom.getIsDismiss());
            roomRespDto.setCreateRoomTime(weworkChatRoom.getBuildRoomTime());
            roomRespDto.setOwnerName((String)weworkUserNameMap.get(weworkChatRoom.getOwner()));
            roomRespDto.setCount((Integer)roomMemberCountMap.get(roomId));
            roomRespDto.setTodayJoinRoomCount(joinRooms.getOrDefault(roomId, 0));
            roomRespDto.setTodayQuitRoomCount(quitRooms.getOrDefault(roomId, 0));
            if (roomId2RoomRemarkMap.containsKey(roomId)) {
                List relations = (List)roomId2RoomRemarkMap.get(roomId);
                ArrayList remarks = Lists.newArrayListWithCapacity((int)relations.size());
                for (WeworkChatRoomRemarkRelation relation : relations) {
                    IdAndNameDto idAndNameDto = new IdAndNameDto();
                    remarks.add(idAndNameDto);
                    idAndNameDto.setId(relation.getChatRoomRemarkId());
                    idAndNameDto.setName(relation.getRemarkName());
                }
                roomRespDto.setRemarks(remarks);
            }
            result.add(roomRespDto);
        }
        return result;
    }

    @Override
    public List<WeworkChatroomDto> queryUserChatroom(UserChatroomQuery req) {
        req.validate();
        return this.weworkChatRoomRelationMapper.queryUserChatroom(req.getUseAgent(), req.getBizId(), req.getWeworkUserId(), req.getQuery(), req.getCorpId(), req.getChatroomIds());
    }

    @Override
    public ChatRoomRespDto queryRoomDetail(String roomId) {
        log.info("queryRoomDetail params: {}", (Object)roomId);
        if (StringUtils.isEmpty((CharSequence)roomId)) {
            return null;
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        WeworkChatRoom weworkChatRoom = this.weworkChatRoomMapper.getWeworkChatRoom(corpId, roomId);
        if (Objects.isNull(weworkChatRoom)) {
            return null;
        }
        Map weworkUserNameMap = this.weworkUserMapper.queryWeworkUserNameMap(corpId, (Collection)Sets.newHashSet((Object[])new String[]{weworkChatRoom.getOwner()}));
        Map roomMemberCountMap = this.weworkChatRoomRelationMapper.getRoomIdAndMemberCountByCorpIdAndRoomIds(corpId, (Collection)Sets.newHashSet((Object[])new String[]{roomId}));
        Date beginOfDay = new Date(DateUtil.getTheDateBegin((Date)new Date()));
        Map joinRooms = this.weworkRoomJoinQuitLogMapper.getRoomIdAndTodayJoinCountByCorpIdAndRoomIds(corpId, (Collection)Sets.newHashSet((Object[])new String[]{roomId}), beginOfDay);
        Map quitRooms = this.weworkRoomJoinQuitLogMapper.getRoomIdAndTodayQuitCountByCorpIdAndRoomIds(corpId, (Collection)Sets.newHashSet((Object[])new String[]{roomId}), beginOfDay);
        Map remarkId2NameMap = this.weworkChatRoomRemarkRelationMapper.selectRoomRemarkByCorpIdAndRoomId(corpId, roomId);
        ChatRoomRespDto roomRespDto = new ChatRoomRespDto();
        roomRespDto.setWeworkRoomId(roomId);
        roomRespDto.setName(weworkChatRoom.getName());
        roomRespDto.setNotice(weworkChatRoom.getNotice());
        roomRespDto.setOwnerId(weworkChatRoom.getOwner());
        roomRespDto.setIsDismiss(weworkChatRoom.getIsDismiss());
        roomRespDto.setCreateRoomTime(weworkChatRoom.getBuildRoomTime());
        roomRespDto.setOwnerName((String)weworkUserNameMap.get(weworkChatRoom.getOwner()));
        roomRespDto.setCount((Integer)roomMemberCountMap.get(roomId));
        roomRespDto.setTodayJoinRoomCount(joinRooms.getOrDefault(roomId, 0));
        roomRespDto.setTodayQuitRoomCount(quitRooms.getOrDefault(roomId, 0));
        if (MapUtils.isNotEmpty((Map)remarkId2NameMap)) {
            ArrayList remarks = Lists.newArrayListWithCapacity((int)remarkId2NameMap.size());
            for (Map.Entry entry : remarkId2NameMap.entrySet()) {
                IdAndNameDto idAndNameDto = new IdAndNameDto();
                remarks.add(idAndNameDto);
                idAndNameDto.setId((Long)entry.getKey());
                idAndNameDto.setName((String)entry.getValue());
            }
            roomRespDto.setRemarks(remarks);
        }
        return roomRespDto;
    }

    @Override
    public List<IdAndNameDto> roomRemarkList(RoomRemarkReqDto params) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        log.info("roomRemarkList,params:{}, operatorId:{}", (Object)params, (Object)userInfo);
        List weworkChatRoomRemarks = this.weworkChatRoomRemarkMapper.selectByCorpIdAndName(corpId, params.getName());
        if (CollectionUtils.isEmpty((Collection)weworkChatRoomRemarks)) {
            log.info("\u6839\u636ecorpId:{},\u672a\u67e5\u8be2\u5230\u7fa4\u5907\u6ce8\u8bb0\u5f55", (Object)corpId);
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)weworkChatRoomRemarks.size());
        for (WeworkChatRoomRemark roomRemark : weworkChatRoomRemarks) {
            IdAndNameDto idAndNameDto = new IdAndNameDto();
            result.add(idAndNameDto);
            idAndNameDto.setId(roomRemark.getId());
            idAndNameDto.setName(roomRemark.getName());
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void attachRemark(RoomAttachRemarkReqDto params) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("attachRemark,params:{}, operatorId:{}", (Object)params, (Object)userInfo);
        params.validateParams();
        String corpId = userInfo.getCorpId();
        String weworkRoomId = params.getWeworkRoomId();
        Sets.SetView names = params.getNames();
        if (CollectionUtils.isEmpty(names)) {
            log.info("\u5907\u6ce8\u540d\u96c6\u5408\u4e3a\u7a7a\uff0c\u53d6\u6d88\u7fa4id:{}\u5df2\u7ecf\u6253\u4e0a\u7684\u5907\u6ce8", (Object)weworkRoomId);
            this.weworkChatRoomRemarkRelationMapper.delRelationByCorpIdAndRoomId(corpId, weworkRoomId);
        } else {
            Set needAddRemarkIds;
            Sets.SetView needAddNames;
            Set existNames = this.weworkChatRoomRemarkMapper.selectNameByCorpIdAndNames(corpId, names);
            Set needUpdateNames = null;
            if (CollectionUtils.isNotEmpty((Collection)existNames)) {
                needAddNames = Sets.difference(names, (Set)existNames);
                needUpdateNames = existNames;
            } else {
                needAddNames = names;
            }
            if (CollectionUtils.isNotEmpty((Collection)needAddNames)) {
                List<WeworkChatRoomRemark> remarks = this.buildRemarks((Set<String>)needAddNames, userInfo);
                this.weworkChatRoomRemarkMapper.batchInsert(remarks);
            }
            if (CollectionUtils.isNotEmpty((Collection)needUpdateNames)) {
                this.weworkChatRoomRemarkMapper.updateUseCountByCorpIdAndNames(corpId, (Collection)needUpdateNames);
            }
            Set remarkIds = this.weworkChatRoomRemarkMapper.selectIdByCorpIdAndNames(corpId, (Collection)names);
            Set existRemarkIds = this.weworkChatRoomRemarkRelationMapper.selectRemarkIdByCorpIdAndRoomId(corpId, weworkRoomId);
            Sets.SetView needDelRemarkIds = null;
            if (CollectionUtils.isNotEmpty((Collection)existRemarkIds)) {
                needAddRemarkIds = Sets.difference((Set)remarkIds, (Set)existRemarkIds);
                needDelRemarkIds = Sets.difference((Set)existRemarkIds, (Set)remarkIds);
            } else {
                needAddRemarkIds = remarkIds;
            }
            if (CollectionUtils.isNotEmpty(needDelRemarkIds)) {
                this.weworkChatRoomRemarkRelationMapper.delByCorpIdRoomIdAndRemarkIds(corpId, weworkRoomId, (Collection)needDelRemarkIds);
            }
            if (CollectionUtils.isNotEmpty((Collection)needAddRemarkIds)) {
                List<WeworkChatRoomRemarkRelation> remarkRelations = this.buildRemarkRelations(weworkRoomId, needAddRemarkIds, userInfo);
                this.weworkChatRoomRemarkRelationMapper.batchInsert(remarkRelations);
            }
        }
    }

    private List<WeworkChatRoomRemark> buildRemarks(Set<String> names, CurrentUserInfo userInfo) {
        ArrayList remarks = Lists.newArrayListWithCapacity((int)names.size());
        for (String name : names) {
            WeworkChatRoomRemark weworkChatRoomRemark = new WeworkChatRoomRemark();
            remarks.add(weworkChatRoomRemark);
            weworkChatRoomRemark.setBizId(userInfo.getBizId());
            weworkChatRoomRemark.setCorpId(userInfo.getCorpId());
            weworkChatRoomRemark.setName(name);
            weworkChatRoomRemark.setUseCount(NumberUtils.LONG_ONE);
            weworkChatRoomRemark.setCreateBy(userInfo.getId());
            weworkChatRoomRemark.setUpdateBy(userInfo.getId());
            weworkChatRoomRemark.setCreateTime(new Date());
            weworkChatRoomRemark.setUpdateTime(new Date());
            weworkChatRoomRemark.setIsDeleted(NumberUtils.INTEGER_ZERO);
        }
        return remarks;
    }

    private List<WeworkChatRoomRemarkRelation> buildRemarkRelations(String weworkRoomId, Set<Long> remarkIds, CurrentUserInfo userInfo) {
        Date currentDate = new Date();
        Long userId = userInfo.getId();
        ArrayList remarkRelations = Lists.newArrayListWithCapacity((int)remarkIds.size());
        for (Long remarkId : remarkIds) {
            WeworkChatRoomRemarkRelation remarkRelation = new WeworkChatRoomRemarkRelation();
            remarkRelations.add(remarkRelation);
            remarkRelation.setBizId(userInfo.getBizId());
            remarkRelation.setCorpId(userInfo.getCorpId());
            remarkRelation.setWeworkRoomId(weworkRoomId);
            remarkRelation.setChatRoomRemarkId(remarkId);
            remarkRelation.setCreateBy(userId);
            remarkRelation.setUpdateBy(userId);
            remarkRelation.setCreateTime(currentDate);
            remarkRelation.setUpdateTime(currentDate);
            remarkRelation.setIsDeleted(NumberUtils.INTEGER_ZERO);
        }
        return remarkRelations;
    }

    public List<BDataValueDto> getBDataOption(String query, PageDto pageDto) {
        Long userId = LoginUtils.getCurrentUserId();
        Long bizId = LoginUtils.getCurrentUserBizId();
        log.info("query room list, bizId={}, userId={}, query={}, pageDto={}", new Object[]{bizId, userId, query, pageDto});
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        ArrayList result = Lists.newArrayList();
        QueryChatRoomListReq params = new QueryChatRoomListReq();
        params.setName(query);
        params.setPageDto(pageDto);
        List<ChatRoomRespDto> list = this.roomList(params);
        if (CollectionUtils.isNotEmpty(list)) {
            for (ChatRoomRespDto it : list) {
                BDataValueDto dto = new BDataValueDto();
                dto.setValue(it.getWeworkRoomId());
                dto.setLabel(it.getName());
                result.add(dto);
            }
        }
        return result;
    }

    public List<BDataValueDto> getBDataValues(String values) {
        Long userId = LoginUtils.getCurrentUserId();
        Long bizId = LoginUtils.getCurrentUserBizId();
        String corpId = LoginUtils.getCurrentUserCorpId();
        log.info("query room list, bizId={}, userId={}, values={}", new Object[]{bizId, userId, values});
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        ArrayList result = Lists.newArrayList();
        String[] args = StringUtils.split((String)values, (String)",");
        HashSet roomIds = Sets.newHashSet();
        for (String it : args) {
            if (!StringUtils.isNotBlank((CharSequence)it)) continue;
            roomIds.add(it.trim());
        }
        if (CollectionUtils.isNotEmpty((Collection)roomIds)) {
            List<WeworkChatRoom> list = this.selectRoomList(corpId, bizId, roomIds);
            for (WeworkChatRoom it : list) {
                BDataValueDto dto = new BDataValueDto();
                dto.setValue(it.getWeworkRoomId());
                dto.setLabel(it.getName());
                result.add(dto);
            }
        }
        return result;
    }
}

