/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.weworkuser.service.impl;

import cn.kinyun.link.common_dto.dto.BaseResponse;
import cn.kinyun.link.service.OperateService;
import cn.kinyun.link.service.response.WeworkStatusInfo;
import cn.kinyun.wework.sdk.api.external.ExternalStatisticClient;
import cn.kinyun.wework.sdk.entity.external.statistic.BehaviorData;
import cn.kinyun.wework.sdk.entity.external.statistic.UserBehaviorParams;
import cn.kinyun.wework.sdk.enums.TalkerType;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.dto.TalkerMsgCountDto;
import com.kuaike.scrm.common.dto.UserRoleRespDto;
import com.kuaike.scrm.common.enums.EnumDto;
import com.kuaike.scrm.common.enums.EnumService;
import com.kuaike.scrm.common.enums.LicenseStatusEnum;
import com.kuaike.scrm.common.enums.SystemRoleType;
import com.kuaike.scrm.common.enums.WeworkActiveStatusEnum;
import com.kuaike.scrm.common.enums.WeworkRoleTypeEnum;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.service.MessageCommonService;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.OrgService;
import com.kuaike.scrm.common.service.dto.WeworkUserDto;
import com.kuaike.scrm.common.service.dto.req.ChatEsReq;
import com.kuaike.scrm.common.service.dto.resp.AggChatUserFromEsResp;
import com.kuaike.scrm.common.utils.ChatCommonUtil;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.addfriend.entity.AddFriendConfig;
import com.kuaike.scrm.dal.addfriend.mapper.AddFriendConfigMapper;
import com.kuaike.scrm.dal.agent.mapper.AgentDecryptWeworkContactIdMapper;
import com.kuaike.scrm.dal.agent.mapper.AgentDecryptWeworkUserIdMapper;
import com.kuaike.scrm.dal.agent.mapper.AgentWeworkUserMapper;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.chat.entity.WeworkUserChatConfig;
import com.kuaike.scrm.dal.chat.mapper.WeworkConversationMapper;
import com.kuaike.scrm.dal.chat.mapper.WeworkUserChatConfigMapper;
import com.kuaike.scrm.dal.contactanalyse.mapper.WeworkContactChangeLogMapper;
import com.kuaike.scrm.dal.contactanalyse.mapper.WeworkContactLogMapper;
import com.kuaike.scrm.dal.contactanalyse.mapper.WeworkContactNumLogMapper;
import com.kuaike.scrm.dal.contactanalyse.mapper.WeworkRoomJoinQuitLogMapper;
import com.kuaike.scrm.dal.contactanalyse.mapper.WeworkRoomNumLogMapper;
import com.kuaike.scrm.dal.permission.entity.Role;
import com.kuaike.scrm.dal.permission.mapper.RoleMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.system.entity.Organization;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.dal.transfer.entity.DimissionAllocateRecord;
import com.kuaike.scrm.dal.transfer.mapper.DimissionAllocateRecordMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkAuthorizeAccountMapper;
import com.kuaike.scrm.dal.wework.dto.QueryWeworkUserListDto;
import com.kuaike.scrm.dal.wework.dto.SearchWeworkUserDto;
import com.kuaike.scrm.dal.wework.dto.WeworkUserBaseReq;
import com.kuaike.scrm.dal.wework.dto.WeworkUserInfo;
import com.kuaike.scrm.dal.wework.dto.WeworkUserListReq;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.entity.WeworkDepartment;
import com.kuaike.scrm.dal.wework.entity.WeworkDepartmentUser;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.entity.WeworkUserRole;
import com.kuaike.scrm.dal.wework.entity.WeworkUserRoleManageUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentUserMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserRoleManageUserMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserRoleMapper;
import com.kuaike.scrm.wework.corp.service.WeworkCorpService;
import com.kuaike.scrm.wework.department.service.DepartmentService;
import com.kuaike.scrm.wework.weworkuser.dto.ChatWeworkUserReq;
import com.kuaike.scrm.wework.weworkuser.dto.ContactStatisticDto;
import com.kuaike.scrm.wework.weworkuser.dto.ContactStatisticParams;
import com.kuaike.scrm.wework.weworkuser.dto.ExternalRoomStatisticDto;
import com.kuaike.scrm.wework.weworkuser.dto.ExternalStatisticMutilParams;
import com.kuaike.scrm.wework.weworkuser.dto.ExternalStatisticParams;
import com.kuaike.scrm.wework.weworkuser.dto.ExternalUserStatisticDto;
import com.kuaike.scrm.wework.weworkuser.dto.StatisticResult;
import com.kuaike.scrm.wework.weworkuser.dto.WeworkRoleDetailReqDto;
import com.kuaike.scrm.wework.weworkuser.dto.WeworkRoleReqDto;
import com.kuaike.scrm.wework.weworkuser.dto.WeworkUserListDto;
import com.kuaike.scrm.wework.weworkuser.dto.WeworkUserReq;
import com.kuaike.scrm.wework.weworkuser.dto.response.DeptNameDto;
import com.kuaike.scrm.wework.weworkuser.dto.response.SearchChatUserFromEsResp;
import com.kuaike.scrm.wework.weworkuser.dto.response.SearchWeworkUserResp;
import com.kuaike.scrm.wework.weworkuser.dto.response.WeworkRoleDetailRespDto;
import com.kuaike.scrm.wework.weworkuser.dto.response.WeworkUserDetailRespDto;
import com.kuaike.scrm.wework.weworkuser.dto.response.WeworkUserNameRespDto;
import com.kuaike.scrm.wework.weworkuser.dto.response.WeworkUserNumAndNameDto;
import com.kuaike.scrm.wework.weworkuser.service.AgentWeworkUserService;
import com.kuaike.scrm.wework.weworkuser.service.WeworkUserService;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WeworkUserServiceImp
implements WeworkUserService {
    private static final Logger log = LoggerFactory.getLogger(WeworkUserServiceImp.class);
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Resource
    private UserMapper userMapper;
    @Resource
    private WeworkContactLogMapper weworkContactLogMapper;
    @Resource
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Resource
    private WeworkContactNumLogMapper weworkContactNumLogMapper;
    @Resource
    private WeworkContactChangeLogMapper weworkContactChangeLogMapper;
    @Resource
    private WeworkRoomNumLogMapper weworkRoomNumLogMapper;
    @Resource
    private WeworkRoomJoinQuitLogMapper weworkRoomJoinQuitLogMapper;
    @Resource
    private WeworkDepartmentUserMapper weworkDepartmentUserMapper;
    @Resource
    private WeworkChatRoomRelationMapper weworkChatRoomRelationMapper;
    @Autowired
    private DepartmentService departmentService;
    @Resource
    private WeworkDepartmentMapper weworkDepartmentMapper;
    @Autowired
    private ExternalStatisticClient externalStatisticClient;
    @Autowired
    private UserRoleCommonService userRoleCommonService;
    @Autowired
    private OrgService orgService;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private WeworkUserRoleMapper weworkUserRoleMapper;
    @Autowired
    private WeworkUserRoleManageUserMapper weworkUserRoleManageUserMapper;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Resource
    private OrganizationMapper organizationMapper;
    @Resource
    private DimissionAllocateRecordMapper dimissionAllocateRecordMapper;
    @Resource
    private VipWeworkAuthorizeAccountMapper vipWeworkAuthorizeAccountMapper;
    @Autowired
    private OperateService operateService;
    @Resource
    private AgentWeworkUserMapper agentWeworkUserMapper;
    @Resource
    private AgentDecryptWeworkUserIdMapper agentDecryptWeworkUserIdMapper;
    @Autowired
    private AgentDecryptWeworkContactIdMapper agentDecryptWeworkContactIdMapper;
    @Autowired
    private MessageCommonService messageCommonService;
    @Autowired
    private WeworkCorpService weworkCorpService;
    @Autowired
    private AgentWeworkUserService agentWeworkUserService;
    @Autowired
    private AddFriendConfigMapper addFriendConfigMapper;
    @Resource
    private WeworkUserChatConfigMapper weworkUserChatConfigMapper;
    @Resource
    private WeworkDepartmentMapper departmentMapper;
    @Autowired
    private WeworkConversationMapper weworkConversationMapper;
    @Resource
    private NodeService nodeService;
    @Autowired
    private RoleMapper roleMapper;

    @Override
    public List<SearchWeworkUserDto> searchWeworkUserList(WeworkUserListReq req) {
        List openChatUserIds;
        log.info("searchWeworkUserList req:{}", (Object)req);
        req.validate();
        ArrayList result = Lists.newArrayList();
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Set<String> weworkUserIdList = this.queryCurManagerWeworkUser();
        log.info("searchWeworkUserList \u7ba1\u7406\u6743\u9650\u4e0b\u7684\u6210\u5458\u4e3a\uff1a{}", weworkUserIdList);
        List<Object> queryNodeIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)req.getNodeIds())) {
            List orgListRespDtos = this.orgService.selectOrgByNums(req.getNodeIds(), currentUserInfo.getBizId(), currentUserInfo.getCorpId());
            List flatOrgListResps = this.orgService.getWeworkOrgId(orgListRespDtos);
            queryNodeIds = flatOrgListResps.stream().map(item -> item.getWeworkOrgId()).collect(Collectors.toList());
            log.info("queryNodeIds:{}", (Object)queryNodeIds);
        }
        Integer operate = NumberUtils.INTEGER_ZERO;
        if (CollectionUtils.isNotEmpty((Collection)queryNodeIds) && CollectionUtils.isNotEmpty((Collection)req.getWeworkUserNums())) {
            operate = NumberUtils.INTEGER_ONE;
        }
        WeworkCorp weworkCorp = this.weworkCorpService.getByCorpId(currentUserInfo.getCorpId());
        if (YnEnum.YES.getValue().equals(weworkCorp.getIsNewDkf())) {
            return this.agentWeworkConversation(weworkCorp, currentUserInfo, queryNodeIds, operate, req, weworkUserIdList);
        }
        List weworkUserChatConfigs = null;
        weworkUserChatConfigs = StringUtils.isNotBlank((CharSequence)req.getQuery()) || CollectionUtils.isNotEmpty((Collection)queryNodeIds) || CollectionUtils.isNotEmpty((Collection)req.getWeworkUserNums()) ? this.weworkUserChatConfigMapper.queryByCorpIdAndUserName(currentUserInfo.getBizId(), req.getQuery(), weworkCorp.getIsNewDkf(), (Collection)queryNodeIds, (Collection)req.getWeworkUserNums(), operate) : this.weworkUserChatConfigMapper.queryByCorpId(currentUserInfo.getCorpId());
        if (CollectionUtils.isEmpty((Collection)weworkUserChatConfigs)) {
            return result;
        }
        List<String> chatConfigWeworkUserIds = weworkUserChatConfigs.stream().map(WeworkUserChatConfig::getWeworkUserId).collect(Collectors.toList());
        log.info("\u5f00\u901a\u4f1a\u8bdd\u5b58\u6863\u6210\u5458\u6709:{}", (Object)JSON.toJSONString(chatConfigWeworkUserIds));
        weworkUserIdList.retainAll(chatConfigWeworkUserIds);
        Set<String> dimissionWeworkUserIds = this.selectDimissionWeworkUserIds(currentUserInfo.getCorpId(), chatConfigWeworkUserIds);
        log.info("\u5f53\u524d\u4f1a\u8bdd\u5b58\u6863\u4e2d\u79bb\u804c\u6210\u5458:{}", dimissionWeworkUserIds);
        weworkUserIdList.addAll(dimissionWeworkUserIds);
        Integer count = this.weworkUserMapper.searchWeworkUserListCount(weworkUserIdList, currentUserInfo.getBizId(), currentUserInfo.getCorpId(), YnEnum.YES.getValue(), req.getQuery(), (Collection)queryNodeIds, (Collection)req.getWeworkUserNums(), operate);
        if (Objects.isNull(count) || count == 0) {
            return result;
        }
        req.getPageDto().setCount(count);
        List searchWeworkUserDtos = this.weworkUserMapper.searchWeworkUserList(weworkUserIdList, currentUserInfo.getBizId(), currentUserInfo.getCorpId(), YnEnum.YES.getValue(), req.getPageDto(), req.getQuery(), (Collection)queryNodeIds, (Collection)req.getWeworkUserNums(), operate);
        List currentOpenWeworkUserIds = weworkUserChatConfigs.stream().filter(item -> item.getIsDeleted() != null && YnEnum.NO.getValue() == item.getIsDeleted()).map(WeworkUserChatConfig::getWeworkUserId).collect(Collectors.toList());
        HashSet noChatAndOpenedUserIds = Sets.newHashSet();
        if ((Objects.isNull(req.getPageDto()) || CollectionUtils.size((Object)searchWeworkUserDtos) < req.getPageDto().getPageSize()) && CollectionUtils.isNotEmpty((Collection)(openChatUserIds = (List)Optional.ofNullable(currentOpenWeworkUserIds).orElse(Lists.newArrayList())))) {
            List hasChatWeworkUserId = this.weworkConversationMapper.queryWeworkUserList(currentUserInfo.getBizId());
            for (String openChatUserId : openChatUserIds) {
                if (hasChatWeworkUserId.contains(openChatUserId)) continue;
                noChatAndOpenedUserIds.add(openChatUserId);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)noChatAndOpenedUserIds)) {
            List noChatUser = this.weworkUserMapper.searchWeworkUserList(weworkUserIdList, currentUserInfo.getBizId(), currentUserInfo.getCorpId(), YnEnum.NO.getValue(), req.getPageDto(), req.getQuery(), (Collection)queryNodeIds, (Collection)req.getWeworkUserNums(), operate);
            searchWeworkUserDtos.addAll(noChatUser);
        }
        return this.convertToVo(searchWeworkUserDtos);
    }

    private List<SearchWeworkUserDto> convertToVo(List<SearchWeworkUserDto> entitys) {
        if (CollectionUtils.isEmpty(entitys)) {
            return Lists.newArrayList();
        }
        for (SearchWeworkUserDto entity : entitys) {
            entity.setWeworkUserId(entity.getWeworkUserNum());
        }
        return entitys;
    }

    private List<SearchWeworkUserDto> agentWeworkConversation(WeworkCorp weworkCorp, CurrentUserInfo currentUserInfo, List<Integer> queryNodeIds, Integer operate, WeworkUserListReq req, Set<String> weworkUserIdList) {
        String corpId = this.weworkCorpService.getDecryptCorpId(weworkCorp.getCorpId(), YnEnum.YES.getValue(), currentUserInfo.getBizId());
        List weworkUserChatConfigs = null;
        if (StringUtils.isNotBlank((CharSequence)req.getQuery()) || CollectionUtils.isNotEmpty(queryNodeIds) || CollectionUtils.isNotEmpty((Collection)req.getWeworkUserNums())) {
            log.info("bizId:{}; query:{}; weworkUserNum:{}; ope:{}; queryNodeIds:{}", new Object[]{currentUserInfo.getBizId(), req.getQuery(), req.getWeworkUserNums(), operate, queryNodeIds});
            weworkUserChatConfigs = this.weworkUserChatConfigMapper.queryByCorpIdAndUserName(currentUserInfo.getBizId(), req.getQuery(), weworkCorp.getIsNewDkf(), queryNodeIds, (Collection)req.getWeworkUserNums(), operate);
        } else {
            weworkUserChatConfigs = this.weworkUserChatConfigMapper.queryByCorpId(corpId);
        }
        if (CollectionUtils.isEmpty((Collection)weworkUserChatConfigs)) {
            return Lists.newArrayList();
        }
        List chatConfigWeworkUserIds = weworkUserChatConfigs.stream().map(WeworkUserChatConfig::getWeworkUserId).collect(Collectors.toList());
        log.info("\u5f00\u901a\u8fc7\u4f1a\u8bdd\u5b58\u6863\u6210\u5458\uff1a{}", (Object)JSON.toJSONString(chatConfigWeworkUserIds));
        Map decryptUserIds = this.agentDecryptWeworkUserIdMapper.queryMapByDecryptUserIds(currentUserInfo.getBizId(), chatConfigWeworkUserIds);
        Set<String> dimissionWeworkUserIds = this.selectDimissionWeworkUserIds(currentUserInfo.getCorpId(), decryptUserIds.keySet());
        log.info("\u5f53\u524d\u4f1a\u8bdd\u5b58\u6863\u4e2d\u79bb\u804c\u6210\u5458:{}", dimissionWeworkUserIds);
        weworkUserIdList.addAll(dimissionWeworkUserIds);
        Map encryptUserIds = this.agentDecryptWeworkUserIdMapper.queryMapByEncryptUserIds(currentUserInfo.getBizId(), weworkUserIdList);
        List searchWeworkUserDtos = this.weworkUserMapper.searchAgentWeworkUserList(encryptUserIds.values(), currentUserInfo.getBizId(), currentUserInfo.getCorpId(), YnEnum.YES.getValue(), req.getPageDto(), req.getQuery(), queryNodeIds, (Collection)req.getWeworkUserNums(), operate);
        weworkUserIdList = searchWeworkUserDtos.stream().map(SearchWeworkUserDto::getWeworkUserId).collect(Collectors.toSet());
        List conversationDecryptUserIds = searchWeworkUserDtos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getDecryptUserId())).map(SearchWeworkUserDto::getDecryptUserId).collect(Collectors.toList());
        log.info("\u901a\u8fc7\u6761\u4ef6\u8fc7\u6ee4\u540e\uff0cweworkUserIdList\uff1a{}", (Object)JSON.toJSONString(weworkUserIdList));
        String decryptCorpId = this.weworkCorpService.getDecryptCorpId(weworkCorp.getCorpId(), YnEnum.YES.getValue(), currentUserInfo.getBizId());
        List currentOpenWeworkUserIds = weworkUserChatConfigs.stream().filter(item -> item.getIsDeleted() != null && YnEnum.NO.getValue() == item.getIsDeleted()).map(WeworkUserChatConfig::getWeworkUserId).collect(Collectors.toList());
        ArrayList manageOpenWeworkUserIds = Lists.newArrayList();
        for (String currentOpenWeworkUserId : currentOpenWeworkUserIds) {
            if (!CollectionUtils.isNotEmpty(conversationDecryptUserIds) || conversationDecryptUserIds.contains(currentOpenWeworkUserId)) continue;
            manageOpenWeworkUserIds.add(currentOpenWeworkUserId);
        }
        ChatWeworkUserReq weworkUserReq = new ChatWeworkUserReq();
        Collection<String> manageDecryptUserIds = encryptUserIds.values();
        manageDecryptUserIds.retainAll(chatConfigWeworkUserIds);
        weworkUserReq.setWeworkUserIdList(manageDecryptUserIds);
        weworkUserReq.setUserAgent(YnEnum.YES.getValue());
        weworkUserReq.setCorpId(weworkCorp.getCorpId());
        weworkUserReq.setDecryptCorpId(decryptCorpId);
        weworkUserReq.setBizId(currentUserInfo.getBizId());
        weworkUserReq.setOnlyShowChatUser(YnEnum.YES.getValue());
        weworkUserReq.setAggField("from");
        weworkUserReq.setCurrentOpenChatUserId(manageOpenWeworkUserIds);
        if (Objects.isNull(req.getPageDto())) {
            PageDto pageDto = new PageDto();
            req.setPageDto(pageDto);
        }
        weworkUserReq.setPageDto(req.getPageDto());
        SearchChatUserFromEsResp resp = this.adapterWeworkUserFromEs(weworkUserReq);
        if (Objects.nonNull(resp) && Objects.nonNull(resp.getPageDto())) {
            req.getPageDto().setCount(resp.getPageDto().getCount());
        }
        return this.convertToVo(resp.getSearchWeworkUserDtos());
    }

    @Override
    public WeworkUser selectByWeworkUserId(String corpId, Long bizId, String weworkUserId) {
        WeworkUser weworkUser = new WeworkUser();
        weworkUser.setCorpId(corpId);
        weworkUser.setBizId(bizId);
        weworkUser.setWeworkUserId(weworkUserId);
        return (WeworkUser)this.weworkUserMapper.selectOne((Object)weworkUser);
    }

    @Override
    public List<SearchWeworkUserResp> selectWeworkUserByContactId(WeworkUserListReq req) {
        List<SearchWeworkUserDto> list;
        log.info("weworkUserList req:{}", (Object)JSON.toJSONString((Object)req));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)req.getContactId()), (Object)"contactId \u4e0d\u80fd\u4e3a\u7a7a");
        String corpId = LoginUtils.getCurrentUser().getCorpId();
        Long bizId = LoginUtils.getCurrentUser().getBizId();
        Set<String> weworkUserIdList = this.queryCurManagerWeworkUser();
        String contactId = req.getContactId();
        WeworkCorp weworkCorp = this.weworkCorpMapper.getByBizId(bizId);
        int useAgent = 0;
        Map weworkUserMap = Maps.newHashMap();
        String deContactId = contactId;
        if (weworkCorp != null && weworkCorp.getIsNewDkf() == 1) {
            useAgent = 1;
            weworkUserMap = this.agentDecryptWeworkUserIdMapper.queryMapByEncryptUserIds(bizId, weworkUserIdList);
            deContactId = this.agentDecryptWeworkContactIdMapper.queryByEncryptContactId(bizId, contactId);
        }
        if (YnEnum.YES.getValue().equals(useAgent) && CollectionUtils.isNotEmpty(weworkUserIdList)) {
            ChatWeworkUserReq weworkUserReq = new ChatWeworkUserReq();
            if (YnEnum.YES.getValue().equals(weworkCorp.getIsNewDkf())) {
                weworkUserReq.setWeworkUserIdList(weworkUserMap.values());
            } else {
                weworkUserReq.setWeworkUserIdList(weworkUserIdList);
            }
            weworkUserReq.setUserAgent(useAgent);
            weworkUserReq.setCorpId(corpId);
            weworkUserReq.setDecryptContactId(deContactId);
            weworkUserReq.setBizId(bizId);
            weworkUserReq.setOnlyShowChatUser(req.getOnlyShowChatUser());
            weworkUserReq.setPageDto(req.getPageDto());
            weworkUserReq.setAggField("from");
            SearchChatUserFromEsResp resp = this.adapterWeworkUserFromEs(weworkUserReq);
            list = resp.getSearchWeworkUserDtos();
            resp.getPageDto().setCount(resp.getPageDto().getCount());
        } else {
            list = this.weworkUserMapper.selectWeworkUserByContactId(corpId, bizId, contactId, weworkUserIdList, req.getOnlyShowChatUser());
        }
        List<Object> result = Lists.newArrayListWithCapacity((int)list.size());
        for (SearchWeworkUserDto it : list) {
            SearchWeworkUserResp dto = new SearchWeworkUserResp();
            dto.setUserId(it.getUserId());
            dto.setUserName(it.getUserName());
            dto.setWeworkUserId(it.getWeworkUserNum());
            dto.setWeworkUserAlias(it.getWeworkUserAlias());
            dto.setWeworkUserNickName(it.getWeworkUserNickName());
            dto.setQrcode(it.getQrcode());
            dto.setAvatar(it.getAvatar());
            dto.setLastMsgTime(it.getLastMsgTime());
            dto.setDigest(it.getDigest());
            dto.setIsDimission(0);
            String weworkUserId = it.getWeworkUserId();
            if (useAgent == 1) {
                weworkUserId = weworkUserMap.getOrDefault(weworkUserId, weworkUserId);
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{weworkUserId, deContactId})) {
                String conversationId = Lists.newArrayList((Object[])new String[]{weworkUserId, deContactId}).stream().sorted().collect(Collectors.joining("$$"));
                dto.setConversationId(conversationId);
            }
            result.add(dto);
        }
        this.addDimissionUser(useAgent, (List<SearchWeworkUserResp>)result, contactId, deContactId, req.getOnlyShowChatUser());
        result = result.stream().sorted(Comparator.comparing(SearchWeworkUserResp::getLastMsgTime, Comparator.nullsFirst(String::compareTo).reversed())).collect(Collectors.toList());
        return result;
    }

    private SearchChatUserFromEsResp adapterWeworkUserFromEs(ChatWeworkUserReq req) {
        List<String> openChatUserIds;
        SearchChatUserFromEsResp chatUserIdFromEs = this.getChatUserIdFromEs(req);
        List<SearchWeworkUserDto> userDtos = chatUserIdFromEs.getSearchWeworkUserDtos();
        if (Objects.isNull(chatUserIdFromEs)) {
            return chatUserIdFromEs;
        }
        Map<Object, Object> groupByWeworkUserId = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(userDtos)) {
            groupByWeworkUserId = userDtos.stream().collect(Collectors.toMap(SearchWeworkUserDto::getWeworkUserId, Function.identity(), (u, v) -> v));
        }
        HashSet weworkUserIdList = null;
        weworkUserIdList = YnEnum.YES.getValue().equals(req.getOnlyShowChatUser()) ? Sets.newHashSet(groupByWeworkUserId.keySet()) : Sets.newHashSet(req.getWeworkUserIdList());
        if ((Objects.isNull(req.getPageDto()) || CollectionUtils.size(userDtos) < req.getPageDto().getPageSize()) && CollectionUtils.isNotEmpty(openChatUserIds = Optional.ofNullable(req.getCurrentOpenChatUserId()).orElse(Lists.newArrayList()))) {
            List hasChatWeworkUserId = this.weworkConversationMapper.queryWeworkUserList(req.getBizId());
            HashSet noChatAndOpenedUserIds = Sets.newHashSet();
            for (String openChatUserId : openChatUserIds) {
                if (hasChatWeworkUserId.contains(openChatUserId)) continue;
                noChatAndOpenedUserIds.add(openChatUserId);
            }
            weworkUserIdList.addAll(noChatAndOpenedUserIds);
        }
        List weworkUserDtos = this.agentWeworkUserMapper.selectWeworkUserByContactId(req.getDecryptCorpId(), req.getBizId(), YnEnum.NO.getValue(), req.getDecryptContactId(), (Collection)weworkUserIdList, null);
        for (SearchWeworkUserDto dto : weworkUserDtos) {
            SearchWeworkUserDto userDto = (SearchWeworkUserDto)groupByWeworkUserId.get(dto.getWeworkUserId());
            String lastChatTimeStr = Optional.ofNullable(userDto).filter(item -> StringUtils.isNotBlank((CharSequence)item.getLastMsgTime())).map(SearchWeworkUserDto::getLastMsgTime).orElse(dto.getLastMsgTime());
            dto.setLastMsgTime(lastChatTimeStr);
        }
        chatUserIdFromEs.setSearchWeworkUserDtos(weworkUserDtos);
        return chatUserIdFromEs;
    }

    public SearchChatUserFromEsResp getChatUserIdFromEs(ChatWeworkUserReq req) {
        log.info("adapterWeworkUserFromEs: param:{}", (Object)JSON.toJSONString((Object)req));
        SearchChatUserFromEsResp resp = new SearchChatUserFromEsResp();
        if (Objects.isNull(req) || Objects.isNull(req.getBizId()) || CollectionUtils.isEmpty(req.getWeworkUserIdList()) || Objects.isNull(req.getCorpId())) {
            resp.setPageDto(new PageDto());
            return resp;
        }
        String decryptCorpId = req.getDecryptCorpId();
        if (StringUtils.isEmpty((CharSequence)decryptCorpId)) {
            decryptCorpId = this.weworkCorpService.getDecryptCorpId(req.getCorpId(), req.getUserAgent(), req.getBizId());
        }
        req.setDecryptCorpId(decryptCorpId);
        ChatEsReq chatEsReq = new ChatEsReq();
        chatEsReq.setShowHits(YnEnum.NO.getValue());
        chatEsReq.setCorpId(decryptCorpId);
        chatEsReq.setTalkerTypes((Collection)Lists.newArrayList((Object[])new Integer[]{TalkerType.CONTACT.getValue()}));
        chatEsReq.setAggField(req.getAggField());
        chatEsReq.setBizId(req.getBizId());
        if (Objects.isNull(req.getPageDto())) {
            req.setPageDto(new PageDto());
        }
        chatEsReq.setPageDto(req.getPageDto());
        chatEsReq.setFromIds(req.getWeworkUserIdList());
        if (StringUtils.isNotBlank((CharSequence)req.getDecryptContactId())) {
            chatEsReq.setToList((Collection)Lists.newArrayList((Object[])new String[]{req.getDecryptContactId()}));
        }
        AggChatUserFromEsResp chatUserFromEsResp = this.messageCommonService.getConversationFromEsMessage(chatEsReq);
        chatEsReq.setToList(null);
        chatEsReq.setFromIds(null);
        chatEsReq.setToList(req.getWeworkUserIdList());
        if (StringUtils.isNotBlank((CharSequence)req.getDecryptContactId())) {
            chatEsReq.setFromIds((Collection)Lists.newArrayList((Object[])new String[]{req.getDecryptContactId()}));
        }
        if (StringUtils.isNotBlank((CharSequence)chatEsReq.getAggField())) {
            chatEsReq.setAggField("tolist");
        }
        AggChatUserFromEsResp chatUserFromEs2 = this.messageCommonService.getConversationFromEsMessage(chatEsReq);
        HashSet allCon = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty((Collection)chatUserFromEsResp.getTalkerMsgs())) {
            allCon.addAll(chatUserFromEsResp.getTalkerMsgs());
        }
        if (CollectionUtils.isNotEmpty((Collection)chatUserFromEs2.getTalkerMsgs())) {
            allCon.addAll(chatUserFromEs2.getTalkerMsgs());
        }
        String decryptContactId = req.getDecryptContactId();
        ArrayList weworkUserResps = Lists.newArrayList();
        Map<String, List<TalkerMsgCountDto>> collect = allCon.stream().collect(Collectors.groupingBy(TalkerMsgCountDto::getConversationId));
        collect.forEach((key, value) -> {
            if (CollectionUtils.isNotEmpty((Collection)value)) {
                SearchWeworkUserDto weworkUserResp = new SearchWeworkUserDto();
                weworkUserResp.setLastMsgTime(((TalkerMsgCountDto)value.get(0)).getLasMsgTimeStr());
                String weworkUserId = null;
                weworkUserId = StringUtils.isNotBlank((CharSequence)req.getAggField()) ? key : ChatCommonUtil.getChatWeworkUserId((String)key, (String)decryptContactId);
                weworkUserResp.setWeworkUserId(key);
                if (CollectionUtils.size((Object)value) > 1) {
                    List collect1 = value.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getLasMsgTimeStr())).sorted(Comparator.comparing(TalkerMsgCountDto::getLasMsgTimeStr).reversed()).collect(Collectors.toList());
                    weworkUserResp.setLastMsgTime(((TalkerMsgCountDto)collect1.get(0)).getLasMsgTimeStr());
                }
                weworkUserResps.add(weworkUserResp);
            }
        });
        log.info("weworkUserResps:{}", (Object)JSON.toJSONString((Object)weworkUserResps));
        resp.setSearchWeworkUserDtos(weworkUserResps);
        resp.setPageDto(chatUserFromEsResp.getPageDto());
        return resp;
    }

    private void addDimissionUser(int useAgent, List<SearchWeworkUserResp> result, String contactId, String deContactId, Integer onlyShowChatUser) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String weworkUserNum = userInfo.getWeworkUserNum();
        if (StringUtils.isBlank((CharSequence)weworkUserNum)) {
            return;
        }
        DimissionAllocateRecord allocateRecord = this.dimissionAllocateRecordMapper.queryAllocateRecord(userInfo.getBizId(), contactId, weworkUserNum);
        if (allocateRecord == null || allocateRecord.getStatus() != 1) {
            return;
        }
        WeworkContactRelation contactRelation = this.weworkContactRelationMapper.get(userInfo.getCorpId(), userInfo.getWeworkUserId(), contactId);
        if (contactRelation == null || contactRelation.getIsDeleted() == 1) {
            return;
        }
        List dimissionUserNums = this.dimissionAllocateRecordMapper.queryDimissionUserIds(userInfo.getBizId(), contactId);
        if (CollectionUtils.isEmpty((Collection)dimissionUserNums)) {
            return;
        }
        List weworkUserList = this.weworkUserMapper.queryInfoListByNums((Collection)dimissionUserNums);
        List<String> enWeworkUserIds = weworkUserList.stream().map(it -> it.getWeworkUserId()).collect(Collectors.toList());
        Map weworkUserIdMap = Maps.newHashMap();
        Map chatUserIdFromEs = null;
        if (useAgent == 1) {
            weworkUserIdMap = this.agentDecryptWeworkUserIdMapper.queryMapByEncryptUserIds(userInfo.getBizId(), enWeworkUserIds);
            ChatWeworkUserReq weworkUserReq = new ChatWeworkUserReq();
            if (YnEnum.YES.getValue().equals(useAgent)) {
                weworkUserReq.setWeworkUserIdList(weworkUserIdMap.values());
            } else {
                weworkUserReq.setWeworkUserIdList(enWeworkUserIds);
            }
            weworkUserReq.setUserAgent(useAgent);
            weworkUserReq.setOnlyShowChatUser(onlyShowChatUser);
            weworkUserReq.setCorpId(userInfo.getCorpId());
            weworkUserReq.setDecryptContactId(deContactId);
            weworkUserReq.setBizId(userInfo.getBizId());
            SearchChatUserFromEsResp chatUserFromEsResp = this.getChatUserIdFromEs(weworkUserReq);
            List<SearchWeworkUserDto> searchWeworkUserDtos = chatUserFromEsResp.getSearchWeworkUserDtos();
            if (CollectionUtils.isNotEmpty(searchWeworkUserDtos)) {
                chatUserIdFromEs = searchWeworkUserDtos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getWeworkUserId())).collect(Collectors.toMap(SearchWeworkUserDto::getWeworkUserId, Function.identity(), (u, v) -> v));
            }
        }
        for (WeworkUser weworkUser : weworkUserList) {
            Set<Object> chatWeworkUsers;
            SearchWeworkUserResp userResp = new SearchWeworkUserResp();
            userResp.setWeworkUserNickName(weworkUser.getName());
            userResp.setAvatar(weworkUser.getAvatar());
            userResp.setWeworkUserId(weworkUser.getNum());
            userResp.setIsDimission(1);
            String weworkUserId = weworkUser.getWeworkUserId();
            if (useAgent == 1) {
                weworkUserId = weworkUserIdMap.getOrDefault(weworkUserId, weworkUserId);
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{weworkUserId, deContactId})) {
                String conversationId = Lists.newArrayList((Object[])new String[]{weworkUserId, deContactId}).stream().sorted().collect(Collectors.joining("$$"));
                userResp.setConversationId(conversationId);
            }
            if (MapUtils.isNotEmpty(chatUserIdFromEs) && (chatWeworkUsers = chatUserIdFromEs.keySet()).contains(weworkUserId)) {
                SearchWeworkUserDto dto = (SearchWeworkUserDto)chatUserIdFromEs.get(weworkUserId);
                userResp.setLastMsgTime(dto.getLastMsgTime());
            }
            if (YnEnum.YES.getValue().equals(onlyShowChatUser)) {
                if (!MapUtils.isNotEmpty((Map)chatUserIdFromEs) || !(chatWeworkUsers = chatUserIdFromEs.keySet()).contains(weworkUserId)) continue;
                result.add(userResp);
                continue;
            }
            result.add(userResp);
        }
    }

    @Override
    public WeworkUserDetailRespDto detail(WeworkUserBaseReq req) {
        WeworkCorp weworkCorp;
        log.info("detail req:{}", (Object)JSON.toJSONString((Object)req));
        CurrentUserInfo currentUserInfo = this.baseValidate();
        log.info("detail: bizId:{}, corpId:{}, id:{}", new Object[]{currentUserInfo.getBizId(), currentUserInfo.getCorpId(), currentUserInfo.getId()});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)req.getWeworkUserId()), (Object)"\u4f01\u5fae\u6210\u5458\u7684\u552f\u4e00id\u4e0d\u80fd\u4e3a\u7a7a");
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByNum(req.getWeworkUserId());
        if (Objects.isNull(weworkUser)) {
            log.info("detail: \u67e5\u4e0d\u5230\u6210\u5458:{}", (Object)req.getWeworkUserId());
            return null;
        }
        WeworkUserDetailRespDto detailRespDto = new WeworkUserDetailRespDto();
        detailRespDto.setNickname(weworkUser.getName());
        detailRespDto.setAlias(weworkUser.getWeworkUserId());
        detailRespDto.setAddress(weworkUser.getAddress());
        detailRespDto.setAvatar(weworkUser.getAvatar());
        detailRespDto.setThumbAvatar(weworkUser.getThumbAvatar());
        detailRespDto.setMobile(weworkUser.getMobile());
        detailRespDto.setEmail(weworkUser.getEmail());
        detailRespDto.setTelephone(weworkUser.getTelephone());
        detailRespDto.setPosition(weworkUser.getPosition());
        detailRespDto.setExternalPosition(weworkUser.getExternalPosition());
        detailRespDto.setIsDimission(weworkUser.getIsDeleted());
        detailRespDto.setGender(weworkUser.getGender());
        String externalCorpName = this.getExternalCorpName(weworkUser.getExternalProfile());
        log.info("detail: externalCorpName:{}", (Object)externalCorpName);
        detailRespDto.setExternalCorpName(externalCorpName);
        if (StringUtils.isEmpty((CharSequence)externalCorpName) && Objects.nonNull(weworkCorp = this.weworkCorpMapper.getByCorpId(currentUserInfo.getCorpId())) && StringUtils.isNotEmpty((CharSequence)weworkCorp.getCorpName())) {
            detailRespDto.setExternalCorpName(weworkCorp.getCorpName());
        }
        List departmentUsers = this.weworkDepartmentUserMapper.queryUserDeptInfo(currentUserInfo.getCorpId(), currentUserInfo.getBizId(), weworkUser.getWeworkUserId());
        ArrayList deptNameDtos = Lists.newArrayList();
        int isLeaderInDept = 0;
        if (CollectionUtils.isNotEmpty((Collection)departmentUsers)) {
            ArrayList deptIds = Lists.newArrayList();
            boolean isContinue = true;
            for (WeworkDepartmentUser deptUser : departmentUsers) {
                if (isContinue && deptUser.getIsLeaderInDept() != null && deptUser.getIsLeaderInDept() == 1) {
                    isLeaderInDept = 1;
                    isContinue = false;
                }
                if (!Objects.nonNull(deptUser.getDepartmentId())) continue;
                deptIds.add(deptUser.getDepartmentId());
            }
            log.info("detail: deptIds:{}", (Object)deptIds);
            this.sortListByMainDept(deptIds, weworkUser.getMainDepartment());
            Map<Integer, List<WeworkDepartment>> deptNames = this.buildDeptLine(deptIds, currentUserInfo);
            for (Map.Entry<Integer, List<WeworkDepartment>> entry : deptNames.entrySet()) {
                List<WeworkDepartment> list = entry.getValue();
                ArrayList nameList = Lists.newArrayList();
                for (int i = list.size() - 1; i >= 0; --i) {
                    nameList.add(list.get(i).getName());
                }
                DeptNameDto deptNameDto = new DeptNameDto();
                deptNameDto.setDept(WeworkUserServiceImp.toStr(nameList, "/"));
                deptNameDtos.add(deptNameDto);
            }
        }
        detailRespDto.setIsLeaderInDept(isLeaderInDept);
        detailRespDto.setDepts(deptNameDtos);
        return detailRespDto;
    }

    private void sortListByMainDept(List<Integer> deptIds, Integer targetId) {
        log.info("sortListByMainDept: targetId:{}", (Object)targetId);
        deptIds.sort((o1, o2) -> {
            if (o1.equals(targetId)) {
                return -1;
            }
            return 1;
        });
    }

    private Map<Integer, List<WeworkDepartment>> buildDeptLine(List<Integer> deptIds, CurrentUserInfo currentUserInfo) {
        LinkedHashMap deptNames = Maps.newLinkedHashMap();
        if (CollectionUtils.isNotEmpty(deptIds)) {
            for (Integer depId : deptIds) {
                WeworkDepartment weworkDepartment = this.weworkDepartmentMapper.getDepartment(currentUserInfo.getCorpId(), depId);
                if (!Objects.nonNull(weworkDepartment)) continue;
                deptNames.put(depId, this.buildDept(weworkDepartment, currentUserInfo));
            }
        }
        return deptNames;
    }

    private List<WeworkDepartment> buildDept(WeworkDepartment weworkDepartment, CurrentUserInfo currentUserInfo) {
        ArrayList deptList = Lists.newArrayList();
        int maxCount = 0;
        while (weworkDepartment.getDepartmentId() != 1 && maxCount++ < 10) {
            deptList.add(weworkDepartment);
            weworkDepartment = this.weworkDepartmentMapper.getDepartment(currentUserInfo.getCorpId(), weworkDepartment.getParentId());
        }
        if (weworkDepartment.getDepartmentId() == 1) {
            deptList.add(weworkDepartment);
            return deptList;
        }
        log.info("buildDept: deptList:{}", (Object)deptList);
        return deptList;
    }

    public static String toStr(List list, String delimiter) {
        return Joiner.on((String)delimiter).skipNulls().join((Iterable)list);
    }

    private String getExternalCorpName(String externalProfile) {
        log.info("getExternalCorpName: externalProfile:{}", (Object)externalProfile);
        if (StringUtils.isEmpty((CharSequence)externalProfile) || "null".equals(externalProfile)) {
            return "";
        }
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)externalProfile);
            return jsonObject.getString("external_corp_name");
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public ContactStatisticDto queryContactStatistic(ContactStatisticParams params) {
        if (params == null) {
            return null;
        }
        params.checkParams();
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        String corpId = currentUserInfo.getCorpId();
        String weworkUserId = this.getWeworkUserIdByNum(params.getWeworkUserId());
        UserBehaviorParams behaviorParams = new UserBehaviorParams();
        behaviorParams.setUserIds((List)Lists.newArrayList((Object[])new String[]{weworkUserId}));
        List<Map<String, Long>> queryTimeList = this.splitDate(params.getStartTime(), params.getEndTime());
        ArrayList userBehaviorDataList = Lists.newArrayList();
        for (Map<String, Long> timeMap : queryTimeList) {
            behaviorParams.setStartTime(Long.valueOf(timeMap.get("startTime") / 1000L));
            behaviorParams.setEndTime(Long.valueOf(timeMap.get("endTime") / 1000L));
            log.info("params: {}", (Object)behaviorParams);
            List list = this.externalStatisticClient.getUserBehaviorData(corpId, behaviorParams);
            userBehaviorDataList.addAll(list);
        }
        ContactStatisticDto contactStatisticDto = new ContactStatisticDto();
        contactStatisticDto.setWeworkUserNum(params.getWeworkUserId());
        int totalChatCnt = 0;
        int totalMessageCnt = 0;
        int totalNegativeFeedbackCnt = 0;
        int totalNewApplycnt = 0;
        int totalNewContactCnt = 0;
        float totalReplyPercentage = 0.0f;
        int replyPercentageNum = 0;
        int totalAvgReplyTime = 0;
        int avgReplyTimeNum = 0;
        for (BehaviorData behaviorData : userBehaviorDataList) {
            if (behaviorData.getChatCnt() != null) {
                totalChatCnt += behaviorData.getChatCnt().intValue();
            }
            if (behaviorData.getMessageCnt() != null) {
                totalMessageCnt += behaviorData.getMessageCnt().intValue();
            }
            if (behaviorData.getNegativeFeedbackCnt() != null) {
                totalNegativeFeedbackCnt += behaviorData.getNegativeFeedbackCnt().intValue();
            }
            if (behaviorData.getNewApplyCnt() != null) {
                totalNewApplycnt += behaviorData.getNewApplyCnt().intValue();
            }
            if (behaviorData.getNewContactCnt() != null) {
                totalNewContactCnt += behaviorData.getNewContactCnt().intValue();
            }
            if (behaviorData.getReplyPercentage() != null) {
                totalReplyPercentage += behaviorData.getReplyPercentage().floatValue();
                ++replyPercentageNum;
            }
            if (behaviorData.getAvgReplyTime() == null) continue;
            totalAvgReplyTime += behaviorData.getAvgReplyTime().intValue();
            ++avgReplyTimeNum;
        }
        contactStatisticDto.setChatCnt(totalChatCnt);
        contactStatisticDto.setMessageCnt(totalMessageCnt);
        contactStatisticDto.setNegativeFeedbackCnt(totalNegativeFeedbackCnt);
        contactStatisticDto.setNewApplyCnt(totalNewApplycnt);
        contactStatisticDto.setNewContactCnt(totalNewContactCnt);
        DecimalFormat decimalFormat = new DecimalFormat("##0.00");
        if (replyPercentageNum != 0) {
            contactStatisticDto.setReplyPercentage(decimalFormat.format(totalReplyPercentage / (float)replyPercentageNum));
        } else {
            contactStatisticDto.setReplyPercentage("0.00");
        }
        if (avgReplyTimeNum != 0) {
            contactStatisticDto.setAvgReplyTime(decimalFormat.format((float)totalAvgReplyTime * 1.0f / (float)avgReplyTimeNum));
        } else {
            contactStatisticDto.setAvgReplyTime("0.00");
        }
        return contactStatisticDto;
    }

    @Override
    public ExternalUserStatisticDto getStatisticExternalUser(ExternalStatisticMutilParams params) {
        log.info("getStatisticExternalUser params: {}", (Object)params);
        if (params == null) {
            return null;
        }
        params.checkParams();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        Set<String> manageWeworkUserIds = this.queryCurManagerWeworkUser();
        log.info("getStatisticExternalUser manageWeworkUserIds : {}", manageWeworkUserIds);
        Set<Object> weworkUserIds = Sets.newHashSet();
        if (StringUtils.isNotBlank((CharSequence)params.getWeworkUserIds())) {
            List<String> userIds = Arrays.asList(params.getWeworkUserIds().split(","));
            log.info("getStatisticExternalUser userIds : {}", userIds);
            for (String userId : userIds) {
                String weworkUserId = this.getWeworkUserIdByNum(userId);
                if (!manageWeworkUserIds.contains(weworkUserId)) continue;
                weworkUserIds.add(weworkUserId);
            }
        } else if (StringUtils.isNotBlank((CharSequence)params.getDeptIds())) {
            List<String> orgNums = Arrays.asList(params.getDeptIds().split(","));
            List weworkDepartmentIds = this.organizationMapper.queryWeworkDepartmentIdsByOrgNums(orgNums);
            log.info("getStatisticExternalUser orgNums : {}, weworkDepartmentIds: {}", orgNums, (Object)weworkDepartmentIds);
            HashSet<Integer> departIdSets = new HashSet<Integer>(weworkDepartmentIds);
            Set<Integer> allDepartIds = this.departmentService.getAllFlatDepartment(corpId, departIdSets, true);
            log.info("getStatisticExternalUser allDepartIds: {}", allDepartIds);
            HashSet<String> depUsers = new HashSet<String>();
            for (Integer dId : allDepartIds) {
                Set<String> departmentUserSet = this.departmentService.getDepartmentOfUser(corpId, dId);
                depUsers.addAll(departmentUserSet);
            }
            weworkUserIds = Sets.intersection(manageWeworkUserIds, depUsers);
        } else {
            weworkUserIds = manageWeworkUserIds;
        }
        log.info("getStatisticExternalUser weworkUserIds: {}", (Object)weworkUserIds);
        return this.internalStatisticExternalUser(corpId, (Set<String>)weworkUserIds, params.getStartTime(), params.getEndTime());
    }

    @Override
    public ExternalUserStatisticDto statisticExternalUser(ExternalStatisticParams params) {
        log.info("external statistic user params: {}", (Object)params);
        if (params == null) {
            return null;
        }
        params.checkParams();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        Set<String> manageWeworkUserIds = this.queryCurManagerWeworkUser();
        if (CollectionUtils.isEmpty(manageWeworkUserIds)) {
            log.info("statisticExternalUser,manageWeworkUserIds is empty");
            return new ExternalUserStatisticDto();
        }
        manageWeworkUserIds = this.getFilteredWeworkUser(params.getWeworkUserIds(), params.getDeptIds(), manageWeworkUserIds, userInfo.getBizId(), userInfo.getCorpId());
        if (CollectionUtils.isEmpty(manageWeworkUserIds)) {
            log.info("statisticExternalUser,manageWeworkUserIds is empty");
            return new ExternalUserStatisticDto();
        }
        return this.internalStatisticExternalUser(corpId, manageWeworkUserIds, params.getStartTime(), params.getEndTime());
    }

    private Set<String> getFilteredWeworkUser(Collection<String> weworkUserIds, Collection<Long> deptIds, Set<String> managerWeworkUserIds, Long bizId, String cropId) {
        if (CollectionUtils.isEmpty(managerWeworkUserIds)) {
            return Collections.emptySet();
        }
        HashSet weworkUserIdsByParams = new HashSet();
        if (CollectionUtils.isNotEmpty(weworkUserIds)) {
            Map weworkUserNumAndWeworkUserIdMap = this.weworkUserMapper.queryWeworkUserIdMapByNums(weworkUserIds);
            Collection weworkUserIdByParams = weworkUserNumAndWeworkUserIdMap.values();
            weworkUserIdsByParams.addAll(weworkUserIdByParams);
        }
        if (CollectionUtils.isNotEmpty(deptIds)) {
            Set subOrgIds = this.nodeService.getPosterityIds(deptIds, bizId);
            Set deptIdsRes = this.orgService.getDepartmentIds(subOrgIds);
            Set weworkUserIdByDeptParams = this.weworkDepartmentUserMapper.selectWeworkUserId(cropId, (Collection)deptIdsRes);
            weworkUserIdsByParams.addAll(weworkUserIdByDeptParams);
        }
        if (CollectionUtils.isNotEmpty(weworkUserIds) || CollectionUtils.isNotEmpty(deptIds)) {
            managerWeworkUserIds.retainAll(weworkUserIdsByParams);
            if (CollectionUtils.isEmpty(managerWeworkUserIds)) {
                log.info("getFilteredWeworkUser,weworkUserIds is empty");
                return Collections.emptySet();
            }
        }
        return managerWeworkUserIds;
    }

    private ExternalUserStatisticDto internalStatisticExternalUser(String corpId, Set<String> weworkUserIds, Date startTime, Date endTime) {
        log.info("internalStatisticExternalUser corpId: {}, weworkUserIds: {}, startTime: {}, endTime: {}", new Object[]{corpId, weworkUserIds, startTime, endTime});
        List<String> dayList = this.getDayLists(startTime, endTime);
        Collections.reverse(dayList);
        if (CollectionUtils.isEmpty(weworkUserIds)) {
            log.warn("wework user list is empty");
            return new ExternalUserStatisticDto().buildEmpty(dayList);
        }
        ExternalUserStatisticDto result = new ExternalUserStatisticDto();
        String todayStr = DateUtil.getCurDate();
        int todayAddContacts = 0;
        int todayDelContacts = 0;
        int pageSize = 200;
        List<Object> pageList = Lists.newArrayListWithCapacity((int)pageSize);
        if (dayList.contains(todayStr)) {
            Date todayStartTime = DateUtil.getTodayStartTime();
            Date todayEndTime = DateUtil.getTodayEndTime();
            Map todayAddMap = Maps.newHashMap();
            Object todayDelMap = Maps.newHashMap();
            todayAddMap = this.weworkContactLogMapper.queryAddExternalStatisticMap(corpId, todayStartTime, todayEndTime, null);
            todayDelMap = this.weworkContactLogMapper.queryDelExternalStatisticMap(corpId, todayStartTime, todayEndTime);
            for (String weworkUserId : weworkUserIds) {
                String userId = this.getWeworkUserNumById(corpId, weworkUserId);
                todayAddContacts += todayAddMap.getOrDefault(userId, 0).intValue();
                todayDelContacts += todayDelMap.getOrDefault(userId, 0).intValue();
            }
        }
        HashMap addExternalUserMap = Maps.newHashMap();
        HashMap delExternalUserMap = Maps.newHashMap();
        HashMap totalExternalUserMap = Maps.newHashMap();
        for (String weworkUserId : weworkUserIds) {
            pageList.add(weworkUserId);
            if (pageList.size() != pageSize) continue;
            pageList = this.getWeworkUserNumByIds(corpId, pageList);
            this.mergeMap(addExternalUserMap, this.weworkContactChangeLogMapper.queryContactAddCount(corpId, pageList, dayList));
            this.mergeMap(delExternalUserMap, this.weworkContactChangeLogMapper.queryContactDelCount(corpId, pageList, dayList));
            this.mergeMap(totalExternalUserMap, this.weworkContactNumLogMapper.queryContactCount(corpId, pageList, dayList));
            pageList.clear();
        }
        if (CollectionUtils.isNotEmpty((Collection)pageList)) {
            pageList = this.getWeworkUserNumByIds(corpId, (Collection<String>)pageList);
            this.mergeMap(addExternalUserMap, this.weworkContactChangeLogMapper.queryContactAddCount(corpId, pageList, dayList));
            this.mergeMap(delExternalUserMap, this.weworkContactChangeLogMapper.queryContactDelCount(corpId, pageList, dayList));
            this.mergeMap(totalExternalUserMap, this.weworkContactNumLogMapper.queryContactCount(corpId, pageList, dayList));
            pageList.clear();
        }
        ArrayList totalResultCountList = Lists.newArrayList();
        ArrayList addResultCountList = Lists.newArrayList();
        ArrayList delResultCountList = Lists.newArrayList();
        for (int i = 0; i < dayList.size(); ++i) {
            String dayStr = dayList.get(i);
            StatisticResult addStatisticResult = new StatisticResult();
            addStatisticResult.setDay(dayStr);
            int num = addExternalUserMap.getOrDefault(dayStr, 0);
            addStatisticResult.setCount(num);
            if (dayStr.equals(DateUtil.getCurDate()) && addExternalUserMap.get(dayStr) == null) {
                addStatisticResult.setCount(todayAddContacts);
            }
            addResultCountList.add(addStatisticResult);
            StatisticResult delStatisticResult = new StatisticResult();
            delStatisticResult.setDay(dayStr);
            num = delExternalUserMap.getOrDefault(dayStr, 0);
            delStatisticResult.setCount(num);
            if (dayStr.equals(DateUtil.getCurDate()) && delExternalUserMap.get(dayStr) == null) {
                delStatisticResult.setCount(todayDelContacts);
            }
            delResultCountList.add(delStatisticResult);
            StatisticResult totalStatisticResult = new StatisticResult();
            totalStatisticResult.setDay(dayStr);
            num = totalExternalUserMap.getOrDefault(dayStr, 0);
            totalStatisticResult.setCount(num);
            totalResultCountList.add(totalStatisticResult);
            if (!dayStr.equals(DateUtil.getCurDate()) || totalExternalUserMap.get(dayStr) != null) continue;
            int todayTotal = this.weworkContactRelationMapper.queryWeworkContactRepeatTotal(corpId, weworkUserIds);
            totalStatisticResult.setCount(todayTotal);
        }
        result.setAddContactCountList(addResultCountList);
        result.setDelContactCountList(delResultCountList);
        result.setTotalContactCountList(totalResultCountList);
        log.info("internalStatisticExternalUser get result: {}", (Object)result);
        return result;
    }

    private void mergeMap(Map<String, Integer> result, Map<String, Integer> mergeMap) {
        for (String key : mergeMap.keySet()) {
            if (result.containsKey(key)) {
                result.put(key, result.get(key) + mergeMap.get(key));
                continue;
            }
            result.put(key, mergeMap.get(key));
        }
    }

    @Override
    public ExternalRoomStatisticDto statisticExternalRoom(ExternalStatisticParams params) {
        log.info("external statistic params: {}", (Object)params);
        if (params == null) {
            return null;
        }
        params.checkParams();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        Set<String> managerWeworkUserIds = this.queryCurManagerWeworkUser();
        if (CollectionUtils.isEmpty(managerWeworkUserIds)) {
            log.info("statisticExternalRoom,manageWeworkUserIds is empty");
            return new ExternalRoomStatisticDto();
        }
        managerWeworkUserIds = this.getFilteredWeworkUser(params.getWeworkUserIds(), params.getDeptIds(), managerWeworkUserIds, userInfo.getBizId(), userInfo.getCorpId());
        if (CollectionUtils.isEmpty(managerWeworkUserIds)) {
            log.info("statisticExternalRoom,manageWeworkUserIds is empty");
            return new ExternalRoomStatisticDto();
        }
        Date startTime = params.getStartTime();
        Date endTime = params.getEndTime();
        List<String> dayStrList = this.getDayLists(startTime, endTime);
        Collections.reverse(dayStrList);
        List<String> weworkUserNums = this.getWeworkUserNumByIds(corpId, managerWeworkUserIds);
        Map totalRoomMap = this.weworkRoomNumLogMapper.queryUserRoomCount(corpId, weworkUserNums, dayStrList);
        Map joinRoomMap = this.weworkRoomJoinQuitLogMapper.queryJoinCount(corpId, startTime, endTime, weworkUserNums);
        Map quitRoomMap = this.weworkRoomJoinQuitLogMapper.queryQuitCount(corpId, startTime, endTime, weworkUserNums);
        ExternalRoomStatisticDto result = new ExternalRoomStatisticDto();
        ArrayList totalRoomList = Lists.newArrayList();
        ArrayList joinRoomList = Lists.newArrayList();
        ArrayList quitRoomList = Lists.newArrayList();
        for (String dayStr : dayStrList) {
            StatisticResult statisticResult = new StatisticResult();
            statisticResult.setDay(dayStr);
            statisticResult.setCount(totalRoomMap.getOrDefault(dayStr, 0));
            if (dayStr.equals(DateUtil.getCurDate()) && totalRoomMap.get(dayStr) == null) {
                int todayTotal = this.weworkChatRoomRelationMapper.queryChatRoomCountByMembers(corpId, managerWeworkUserIds);
                statisticResult.setCount(todayTotal);
            }
            totalRoomList.add(statisticResult);
            StatisticResult joinStatistic = new StatisticResult();
            joinStatistic.setDay(dayStr);
            joinStatistic.setCount(joinRoomMap.getOrDefault(dayStr, 0));
            joinRoomList.add(joinStatistic);
            StatisticResult quitStatistic = new StatisticResult();
            quitStatistic.setDay(dayStr);
            quitStatistic.setCount(quitRoomMap.getOrDefault(dayStr, 0));
            quitRoomList.add(quitStatistic);
        }
        result.setTotalWeworkRoomCountList(totalRoomList);
        result.setJoinWeworkRoomCountList(joinRoomList);
        result.setQuitWeworkRoomCountList(quitRoomList);
        return result;
    }

    @Override
    public Set<String> queryCurManagerWeworkUser() {
        StopWatchDto timer = new StopWatchDto("queryCurManagerWeworkUser", true, log);
        timer.start("getManageNodeIds");
        Set nodeIds = this.userRoleCommonService.getManageNodeIds();
        timer.stop();
        timer.start("getDepartmentIds");
        Set departmentIds = this.orgService.getDepartmentIds(nodeIds);
        timer.stop();
        String currentCorpId = LoginUtils.getCurrentUser().getCorpId();
        timer.start("selectByCorpIdAndDepartmentIds");
        Set weworkUserIds = this.weworkDepartmentUserMapper.selectByCorpIdAndDepartmentIds(currentCorpId, (Collection)departmentIds, Boolean.valueOf(true));
        timer.stop();
        Long userId = LoginUtils.getCurrentUser().getId();
        timer.start("queryWeworkUserIdOfUser");
        String ownerWeworkUserId = this.userMapper.queryWeworkUserIdOfUser(userId);
        timer.stop();
        if (StringUtils.isNotBlank((CharSequence)ownerWeworkUserId)) {
            weworkUserIds.add(ownerWeworkUserId);
        }
        timer.print();
        return weworkUserIds;
    }

    @Override
    public Set<String> queryCurManagerVipWeworkUser() {
        String currentCorpId = LoginUtils.getCurrentUser().getCorpId();
        Set<String> weworkUserIds = this.queryCurManagerWeworkUser();
        return this.weworkUserMapper.queryVipUserByWeworkUserId(currentCorpId, weworkUserIds).stream().map(a -> a.getWeworkUserId()).collect(Collectors.toSet());
    }

    @Override
    public Set<String> filterVipWeworkUser(Set<String> weworkUserIds) {
        if (CollectionUtils.isEmpty(weworkUserIds)) {
            return Sets.newHashSet();
        }
        String currentCorpId = LoginUtils.getCurrentUser().getCorpId();
        return this.weworkUserMapper.queryVipUserByWeworkUserId(currentCorpId, weworkUserIds).stream().map(a -> a.getWeworkUserId()).collect(Collectors.toSet());
    }

    @Override
    public Set<String> queryCurManagerWeworkUserContainDel() {
        Set nodeIds = this.userRoleCommonService.getManageNodeIds();
        Set departmentIds = this.orgService.getDepartmentIds(nodeIds);
        String currentCorpId = LoginUtils.getCurrentUser().getCorpId();
        Set weworkUserIds = this.weworkDepartmentUserMapper.selectUserIdContainDel(currentCorpId, (Collection)departmentIds);
        Long userId = LoginUtils.getCurrentUser().getId();
        String ownerWeworkUserId = this.userMapper.queryWeworkUserIdOfUser(userId);
        if (StringUtils.isNotBlank((CharSequence)ownerWeworkUserId)) {
            weworkUserIds.add(ownerWeworkUserId);
        }
        return weworkUserIds;
    }

    private List<String> getDayLists(Date startTime, Date endTime) {
        ArrayList result = Lists.newArrayList();
        String startDateStr = DateUtil.dateToDateString((Date)startTime, (String)"yyyy-MM-dd");
        String endDateStr = DateUtil.dateToDateString((Date)endTime, (String)"yyyy-MM-dd");
        result.add(endDateStr);
        Date temp = endTime;
        while (!endDateStr.equals(startDateStr)) {
            temp = DateUtil.getDateAddDay((Date)temp, (int)-1);
            endDateStr = DateUtil.dateToDateString((Date)temp, (String)"yyyy-MM-dd");
            result.add(endDateStr);
        }
        return result;
    }

    private List<Map<String, Long>> splitDate(Date startTime, Date endTime) {
        HashMap<String, Long> map;
        long timeLen = 2505600000L;
        long queryStart = DateUtil.getTheDateBegin((Date)startTime);
        long queryEnd = DateUtil.getTheDateBegin((Date)endTime);
        ArrayList result = Lists.newArrayList();
        while (queryEnd - queryStart > timeLen) {
            map = new HashMap<String, Long>();
            map.put("endTime", queryEnd);
            map.put("startTime", queryEnd - timeLen);
            result.add(map);
            queryEnd = queryEnd - timeLen - 86400L;
        }
        map = new HashMap();
        map.put("endTime", queryEnd);
        map.put("startTime", queryStart);
        result.add(map);
        return result;
    }

    @Override
    public Map<String, String> getWeworkUserNameMap(String corpId, List<String> weworkUserId) {
        List weworkUsers = this.weworkUserMapper.queryWeworkUserInfoList(corpId, weworkUserId);
        HashMap mapWeworkUserNames = Maps.newHashMap();
        for (WeworkUser weworkUser : weworkUsers) {
            mapWeworkUserNames.put(weworkUser.getWeworkUserId(), weworkUser.getName());
        }
        return mapWeworkUserNames;
    }

    @Override
    public List<WeworkUserListDto> list(WeworkUserReq params) {
        if (params == null) {
            return null;
        }
        Long bizId = LoginUtils.getCurrentUserBizId();
        String corpId = LoginUtils.getCurrentUserCorpId();
        Sets.SetView managerWeworkUserIds = this.queryCurManagerWeworkUser();
        boolean notContainDeleted = true;
        if (params.getContainDel() != null && params.getContainDel() == 1) {
            managerWeworkUserIds = this.queryCurManagerWeworkUserContainDel();
            notContainDeleted = false;
        }
        Set departmentWeworkUserIds = Sets.newHashSet();
        if (params.getWeworkDepartmentId() != null) {
            if (params.getContainChildNode() == null || params.getContainChildNode() == 1) {
                Set<Integer> departments = this.departmentService.getChildDepartment(params.getCorpId(), params.getWeworkDepartmentId(), true);
                departmentWeworkUserIds = this.weworkDepartmentUserMapper.selectByCorpIdAndDepartmentIds(params.getCorpId(), departments, Boolean.valueOf(notContainDeleted));
            } else if (params.getContainChildNode() != null && params.getContainChildNode() == 0) {
                departmentWeworkUserIds = this.weworkDepartmentUserMapper.selectByCorpIdAndDepartmentIds(params.getCorpId(), (Collection)Lists.newArrayList((Object[])new Integer[]{params.getWeworkDepartmentId()}), Boolean.valueOf(notContainDeleted));
            }
            if (CollectionUtils.isEmpty((Collection)departmentWeworkUserIds)) {
                return Lists.newArrayList();
            }
        }
        Object queryWeworkUserIds = managerWeworkUserIds;
        if (params.getAuthControl() != null && params.getAuthControl() == 0) {
            queryWeworkUserIds = null;
            if (params.getWeworkDepartmentId() != null) {
                queryWeworkUserIds = departmentWeworkUserIds;
            }
        } else if (params.getWeworkDepartmentId() != null) {
            queryWeworkUserIds = Sets.intersection(managerWeworkUserIds, (Set)departmentWeworkUserIds);
        }
        List vipUserList = Lists.newArrayList();
        if (params.getVipType() != null && params.getVipType() == 1) {
            vipUserList = this.vipWeworkAuthorizeAccountMapper.queryBizVipUserStatus(bizId);
            if (CollectionUtils.isNotEmpty((Collection)vipUserList)) {
                List vipWeworkUserIds = this.weworkUserMapper.queryWeworkUserIdByNums((Collection)vipUserList);
                queryWeworkUserIds = Sets.intersection((Set)queryWeworkUserIds, (Set)Sets.newHashSet((Iterable)vipWeworkUserIds));
            } else {
                queryWeworkUserIds = Sets.newHashSet();
            }
        }
        QueryWeworkUserListDto queryParams = new QueryWeworkUserListDto();
        queryParams.setQuery(params.getQuery());
        queryParams.setPosition(params.getPosition());
        queryParams.setWeworkUserIds((Set)queryWeworkUserIds);
        queryParams.setCorpId(params.getCorpId());
        queryParams.setIsSuiteAuth(params.getIsSuiteAuth());
        queryParams.setIsAgentAuth(params.getIsAgentAuth());
        queryParams.setPageDto(params.getPageDto());
        queryParams.setContainDel(params.getContainDel());
        queryParams.setUseWeworkUserRange(Boolean.valueOf(true));
        if (params.getAuthControl() != null && params.getAuthControl() == 0 && params.getWeworkDepartmentId() == null) {
            queryParams.setUseWeworkUserRange(Boolean.valueOf(false));
        }
        queryParams.setWeworkRoleType(params.getWeworkRoleType());
        if (params.getPageDto() != null) {
            int total = this.weworkUserMapper.queryWeworkUserCount(queryParams);
            params.getPageDto().setCount(Integer.valueOf(total));
        }
        queryParams.setVipType(params.getVipType());
        log.info("queryParams: {}", (Object)queryParams);
        List list = this.weworkUserMapper.queryWeworkUserList(queryParams);
        ArrayList result = Lists.newArrayList();
        Map<Integer, Integer> departMap = this.departmentService.queryDepartMap(params.getCorpId());
        Map<Integer, String> departNameMap = this.departmentService.queryDepartNameMap(params.getCorpId());
        List<String> weworkUserNums = list.stream().map(item -> item.getNum()).collect(Collectors.toList());
        Map<String, Long> userRegionMap = this.departmentService.getWeworkUserRegionMap(params.getCorpId(), weworkUserNums);
        List groupSendWeworkUserNums = null;
        Integer currentUserWeworkRoleType = null;
        String currentUserWeworkUserNum = this.userMapper.getWeworkUserNumByCorpIdAndUserId(params.getCorpId(), params.getQueryUserId());
        if (StringUtils.isNotBlank((CharSequence)currentUserWeworkUserNum)) {
            groupSendWeworkUserNums = this.weworkUserRoleManageUserMapper.queryManagedWeworkUserNums(params.getCorpId(), currentUserWeworkUserNum);
            currentUserWeworkRoleType = this.weworkUserRoleMapper.selectRoleTypeByCorpIdAndWeworkUserNum(params.getCorpId(), currentUserWeworkUserNum);
        }
        Set mainDepartIds = list.stream().map(it -> it.getMainDepartment()).collect(Collectors.toSet());
        List organizationList = this.organizationMapper.queryOrgByDepartmentIds(params.getBizId(), mainDepartIds);
        Map organizationMap = organizationList.stream().collect(Collectors.toMap(Organization::getWeworkDepartmentId, Function.identity()));
        Map<Object, Object> weworkOnlineMap = Maps.newHashMap();
        if (params.getVipType() != null && params.getVipType() == 1) {
            List<String> weworkDigitIds = list.stream().filter(it -> StringUtils.isNotBlank((CharSequence)it.getWeworkDigitId())).map(it -> it.getWeworkDigitId()).collect(Collectors.toList());
            weworkOnlineMap = this.getWeworkIdOnlineMap(bizId, weworkDigitIds);
        }
        List friendConfigs = this.addFriendConfigMapper.queryByWeworkUserNums(corpId, weworkUserNums);
        Map configMap = friendConfigs.stream().collect(Collectors.toMap(AddFriendConfig::getWeworkUserNum, Function.identity()));
        List weworkUserIds = list.stream().map(item -> item.getWeworkUserId()).collect(Collectors.toList());
        Map licenseMaps = this.userMapper.selectLicenseByWeworkUserId(bizId, weworkUserIds);
        for (WeworkUser weworkUser : list) {
            Organization org;
            WeworkUserListDto userListDto = new WeworkUserListDto();
            userListDto.setWeworkUserId(weworkUser.getNum());
            userListDto.setWeworkUserName(weworkUser.getName());
            userListDto.setAvatar(weworkUser.getAvatar());
            userListDto.setEmail(weworkUser.getEmail());
            userListDto.setMobile(weworkUser.getMobile());
            userListDto.setSex(weworkUser.getGender());
            userListDto.setPosition(weworkUser.getPosition());
            userListDto.setIsAgentAuth(weworkUser.getIsAgentAuth());
            userListDto.setIsSuiteAuth(weworkUser.getIsSuiteAuth());
            userListDto.setIsDeleted(weworkUser.getIsDeleted());
            userListDto.setRegionInfoId(userRegionMap.get(weworkUser.getNum()));
            WeworkActiveStatusEnum status = WeworkActiveStatusEnum.get((Integer)weworkUser.getStatus());
            userListDto.setStatusDto(EnumDto.from((EnumService)status));
            AddFriendConfig config = (AddFriendConfig)configMap.get(weworkUser.getNum());
            if (config != null && config.getErrorCode() != -999) {
                userListDto.setErrorCode(config.getErrorCode());
                userListDto.setErrorMsg(config.getErrorMsg());
            }
            if (MapUtils.isNotEmpty((Map)licenseMaps)) {
                Integer licenseStatus = licenseMaps.getOrDefault(weworkUser.getWeworkUserId(), LicenseStatusEnum.UNBIND.getValue());
                String licenseStatusStr = Optional.ofNullable(licenseStatus).map(item -> LicenseStatusEnum.get((int)item).getDesc()).orElse(LicenseStatusEnum.UNBIND.getDesc());
                userListDto.setLicenseStatus(licenseStatus);
                userListDto.setLicenseStatusStr(licenseStatusStr);
            }
            userListDto.setIsVcode(StringUtils.isEmpty((CharSequence)weworkUser.getVcode()) ? 0 : 1);
            Integer weworkRoleType = weworkUser.getWeworkRoleType();
            if (Objects.nonNull(weworkRoleType)) {
                userListDto.setWeworkRoleType(weworkRoleType);
                userListDto.setWeworkRoleTypeDesc(WeworkRoleTypeEnum.get((int)weworkRoleType).getDesc());
            }
            userListDto.setGroupSendIsCanSelected(NumberUtils.INTEGER_ZERO);
            if (Objects.nonNull(currentUserWeworkRoleType)) {
                WeworkRoleTypeEnum weworkRoleTypeEnum = WeworkRoleTypeEnum.get((int)currentUserWeworkRoleType);
                switch (weworkRoleTypeEnum) {
                    case ADMIN: {
                        userListDto.setGroupSendIsCanSelected(NumberUtils.INTEGER_ONE);
                        break;
                    }
                    case PERSON_IN_CHARGE: {
                        if (!CollectionUtils.isNotEmpty((Collection)groupSendWeworkUserNums) || !groupSendWeworkUserNums.contains(weworkUser.getNum())) break;
                        userListDto.setGroupSendIsCanSelected(NumberUtils.INTEGER_ONE);
                        break;
                    }
                }
            }
            if ((org = (Organization)organizationMap.get(weworkUser.getMainDepartment())) != null) {
                userListDto.setOrgName(org.getName());
                userListDto.setOrgId(org.getId());
            }
            if (params.getShowNodes() != null && YnEnum.YES.getValue().equals(params.getShowNodes())) {
                userListDto.setNodes(this.departmentService.buildWeworkUser(params.getBizId(), params.getCorpId(), weworkUser, departMap, departNameMap));
            }
            if (CollectionUtils.isNotEmpty((Collection)vipUserList) && vipUserList.contains(userListDto.getWeworkUserId())) {
                userListDto.setStatus(weworkOnlineMap.getOrDefault(weworkUser.getWeworkDigitId(), 0));
                userListDto.setVipUser(true);
            }
            result.add(userListDto);
        }
        return result;
    }

    private Map<String, Integer> getWeworkIdOnlineMap(Long bizId, List<String> weworkDigitIds) {
        BaseResponse weworksStatus;
        HashMap weworkOnlineMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(weworkDigitIds) && (weworksStatus = this.operateService.queryWeworksStatus(bizId, weworkDigitIds)) != null && weworksStatus.getCode() == 0L) {
            List statusData = (List)weworksStatus.getData();
            if (CollectionUtils.isEmpty((Collection)statusData)) {
                log.warn("wework online status is empty");
            } else {
                for (WeworkStatusInfo statusInfo : statusData) {
                    weworkOnlineMap.put(statusInfo.getWeworkId(), statusInfo.isOnline() ? 1 : 0);
                }
            }
        }
        return weworkOnlineMap;
    }

    @Override
    public List<WeworkUserNameRespDto> getWeworkUserNames(List<String> weworkUserNums) {
        log.info("getWeworkUserNames: weworkUserIds:{}", (Object)JSONObject.toJSONString(weworkUserNums));
        if (CollectionUtils.isEmpty(weworkUserNums)) {
            return Lists.newArrayList();
        }
        CurrentUserInfo currentUserInfo = this.baseValidate();
        log.info("getWeworkUserNames: bizId:{}, corpId:{}, id:{}", new Object[]{currentUserInfo.getBizId(), currentUserInfo.getCorpId(), currentUserInfo.getId()});
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(weworkUserNums), (Object)"\u8f93\u5165\u7528\u6237\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        List weworkUsers = this.weworkUserMapper.queryWeworkUsersByNums(currentUserInfo.getCorpId(), weworkUserNums);
        if (CollectionUtils.isEmpty((Collection)weworkUsers)) {
            log.info("getWeworkUserNames: no result");
            return Collections.emptyList();
        }
        ArrayList respDtos = Lists.newArrayList();
        for (WeworkUser weworkUser : weworkUsers) {
            WeworkUserNameRespDto dto = new WeworkUserNameRespDto();
            dto.setWeworkUserId(weworkUser.getNum());
            dto.setUserName(weworkUser.getName());
            dto.setAvatar(weworkUser.getAvatar());
            dto.setAlias(weworkUser.getAlias());
            respDtos.add(dto);
        }
        return respDtos;
    }

    @Override
    public String getWeworkUserIdByNum(String weworkUserNum) {
        if (StringUtils.isBlank((CharSequence)weworkUserNum)) {
            return null;
        }
        String weworkUserId = this.weworkUserMapper.queryWeworkUserIdByNum(weworkUserNum);
        if (StringUtils.isBlank((CharSequence)weworkUserId)) {
            log.warn("getWeworkUserNumById num is empty, weworkUserNum: {}", (Object)weworkUserNum);
        }
        return weworkUserId;
    }

    @Override
    public Map<String, WeworkUser> queryByWeworkUserNum(Long bizId, String weworkUserNum, Integer isAgent) {
        if (StringUtils.isBlank((CharSequence)weworkUserNum)) {
            return Maps.newHashMap();
        }
        HashMap result = Maps.newHashMap();
        if (YnEnum.YES.getValue().equals(isAgent)) {
            WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByNum(weworkUserNum);
            String encodeWeworkUserId = weworkUser.getWeworkUserId();
            String decodeWeworkUserId = this.agentDecryptWeworkUserIdMapper.queryByEncryptUserId(bizId, encodeWeworkUserId);
            result.put(decodeWeworkUserId, weworkUser);
            return result;
        }
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByNum(weworkUserNum);
        result.put(weworkUser.getWeworkUserId(), weworkUser);
        return result;
    }

    @Override
    public String getDecryptWeworkUserId(String weworkUserNum) {
        if (StringUtils.isBlank((CharSequence)weworkUserNum)) {
            return null;
        }
        String weworkUserId = this.getWeworkUserIdByNum(weworkUserNum);
        Long bizId = LoginUtils.getCurrentUserBizId();
        WeworkCorp weworkCorp = this.weworkCorpMapper.getByBizId(bizId);
        if (Objects.equals(weworkCorp.getIsNewDkf(), 1)) {
            return this.agentDecryptWeworkUserIdMapper.queryByEncryptUserId(bizId, weworkUserId);
        }
        return weworkUserId;
    }

    @Override
    public Map<String, String> getWeworkUserIdMapByNums(List<String> weworkUserNums) {
        if (CollectionUtils.isEmpty(weworkUserNums)) {
            return Maps.newHashMap();
        }
        return this.weworkUserMapper.queryWeworkUserIdMapByNums(weworkUserNums);
    }

    @Override
    public List<WeworkUserDto> queryWeworkUserInfoByNums(List<String> weworkUserNums) {
        if (CollectionUtils.isEmpty(weworkUserNums)) {
            return Lists.newArrayList();
        }
        List weworkUsers = this.weworkUserMapper.queryInfoListByNums(weworkUserNums);
        return weworkUsers.stream().map(a -> new WeworkUserDto(a.getId(), a.getNum(), a.getName(), a.getAlias(), a.getAvatar())).collect(Collectors.toList());
    }

    @Override
    public String getWeworkUserNumById(String corpId, String weworkUserId) {
        if (StringUtils.isBlank((CharSequence)corpId) || StringUtils.isBlank((CharSequence)weworkUserId)) {
            return null;
        }
        String weworkUserNum = this.weworkUserMapper.queryWeworkUserNumById(corpId, weworkUserId);
        if (StringUtils.isBlank((CharSequence)weworkUserNum)) {
            log.warn("getWeworkUserNumById num is empty corpId: {}, weworkUserId: {}", (Object)corpId, (Object)weworkUserId);
        }
        return weworkUserNum;
    }

    @Override
    public List<String> getWeworkUserNumByIds(String corpId, Collection<String> weworkUserIds) {
        if (StringUtils.isBlank((CharSequence)corpId) || CollectionUtils.isEmpty(weworkUserIds)) {
            return Lists.newArrayList();
        }
        return this.weworkUserMapper.queryWeworkUserNumByIds(corpId, weworkUserIds);
    }

    private CurrentUserInfo baseValidate() {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo), (Object)"\u5f53\u524d\u64cd\u4f5c\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo.getBizId()), (Object)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u6240\u5c5e\u5546\u6237\u4fe1\u606f\u4e0d\u80fd\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)currentUserInfo.getCorpId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
        return currentUserInfo;
    }

    @Override
    public Map<String, WeworkUser> queryUserByWeworkUserIds(String corpId, Collection<String> weworkUserIds) {
        if (StringUtils.isBlank((CharSequence)corpId) || CollectionUtils.isEmpty(weworkUserIds)) {
            return Maps.newHashMap();
        }
        List users = this.weworkUserMapper.queryWeworkUserInfoList(corpId, weworkUserIds);
        return users.stream().collect(Collectors.toMap(a -> a.getWeworkUserId(), a -> a));
    }

    @Override
    public Map<String, WeworkUser> queryUserByWeworkUserIds(Long bizId, Collection<String> weworkUserIds, Integer isAgent, String corpId) {
        if (Objects.isNull(bizId) || CollectionUtils.isEmpty(weworkUserIds) || StringUtils.isBlank((CharSequence)corpId)) {
            return Maps.newHashMap();
        }
        Collection<String> realQueryUserId = weworkUserIds;
        if (YnEnum.YES.getValue().equals(isAgent)) {
            Map encryptUserIds = this.agentDecryptWeworkUserIdMapper.queryMapByDecryptUserIds(bizId, weworkUserIds);
            realQueryUserId = encryptUserIds.keySet();
            HashMap result = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty(realQueryUserId)) {
                List users = this.weworkUserMapper.queryWeworkUserInfoListByWeworkUserIds(bizId, corpId, realQueryUserId);
                Map<String, WeworkUser> weworkUserMap = users.stream().collect(Collectors.toMap(a -> a.getWeworkUserId(), a -> a));
                for (Map.Entry<String, WeworkUser> entry : weworkUserMap.entrySet()) {
                    String decryptUserId = (String)encryptUserIds.get(entry.getKey());
                    if (!StringUtils.isNotBlank((CharSequence)decryptUserId)) continue;
                    result.put(decryptUserId, entry.getValue());
                }
            }
            return result;
        }
        List users = this.weworkUserMapper.queryWeworkUserInfoListByWeworkUserIds(bizId, corpId, realQueryUserId);
        return users.stream().collect(Collectors.toMap(a -> a.getWeworkUserId(), a -> a));
    }

    @Override
    public Map<Long, WeworkUserInfo> queryWeworkUserByUserIds(String corpId, Collection<Long> userIds) {
        if (StringUtils.isBlank((CharSequence)corpId) || CollectionUtils.isEmpty(userIds)) {
            return Maps.newHashMap();
        }
        List users = this.weworkUserMapper.queryWeworkUserByUserIds(corpId, userIds);
        return users.stream().collect(Collectors.toMap(a -> a.getUserId(), a -> a));
    }

    @Override
    public int externalUserNum(ExternalStatisticParams params) {
        log.info("external user num params: {}", (Object)params);
        if (params == null) {
            return 0;
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        Set<String> manageWeworkUserIds = this.queryCurManagerWeworkUser();
        if (CollectionUtils.isEmpty(manageWeworkUserIds)) {
            log.info("externalUserNum,manageWeworkUserIds is empty");
            return 0;
        }
        manageWeworkUserIds = this.getFilteredWeworkUser(params.getWeworkUserIds(), params.getDeptIds(), manageWeworkUserIds, userInfo.getBizId(), userInfo.getCorpId());
        if (CollectionUtils.isEmpty(manageWeworkUserIds)) {
            log.info("externalUserNum,manageWeworkUserIds is empty");
            return 0;
        }
        int num = this.weworkContactRelationMapper.queryWeworkContactTotal(corpId, manageWeworkUserIds);
        return num;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOrModWeworkRole(WeworkRoleReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("addOrModWeworkRole,reqDto:{}, operatorId:{}, corpId:{}", new Object[]{reqDto, currentUser.getId(), currentUser.getCorpId()});
        reqDto.validateParams();
        String corpId = currentUser.getCorpId();
        Integer weworkRoleType = reqDto.getWeworkRoleType();
        for (String weworkUserNum : reqDto.getWeworkUserNums()) {
            List<WeworkUserRoleManageUser> manageUsers;
            WeworkUserRole weworkUserRole = this.weworkUserRoleMapper.selectByCorpIdAndWeworkUserNum(corpId, weworkUserNum);
            if (Objects.nonNull(weworkUserRole)) {
                if (!weworkUserRole.getWeworkRoleType().equals(weworkRoleType)) {
                    weworkUserRole.setUpdateBy(currentUser.getId());
                    weworkUserRole.setUpdateTime(new Date());
                    weworkUserRole.setWeworkRoleType(weworkRoleType);
                    this.weworkUserRoleMapper.updateByPrimaryKey((Object)weworkUserRole);
                }
                this.weworkUserRoleManageUserMapper.deleteByCorpIdAndWeworkUserNum(corpId, weworkUserNum);
                if (WeworkRoleTypeEnum.PERSON_IN_CHARGE.getValue() != weworkUserRole.getWeworkRoleType().intValue()) continue;
                manageUsers = this.buildManagerUserList(currentUser, weworkUserNum, reqDto.getManageWeworkUserNums());
                this.weworkUserRoleManageUserMapper.batchInsert(manageUsers);
                continue;
            }
            weworkUserRole = this.buildWeworkUserRole(currentUser, weworkUserNum, weworkRoleType);
            this.weworkUserRoleMapper.insertSelective((Object)weworkUserRole);
            if (WeworkRoleTypeEnum.PERSON_IN_CHARGE.getValue() != weworkUserRole.getWeworkRoleType().intValue()) continue;
            manageUsers = this.buildManagerUserList(currentUser, weworkUserNum, reqDto.getManageWeworkUserNums());
            this.weworkUserRoleManageUserMapper.batchInsert(manageUsers);
        }
    }

    @Override
    public WeworkRoleDetailRespDto weworkRoleDetail(WeworkRoleDetailReqDto reqDto) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("weworkRoleDetail,params:{}, operatorId:{}, corpId:{}", new Object[]{reqDto, currentUserInfo.getId(), currentUserInfo.getCorpId()});
        reqDto.validateParams();
        WeworkRoleDetailRespDto weworkRoleDetailRespDto = new WeworkRoleDetailRespDto();
        WeworkUserRole weworkUserRole = this.weworkUserRoleMapper.selectByCorpIdAndWeworkUserNum(currentUserInfo.getCorpId(), reqDto.getWeworkUserNum());
        if (Objects.isNull(weworkUserRole)) {
            log.info("\u6210\u5458weworkUserNum:{}\u672a\u8bbe\u7f6e\u4f01\u5fae\u89d2\u8272", (Object)reqDto.getWeworkUserNum());
            return weworkRoleDetailRespDto;
        }
        int weworkRoleType = weworkUserRole.getWeworkRoleType();
        weworkRoleDetailRespDto.setWeworkRoleType(weworkRoleType);
        if (weworkRoleType != WeworkRoleTypeEnum.PERSON_IN_CHARGE.getValue()) {
            return weworkRoleDetailRespDto;
        }
        Map weworkUserNum2NameMap = this.weworkUserRoleManageUserMapper.selectByCorpIdAndWeworkUserNum(currentUserInfo.getCorpId(), reqDto.getWeworkUserNum());
        if (MapUtils.isEmpty((Map)weworkUserNum2NameMap)) {
            return weworkRoleDetailRespDto;
        }
        ArrayList weworkUsers = Lists.newArrayList();
        weworkRoleDetailRespDto.setWeworkUsers(weworkUsers);
        for (Map.Entry entry : weworkUserNum2NameMap.entrySet()) {
            WeworkUserNumAndNameDto weworkUser = new WeworkUserNumAndNameDto();
            weworkUsers.add(weworkUser);
            weworkUser.setWeworkUserNum((String)entry.getKey());
            weworkUser.setWeworkUserName((String)entry.getValue());
        }
        return weworkRoleDetailRespDto;
    }

    @Override
    public void initWeworkUserRole() {
        log.info("\u5f00\u59cb\u521d\u59cb\u5316\u6210\u5458\u4f01\u5fae\u89d2\u8272");
        Map corpId2ApplyWeworkUserIdMap = this.businessCustomerMapper.selectCorpIdAndApplyWeworkUserId();
        for (Map.Entry entry : corpId2ApplyWeworkUserIdMap.entrySet()) {
            String corpId = (String)entry.getKey();
            Long bizId = this.businessCustomerMapper.getExistBizId(corpId);
            String applyWeworkUserNum = (String)entry.getValue();
            Set weworkUserNums = this.weworkUserMapper.selectWeworkUserNumsByCorpId(corpId);
            for (String weworkUserNum : weworkUserNums) {
                WeworkUserRole weworkUserRole = new WeworkUserRole();
                weworkUserRole.setBizId(bizId);
                weworkUserRole.setCorpId(corpId);
                weworkUserRole.setWeworkUserNum(weworkUserNum);
                weworkUserRole.setWeworkRoleType(Integer.valueOf(WeworkRoleTypeEnum.NORMAL.getValue()));
                if (weworkUserNum.equals(applyWeworkUserNum)) {
                    weworkUserRole.setWeworkRoleType(Integer.valueOf(WeworkRoleTypeEnum.ADMIN.getValue()));
                }
                weworkUserRole.setCreateTime(new Date());
                weworkUserRole.setUpdateTime(new Date());
                this.weworkUserRoleMapper.saveWeworkUserRole(weworkUserRole);
            }
        }
    }

    private List<WeworkUserRoleManageUser> buildManagerUserList(CurrentUserInfo currentUserInfo, String weworkUserNum, List<String> manageWeworkUserNUms) {
        ArrayList manageUsers = Lists.newArrayList();
        Date date = new Date();
        for (String manageWeworkUserNum : manageWeworkUserNUms) {
            WeworkUserRoleManageUser manageUser = new WeworkUserRoleManageUser();
            manageUsers.add(manageUser);
            manageUser.setBizId(currentUserInfo.getBizId());
            manageUser.setCorpId(currentUserInfo.getCorpId());
            manageUser.setWeworkUserNum(weworkUserNum);
            manageUser.setManageWeworkUserNum(manageWeworkUserNum);
            manageUser.setCreateTime(date);
            manageUser.setCreateBy(currentUserInfo.getId());
            manageUser.setUpdateTime(date);
            manageUser.setUpdateBy(currentUserInfo.getId());
            manageUser.setIsDeleted(NumberUtils.INTEGER_ZERO);
        }
        return manageUsers;
    }

    private WeworkUserRole buildWeworkUserRole(CurrentUserInfo currentUserInfo, String weworkUserNum, Integer weworkRoleType) {
        WeworkUserRole weworkUserRole = new WeworkUserRole();
        weworkUserRole.setBizId(currentUserInfo.getBizId());
        weworkUserRole.setCorpId(currentUserInfo.getCorpId());
        weworkUserRole.setWeworkUserNum(weworkUserNum);
        weworkUserRole.setWeworkRoleType(weworkRoleType);
        weworkUserRole.setCreateTime(new Date());
        weworkUserRole.setCreateBy(currentUserInfo.getId());
        weworkUserRole.setUpdateTime(new Date());
        weworkUserRole.setUpdateBy(currentUserInfo.getId());
        weworkUserRole.setIsDeleted(NumberUtils.INTEGER_ZERO);
        return weworkUserRole;
    }

    public Set<String> selectDimissionWeworkUserIds(String corpId, Collection<String> weworkUserIds) {
        Long roleId;
        Role role;
        if (CollectionUtils.isEmpty(weworkUserIds)) {
            return Sets.newHashSet();
        }
        Set nodeIds = this.userRoleCommonService.getManageNodeIds();
        Set departmentIds = this.orgService.getDepartmentIds(nodeIds);
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        UserRoleRespDto curRole = currentUser.getCurRole();
        if (Objects.nonNull(curRole) && Objects.nonNull(role = this.roleMapper.selectRoleById(roleId = curRole.getRoleId(), currentUser.getBizId())) && Objects.nonNull(role.getType()) && SystemRoleType.ADMIN.getValue() == role.getType().intValue()) {
            return this.weworkDepartmentUserMapper.queryDimissionUserIds(corpId, (Collection)departmentIds, weworkUserIds);
        }
        return Sets.newHashSet();
    }

    @Override
    public Integer queryUserRole(String corpId, String weworkUserNum) {
        log.info("queryUserRole with corpId={},weworkUserNum={}", (Object)corpId, (Object)weworkUserNum);
        WeworkUserRole weworkUserRole = this.weworkUserRoleMapper.selectByCorpIdAndWeworkUserNum(corpId, weworkUserNum);
        if (Objects.isNull(weworkUserRole)) {
            log.info("\u6839\u636ecorpId:{},weworkUserNum:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)corpId, (Object)weworkUserNum);
            return null;
        }
        return weworkUserRole.getWeworkRoleType();
    }

    @Override
    public void refreshQyQrcode(List<String> weworkUserNums) {
        log.info("refreshQyQrcode weworkUserNums: {}", weworkUserNums);
        if (CollectionUtils.isEmpty(weworkUserNums)) {
            return;
        }
        List weworkUsers = this.weworkUserMapper.queryInfoListByNums(weworkUserNums);
        for (WeworkUser weworkUser : weworkUsers) {
            if (weworkUser.getEnableQrcode() == 1) continue;
            weworkUser.setEnableQrcode(Integer.valueOf(1));
            this.weworkUserMapper.updateByPrimaryKeySelective((Object)weworkUser);
        }
    }
}

