/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.contactstage.service.impl;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.ContactStageStatus;
import com.kuaike.scrm.common.enums.FollowRecordType;
import com.kuaike.scrm.common.service.CustomerCenterService;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.contactstage.entity.WeworkContactStage;
import com.kuaike.scrm.dal.contactstage.mapper.WeworkContactStageMapper;
import com.kuaike.scrm.dal.system.entity.CustomerStage;
import com.kuaike.scrm.dal.system.mapper.CustomerStageMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.follow.dto.CustomerStageInfo;
import com.kuaike.scrm.follow.dto.FollowReqDto;
import com.kuaike.scrm.follow.service.FollowService;
import com.kuaike.scrm.wework.contactstage.dto.request.ContactBaseReqDto;
import com.kuaike.scrm.wework.contactstage.dto.request.ContactStageModEndReqDto;
import com.kuaike.scrm.wework.contactstage.dto.request.ContactStageModReqDto;
import com.kuaike.scrm.wework.contactstage.dto.response.ContactStageRespDto;
import com.kuaike.scrm.wework.contactstage.service.ContactStageService;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContactStageServiceImpl
implements ContactStageService {
    private static final Logger log = LoggerFactory.getLogger(ContactStageServiceImpl.class);
    @Autowired
    private WeworkContactStageMapper weworkContactStageMapper;
    @Autowired
    private FollowService followService;
    @Autowired
    private CustomerStageMapper customerStageMapper;
    @Autowired
    private WeworkContactMapper contactMapper;
    @Autowired
    private CustomerCenterService customerCenterService;

    @Override
    public ContactStageRespDto detail(ContactBaseReqDto req) {
        log.info("detail req:{}", (Object)req);
        CurrentUserInfo currentUserInfo = this.baseValidate();
        log.info("detail: bizId:{}, corpId:{}, id:{}", new Object[]{currentUserInfo.getBizId(), currentUserInfo.getCorpId(), currentUserInfo.getId()});
        req.validate();
        WeworkContactStage contactStage = this.weworkContactStageMapper.selectCurrentStageByParams(currentUserInfo.getCorpId(), req.getWeworkUserId(), req.getContactId());
        if (Objects.isNull(contactStage)) {
            log.info("getContactStageList : contactStages is null");
            contactStage = this.initContactStage(currentUserInfo.getBizId(), currentUserInfo.getCorpId(), req.getWeworkUserId(), req.getContactId());
        }
        if (Objects.isNull(contactStage)) {
            return null;
        }
        ContactStageRespDto respDto = this.buildRespDto(contactStage);
        log.info("detail: respDto :{}", (Object)respDto);
        return respDto;
    }

    @Override
    public void modFlowing(ContactStageModReqDto reqDto) {
        WeworkContactStage stage;
        log.info("modFlowing reqDto:{}", (Object)reqDto);
        CurrentUserInfo currentUserInfo = this.baseValidate();
        log.info("modFlowing: bizId:{}, corpId:{}, id:{}", new Object[]{currentUserInfo.getBizId(), currentUserInfo.getCorpId(), currentUserInfo.getId()});
        WeworkContact contact = this.contactMapper.queryContact(currentUserInfo.getCorpId(), reqDto.getCustomerNum());
        String contactId = "";
        if (Objects.nonNull(contact)) {
            contactId = contact.getContactId();
            reqDto.setContactId(contactId);
        }
        log.info("modFlowing get contactId: {}, customerNum: {}", (Object)contactId, (Object)reqDto.getCustomerNum());
        reqDto.validate();
        WeworkContactStage oldContactStage = this.weworkContactStageMapper.selectCurrentStageByParams(currentUserInfo.getCorpId(), reqDto.getWeworkUserId(), reqDto.getContactId());
        log.info("modFlowing: oldContactStage:{}", (Object)oldContactStage);
        if (Objects.isNull(reqDto.getFollowRecordType()) && Objects.nonNull(oldContactStage)) {
            this.addSaveFollowRecord(reqDto, oldContactStage);
        }
        if (Objects.nonNull(oldContactStage) && reqDto.getStageId().equals(oldContactStage.getStageId())) {
            stage = this.buildContactStage(reqDto, currentUserInfo);
            this.weworkContactStageMapper.updateByStageId(stage);
        } else {
            stage = this.buildContactStage(reqDto, currentUserInfo);
            this.weworkContactStageMapper.batchInsert(Collections.singletonList(stage));
        }
        this.customerCenterService.pushCustomerStage(stage);
    }

    @Override
    public void modEnd(ContactStageModEndReqDto reqDto) {
        WeworkContactStage stage;
        log.info("modEnd reqDto:{}", (Object)reqDto);
        CurrentUserInfo currentUserInfo = this.baseValidate();
        log.info("modEnd: bizId:{}, corpId:{}, id:{}", new Object[]{currentUserInfo.getBizId(), currentUserInfo.getCorpId(), currentUserInfo.getId()});
        reqDto.validate();
        WeworkContact contact = this.contactMapper.queryContact(currentUserInfo.getCorpId(), reqDto.getCustomerNum());
        String contactId = "";
        if (Objects.nonNull(contact)) {
            contactId = contact.getContactId();
            reqDto.setContactId(contactId);
        }
        log.info("modFlowing get contactId: {}, customerNum: {}", (Object)contactId, (Object)reqDto.getCustomerNum());
        WeworkContactStage oldContactStage = this.weworkContactStageMapper.selectCurrentStageByParams(currentUserInfo.getCorpId(), reqDto.getWeworkUserId(), reqDto.getContactId());
        log.info("modEnd: oldContactStage:{}", (Object)oldContactStage);
        Long oldStageId = null;
        if (Objects.nonNull(oldContactStage)) {
            oldStageId = oldContactStage.getStageId();
        }
        if (Objects.isNull(reqDto.getFollowRecordType()) && Objects.nonNull(oldContactStage)) {
            this.addSaveEndRecord(reqDto, oldContactStage);
        }
        if (Objects.nonNull(oldContactStage) && reqDto.getFinalStageId().equals(oldContactStage.getFinalStageId())) {
            stage = this.buildContactStage(reqDto, currentUserInfo);
            this.weworkContactStageMapper.updateByFinalStageId(stage);
        } else {
            stage = this.buildContactStage(reqDto, currentUserInfo);
            stage.setStageId(oldStageId);
            this.weworkContactStageMapper.batchInsert(Collections.singletonList(stage));
        }
        this.customerCenterService.pushCustomerStage(stage);
    }

    public WeworkContactStage initContactStage(Long bizId, String corpId, String weworkUserNum, String contactId) {
        log.info("initContactStage: bizId:{}, corpId:{}, weworkUserNum:{}, contactId:{}", new Object[]{bizId, corpId, weworkUserNum, contactId});
        CustomerStage firstStage = this.customerStageMapper.queryFirstStage(bizId, corpId);
        if (Objects.isNull(firstStage)) {
            log.error("initContactStage: firstStage is null");
            return null;
        }
        WeworkContactStage stage = new WeworkContactStage();
        stage.setBizId(bizId);
        stage.setCorpId(corpId);
        stage.setContactId(contactId);
        stage.setWeworkUserNum(weworkUserNum);
        stage.setStageId(firstStage.getId());
        stage.setRemark(null);
        stage.setStageReasonId(null);
        stage.setIsDeleted(Integer.valueOf(0));
        stage.setStatus(Integer.valueOf(0));
        stage.setFinalStageId(null);
        stage.setUpdateBy(Long.valueOf(-1L));
        stage.setCreateBy(Long.valueOf(-1L));
        stage.setCreateTime(new Date());
        stage.setUpdateTime(new Date());
        this.weworkContactStageMapper.insertSelective((Object)stage);
        this.customerCenterService.pushCustomerStage(stage);
        return stage;
    }

    private WeworkContactStage buildContactStage(ContactStageModEndReqDto dto, CurrentUserInfo userInfo) {
        WeworkContactStage stage = new WeworkContactStage();
        stage.setContactId(dto.getContactId());
        stage.setWeworkUserNum(dto.getWeworkUserId());
        stage.setRemark(dto.getRemark());
        stage.setStageReasonId(dto.getStageReasonId());
        stage.setStatus(Integer.valueOf(ContactStageStatus.END.getValue()));
        stage.setFinalStageId(dto.getFinalStageId());
        stage.setCreateBy(userInfo.getId());
        stage.setCreateTime(new Date());
        stage.setUpdateBy(userInfo.getId());
        stage.setUpdateTime(new Date());
        stage.setCorpId(userInfo.getCorpId());
        stage.setBizId(userInfo.getBizId());
        stage.setIsDeleted(NumberUtils.INTEGER_ZERO);
        return stage;
    }

    private WeworkContactStage buildContactStage(ContactStageModReqDto dto, CurrentUserInfo userInfo) {
        WeworkContactStage stage = new WeworkContactStage();
        stage.setContactId(dto.getContactId());
        stage.setWeworkUserNum(dto.getWeworkUserId());
        stage.setStageId(dto.getStageId());
        stage.setStatus(dto.getStatus());
        stage.setCreateBy(userInfo.getId());
        stage.setCreateTime(new Date());
        stage.setUpdateBy(userInfo.getId());
        stage.setUpdateTime(new Date());
        stage.setCorpId(userInfo.getCorpId());
        stage.setBizId(userInfo.getBizId());
        stage.setIsDeleted(NumberUtils.INTEGER_ZERO);
        stage.setFinalStageId(null);
        return stage;
    }

    private ContactStageRespDto buildRespDto(WeworkContactStage stage) {
        ContactStageRespDto dto = new ContactStageRespDto();
        dto.setStageId(stage.getStageId());
        dto.setRemark(stage.getRemark());
        dto.setStageReasonId(stage.getStageReasonId());
        dto.setStatus(stage.getStatus());
        dto.setFinalStageId(stage.getFinalStageId());
        return dto;
    }

    private CurrentUserInfo baseValidate() {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo), (Object)"\u5f53\u524d\u64cd\u4f5c\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo.getBizId()), (Object)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u6240\u5c5e\u5546\u6237\u4fe1\u606f\u4e0d\u80fd\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)currentUserInfo.getCorpId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
        return currentUserInfo;
    }

    private void addSaveFollowRecord(ContactStageModReqDto newStageDto, WeworkContactStage contactStage) {
        log.info("addSaveFollowRecord, \u8ddf\u8fdb\u9636\u6bb5\uff1anewStageDto:{}, contactStage:{}", (Object)newStageDto, (Object)contactStage);
        FollowReqDto followReqDto = new FollowReqDto();
        followReqDto.setType(Integer.valueOf(FollowRecordType.UPDATE_CONTACT_STAGE.getValue()));
        followReqDto.setWeworkUserNum(newStageDto.getWeworkUserId());
        followReqDto.setContactId(newStageDto.getContactId());
        CustomerStageInfo customerStageInfo = new CustomerStageInfo();
        customerStageInfo.setNewStageId(newStageDto.getStageId());
        followReqDto.setCustomerStageInfo(customerStageInfo);
        Long stageId = contactStage.getStageId();
        if (ContactStageStatus.END.getValue() == contactStage.getStatus().intValue()) {
            stageId = contactStage.getFinalStageId();
        }
        customerStageInfo.setOldStageId(stageId);
        customerStageInfo.setOldStageReasonId(contactStage.getStageReasonId());
        customerStageInfo.setOldRemark(contactStage.getRemark());
        log.info("addSaveFollowRecord:, \u8ddf\u8fdb\u9636\u6bb5 customerStageInfo{}", (Object)customerStageInfo);
        this.followService.saveFollowRecord(followReqDto, LoginUtils.getCurrentUser());
    }

    private void addSaveEndRecord(ContactStageModEndReqDto newStageDto, WeworkContactStage contactStage) {
        log.info("addSaveEndRecord, \u7ed3\u675f\u9636\u6bb5\uff1anewStageDto:{}, contactStage:{}", (Object)newStageDto, (Object)contactStage);
        FollowReqDto followReqDto = new FollowReqDto();
        followReqDto.setType(Integer.valueOf(FollowRecordType.UPDATE_CONTACT_STAGE.getValue()));
        followReqDto.setWeworkUserNum(newStageDto.getWeworkUserId());
        followReqDto.setContactId(newStageDto.getContactId());
        CustomerStageInfo customerStageInfo = new CustomerStageInfo();
        customerStageInfo.setNewStageId(newStageDto.getFinalStageId());
        customerStageInfo.setNewStageReasonId(newStageDto.getStageReasonId());
        customerStageInfo.setNewRemark(newStageDto.getRemark());
        followReqDto.setCustomerStageInfo(customerStageInfo);
        if (Objects.nonNull(contactStage)) {
            Long oldStageId;
            if (contactStage.getStatus().intValue() == ContactStageStatus.END.getValue()) {
                oldStageId = contactStage.getFinalStageId();
                customerStageInfo.setOldStageReasonId(contactStage.getStageReasonId());
                customerStageInfo.setOldRemark(contactStage.getRemark());
            } else {
                oldStageId = contactStage.getStageId();
            }
            customerStageInfo.setOldStageId(oldStageId);
        }
        log.info("addSaveFollowRecord:, \u7ed3\u675f\u9636\u6bb5 customerStageInfo{}", (Object)customerStageInfo);
        this.followService.saveFollowRecord(followReqDto, LoginUtils.getCurrentUser());
    }
}

