/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.wework.contact.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.component.AliyunOss;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.ExportTaskStatus;
import com.kuaike.scrm.common.enums.ExportTaskType;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.common.utils.ThreadPoolMonitorUtils;
import com.kuaike.scrm.dal.exporttask.entity.ExportTask;
import com.kuaike.scrm.dal.exporttask.mapper.ExportTaskMapper;
import com.kuaike.scrm.wework.contact.dto.ExportQueryDto;
import com.kuaike.scrm.wework.contact.dto.ExportReqDto;
import com.kuaike.scrm.wework.contact.dto.ExportResp;
import com.kuaike.scrm.wework.contact.dto.ExportTaskDto;
import com.kuaike.scrm.wework.contact.service.ExportService;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public abstract class AbstractExportService
implements ExportService {
    private static final Logger log = LoggerFactory.getLogger(AbstractExportService.class);
    @Resource
    private ExportTaskMapper exportTaskMapper;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IdGen idGen;
    @Autowired
    private AliyunOss aliyunOss;
    private static final String EXPORT_DIR = "./exportDir/";
    private static final String EXPORT_FILE_TYPE = ".xlsx";
    public static final String EXPORT_COUNT_PREFIX = "export_count_prefix";
    private final ExecutorService executeService = new ThreadPoolExecutor(5, 5, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(200), (ThreadFactory)new NamedThreadFactory("ExportFileExecuteService"));

    @PostConstruct
    public void init() {
        ThreadPoolMonitorUtils.addToMonitor((ExecutorService)this.executeService);
        File fileDir = new File(EXPORT_DIR);
        if (!fileDir.exists()) {
            fileDir.mkdir();
        }
    }

    @Override
    public ExportResp export(ExportReqDto exportReqDto) {
        log.info("export task exportReqDto: {}", (Object)exportReqDto);
        if (exportReqDto == null) {
            return null;
        }
        Integer type = exportReqDto.getType();
        String json = exportReqDto.getJson();
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)json), (Object)"json\u4e0d\u80fd\u4e3a\u7a7a");
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        Long bizId = userInfo.getBizId();
        HttpSession httpSession = LoginUtils.getSession();
        Date curDate = new Date();
        ExportTask exportTask = new ExportTask();
        exportTask.setNum(this.idGen.getNum());
        exportTask.setBizId(bizId);
        exportTask.setCorpId(corpId);
        exportTask.setTaskType(type);
        exportTask.setStatus(Integer.valueOf(1));
        exportTask.setCreateBy(userInfo.getId());
        exportTask.setCreateTime(curDate);
        exportTask.setUpdateTime(curDate);
        exportTask.setIsDeleted(Integer.valueOf(0));
        this.exportTaskMapper.insertSelective((Object)exportTask);
        this.executeService.execute(() -> {
            try {
                LoginUtils.setCurrentUser((CurrentUserInfo)userInfo);
                LoginUtils.setSession((HttpSession)httpSession);
                Long userId = LoginUtils.getCurrentUserId();
                String sessionId = LoginUtils.getSessionId();
                if (Objects.isNull(userId) || StringUtils.isBlank((CharSequence)sessionId)) {
                    log.warn("buildTask warn,exportTaskNum={},exportReqDto={},current userId={},sessionId={}", new Object[]{exportTask.getNum(), exportReqDto, userId, sessionId});
                }
                this.buildTask(exportTask, json).run();
            }
            catch (Exception e) {
                log.error("execute export with error", (Throwable)e);
            }
            finally {
                LoginUtils.clear();
            }
        });
        Long totalExportCount = this.increaseReadExportCount();
        ExportResp exportResp = new ExportResp();
        exportResp.setTaskNum(exportTask.getNum());
        exportResp.setUnReadTaskCount(totalExportCount);
        return exportResp;
    }

    @Override
    public List<ExportTaskDto> getExportTaskList(ExportQueryDto queryDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        Integer type = queryDto.getType();
        queryDto.validate();
        PageDto pageDto = Objects.isNull(queryDto.getPageDto()) ? new PageDto() : queryDto.getPageDto();
        Page exportTasks = PageHelper.startPage((int)pageDto.getPageNum(), (int)pageDto.getPageSize()).doSelectPage(() -> this.exportTaskMapper.queryTaskList(corpId, userInfo.getId(), type, queryDto.getPageDto()));
        pageDto.setCount(Integer.valueOf((int)exportTasks.getTotal()));
        queryDto.setPageDto(pageDto);
        ArrayList result = Lists.newArrayListWithCapacity((int)exportTasks.size());
        for (ExportTask task : exportTasks) {
            ExportTaskDto exportTaskDto = this.getTaskDto(task);
            result.add(exportTaskDto);
        }
        return result;
    }

    public Long increaseReadExportCount() {
        String exportCountKey = this.buildExportCountKey();
        log.info("\u5bfc\u51fa\u6570\u91cfkey:{}", (Object)exportCountKey);
        BoundValueOperations operations = this.redisTemplate.boundValueOps((Object)exportCountKey);
        operations.expire(365L, TimeUnit.DAYS);
        return operations.increment();
    }

    @Override
    public void removeUnReadCount() {
        String countKey = this.buildExportCountKey();
        Object value = this.redisTemplate.opsForValue().get((Object)countKey);
        log.info("\u5bfc\u51fa\u6570\u91cfkey:{},\u603b\u6570\u91cf\u4e3a\uff1a{}", (Object)countKey, value);
        if (Objects.nonNull(value)) {
            this.redisTemplate.delete((Object)countKey);
        }
    }

    @Override
    public Long queryUnReadExportCount() {
        String countKey = this.buildExportCountKey();
        Object value = this.redisTemplate.opsForValue().get((Object)countKey);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return 0L;
    }

    private String buildExportCountKey() {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        return "export_count_prefix_" + userInfo.getBizId() + "_" + userInfo.getId();
    }

    public ExportTaskDto getTaskDto(ExportTask exportTask) {
        int index;
        ExportTaskDto exportTaskDto = new ExportTaskDto();
        exportTaskDto.setId(exportTask.getNum());
        String filePath = exportTask.getFilePath();
        if (StringUtils.isNotEmpty((CharSequence)filePath) && (index = filePath.lastIndexOf(File.separator)) > -1) {
            exportTaskDto.setFileName(filePath.substring(index + 1));
        }
        exportTaskDto.setFileUrl(filePath);
        exportTaskDto.setFileType(EXPORT_FILE_TYPE);
        exportTaskDto.setCreateTime(exportTask.getCreateTime());
        exportTaskDto.setType(exportTask.getTaskType());
        ExportTaskType taskType = ExportTaskType.get((Integer)exportTask.getTaskType());
        exportTaskDto.setTypeStr(Objects.isNull(taskType) ? null : taskType.getCNDesc());
        if (exportTask.getIsDeleted() == 1) {
            exportTaskDto.setStatus(ExportTaskStatus.TASK_DELETED.getValue());
        } else if (StringUtils.isNotBlank((CharSequence)exportTask.getErrorMsg())) {
            exportTaskDto.setStatus(ExportTaskStatus.TASK_FAIL.getValue());
            exportTaskDto.setErrorMsg(exportTask.getErrorMsg());
        } else {
            exportTaskDto.setStatus(exportTask.getStatus());
        }
        return exportTaskDto;
    }

    protected Runnable buildTask(ExportTask exportTask, String json) {
        throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9700\u8981\u5b9e\u4f8b\u5316\u624d\u80fd\u6784\u5efa\u4e0b\u8f7d\u4efb\u52a1");
    }

    public String createFilePath(String corpId, @Nonnull ExportTaskType exportType, String fileName) {
        int count = this.exportTaskMapper.queryCorpIdFileIndex(corpId, DateUtil.getTodayStartTime(), DateUtil.getTodayEndTime());
        String dateStr = DateUtil.getCurDate((String)"yyyy-MM-dd");
        String str = String.valueOf(count);
        int len = 4 - str.length();
        if (len < 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5546\u6237\u5f53\u5929\u751f\u6210\u6587\u4ef6\u6570\u91cf\u8fc7\u591a");
        }
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            builder.append(fileName);
        } else {
            builder.append(Optional.of(exportType).map(ExportTaskType::getCNDesc).orElse("")).append(dateStr);
        }
        for (int i = 0; i < len; ++i) {
            builder.append('0');
        }
        builder.append(str);
        return EXPORT_DIR + corpId + File.separator + builder.toString() + EXPORT_FILE_TYPE;
    }

    public void createCorpDir(String corpId) {
        String dirPath = EXPORT_DIR + corpId;
        File file = new File(dirPath);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    public String uploadOss(String corpId, File file) {
        return this.aliyunOss.uploadFile(corpId, file, file.getName());
    }
}

