/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.synctask.service.impl;

import cn.kinyun.scrm.vip.service.IdTranslateService;
import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.CustomizedAppDevStatus;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkAuthorizeAccountMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.synctask.service.SyncTaskService;
import com.kuaike.scrm.synctask.service.VipWeworkContactSyncService;
import com.kuaike.scrm.synctask.service.enums.SyncTaskType;
import com.kuaike.scrm.token.service.CustomizedTokenService;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VipWeworkContactSyncServiceImpl
implements VipWeworkContactSyncService {
    private static final Logger log = LoggerFactory.getLogger(VipWeworkContactSyncServiceImpl.class);
    private static final int PAGE_SIZE = 1000;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private VipWeworkAuthorizeAccountMapper vipWeworkAuthorizeAccountMapper;
    @Autowired
    private CustomizedTokenService customizedTokenService;
    @Autowired
    private SyncTaskService syncTaskService;
    @Autowired
    private IdTranslateService idTranslateService;

    @Override
    public Long sync() {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"user not login");
        Long bizId = user.getBizId();
        String corpId = user.getCorpId();
        Long operatorId = user.getId();
        Integer devStatus = this.customizedTokenService.getAuthStatus(bizId);
        if (devStatus == null) {
            log.warn("\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, corpId={}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528");
        }
        if (devStatus.intValue() != CustomizedAppDevStatus.DONE.getValue()) {
            log.warn("\u4f01\u4e1a\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528\u914d\u7f6e\u672a\u5b8c\u6210, corpId={}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528\u914d\u7f6e\u672a\u5b8c\u6210");
        }
        return this.syncTaskService.start(bizId, corpId, SyncTaskType.VIP_WEWORK_CONTACT, operatorId);
    }

    @Override
    public void fetch(String corpId) {
        log.info("sync vip wework contact digit id, corpId:{}", (Object)corpId);
        Long bizId = this.businessCustomerMapper.getBizId(corpId);
        if (bizId == null) {
            log.warn("bizId is null, corpId:{}", (Object)corpId);
            return;
        }
        List weworkUserIds = this.vipWeworkAuthorizeAccountMapper.queryAvailableUserIds(corpId);
        log.info("user ids:{}", (Object)weworkUserIds);
        if (CollectionUtils.isEmpty((Collection)weworkUserIds)) {
            log.warn("userIds is empty, corpId:{}", (Object)corpId);
            return;
        }
        String accessToken = this.customizedTokenService.getAgentAccessToken(corpId);
        if (accessToken == null) {
            log.warn("\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, corpId={}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528");
        }
        this.startMatchingDigitId(corpId, weworkUserIds);
    }

    private void startMatchingDigitId(String corpId, List<String> weworkUserIds) {
        int count = this.weworkContactRelationMapper.selectNoDigitIdRelationCount(corpId, weworkUserIds);
        if (count == 0) {
            log.info("\u6ca1\u6709\u9700\u8981\u6253\u901a\u7684\u597d\u53cb\u5173\u7cfb\u6570\u636e, corpId={}, weworkUserIds={}", (Object)corpId, weworkUserIds);
            return;
        }
        PageDto pageDto = new PageDto();
        pageDto.setCount(Integer.valueOf(count));
        pageDto.setPageSize(Integer.valueOf(1000));
        pageDto.setPageNum(Integer.valueOf(1));
        int totalPageNum = pageDto.getTotalPageNum();
        for (int page = 1; page <= totalPageNum; ++page) {
            pageDto.setPageNum(Integer.valueOf(page));
            List list = this.weworkContactRelationMapper.selectNoDigitIdRelation(corpId, weworkUserIds, pageDto);
            log.info("match page={}/{}, size={}", new Object[]{page, totalPageNum, list.size()});
            for (WeworkContactRelation it : list) {
                try {
                    this.idTranslateService.addDescription(it);
                }
                catch (Exception e) {
                    log.error("\u4fee\u6539\u5907\u6ce8\u63cf\u8ff0\u5931\u8d25, corpId={}, weworkUserId={}, contactId={}", new Object[]{it.getCorpId(), it.getWeworkUserId(), it.getContactId(), e});
                }
            }
        }
    }
}

