/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.synctask.service.impl;

import cn.kinyun.wework.sdk.api.CustomizedApi;
import cn.kinyun.wework.sdk.entity.custmized.OpenUserId;
import cn.kinyun.wework.sdk.entity.custmized.OpenUserIds;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.scrm.callback.service.SuiteAuthService;
import com.kuaike.scrm.common.enums.WeworkCorpSyncStatus;
import com.kuaike.scrm.dal.accesstoken.mapper.CorpSuiteTokenMapper;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.wework.dto.WeworkOpenUserId;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.synctask.service.UpgradeOpenCorpIdService;
import com.kuaike.scrm.token.service.ProviderTokenService;
import com.kuaike.scrm.token.service.SuiteTokenService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UpgradeOpenCorpIdServiceImpl
implements UpgradeOpenCorpIdService {
    private static final Logger log = LoggerFactory.getLogger(UpgradeOpenCorpIdServiceImpl.class);
    @Autowired
    private SuiteTokenService suiteTokenService;
    @Autowired
    private ProviderTokenService providerTokenService;
    @Autowired
    private CustomizedApi customizedApi;
    @Autowired
    private CorpSuiteTokenMapper corpSuiteTokenMapper;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private SuiteAuthService suiteAuthService;

    @Override
    public void start() {
        List list = this.businessCustomerMapper.selectAll();
        for (BusinessCustomer biz : list) {
            String authCorpId = biz.getAuthCorpId();
            if (authCorpId.startsWith("wp")) continue;
            try {
                this.fetch(biz);
            }
            catch (Exception e) {
                log.error("\u5931\u8d25, corpId={}", (Object)biz.getCorpId(), (Object)e);
            }
        }
    }

    @Override
    public void fetch(String corpId) {
        log.info("fetch corp, id={}", (Object)corpId);
        BusinessCustomer biz = this.businessCustomerMapper.getByCorpId(corpId);
        if (biz == null) {
            log.warn("corp not found, corpId={}", (Object)corpId);
            return;
        }
        this.fetch(biz);
    }

    @Transactional(rollbackFor={Exception.class})
    public void fetch(BusinessCustomer biz) {
        String openCorpId;
        Preconditions.checkArgument((biz != null ? 1 : 0) != 0, (Object)"corpId is null");
        log.info("fetch corp, id={}", (Object)biz.getCorpId());
        Long bizId = biz.getId();
        String corpId = biz.getCorpId();
        String authCorpId = biz.getAuthCorpId();
        String providerAccessToken = this.providerTokenService.getProviderToken();
        try {
            openCorpId = this.customizedApi.getOpenCorpId(providerAccessToken, corpId);
        }
        catch (WeworkException e) {
            if (e.getErrorCode() == 2000002) {
                log.error("corpid not found, corpId:{}", (Object)authCorpId);
            } else if (e.getErrorCode() == 48001) {
                log.error("\u4f01\u4e1a\u672a\u6388\u6743:{}", (Object)authCorpId);
            } else {
                log.error("\u8f6c\u5316corpId\u5931\u8d25:{}", (Object)e.getErrorMsg());
            }
            return;
        }
        BusinessCustomer authBiz = this.businessCustomerMapper.getByAuthCorpId(openCorpId);
        if (authBiz != null && !authBiz.getId().equals(bizId)) {
            this.suiteAuthService.resetAuthCorpIdByCorpId(biz, authBiz, openCorpId, authBiz.getApplyWeworkUserId(), corpId, biz.getApplyWeworkUserId());
        } else {
            this.suiteAuthService.resetCorpIdByAuthCorpId(bizId, openCorpId, biz.getApplyWeworkUserId(), corpId, biz.getApplyWeworkUserId());
            if (biz.getSyncStatus().intValue() == WeworkCorpSyncStatus.INIT_SUITE.getValue()) {
                this.suiteAuthService.initBiz(bizId);
                this.businessCustomerMapper.updateSyncStatus(bizId, Integer.valueOf(WeworkCorpSyncStatus.MATCH_CORP_ID.getValue()));
            }
            this.businessCustomerMapper.updateAuthCorpIdByCorpId(bizId, openCorpId, corpId);
            this.weworkCorpMapper.updateAuthCorpIdByCorpId(bizId, openCorpId, corpId);
            this.corpSuiteTokenMapper.updateAuthCorpIdByCorpId(bizId, openCorpId, corpId);
        }
        WeworkCorp corp = this.weworkCorpMapper.getByCorpId(corpId);
        if (corp.getIsAuth() == 0) {
            log.warn("\u4f01\u4e1a\u672a\u6388\u6743\uff0c\u65e0\u6cd5\u8f6c\u6362weworkUserId\u3002corpId={}", (Object)corpId);
            return;
        }
        List weworkUserIds = this.weworkUserMapper.getWeworkUserIds(corpId);
        HashMap map = Maps.newHashMap();
        List userIdList = Lists.partition((List)weworkUserIds, (int)200);
        for (List userIds : userIdList) {
            OpenUserIds result;
            try {
                String suiteAccessToken = this.suiteTokenService.getSuiteAccessToken(corpId);
                result = this.customizedApi.getOpenUserIds(suiteAccessToken, userIds);
            }
            catch (WeworkException e) {
                log.error("\u83b7\u53d6\u4f01\u4e1a\u53c2\u6570\u5931\u8d25, corpId={}", (Object)corpId, (Object)e);
                throw e;
            }
            List list = result.getOpenUserIdList();
            if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
            ArrayList ids = Lists.newArrayList();
            for (OpenUserId it : list) {
                WeworkOpenUserId dto = new WeworkOpenUserId();
                dto.setUserId(it.getUserId());
                dto.setOpenUserId(it.getOpenUserId());
                ids.add(dto);
                map.put(it.getUserId(), it.getOpenUserId());
            }
            log.info("batch update authUserId, corpId={}, ids={}", (Object)corpId, (Object)ids);
            this.weworkUserMapper.batchUpdateAuthUserId(corpId, (List)ids);
        }
        biz = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        String applyWeworkUserId = (String)map.get(biz.getApplyWeworkUserId());
        if (applyWeworkUserId != null) {
            log.info("update apply wework userId, corpId={}, {} -> {}", new Object[]{corpId, biz.getApplyWeworkUserId(), applyWeworkUserId});
            biz.setApplyWeworkUserId(applyWeworkUserId);
            this.businessCustomerMapper.updateByPrimaryKeySelective((Object)biz);
        }
    }
}

