/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.synctask.service.impl;

import cn.kinyun.wework.sdk.api.CustomizedApi;
import cn.kinyun.wework.sdk.api.SuiteApi;
import cn.kinyun.wework.sdk.api.UserApi;
import cn.kinyun.wework.sdk.entity.contact.user.UserInfo;
import cn.kinyun.wework.sdk.entity.custmized.OpenUserId;
import cn.kinyun.wework.sdk.entity.custmized.OpenUserIds;
import cn.kinyun.wework.sdk.entity.suite.Agent;
import cn.kinyun.wework.sdk.entity.suite.AuthInfo;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.WeworkUserSyncStatus;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.accesstoken.entity.CorpSuiteToken;
import com.kuaike.scrm.dal.accesstoken.mapper.CorpSuiteTokenMapper;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.synctask.service.SuiteSyncService;
import com.kuaike.scrm.synctask.service.SyncTaskService;
import com.kuaike.scrm.synctask.service.enums.SyncTaskType;
import com.kuaike.scrm.system.service.UserService;
import com.kuaike.scrm.token.service.ProviderTokenService;
import com.kuaike.scrm.token.service.SuiteTokenService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Deprecated
public class SuiteSyncServiceImpl
implements SuiteSyncService {
    private static final Logger log = LoggerFactory.getLogger(SuiteSyncServiceImpl.class);
    @Value(value="${qyapi.suite.id}")
    private String suiteId;
    @Autowired
    private UserApi userApi;
    @Autowired
    private SuiteApi suiteApi;
    @Autowired
    private CustomizedApi customizedApi;
    @Autowired
    private ProviderTokenService providerTokenService;
    @Autowired
    private SuiteTokenService suiteTokenService;
    @Autowired
    private SyncTaskService syncTaskService;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private CorpSuiteTokenMapper corpSuiteTokenMapper;
    @Autowired
    private UserService userService;

    @Override
    public Long sync() {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"user not login");
        Long bizId = user.getBizId();
        String corpId = user.getCorpId();
        Long operatorId = user.getId();
        return this.syncTaskService.start(bizId, corpId, SyncTaskType.SUITE, operatorId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void fetch(String corpId) {
        String actualCorpId;
        Agent agent;
        log.info("fetch suite, corpId:{}", (Object)corpId);
        Long bizId = this.businessCustomerMapper.getBizId(corpId);
        if (bizId == null) {
            log.warn("bizId is null, corpId:{}", (Object)corpId);
            return;
        }
        String suiteAccessToken = this.providerTokenService.getSuiteAccessToken(this.suiteId);
        if (suiteAccessToken == null) {
            log.warn("\u65e0\u6cd5\u83b7\u53d6\u7b2c\u4e09\u65b9\u5e94\u7528\u7684accessToken, suiteId={}", (Object)this.suiteId);
            return;
        }
        log.info("get suite user list, corpId:{}", (Object)corpId);
        String accessToken = this.suiteTokenService.getSuiteAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("\u672a\u6388\u6743\u7b2c\u4e09\u65b9\u5e94\u7528, corpId:{}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u6388\u6743\u7b2c\u4e09\u65b9\u5e94\u7528");
        }
        CorpSuiteToken token = this.corpSuiteTokenMapper.getAccessToken(corpId, this.suiteId);
        try {
            AuthInfo authInfo = this.suiteApi.getAuthInfo(suiteAccessToken, token.getAuthCorpId(), token.getPermanentCode());
            agent = (Agent)authInfo.getAuthInfo().getAgent().get(0);
            actualCorpId = authInfo.getAuthCorpInfo().getCorpId();
            log.info("Fetch suite auth info:{}", (Object)authInfo);
        }
        catch (WeworkException e) {
            log.error("{}, corpId:{}", (Object)e.getMessage(), (Object)corpId);
            throw e;
        }
        catch (Exception e) {
            log.error("Fetch suite failed.", (Throwable)e);
            throw e;
        }
        List userIds = Collections.emptyList();
        List deptIds = Collections.emptyList();
        if (agent.getPrivilege() != null) {
            if (CollectionUtils.isNotEmpty((Collection)agent.getPrivilege().getAllowUser())) {
                userIds = agent.getPrivilege().getAllowUser();
            }
            if (CollectionUtils.isNotEmpty((Collection)agent.getPrivilege().getAllowParty())) {
                deptIds = agent.getPrivilege().getAllowParty();
            }
        }
        ArrayList fetchUserList = Lists.newArrayList();
        HashSet fetchUserIds = Sets.newHashSet();
        for (String userId : userIds) {
            if (fetchUserIds.contains(userId)) continue;
            fetchUserIds.add(userId);
            fetchUserList.add(userId);
        }
        for (Integer deptId : deptIds) {
            List<UserInfo> list;
            try {
                list = this.userApi.list(accessToken, deptId, Integer.valueOf(1));
                if (list == null) {
                    list = Collections.emptyList();
                }
                log.info("fetch user list, deptId:{}, count:{}", (Object)deptId, (Object)list.size());
            }
            catch (WeworkException e) {
                log.error("{}, deptId:{}", (Object)e.getMessage(), (Object)deptId);
                throw e;
            }
            catch (Exception e) {
                log.error("fetch user list failed, deptId:{}", (Object)deptId, (Object)e);
                throw e;
            }
            for (UserInfo u : list) {
                if (fetchUserIds.contains(u.getUserId())) continue;
                fetchUserIds.add(u.getUserId());
                fetchUserList.add(u.getUserId());
            }
        }
        fetchUserList.sort(String::compareTo);
        if (!actualCorpId.startsWith("wp")) {
            ArrayList authUserList = Lists.newArrayListWithCapacity((int)fetchUserList.size());
            for (List userIdList : Lists.partition((List)fetchUserList, (int)200)) {
                try {
                    OpenUserIds result = this.customizedApi.getOpenUserIds(accessToken, userIdList);
                    if (!CollectionUtils.isNotEmpty((Collection)result.getOpenUserIdList())) continue;
                    List authUserIds = result.getOpenUserIdList().stream().map(OpenUserId::getOpenUserId).collect(Collectors.toList());
                    log.info("\u8f6c\u5316userId\u4e3aopenUserId, corpId:{}, userIds:{}, openUserIds:{}", new Object[]{corpId, userIdList, authUserIds});
                    authUserList.addAll(authUserIds);
                }
                catch (WeworkException e) {
                    log.error("\u83b7\u53d6openUserId\u5931\u8d25:{}, corpId={}", (Object)e.getMessage(), (Object)corpId);
                }
            }
            fetchUserList = authUserList;
        }
        this.updateSuiteAuth(bizId, corpId, fetchUserList);
    }

    private void updateSuiteAuth(Long bizId, String corpId, List<String> userIds) {
        List weworkUsers;
        List existAuthUserIds = this.weworkUserMapper.getAuthUserIds(corpId);
        if (CollectionUtils.isNotEmpty(userIds) && CollectionUtils.isNotEmpty((Collection)existAuthUserIds)) {
            for (String userId : userIds) {
                existAuthUserIds.remove(userId);
            }
        }
        log.info("update suite auth, corpId:{}, userIds:{}, existIds:{}", new Object[]{corpId, userIds, existAuthUserIds});
        if (CollectionUtils.isNotEmpty(userIds)) {
            this.weworkUserMapper.updateSuiteAuth(corpId, userIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)existAuthUserIds)) {
            this.weworkUserMapper.updateSuiteDeauth(corpId, (Collection)existAuthUserIds);
        }
        if (CollectionUtils.isNotEmpty(userIds) && CollectionUtils.isNotEmpty((Collection)(weworkUsers = this.weworkUserMapper.queryAuthList(corpId, userIds)))) {
            List weworkUserIds = weworkUsers.stream().map(WeworkUser::getWeworkUserId).collect(Collectors.toList());
            log.info("updateSuiteAuth: \u6210\u5458\u8f6c\u5316\u4e3a\u7528\u6237, bizId:{}, weworkUserIds\uff1a{}", (Object)bizId, weworkUserIds);
            for (WeworkUser weworkUser : weworkUsers) {
                if (weworkUser.getSyncStatus().intValue() != WeworkUserSyncStatus.SYNCHRONIZED.getValue()) continue;
                this.userService.insertUser(weworkUser, false);
            }
        }
    }
}

