/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.synctask.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.kinyun.ad.common.service.IntoLeadsPoolService;
import cn.kinyun.crm.common.enums.SourceType;
import cn.kinyun.crm.common.service.CrmLeadsService;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsReq;
import cn.kinyun.crm.common.service.dto.req.CrmModMobileReq;
import cn.kinyun.crm.common.service.dto.resp.CrmLeadsInfoResp;
import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.enums.ModuleType;
import cn.kinyun.customer.center.service.CcCustomerInfoService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.wework.sdk.api.external.ExternalContactClient;
import cn.kinyun.wework.sdk.entity.external.contact.ExternalContactInfo;
import cn.kinyun.wework.sdk.entity.external.contact.ExternalContactResp;
import cn.kinyun.wework.sdk.entity.external.contact.FollowUser;
import cn.kinyun.wework.sdk.entity.external.contact.Tag;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.CustomizedAppDevStatus;
import com.kuaike.scrm.common.enums.SettingEnum;
import com.kuaike.scrm.common.enums.SysChannelEnum;
import com.kuaike.scrm.common.enums.TelAddFriendStatus;
import com.kuaike.scrm.common.service.CustomerCenterService;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.contactanalyse.entity.WeworkContactLog;
import com.kuaike.scrm.dal.contactanalyse.mapper.WeworkContactLogMapper;
import com.kuaike.scrm.dal.contactstage.entity.WeworkContactStage;
import com.kuaike.scrm.dal.contactstage.mapper.WeworkContactStageMapper;
import com.kuaike.scrm.dal.marketing.entity.MarketingQrcode;
import com.kuaike.scrm.dal.marketing.mapper.MarketingQrcodeMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.system.entity.CustomerStage;
import com.kuaike.scrm.dal.system.mapper.CustomerStageMapper;
import com.kuaike.scrm.dal.teladdfriend.entity.TelAddFriendTask;
import com.kuaike.scrm.dal.teladdfriend.entity.TelAddFriendTaskDetail;
import com.kuaike.scrm.dal.teladdfriend.mapper.TelAddFriendTaskDetailMapper;
import com.kuaike.scrm.dal.teladdfriend.mapper.TelAddFriendTaskMapper;
import com.kuaike.scrm.dal.wework.dto.ContactRelationParams;
import com.kuaike.scrm.dal.wework.dto.ContactWeworkUserDto;
import com.kuaike.scrm.dal.wework.dto.WeworkUserIdContactIdDto;
import com.kuaike.scrm.dal.wework.dto.WeworkUserIdContactIdPair;
import com.kuaike.scrm.dal.wework.dto.WeworkUserNumContactIdDto;
import com.kuaike.scrm.dal.wework.entity.ContactDistinctStatisticRecord;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkContactMobile;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.ContactDistinctStatisticRecordMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMobileMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworktag.entity.WeworkContactTag;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkContactTagMapper;
import com.kuaike.scrm.event.context.ReplyContext;
import com.kuaike.scrm.event.context.ReplyContextUtil;
import com.kuaike.scrm.event.service.DelContactCallbackService;
import com.kuaike.scrm.synctask.service.ExternalContactSyncService;
import com.kuaike.scrm.synctask.service.RemarkMobileSyncService;
import com.kuaike.scrm.synctask.service.SyncTaskService;
import com.kuaike.scrm.synctask.service.dto.RemarkMobileSyncDto;
import com.kuaike.scrm.synctask.service.enums.SyncTaskType;
import com.kuaike.scrm.token.service.CustomizedTokenService;
import com.kuaike.scrm.utils.CheckContactUtil;
import com.kuaike.scrm.wework.contact.service.ContactCenterService;
import com.kuaike.scrm.wework.contact.service.ContactOpService;
import com.kuaike.scrm.wework.contact.service.ContactTagSyncService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExternalContactSyncServiceImpl
implements ExternalContactSyncService {
    private static final Logger log = LoggerFactory.getLogger(ExternalContactSyncServiceImpl.class);
    @Autowired
    @Qualifier(value="synctaskThreadPool")
    private ExecutorService executorService;
    @Autowired
    private IdGen idGen;
    @Autowired
    private ExternalContactClient externalContactClient;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private CustomizedTokenService customizedTokenService;
    @Autowired
    private SyncTaskService syncTaskService;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private WeworkContactLogMapper weworkContactLogMapper;
    @Autowired
    private WeworkContactTagMapper weworkContactTagMapper;
    @Autowired
    private WeworkContactMobileMapper weworkContactMobileMapper;
    @Autowired
    private WeworkContactStageMapper weworkContactStageMapper;
    @Autowired
    private CustomerStageMapper customerStageMapper;
    @Resource
    private ChannelMapper channelMapper;
    @Resource
    private MarketingQrcodeMapper marketingQrcodeMapper;
    @Autowired
    private ContactCenterService contactCenterService;
    @Autowired
    private CustomerCenterService customerCenterService;
    @Autowired
    private CcCustomerInfoService ccCustomerInfoService;
    @Autowired
    private CcCustomerNumService ccCustomerNumService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private CrmLeadsService crmLeadsService;
    @Autowired
    private ScrmBizService scrmBizService;
    @Resource
    private TelAddFriendTaskDetailMapper telAddFriendTaskDetailMapper;
    @Resource
    private TelAddFriendTaskMapper telAddFriendTaskMapper;
    @Resource
    private IntoLeadsPoolService intoLeadsPoolService;
    @Resource
    private DelContactCallbackService delContactCallbackService;
    @Autowired
    private ContactOpService contactOpService;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Resource
    private ContactDistinctStatisticRecordMapper contactDistinctStatisticRecordMapper;
    @Value(value="${kafka.topic.scrm_common_msg}")
    private String topic;
    @Autowired
    private ContactTagSyncService contactTagSyncService;
    @Autowired
    private RemarkMobileSyncService remarkMobileSyncService;
    @Autowired
    private SettingService settingService;

    @Override
    public Long sync() {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"user not login");
        Long bizId = user.getBizId();
        String corpId = user.getCorpId();
        Long operatorId = user.getId();
        Integer devStatus = this.customizedTokenService.getAuthStatus(bizId);
        if (devStatus == null) {
            log.warn("\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, corpId={}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528");
        }
        if (devStatus.intValue() != CustomizedAppDevStatus.DONE.getValue()) {
            log.warn("\u4f01\u4e1a\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528\u914d\u7f6e\u672a\u5b8c\u6210, corpId={}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528\u914d\u7f6e\u672a\u5b8c\u6210");
        }
        Long taskId = this.syncTaskService.start(bizId, corpId, SyncTaskType.EXTERNAL_CONTACT, operatorId);
        this.syncTaskService.start(bizId, corpId, SyncTaskType.AGENT_ID_CONVERT, operatorId);
        return taskId;
    }

    @Override
    public void fetch(String corpId) {
        log.info("fetch external contact, corpId:{}", (Object)corpId);
        Long bizId = this.businessCustomerMapper.getBizId(corpId);
        if (bizId == null) {
            log.warn("bizId is null, corpId:{}", (Object)corpId);
            return;
        }
        List userIds = this.weworkUserMapper.queryAccessWeworkUserIds(corpId);
        log.info("user ids:{}", (Object)userIds);
        if (CollectionUtils.isEmpty((Collection)userIds)) {
            log.info("userIds is empty, corpId:{}", (Object)corpId);
            return;
        }
        String accessToken = this.customizedTokenService.getAgentAccessToken(corpId);
        if (accessToken == null) {
            log.warn("\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, corpId={}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528");
        }
        Map<String, List<String>> userContactMap = this.fetchUserContactIds(corpId, userIds);
        TreeSet externalUserIdSet = new TreeSet();
        userContactMap.forEach((k, v) -> externalUserIdSet.addAll(v));
        ArrayList externalUserIds = Lists.newArrayList(externalUserIdSet);
        List pages = Lists.partition((List)externalUserIds, (int)500);
        for (List page : pages) {
            try {
                this.batchSaveContact(bizId, corpId, page);
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u4fdd\u5b58\u5ba2\u6237\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
        }
        this.initContactStage(bizId, corpId);
        this.syncTaskService.start(bizId, corpId, SyncTaskType.CONTACT_MOBILE, -1L);
    }

    private Map<String, List<String>> fetchUserContactIds(String corpId, List<String> userIds) {
        log.info("fetch user contact, corpId:{}, userIds:{}", (Object)corpId, userIds);
        HashMap map = Maps.newHashMap();
        int capacity = userIds.size();
        ArrayList fetchTasks = Lists.newArrayListWithCapacity((int)capacity);
        ArrayList exceptions = Lists.newArrayListWithCapacity((int)capacity);
        for (String weworkUserId : userIds) {
            Callable<Void> task = () -> {
                block8: {
                    try {
                        List<String> externalUserIds = this.fetchContactIds(corpId, weworkUserId);
                        if (externalUserIds == null) break block8;
                        Map map2 = map;
                        synchronized (map2) {
                            map.put(weworkUserId, externalUserIds);
                        }
                    }
                    catch (Exception e) {
                        List list = exceptions;
                        synchronized (list) {
                            exceptions.add(e);
                        }
                    }
                }
                return null;
            };
            fetchTasks.add(task);
        }
        try {
            this.executorService.invokeAll(fetchTasks);
        }
        catch (InterruptedException e) {
            log.error("invoke synctask failed", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u62c9\u53d6\u6570\u636e\u5931\u8d25");
        }
        if (CollectionUtils.isNotEmpty((Collection)exceptions)) {
            Exception e = (Exception)exceptions.get(0);
            log.error("fetch external contact error:{}", (Object)exceptions.size(), (Object)e);
            if (map.isEmpty()) {
                log.warn("fetch nothing");
                if (e instanceof BusinessException) {
                    throw (BusinessException)e;
                }
                if (e instanceof WeworkException) {
                    throw (WeworkException)e;
                }
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u62c9\u53d6\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
        }
        return map;
    }

    private List<String> fetchContactIds(String corpId, String weworkUserId) {
        try {
            return this.externalContactClient.list(corpId, weworkUserId);
        }
        catch (WeworkException e) {
            if (e.getErrorCode() == 84061) {
                log.warn("\u4e0d\u5b58\u5728\u5916\u90e8\u8054\u7cfb\u4eba\u5173\u7cfb, userId:{}", (Object)weworkUserId);
                return Collections.emptyList();
            }
            if (e.getErrorCode() == 60011) {
                log.warn("\u8be5\u6210\u5458\u6ca1\u6709\u914d\u7f6e\u5ba2\u6237\u8054\u7cfb\u6743\u9650, userId:{}", (Object)weworkUserId);
                return Collections.emptyList();
            }
            if (e.getErrorCode() == 45033) {
                log.error("{}, userId:{}", (Object)e.getMessage(), (Object)weworkUserId);
                return Collections.emptyList();
            }
            log.error("{}, userId:{}", (Object)e.getMessage(), (Object)weworkUserId);
            throw e;
        }
        catch (Exception e) {
            log.error("failed to get external contact, userId:{}", (Object)weworkUserId, (Object)e);
            throw e;
        }
    }

    private List<ExternalContactResp> fetchContactDetailList(String corpId, List<String> externalUserIds) {
        log.info("fetch user contact detail, externalUserIds:{}", externalUserIds);
        int capacity = externalUserIds.size();
        ArrayList fetchList = Lists.newArrayListWithCapacity((int)capacity);
        ArrayList fetchTasks = Lists.newArrayListWithCapacity((int)capacity);
        ArrayList exceptions = Lists.newArrayListWithCapacity((int)capacity);
        for (String externalUserId : externalUserIds) {
            Callable<Void> task = () -> {
                block8: {
                    try {
                        ExternalContactResp detail = this.fetchContactDetail(corpId, externalUserId);
                        if (detail == null) break block8;
                        List list = fetchList;
                        synchronized (list) {
                            fetchList.add(detail);
                        }
                    }
                    catch (Exception e) {
                        List list = exceptions;
                        synchronized (list) {
                            exceptions.add(e);
                        }
                    }
                }
                return null;
            };
            fetchTasks.add(task);
        }
        try {
            this.executorService.invokeAll(fetchTasks);
        }
        catch (InterruptedException e) {
            log.error("invoke synctask failed", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u62c9\u53d6\u6570\u636e\u5931\u8d25");
        }
        if (CollectionUtils.isNotEmpty((Collection)exceptions)) {
            Exception e = (Exception)exceptions.get(0);
            log.error("fetch external contact error:{}", (Object)exceptions.size(), (Object)e);
            if (fetchList.isEmpty()) {
                if (e instanceof BusinessException) {
                    throw (BusinessException)e;
                }
                if (e instanceof WeworkException) {
                    throw (WeworkException)((Object)e);
                }
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u62c9\u53d6\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
        }
        return fetchList;
    }

    @Override
    public ExternalContactResp fetchContactDetail(String corpId, String externalUserId) {
        ExternalContactResp result;
        boolean flag = false;
        String cursor = null;
        ArrayList followUsers = Lists.newArrayList();
        do {
            result = this.externalContactClient.getDetail(corpId, externalUserId, cursor);
            cursor = result.getNextCursor();
            ExternalContactInfo externalContact = result.getExternalContact();
            List followUserList = result.getFollowUserList();
            if (!flag) {
                log.info("contact detail:{}", (Object)externalContact);
            }
            flag = true;
            if (!CollectionUtils.isNotEmpty((Collection)followUserList)) continue;
            log.info("followUser:{}", (Object)followUserList);
            followUsers.addAll(followUserList);
        } while (cursor != null);
        result.setFollowUserList((List)followUsers);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchSaveContact(Long bizId, String corpId, List<String> externalUserIds) {
        Set ids;
        Map<Object, Object> contactId2RelationMap;
        Map<Object, Object> existsRelationMap;
        log.info("batch save contact, bizId:{}, corpId:{}, externalUserIds:{}", new Object[]{bizId, corpId, externalUserIds});
        List<ExternalContactResp> fetchList = this.fetchContactDetailList(corpId, externalUserIds);
        ArrayList addContactList = Lists.newArrayList();
        ArrayList addRelationList = Lists.newArrayList();
        ArrayList addTagList = Lists.newArrayList();
        ArrayList addMobileList = Lists.newArrayList();
        ArrayList delTagList = Lists.newArrayList();
        ArrayList delMobileList = Lists.newArrayList();
        List existsContactList = this.weworkContactMapper.queryWeworkContactList(corpId, externalUserIds);
        Map<Object, Object> existsContactMap = CollectionUtils.isNotEmpty((Collection)existsContactList) ? existsContactList.stream().collect(Collectors.toMap(WeworkContact::getContactId, it -> it)) : Maps.newHashMap();
        String contactFormat = "%s##%s";
        List existsRelationList = this.weworkContactRelationMapper.queryByCorpIdAndContactIds(corpId, externalUserIds);
        if (CollectionUtils.isNotEmpty((Collection)existsRelationList)) {
            existsRelationMap = existsRelationList.stream().collect(Collectors.toMap(it -> String.format(contactFormat, it.getContactId(), it.getWeworkUserId()), it -> it));
            contactId2RelationMap = existsRelationList.stream().collect(Collectors.groupingBy(WeworkContactRelation::getContactId));
        } else {
            existsRelationMap = Maps.newHashMap();
            contactId2RelationMap = Collections.emptyMap();
        }
        int newTotal = 0;
        int delTotal = 0;
        List existsTagList = this.weworkContactTagMapper.queryByCorpIdAndContactIds(corpId, externalUserIds);
        Map<Object, Object> existsTagListMap = CollectionUtils.isNotEmpty((Collection)existsTagList) ? existsTagList.stream().collect(Collectors.groupingBy(it -> String.format(contactFormat, it.getContactId(), it.getWeworkUserId()))) : Collections.emptyMap();
        List existsMobileList = this.weworkContactMobileMapper.queryByCorpIdAndContactIds(corpId, externalUserIds);
        Map<Object, Object> existsMobileListMap = CollectionUtils.isNotEmpty((Collection)existsMobileList) ? existsMobileList.stream().collect(Collectors.groupingBy(it -> String.format(contactFormat, it.getContactId(), it.getWeworkUserId()))) : Collections.emptyMap();
        Long channelId = this.channelMapper.querySysChannelId(SysChannelEnum.QY_WEIXIN.getCode());
        Map weworkUserIdNumMap = this.weworkUserMapper.queryWeworkUserIdNumMapByCorpId(corpId);
        ArrayList contactWeworkUserDtos = Lists.newArrayList();
        for (ExternalContactResp externalContactResp : fetchList) {
            List followUserList;
            ExternalContactInfo contact2 = externalContactResp.getExternalContact();
            String contactId = contact2.getExternalUserId();
            WeworkContact existContact = (WeworkContact)existsContactMap.remove(contactId);
            if (this.diffContact(existContact, contact2)) {
                addContactList.add(this.newContact(bizId, corpId, contact2, null));
            }
            if (CollectionUtils.isEmpty((Collection)(followUserList = externalContactResp.getFollowUserList()))) {
                ++delTotal;
                continue;
            }
            if (!contactId2RelationMap.containsKey(contactId)) {
                ++newTotal;
            }
            ContactWeworkUserDto contactWeworkUserDto = new ContactWeworkUserDto();
            contactWeworkUserDtos.add(contactWeworkUserDto);
            contactWeworkUserDto.setCorpId(corpId);
            contactWeworkUserDto.setContactId(contactId);
            contactWeworkUserDto.setWeworkUserCount(Integer.valueOf(followUserList.size()));
            String customerNum = this.ccCustomerNumService.getCustomerNumByWeworkContactId(bizId, contactId, null);
            for (FollowUser followUser : followUserList) {
                String contactKey = String.format(contactFormat, contactId, followUser.getUserId());
                WeworkContactRelation existRelation = (WeworkContactRelation)existsRelationMap.remove(contactKey);
                if (this.diffRelation(existRelation, followUser, null)) {
                    addRelationList.add(this.newRelation(bizId, corpId, contactId, followUser, null));
                }
                Map<String, List<WeworkContactTag>> existsTagMap = Collections.emptyMap();
                List existsTags = (List)existsTagListMap.remove(contactKey);
                if (CollectionUtils.isNotEmpty((Collection)existsTags)) {
                    existsTagMap = existsTags.stream().collect(Collectors.groupingBy(this::tagKey));
                }
                List<WeworkContactTag> addTags = this.newTagList(bizId, corpId, contactId, followUser, existsTagMap);
                addTagList.addAll(addTags);
                ArrayList delTagIds = Lists.newArrayList();
                if (!existsTagMap.isEmpty()) {
                    for (List<WeworkContactTag> it2 : existsTagMap.values()) {
                        delTagList.addAll(it2);
                        delTagIds.addAll(it2.stream().map(WeworkContactTag::getTagId).collect(Collectors.toList()));
                    }
                }
                String weworkUserNum = (String)weworkUserIdNumMap.get(followUser.getUserId());
                List addTgaIds = addTags.stream().map(WeworkContactTag::getTagId).filter(StringUtils::isNotBlank).collect(Collectors.toList());
                this.customerCenterService.pushTagRelation(bizId, weworkUserNum, customerNum, addTgaIds, (List)delTagIds);
                Map<String, List<WeworkContactMobile>> existsMobileMap = Collections.emptyMap();
                List existsMobiles = (List)existsMobileListMap.remove(contactKey);
                if (CollectionUtils.isNotEmpty((Collection)existsMobiles)) {
                    existsMobileMap = existsMobiles.stream().collect(Collectors.groupingBy(WeworkContactMobile::getRemarkMobile));
                }
                addMobileList.addAll(this.newMobileList(bizId, corpId, contactId, followUser, existsMobileMap));
                if (existsMobileMap.isEmpty()) continue;
                for (List<WeworkContactMobile> it3 : existsMobileMap.values()) {
                    delMobileList.addAll(it3);
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)addContactList)) {
            log.info("save contact:{}", (Object)addContactList.size());
            Lists.partition((List)addContactList, (int)200).forEach(list -> this.weworkContactMapper.batchInsert(list));
            Map<Object, Object> tagIds = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)addTagList)) {
                tagIds = addTagList.stream().filter(it -> StringUtils.isNotBlank((CharSequence)it.getTagId())).collect(Collectors.groupingBy(WeworkContactTag::getContactId, Collectors.mapping(WeworkContactTag::getTagId, Collectors.toList())));
            }
            for (Object contact : addContactList) {
                this.customerCenterService.pushContactCustomer((WeworkContact)contact);
                if (!StringUtils.isNotEmpty((CharSequence)contact.getMobile())) continue;
                String moduleType = ModuleType.BATCH_ADD_FRIEND.getCode();
                this.customerCenterService.pushAddMobileEvent(contact.getBizId(), contact.getMobile(), moduleType);
                this.customerCenterService.pushMobileCustomer(contact.getBizId(), contact.getMobile(), contact.getName(), (List)tagIds.get(contact.getContactId()), Long.valueOf(-1L), channelId);
                this.customerCenterService.bindCustomer(contact.getBizId(), contact.getCorpId(), contact.getContactId(), contact.getMobile(), moduleType);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)addRelationList)) {
            log.info("save contact relation:{}", (Object)addRelationList.size());
            Lists.partition((List)addRelationList, (int)200).forEach(list -> this.weworkContactRelationMapper.batchInsert(list));
            List list2 = addRelationList.stream().map(a -> new WeworkUserIdContactIdPair(a.getWeworkUserId(), a.getContactId())).collect(Collectors.toList());
            ArrayList arrayList = Lists.newArrayList();
            Lists.partition(list2, (int)200).forEach(subList -> {
                List part = this.weworkContactRelationMapper.queryByWeworkUserIdAndContactId(corpId, subList);
                if (CollectionUtils.isNotEmpty((Collection)part)) {
                    weworkContactRelationList.addAll(part);
                }
            });
            for (WeworkContactRelation contactRelation : arrayList) {
                this.customerCenterService.pushContactRelation(contactRelation);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)addTagList)) {
            log.info("save contact tag:{}", (Object)addTagList.size());
            Lists.partition((List)addTagList, (int)200).forEach(list -> this.weworkContactTagMapper.batchInsert(list));
        }
        if (CollectionUtils.isNotEmpty((Collection)addMobileList)) {
            log.info("save contact mobile:{}", (Object)addMobileList.size());
            this.weworkContactMobileMapper.batchInsert((List)addMobileList);
        }
        if (!existsRelationMap.isEmpty()) {
            ids = existsRelationMap.values().stream().map(WeworkContactRelation::getId).collect(Collectors.toSet());
            log.info("delete contact relation size:{}, ids:{}", (Object)ids.size(), ids);
            this.weworkContactRelationMapper.logicDeleteByIds(ids, Long.valueOf(-1L));
            for (Long contactRelationId : ids) {
                WeworkContactRelation delContactRelation = (WeworkContactRelation)this.weworkContactRelationMapper.selectByPrimaryKey((Object)contactRelationId);
                this.customerCenterService.pushContactRelation(delContactRelation);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)delTagList)) {
            ids = delTagList.stream().map(WeworkContactTag::getId).collect(Collectors.toSet());
            log.info("delete contact tag size:{}, ids:{}", (Object)ids.size(), ids);
            this.weworkContactTagMapper.logicDeleteByIds(ids, Long.valueOf(-1L));
        }
        if (CollectionUtils.isNotEmpty((Collection)delMobileList)) {
            ids = delMobileList.stream().map(WeworkContactMobile::getId).collect(Collectors.toSet());
            log.info("delete contact mobile size:{}, ids:{}", (Object)ids.size(), ids);
            this.weworkContactMobileMapper.logicDeleteByIds(ids, Long.valueOf(-1L));
        }
        ContactRelationParams params = new ContactRelationParams();
        params.setCorpId(corpId);
        List list2 = this.weworkContactRelationMapper.queryContactRelationList(params);
        list2.forEach(a -> this.contactOpService.updateTagCount(corpId, a.getWeworkUserId(), a.getContactId()));
        if (CollectionUtils.isNotEmpty((Collection)contactWeworkUserDtos)) {
            Lists.partition((List)contactWeworkUserDtos, (int)200).forEach(list -> this.weworkContactMapper.updateWeworkUserCount((Collection)list));
        }
        this.addSaveContactDistinctStatisticData(bizId, newTotal, delTotal);
    }

    private boolean diffContact(WeworkContact exist, ExternalContactInfo contact, String mobile) {
        boolean result = this.diffContact(exist, contact);
        if (result) {
            return result;
        }
        if (!com.google.common.base.Objects.equal((Object)mobile, (Object)exist.getMobile())) {
            log.info("mobile diff:\n{}\n{}", (Object)mobile, (Object)exist.getMobile());
            result = true;
        }
        return result;
    }

    private boolean diffContact(WeworkContact exist, ExternalContactInfo contact) {
        if (exist == null) {
            log.info("contact not exist");
            return true;
        }
        if (!com.google.common.base.Objects.equal((Object)contact.getName(), (Object)exist.getName())) {
            log.info("name diff:\n{}\n{}", (Object)contact.getName(), (Object)exist.getName());
            return true;
        }
        if (!com.google.common.base.Objects.equal((Object)contact.getAvatar(), (Object)exist.getAvatar())) {
            log.info("avatar diff:\n{}\n{}", (Object)contact.getAvatar(), (Object)exist.getAvatar());
            return true;
        }
        if (!com.google.common.base.Objects.equal((Object)contact.getGender(), (Object)exist.getGender())) {
            log.info("gender diff:\n{}\n{}", (Object)contact.getGender(), (Object)exist.getGender());
            return true;
        }
        if (!com.google.common.base.Objects.equal((Object)contact.getUnionId(), (Object)exist.getUnionid())) {
            log.info("unionid diff:\n{}\n{}", (Object)contact.getUnionId(), (Object)exist.getUnionid());
            return true;
        }
        if (!com.google.common.base.Objects.equal((Object)contact.getType(), (Object)exist.getType())) {
            log.info("type diff:\n{}\n{}", (Object)contact.getType(), (Object)exist.getType());
            return true;
        }
        if (!com.google.common.base.Objects.equal((Object)contact.getPosition(), (Object)exist.getPosition())) {
            log.info("position diff:\n{}\n{}", (Object)contact.getPosition(), (Object)exist.getPosition());
            return true;
        }
        if (!com.google.common.base.Objects.equal((Object)contact.getCorpName(), (Object)exist.getCorpName())) {
            log.info("corpName diff:\n{}\n{}", (Object)contact.getCorpName(), (Object)exist.getCorpName());
            return true;
        }
        if (!com.google.common.base.Objects.equal((Object)contact.getCorpFullName(), (Object)exist.getCorpFullName())) {
            log.info("corpFullName diff:\n{}\n{}", (Object)contact.getCorpFullName(), (Object)exist.getCorpFullName());
            return true;
        }
        String externalProfile = "";
        if (contact.getExternalProfile() != null) {
            externalProfile = JacksonUtil.obj2Str((Object)contact.getExternalProfile());
        }
        if (!com.google.common.base.Objects.equal((Object)externalProfile, (Object)exist.getExternalProfile())) {
            log.info("externalProfile diff:\n{}\n{}", (Object)externalProfile, (Object)exist.getExternalProfile());
            return true;
        }
        return false;
    }

    private boolean diffRelation(WeworkContactRelation exist, FollowUser followUser, Integer isZombieFans) {
        if (exist == null) {
            return true;
        }
        if (!com.google.common.base.Objects.equal((Object)followUser.getRemark(), (Object)exist.getRemark())) {
            log.info("old remark:{} ;new remark:{}", (Object)exist.getRemark(), (Object)followUser.getRemark());
            return true;
        }
        if (!com.google.common.base.Objects.equal((Object)followUser.getDescription(), (Object)exist.getDescription())) {
            log.info("old description:{} ;new description:{}", (Object)exist.getDescription(), (Object)followUser.getDescription());
            return true;
        }
        if (!com.google.common.base.Objects.equal((Object)followUser.getRemarkCorpName(), (Object)exist.getRemarkCorpName())) {
            log.info("old remarkCorpName:{} ;new remarkCorpName:{}", (Object)exist.getRemarkCorpName(), (Object)followUser.getRemarkCorpName());
            return true;
        }
        if (!com.google.common.base.Objects.equal((Object)followUser.getAddWay(), (Object)exist.getAddWay())) {
            log.info("old addWay:{} ;new addWay:{}", (Object)exist.getAddWay(), (Object)followUser.getAddWay());
            return true;
        }
        Long addTime = null;
        if (exist.getAddTime() != null) {
            addTime = exist.getAddTime().getTime() / 1000L;
        }
        if (!com.google.common.base.Objects.equal((Object)followUser.getCreateTime(), addTime)) {
            log.info("old addTime:{} ;new createTime:{}", (Object)addTime, (Object)followUser.getCreateTime());
            return true;
        }
        if (!com.google.common.base.Objects.equal((Object)followUser.getOperUserId(), (Object)exist.getOperUserId())) {
            log.info("old operUserId:{} ;new operUserId:{}", (Object)exist.getOperUserId(), (Object)followUser.getOperUserId());
            return true;
        }
        Integer tagCount = 0;
        if (CollectionUtils.isNotEmpty((Collection)followUser.getTags())) {
            for (Tag tag : followUser.getTags()) {
                if (tag.getType() != 1) continue;
                Integer n = tagCount;
                Integer n2 = tagCount = Integer.valueOf(tagCount + 1);
            }
        }
        if (!com.google.common.base.Objects.equal((Object)tagCount, (Object)exist.getTagCount())) {
            log.info("old tagCount:{} ;new tagCount:{}", (Object)exist.getTagCount(), (Object)tagCount);
            return true;
        }
        int mobileCount = 0;
        if (CollectionUtils.isNotEmpty((Collection)followUser.getRemarkMobiles())) {
            mobileCount = followUser.getRemarkMobiles().size();
        }
        if (!com.google.common.base.Objects.equal((Object)mobileCount, (Object)exist.getMobileCount())) {
            log.info("old mobileCount:{} ;new mobileCount:{}", (Object)exist.getMobileCount(), (Object)mobileCount);
            return true;
        }
        if (isZombieFans != null) {
            log.info("isZombieFans:{}", (Object)exist.getIsZombieFans());
            return !com.google.common.base.Objects.equal((Object)isZombieFans, (Object)exist.getIsZombieFans());
        }
        return false;
    }

    private WeworkContact newContact(Long bizId, String corpId, ExternalContactInfo contact, Long timeStamp) {
        WeworkContact weworkContact = new WeworkContact();
        weworkContact.setNum(this.idGen.getNum());
        weworkContact.setBizId(bizId);
        weworkContact.setCorpId(corpId);
        weworkContact.setContactId(contact.getExternalUserId());
        weworkContact.setUnionid(contact.getUnionId());
        weworkContact.setName(contact.getName());
        weworkContact.setAvatar(contact.getAvatar());
        weworkContact.setGender(contact.getGender());
        weworkContact.setType(contact.getType());
        weworkContact.setPosition(contact.getPosition());
        weworkContact.setCorpName(contact.getCorpName());
        weworkContact.setCorpFullName(contact.getCorpFullName());
        String externalProfile = "";
        if (contact.getExternalProfile() != null) {
            externalProfile = JacksonUtil.obj2Str((Object)contact.getExternalProfile());
        }
        weworkContact.setExternalProfile(externalProfile);
        Date now = Objects.isNull(timeStamp) ? new Date() : new Date(timeStamp * 1000L);
        weworkContact.setCreateTime(now);
        weworkContact.setUpdateTime(now);
        return weworkContact;
    }

    private WeworkContactRelation newRelation(Long bizId, String corpId, String contactId, FollowUser followUser, Integer isZombieFans) {
        Integer tagCount = 0;
        if (CollectionUtils.isNotEmpty((Collection)followUser.getTags())) {
            for (Tag tag : followUser.getTags()) {
                if (tag.getType() != 1) continue;
                Integer n = tagCount;
                Integer n2 = tagCount = Integer.valueOf(tagCount + 1);
            }
        }
        int mobileCount = 0;
        if (CollectionUtils.isNotEmpty((Collection)followUser.getRemarkMobiles())) {
            mobileCount = followUser.getRemarkMobiles().size();
        }
        WeworkContactRelation weworkContactRelation = new WeworkContactRelation();
        String weworkUserId = followUser.getUserId();
        weworkContactRelation.setNum(this.idGen.getNum());
        weworkContactRelation.setBizId(bizId);
        weworkContactRelation.setCorpId(corpId);
        weworkContactRelation.setWeworkUserId(weworkUserId);
        weworkContactRelation.setContactId(contactId);
        weworkContactRelation.setRemark(followUser.getRemark());
        weworkContactRelation.setRemarkCorpName(followUser.getRemarkCorpName());
        weworkContactRelation.setDescription(followUser.getDescription());
        weworkContactRelation.setTagCount(tagCount);
        weworkContactRelation.setMobileCount(Integer.valueOf(mobileCount));
        if (isZombieFans != null) {
            weworkContactRelation.setIsZombieFans(isZombieFans);
        }
        weworkContactRelation.setOperUserId(followUser.getOperUserId());
        weworkContactRelation.setAddWay(followUser.getAddWay());
        weworkContactRelation.setAddTime(new Date(followUser.getCreateTime() * 1000L));
        Date now = new Date();
        weworkContactRelation.setCreateBy(Long.valueOf(-1L));
        weworkContactRelation.setCreateTime(now);
        weworkContactRelation.setUpdateBy(Long.valueOf(-1L));
        weworkContactRelation.setUpdateTime(now);
        weworkContactRelation.setIsDeleted(Integer.valueOf(0));
        return weworkContactRelation;
    }

    private List<WeworkContactTag> newTagList(Long bizId, String corpId, String contactId, FollowUser followUser, Map<String, List<WeworkContactTag>> existsTagMap) {
        String weworkUserId = followUser.getUserId();
        ArrayList list = Lists.newArrayList();
        List tags = followUser.getTags();
        if (CollectionUtils.isEmpty((Collection)tags)) {
            return Collections.emptyList();
        }
        for (Tag tag : tags) {
            String key = this.tagKey(tag);
            if (existsTagMap.containsKey(key)) {
                existsTagMap.remove(key);
                continue;
            }
            list.add(this.newTag(bizId, corpId, weworkUserId, contactId, tag));
        }
        return list;
    }

    private WeworkContactTag newTag(Long bizId, String corpId, String weworkUserId, String contactId, Tag tag) {
        WeworkContactTag weworkContactTag = new WeworkContactTag();
        weworkContactTag.setNum(this.idGen.getNum());
        log.info("num:{}", (Object)this.idGen.getNum());
        weworkContactTag.setBizId(bizId);
        weworkContactTag.setCorpId(corpId);
        weworkContactTag.setWeworkUserId(weworkUserId);
        weworkContactTag.setContactId(contactId);
        weworkContactTag.setType(tag.getType());
        if (tag.getType() == 1) {
            weworkContactTag.setTagId(tag.getTagId());
        } else {
            weworkContactTag.setTagName(tag.getTagName());
        }
        Date now = new Date();
        weworkContactTag.setCreateBy(Long.valueOf(-1L));
        weworkContactTag.setCreateTime(now);
        weworkContactTag.setUpdateBy(Long.valueOf(-1L));
        weworkContactTag.setUpdateTime(now);
        return weworkContactTag;
    }

    private String tagKey(WeworkContactTag tag) {
        if (tag.getType() == 1) {
            return "1##" + tag.getTagId();
        }
        return "2##" + tag.getTagName();
    }

    private String tagKey(Tag tag) {
        if (tag.getType() == 1) {
            return "1##" + tag.getTagId();
        }
        return "2##" + tag.getTagName();
    }

    private List<WeworkContactMobile> newMobileList(Long bizId, String corpId, String contactId, FollowUser followUser, Map<String, List<WeworkContactMobile>> existsMobileMap) {
        ArrayList list = Lists.newArrayList();
        List mobiles = followUser.getRemarkMobiles();
        String weworkUserId = followUser.getUserId();
        if (CollectionUtils.isEmpty((Collection)mobiles)) {
            return Collections.emptyList();
        }
        for (String mobile : mobiles) {
            if (existsMobileMap.containsKey(mobile)) {
                existsMobileMap.remove(mobile);
                continue;
            }
            list.add(this.newMobile(bizId, corpId, weworkUserId, contactId, mobile));
        }
        return list;
    }

    private WeworkContactMobile newMobile(Long bizId, String corpId, String weworkUserId, String contactId, String mobile) {
        WeworkContactMobile weworkContactMobile = new WeworkContactMobile();
        weworkContactMobile.setNum(this.idGen.getNum());
        weworkContactMobile.setBizId(bizId);
        weworkContactMobile.setCorpId(corpId);
        weworkContactMobile.setWeworkUserId(weworkUserId);
        weworkContactMobile.setContactId(contactId);
        weworkContactMobile.setRemarkMobile(mobile);
        Date now = new Date();
        weworkContactMobile.setCreateBy(Long.valueOf(-1L));
        weworkContactMobile.setCreateTime(now);
        weworkContactMobile.setUpdateBy(Long.valueOf(-1L));
        weworkContactMobile.setUpdateTime(now);
        return weworkContactMobile;
    }

    private WeworkContactStage newContactStage(Long bizId, String corpId, String weworkUserNum, String contactId, CustomerStage defaultStage) {
        WeworkContactStage weworkContactStage = new WeworkContactStage();
        weworkContactStage.setBizId(bizId);
        weworkContactStage.setCorpId(corpId);
        weworkContactStage.setContactId(contactId);
        weworkContactStage.setWeworkUserNum(weworkUserNum);
        weworkContactStage.setStatus(Integer.valueOf(0));
        weworkContactStage.setStageId(defaultStage.getId());
        weworkContactStage.setRemark("");
        weworkContactStage.setFinalStageId(null);
        weworkContactStage.setStageReasonId(null);
        weworkContactStage.setUpdateBy(Long.valueOf(-1L));
        weworkContactStage.setCreateBy(Long.valueOf(-1L));
        weworkContactStage.setCreateTime(new Date());
        weworkContactStage.setUpdateTime(new Date());
        weworkContactStage.setIsDeleted(Integer.valueOf(0));
        return weworkContactStage;
    }

    private void initContactStage(Long bizId, String corpId) {
        log.info("init contact stage, bizId:{}, corpId:{}", (Object)bizId, (Object)corpId);
        CustomerStage defaultStage = this.customerStageMapper.queryFirstStage(bizId, corpId);
        if (defaultStage == null) {
            log.warn("\u627e\u4e0d\u5230\u8be5\u5546\u6237\u4e0b\u7684\u521d\u59cb\u8ddf\u8fdb\u9636\u6bb5\uff0cbizId:{}, corpId:{}", (Object)bizId, (Object)corpId);
            return;
        }
        ArrayList addList = Lists.newArrayList();
        List stageList = this.weworkContactStageMapper.selectExistStageByCorpId(corpId);
        HashSet stageSet = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty((Collection)stageList)) {
            for (WeworkUserNumContactIdDto it : stageList) {
                String val = it.getWeworkUserNum() + "##" + it.getContactId();
                stageSet.add(val);
            }
        }
        Map weworkUserIdNumMap = this.weworkUserMapper.queryWeworkUserIdNumMapByCorpId(corpId);
        List relationList = this.weworkContactRelationMapper.selectExistRelationByCorpId(corpId);
        if (CollectionUtils.isNotEmpty((Collection)relationList)) {
            for (WeworkUserIdContactIdDto it : relationList) {
                String val;
                String weworkUserId = it.getWeworkUserId();
                String contactId = it.getContactId();
                String weworkUserNum = (String)weworkUserIdNumMap.get(weworkUserId);
                if (weworkUserNum == null || stageSet.contains(val = weworkUserNum + "##" + contactId)) continue;
                addList.add(this.newContactStage(bizId, corpId, weworkUserNum, contactId, defaultStage));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)addList)) {
            log.info("save wework_contact_stage, count:{}", (Object)addList.size());
            Lists.partition((List)addList, (int)200).forEach(list -> this.weworkContactStageMapper.batchInsert(list));
            for (WeworkContactStage stage : addList) {
                this.customerCenterService.pushCustomerStage(stage);
            }
        }
    }

    private void initContactStage(Long bizId, String corpId, String weworkUserId, String contactId) {
        String num = this.weworkUserMapper.getNumByCorpIdAndWeworkUserId(corpId, weworkUserId);
        int count = this.weworkContactStageMapper.countContactStage(corpId, num, contactId);
        if (count <= 0) {
            log.info("initialize wework contact stage, corpId:{}, weworkUserId:{}, contactId:{}", new Object[]{corpId, weworkUserId, contactId});
            CustomerStage defaultStage = this.customerStageMapper.queryFirstStage(bizId, corpId);
            if (defaultStage == null) {
                log.warn("\u627e\u4e0d\u5230\u8be5\u5546\u6237\u4e0b\u7684\u521d\u59cb\u8ddf\u8fdb\u9636\u6bb5\uff0cbizId:{}, corpId:{}", (Object)bizId, (Object)corpId);
                return;
            }
            WeworkContactStage stage = this.newContactStage(bizId, corpId, num, contactId, defaultStage);
            this.weworkContactStageMapper.batchInsert(Collections.singletonList(stage));
            this.customerCenterService.pushCustomerStage(stage);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void modifyExternalContact(String accessToken, String corpId, String userId, String externalUserId, Long timestamp, boolean isAdd, String state) {
        void var36_45;
        String settingValue;
        User user;
        ExternalContactResp result;
        log.info("modify external contact, corpId:{}, userId:{}, externalUserId:{}, timestamp:{} state:{},isAdd:{}", new Object[]{corpId, userId, externalUserId, timestamp, state, isAdd});
        Long bizId = this.businessCustomerMapper.getExistBizId(corpId);
        if (bizId == null) {
            log.warn("bizId is null, corpId:{}", (Object)corpId);
            return;
        }
        try {
            result = this.fetchContactDetail(corpId, externalUserId);
        }
        catch (Exception e) {
            log.error("Failed fetch contact detail, externalUserId:{}", (Object)externalUserId, (Object)e);
            return;
        }
        ExternalContactInfo contact = result.getExternalContact();
        if (contact == null) {
            log.warn("external contact info is null");
            return;
        }
        int weworkUserCount = CollectionUtils.isEmpty((Collection)result.getFollowUserList()) ? 0 : result.getFollowUserList().size();
        this.weworkContactMapper.updateSingleContactWeworkUserCount(corpId, externalUserId, Integer.valueOf(weworkUserCount));
        int newTotal = 0;
        int delTotal = 0;
        List contactRelations = this.weworkContactRelationMapper.queryListByContactId(corpId, externalUserId);
        FollowUser followUser = null;
        if (CollectionUtils.isNotEmpty((Collection)result.getFollowUserList())) {
            if (CollectionUtils.isEmpty((Collection)contactRelations) && NumberUtils.INTEGER_ONE.intValue() == result.getFollowUserList().size()) {
                ++newTotal;
            }
            for (FollowUser it : result.getFollowUserList()) {
                if (!userId.equals(it.getUserId())) continue;
                followUser = it;
                break;
            }
        }
        if (followUser == null) {
            log.warn("follow user is null");
            this.addSaveContactDistinctStatisticData(bizId, newTotal, ++delTotal);
            return;
        }
        if (newTotal > 0) {
            this.addSaveContactDistinctStatisticData(bizId, newTotal, delTotal);
        }
        WeworkContact existContact = this.weworkContactMapper.queryWeworkContact(bizId, corpId, externalUserId);
        WeworkContactRelation existRelation = this.weworkContactRelationMapper.get(corpId, userId, externalUserId);
        List existsTags = this.weworkContactTagMapper.queryContactTags(corpId, userId, externalUserId, Integer.valueOf(0));
        List existsMobiles = this.weworkContactMobileMapper.queryContactMobiles(corpId, userId, externalUserId);
        ReplyContextUtil.get().setNewCustomer(CheckContactUtil.isNewCustomer((WeworkContact)existContact, (Long)timestamp));
        List<Object> addContactList = Collections.emptyList();
        String mobile = null;
        if (CollectionUtils.isNotEmpty((Collection)followUser.getRemarkMobiles())) {
            mobile = (String)followUser.getRemarkMobiles().get(0);
        }
        if (this.diffContact(existContact, contact, mobile)) {
            addContactList = Collections.singletonList(this.newContact(bizId, corpId, contact, timestamp));
        }
        if (CollectionUtils.isNotEmpty(addContactList)) {
            log.info("save contact:{}", (Object)addContactList.size());
            WeworkContact weworkContact = (WeworkContact)addContactList.get(0);
            if (isAdd && StringUtils.isNotBlank((CharSequence)mobile)) {
                weworkContact.setMobile(mobile);
            }
            this.weworkContactMapper.batchInsert(addContactList);
            int followUserSize = CollectionUtils.isEmpty((Collection)result.getFollowUserList()) ? 0 : result.getFollowUserList().size();
            this.weworkContactMapper.updateSingleContactWeworkUserCount(corpId, externalUserId, Integer.valueOf(followUserSize));
        }
        Integer isZombieFans = null;
        if (isAdd) {
            isZombieFans = 0;
        }
        List<Object> addRelationList = Collections.emptyList();
        if (this.diffRelation(existRelation, followUser, isZombieFans)) {
            addRelationList = Collections.singletonList(this.newRelation(bizId, corpId, externalUserId, followUser, isZombieFans));
        }
        if (CollectionUtils.isNotEmpty(addRelationList)) {
            log.info("save contact relation:{}", (Object)addRelationList.size());
            this.weworkContactRelationMapper.batchInsert(addRelationList);
        }
        Map<String, List<WeworkContactTag>> existsTagMap = Collections.emptyMap();
        if (CollectionUtils.isNotEmpty((Collection)existsTags)) {
            existsTagMap = existsTags.stream().collect(Collectors.groupingBy(this::tagKey));
        }
        List<WeworkContactTag> addTagList = this.newTagList(bizId, corpId, externalUserId, followUser, existsTagMap);
        ArrayList delTagList = Collections.emptyList();
        if (!existsTagMap.isEmpty()) {
            delTagList = Lists.newArrayList();
            for (List<WeworkContactTag> it : existsTagMap.values()) {
                delTagList.addAll(it);
            }
        }
        Map<String, List<WeworkContactMobile>> existsMobileMap = Collections.emptyMap();
        if (CollectionUtils.isNotEmpty((Collection)existsMobiles)) {
            existsMobileMap = existsMobiles.stream().collect(Collectors.groupingBy(WeworkContactMobile::getRemarkMobile));
        }
        List<WeworkContactMobile> addMobileList = this.newMobileList(bizId, corpId, externalUserId, followUser, existsMobileMap);
        ArrayList delMobileList = Collections.emptyList();
        if (!existsMobileMap.isEmpty()) {
            delMobileList = Lists.newArrayList();
            for (List<WeworkContactMobile> it : existsMobileMap.values()) {
                delMobileList.addAll(it);
            }
        }
        Long operatorId = -1L;
        if (StringUtils.isNotBlank((CharSequence)userId) && (user = this.userMapper.selectUserByWeworkUserIdAndCorpId(userId, corpId)) != null) {
            operatorId = user.getId();
        }
        List<String> tagIds = null;
        if (CollectionUtils.isNotEmpty(addTagList)) {
            tagIds = addTagList.stream().map(WeworkContactTag::getTagId).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        }
        String weworkUserNum = this.weworkUserMapper.getNumByCorpIdAndWeworkUserId(corpId, followUser.getUserId());
        String channelNum = SysChannelEnum.QY_WEIXIN.getCode();
        log.info("add contact isAdd:{}; weworkUserNum:{};mobile:{}", new Object[]{isAdd, weworkUserNum, mobile});
        if (StringUtils.isNotBlank((CharSequence)weworkUserNum) && isAdd) {
            List telAddFriendTaskDetails = this.telAddFriendTaskDetailMapper.selectByCorpIdWeworkUserNumAndTel(corpId, weworkUserNum, mobile);
            ArrayList needFilterStatus = Lists.newArrayList((Object[])new Integer[]{TelAddFriendStatus.SUCCESS.getStatus(), TelAddFriendStatus.EXPIRE.getStatus()});
            List<String> list = telAddFriendTaskDetails.stream().filter(item -> !needFilterStatus.contains(item.getStatus())).map(TelAddFriendTaskDetail::getTaskNum).collect(Collectors.toList());
            log.info("realTaskDetail:{}", (Object)JSON.toJSONString(list));
            String originChannelNum = this.getOriginChannel(bizId, corpId, list, state);
            if (StringUtils.isNotBlank((CharSequence)originChannelNum)) {
                log.info("modifyExternalContact get origin channelNum: {}", (Object)originChannelNum);
                channelNum = originChannelNum;
            }
        }
        Long channelId = null;
        if (StringUtils.isNotBlank((CharSequence)channelNum)) {
            if (StringUtils.isNotBlank((CharSequence)state) && state.startsWith("AD_")) {
                channelId = this.channelMapper.getIdByNum(bizId, channelNum);
                log.info("\u901a\u8fc7\u5e7f\u544a\u6295\u653e\u52a0\u597d\u53cb\u7684\u56de\u8c03\uff0c\u4ece\u5e7f\u544a\u67e5\u8be2\u7684\u6e20\u9053num\u4e3a:{}\uff0c\u5bf9\u5e94\u7684channelId\u4e3a:{}", (Object)channelNum, (Object)channelId);
            } else {
                channelId = this.channelMapper.querySysChannelId(channelNum);
            }
            ReplyContext ctx = ReplyContextUtil.get();
            if (ctx.getChannelId() == null) {
                ctx.setChannelId(channelId);
            }
        }
        if (CollectionUtils.isNotEmpty(addContactList)) {
            for (WeworkContact weworkContact : addContactList) {
                weworkContact.setChannelNum(channelNum);
                this.customerCenterService.pushContactCustomer(weworkContact);
                if (!StringUtils.isNotEmpty((CharSequence)weworkContact.getMobile())) continue;
                String moduleType = ModuleType.BATCH_ADD_FRIEND.getCode();
                this.customerCenterService.pushAddMobileEvent(weworkContact.getBizId(), weworkContact.getMobile(), moduleType);
                this.customerCenterService.pushMobileCustomer(weworkContact.getBizId(), weworkContact.getMobile(), weworkContact.getName(), tagIds, operatorId, channelId);
                List existMobiles = this.ccCustomerNumService.getMobilesByContactId(bizId, weworkContact.getContactId());
                if (!this.checkMobileBindCustomer(bizId, weworkContact.getMobile()) && CollectionUtils.isEmpty((Collection)existMobiles)) {
                    this.customerCenterService.bindCustomer(weworkContact.getBizId(), weworkContact.getCorpId(), weworkContact.getContactId(), weworkContact.getMobile(), moduleType);
                    continue;
                }
                log.info("save contact bind customer mobile:{} has bind contact", (Object)weworkContact.getMobile());
            }
        }
        if (CollectionUtils.isNotEmpty(addRelationList)) {
            List list = addRelationList.stream().map(a -> new WeworkUserIdContactIdPair(a.getWeworkUserId(), a.getContactId())).collect(Collectors.toList());
            ArrayList arrayList = Lists.newArrayList();
            Lists.partition(list, (int)200).forEach(subList -> {
                List part = this.weworkContactRelationMapper.queryByWeworkUserIdAndContactId(corpId, subList);
                if (CollectionUtils.isNotEmpty((Collection)part)) {
                    weworkContactRelationList.addAll(part);
                }
            });
            for (WeworkContactRelation contactRelation : arrayList) {
                this.customerCenterService.pushContactRelation(contactRelation);
            }
        }
        if (CollectionUtils.isNotEmpty(addMobileList)) {
            log.info("save contact mobile:{}", (Object)addMobileList.size());
            this.weworkContactMobileMapper.batchInsert(addMobileList);
        }
        this.initContactStage(bizId, corpId, userId, externalUserId);
        List addTagIds = null;
        if (CollectionUtils.isNotEmpty(addTagList)) {
            addTagIds = addTagList.stream().map(WeworkContactTag::getTagId).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        }
        Object var36_43 = null;
        if (CollectionUtils.isNotEmpty((Collection)delTagList)) {
            List list = delTagList.stream().map(WeworkContactTag::getTagId).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        }
        if (StringUtils.isEmpty((CharSequence)(settingValue = this.settingService.getSettingDetail(bizId, SettingEnum.TAG_SYNC.getName()))) || settingValue.equals("0")) {
            log.info("handleExternalCallBackTags \u4f01\u4e1a\u672a\u5f00\u901a\u6807\u7b7e\u540c\u6b65\uff0c bizId: {}", (Object)bizId);
            if (CollectionUtils.isNotEmpty(addTagList)) {
                log.info("save contact tag:{}", (Object)addTagList.size());
                this.weworkContactTagMapper.batchInsert(addTagList);
            }
            if (CollectionUtils.isNotEmpty((Collection)delTagList)) {
                Set ids = delTagList.stream().map(WeworkContactTag::getId).collect(Collectors.toSet());
                log.info("delete contact tag size:{}, ids:{}", (Object)ids.size(), ids);
                this.weworkContactTagMapper.logicDeleteByIds(ids, Long.valueOf(-1L));
            }
            this.contactOpService.updateTagCount(corpId, userId, externalUserId);
        } else if (CollectionUtils.isNotEmpty(addTagIds) || CollectionUtils.isNotEmpty((Collection)var36_45)) {
            this.contactTagSyncService.handleExternalCallBackTags(bizId, corpId, addTagIds, (List)var36_45, externalUserId, result);
        }
        WeworkContact weworkContact = this.weworkContactMapper.queryWeworkContact(bizId, corpId, externalUserId);
        String customerNum = weworkContact.getCustomerNum();
        if (StringUtils.isEmpty((CharSequence)customerNum)) {
            this.customerCenterService.pushContactCustomer(weworkContact);
            customerNum = weworkContact.getCustomerNum();
        }
        this.customerCenterService.pushTagRelation(bizId, weworkUserNum, customerNum, addTagIds, (List)var36_45);
        if (CollectionUtils.isNotEmpty((Collection)delMobileList)) {
            Set ids = delMobileList.stream().map(WeworkContactMobile::getId).collect(Collectors.toSet());
            log.info("delete contact mobile size:{}, ids:{}", (Object)ids.size(), ids);
            this.weworkContactMobileMapper.logicDeleteByIds(ids, Long.valueOf(-1L));
        }
        if (CollectionUtils.isNotEmpty((Collection)followUser.getRemarkMobiles())) {
            log.info("\u540c\u6b65\u5907\u6ce8\u624b\u673a\u53f7, bizId:{}, contactId:{}, remarkMobiles:{}", new Object[]{bizId, externalUserId, followUser.getRemarkMobiles()});
            RemarkMobileSyncDto params = new RemarkMobileSyncDto();
            params.setBizId(bizId);
            params.setCorpId(corpId);
            params.setContactId(externalUserId);
            params.setCustomerNum(customerNum);
            params.setRemarkMobile(followUser.getRemarkMobiles());
            params.setWeworkUserId(userId);
            params.setName(contact.getName());
            params.setRemark(followUser.getRemark());
            params.setTagIds(tagIds);
            params.setAllocUserId(operatorId);
            params.setChannelId(channelId);
            try {
                this.remarkMobileSyncService.doSync(params);
            }
            catch (Exception e) {
                log.error("modMobile error: ", (Throwable)e);
            }
        }
    }

    private String getOriginChannel(Long bizId, String corpId, List<String> realTaskDetail, String state) {
        Long channelId;
        MarketingQrcode mkQrcode;
        TelAddFriendTask telAddFriendTask;
        String channelNum = null;
        if (CollectionUtils.isNotEmpty(realTaskDetail) && Objects.nonNull(telAddFriendTask = this.telAddFriendTaskMapper.selectByNum(realTaskDetail.get(0))) && StringUtils.isNotBlank((CharSequence)telAddFriendTask.getChannelNums())) {
            channelNum = telAddFriendTask.getChannelNums();
        }
        if (StringUtils.isNotBlank((CharSequence)state) && state.startsWith("AD_")) {
            try {
                String adCardPoolDetailNum = state.split("AD_")[1];
                String adChannelNum = this.intoLeadsPoolService.getLeadsChannelNumByCardPoolDetailNum(bizId, adCardPoolDetailNum);
                if (StringUtils.isNotBlank((CharSequence)adChannelNum)) {
                    channelNum = adChannelNum;
                }
            }
            catch (Exception e) {
                log.error("ad leads get ad channelNum error", (Throwable)e);
            }
        } else if (StringUtils.isNotBlank((CharSequence)state) && (mkQrcode = this.marketingQrcodeMapper.queryMarketingQrcodeByState(bizId, corpId, state)) != null && (channelId = mkQrcode.getChannelId()) != null && channelId != -1L) {
            channelNum = this.channelMapper.getNumById(channelId);
        }
        return channelNum;
    }

    private boolean checkMobileBindCustomer(Long bizId, String mobile) {
        log.info("checkMobileBindCustomer bizId: {}, mobile: {}", (Object)bizId, (Object)mobile);
        boolean ret = false;
        String customerNum = this.ccCustomerNumService.getCustomerNumByMobile(bizId, mobile);
        if (StringUtils.isBlank((CharSequence)customerNum)) {
            log.info("checkMobileBindCustomer customerNum is empty");
            return false;
        }
        String contactId = this.ccCustomerNumService.getWeworkContactId(bizId, customerNum);
        log.info("checkMobileBindCustomer contactId: {}, customerNum: {}", (Object)contactId, (Object)customerNum);
        if (StringUtils.isNotBlank((CharSequence)contactId)) {
            ret = true;
        }
        return ret;
    }

    public void makeCrmLeads(String corpId, Long bizId, String mobile, Long userId, String name, List<String> tagIds, String contactId, CustomerDetailResp detailResp) {
        log.info("make crm leads, corpId:{}, mobile:{}", (Object)corpId, (Object)mobile);
        CrmLeadsInfoResp existsLeads = this.contactCenterService.checkAndGetCrmLeads(bizId, corpId, detailResp, mobile);
        CrmLeadsInfoResp newLeads = this.contactCenterService.getCrmLeadsInfo(bizId, corpId, mobile);
        if (existsLeads != null && newLeads != null) {
            if (!Objects.equals(existsLeads.getId(), newLeads.getId())) {
                log.warn("\u624b\u673a\u53f7\u7ebf\u7d22\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u7ebf\u7d22\u624b\u673a\u53f7\u3002bizId:{}, mobile:{}", (Object)bizId, (Object)mobile);
                if (StringUtils.isBlank((CharSequence)existsLeads.getMobile1())) {
                    log.info("\u628a\u65b0\u5907\u6ce8\u624b\u673a\u53f7\uff0c\u586b\u5145\u5230\u7ebf\u7d22\u7684mobile1\u5b57\u6bb5\u4e0a\u3002");
                    this.modCrmLeadsMobile(corpId, existsLeads.getNum(), existsLeads.getMobile(), mobile);
                } else {
                    log.warn("\u7ebf\u7d22\u7684mobile1\u5b57\u6bb5\u5df2\u5b58\u5728\uff0c\u5ffd\u7565\u65b0\u5907\u6ce8\u7684\u624b\u673a\u53f7\u3002");
                }
            } else {
                this.modCrmLeadsMobile(corpId, existsLeads.getNum(), mobile, null);
            }
        } else if (existsLeads != null) {
            this.modCrmLeadsMobile(corpId, existsLeads.getNum(), mobile, null);
        } else if (newLeads != null) {
            this.modCrmLeadsMobile(corpId, newLeads.getNum(), mobile, null);
        }
        this.addCrmLeads(bizId, corpId, mobile, name, tagIds, userId, contactId);
    }

    private void addCrmLeads(Long bizId, String corpId, String mobile, String name, List<String> tagIds, Long userId, String contactId) {
        log.info("add crm leads, corpId:{}, mobile:{}, name: {}, tagIds: {}", new Object[]{corpId, mobile, name, tagIds});
        CustomerDetailResp customerDetail = this.ccCustomerNumService.getCustomerDetailByType(bizId, contactId);
        Long channelId = null;
        if (customerDetail != null && customerDetail.getChannelId() != null) {
            channelId = this.channelMapper.getIdByNum(bizId, customerDetail.getChannelId());
        }
        if (channelId == null) {
            channelId = this.channelMapper.querySysChannelId(SysChannelEnum.QY_WEIXIN.getCode());
        }
        CrmLeadsReq crmLeadsReq = new CrmLeadsReq();
        crmLeadsReq.setCorpId(corpId);
        crmLeadsReq.setMobile(mobile);
        crmLeadsReq.setName(name);
        crmLeadsReq.setTagIds(tagIds);
        crmLeadsReq.setCreatorId(Long.valueOf(-1L));
        crmLeadsReq.setSourceType(Integer.valueOf(SourceType.SCRM_SYNC.getValue()));
        crmLeadsReq.setChannelId(channelId);
        crmLeadsReq.setAllocUserId(userId);
        try {
            this.crmLeadsService.addLeads(crmLeadsReq);
        }
        catch (Exception e) {
            log.error("addCrmLeads,crmLeadsReq:{}\u53d1\u751f\u5f02\u5e38", (Object)crmLeadsReq, (Object)e);
        }
    }

    private void modCrmLeadsMobile(String corpId, String leadsNum, String mobile, String mobile1) {
        log.info("mod crm leads mobile, corpId:{}, leadsNum:{}, mobile:{}, mobile1:{}", new Object[]{corpId, leadsNum, mobile, mobile1});
        CrmModMobileReq req = new CrmModMobileReq();
        req.setCorpId(corpId);
        req.setLeadsNum(leadsNum);
        req.setMobile(mobile);
        req.setMobile1(mobile1);
        try {
            this.crmLeadsService.modMobiles(req);
        }
        catch (Exception e) {
            log.error("modCrmLeadsMobile,req:{}\u53d1\u751f\u5f02\u5e38:", (Object)req, (Object)e);
        }
    }

    @Override
    public void delExternalContact(String corpId, String userId, String externalUserId, Long timestamp) {
        WeworkContact weworkContact;
        Long bizId = this.businessCustomerMapper.getExistBizId(corpId);
        if (bizId == null) {
            log.warn("bizId is null, corpId:{}", (Object)corpId);
            return;
        }
        WeworkContactRelation exist = this.weworkContactRelationMapper.get(corpId, userId, externalUserId);
        if (exist == null) {
            log.warn("wework contact relation not exist, corpId:{}, weworkUserId:{}, contactId:{}", new Object[]{corpId, userId, externalUserId});
            return;
        }
        if (NumberUtils.INTEGER_ZERO.equals(exist.getIsZombieFans()) && (weworkContact = this.weworkContactMapper.queryContactByContactId(corpId, externalUserId)) != null) {
            int weworkUserCount = weworkContact.getWeworkUserCount();
            weworkUserCount = weworkUserCount > 1 ? weworkUserCount - 1 : 0;
            weworkContact.setWeworkUserCount(Integer.valueOf(weworkUserCount));
            this.weworkContactMapper.updateByPrimaryKey((Object)weworkContact);
            if (weworkUserCount == 0) {
                this.addSaveContactDistinctStatisticData(bizId, 0, 1);
            }
        }
        Date deletedTime = new Date(timestamp * 1000L);
        WeworkContactRelation weworkContactRelation = new WeworkContactRelation();
        weworkContactRelation.setId(exist.getId());
        weworkContactRelation.setIsDeleted(Integer.valueOf(1));
        weworkContactRelation.setUpdateBy(Long.valueOf(-1L));
        weworkContactRelation.setDeletedTime(deletedTime);
        weworkContactRelation.setUpdateTime(new Date());
        this.weworkContactRelationMapper.updateByPrimaryKeySelective((Object)weworkContactRelation);
        exist.setIsDeleted(Integer.valueOf(1));
        exist.setDeletedTime(deletedTime);
        this.customerCenterService.pushContactRelation(exist);
        this.weworkContactMobileMapper.delAllMobiles(corpId, Long.valueOf(-1L), exist.getWeworkUserId(), externalUserId);
        try {
            this.delContactCallbackService.callbackEventToMarketingMaterialApplet(bizId, deletedTime, externalUserId, exist.getWeworkUserId());
        }
        catch (Exception e) {
            log.error("delContactCallbackService callbackEventToMarketingMaterialApplet error", (Throwable)e);
        }
    }

    @Override
    public void delFollowUser(String corpId, String userId, String externalUserId, Long timestamp) {
        WeworkContact weworkContact;
        Long bizId = this.businessCustomerMapper.getExistBizId(corpId);
        if (bizId == null) {
            log.warn("bizId is null, corpId:{}", (Object)corpId);
            return;
        }
        WeworkContactRelation exist = this.weworkContactRelationMapper.get(corpId, userId, externalUserId);
        if (exist == null) {
            log.warn("wework contact relation not exist, corpId:{}, weworkUserId:{}, contactId:{}", new Object[]{corpId, userId, externalUserId});
            return;
        }
        if (NumberUtils.INTEGER_ZERO.equals(exist.getIsDeleted()) && (weworkContact = this.weworkContactMapper.queryContactByContactId(corpId, externalUserId)) != null) {
            int weworkUserCount = weworkContact.getWeworkUserCount();
            weworkUserCount = weworkUserCount > 1 ? weworkUserCount - 1 : 0;
            weworkContact.setWeworkUserCount(Integer.valueOf(weworkUserCount));
            this.weworkContactMapper.updateByPrimaryKey((Object)weworkContact);
            if (weworkUserCount == 0) {
                this.addSaveContactDistinctStatisticData(bizId, 0, 1);
            }
        }
        WeworkContactRelation relation = new WeworkContactRelation();
        relation.setId(exist.getId());
        relation.setIsZombieFans(Integer.valueOf(1));
        relation.setZombieFansTime(new Date());
        relation.setUpdateBy(Long.valueOf(-1L));
        relation.setUpdateTime(new Date());
        this.weworkContactRelationMapper.updateByPrimaryKeySelective((Object)relation);
        WeworkUser weworkUser = this.weworkUserMapper.queryByWeworkUserId(corpId, userId);
        WeworkContactLog contactLog = new WeworkContactLog();
        contactLog.setBizId(bizId);
        contactLog.setCorpId(corpId);
        contactLog.setContactId(externalUserId);
        if (weworkUser != null) {
            contactLog.setWeworkUserNum(weworkUser.getNum());
            contactLog.setName(weworkUser.getName());
        }
        contactLog.setIsDeleted(Integer.valueOf(1));
        contactLog.setDeletedTime(new Date());
        contactLog.setCreateTime(new Date());
        this.weworkContactLogMapper.insertSelective((Object)contactLog);
        try {
            this.delContactCallbackService.callbackEventToMarketingMaterialApplet(bizId, new Date(), externalUserId, exist.getWeworkUserId());
        }
        catch (Exception e) {
            log.error("delContactCallbackService callbackEventToMarketingMaterialApplet error", (Throwable)e);
        }
    }

    private void addSaveContactDistinctStatisticData(Long bizId, Integer newTotal, Integer delTotal) {
        log.info("addSaveContactDistinctStatisticData,newTotal:{}, delTotal:{}", (Object)newTotal, (Object)delTotal);
        Date curDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(curDate);
        ContactDistinctStatisticRecord statisticRecord = new ContactDistinctStatisticRecord();
        statisticRecord.setNum(this.idGen.getNum());
        statisticRecord.setBizId(bizId);
        statisticRecord.setYear(Integer.valueOf(calendar.get(1)));
        statisticRecord.setMonth(Integer.valueOf(calendar.get(2) + 1));
        statisticRecord.setWeek(Integer.valueOf(calendar.get(3)));
        statisticRecord.setStatisticDate((Date)DateUtil.beginOfDay((Date)curDate));
        statisticRecord.setTotal(NumberUtils.INTEGER_ZERO);
        statisticRecord.setNewTotal(newTotal);
        statisticRecord.setDelTotal(delTotal);
        statisticRecord.setCreateTime(curDate);
        statisticRecord.setUpdateTime(curDate);
        this.contactDistinctStatisticRecordMapper.insertOrUpdate(statisticRecord);
    }
}

