/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.synctask.service.impl;

import cn.kinyun.wework.sdk.api.AgentApi;
import cn.kinyun.wework.sdk.api.CustomizedApi;
import cn.kinyun.wework.sdk.api.UserApi;
import cn.kinyun.wework.sdk.entity.agent.Agent;
import cn.kinyun.wework.sdk.entity.agent.AllowPartys;
import cn.kinyun.wework.sdk.entity.agent.AllowUser;
import cn.kinyun.wework.sdk.entity.agent.AllowUserInfos;
import cn.kinyun.wework.sdk.entity.contact.user.UserInfo;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.CustomizedAppDevStatus;
import com.kuaike.scrm.common.enums.WeworkUserSyncStatus;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.synctask.service.CustomizedSyncService;
import com.kuaike.scrm.synctask.service.SyncTaskService;
import com.kuaike.scrm.synctask.service.enums.SyncTaskType;
import com.kuaike.scrm.system.service.UserService;
import com.kuaike.scrm.token.service.CustomizedTokenService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.apache.curator.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomizedSyncServiceImpl
implements CustomizedSyncService {
    private static final Logger log = LoggerFactory.getLogger(CustomizedSyncServiceImpl.class);
    @Autowired
    @Qualifier(value="synctaskThreadPool")
    private ExecutorService executorService;
    @Autowired
    private UserApi userApi;
    @Autowired
    private AgentApi agentApi;
    @Autowired
    private CustomizedApi customizedApi;
    @Autowired
    private CustomizedTokenService customizedTokenService;
    @Autowired
    private SyncTaskService syncTaskService;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private UserService userService;

    @Override
    public Long sync() {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"user not login");
        Long bizId = user.getBizId();
        String corpId = user.getCorpId();
        Long operatorId = user.getId();
        Integer devStatus = this.customizedTokenService.getAuthStatus(bizId);
        if (devStatus == null) {
            log.warn("\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, corpId={}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528");
        }
        if (devStatus.intValue() != CustomizedAppDevStatus.DONE.getValue()) {
            log.warn("\u4f01\u4e1a\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528\u914d\u7f6e\u672a\u5b8c\u6210, corpId={}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528\u914d\u7f6e\u672a\u5b8c\u6210");
        }
        return this.syncTaskService.start(bizId, corpId, SyncTaskType.CUSTOMIZED_APP, operatorId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void fetch(String corpId) {
        List userList;
        Agent agent;
        log.info("fetch customized agent, corpId:{}", (Object)corpId);
        Long bizId = this.businessCustomerMapper.getBizId(corpId);
        if (bizId == null) {
            log.warn("bizId is null, corpId:{}", (Object)corpId);
            return;
        }
        log.info("get customized agent user list, corpId:{}", (Object)corpId);
        String accessToken = this.customizedTokenService.getAgentAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, corpId:{}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528");
        }
        Integer agentId = this.customizedTokenService.getAgentId(corpId);
        if (agentId == null) {
            log.warn("\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, corpId:{}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528");
        }
        try {
            agent = this.agentApi.getAgent(accessToken, agentId);
            log.info("Fetch customized agent:{}", (Object)agent);
        }
        catch (WeworkException e) {
            log.error("{}, corpId:{}", (Object)e.getMessage(), (Object)corpId);
            throw e;
        }
        catch (Exception e) {
            log.error("Fetch customized agent failed.", (Throwable)e);
            throw e;
        }
        List<String> userIds = Collections.emptyList();
        AllowUserInfos allowUserInfos = agent.getAllowUserInfos();
        if (allowUserInfos != null && CollectionUtils.isNotEmpty((Collection)(userList = allowUserInfos.getUserList()))) {
            userIds = userList.stream().map(AllowUser::getUserId).collect(Collectors.toList());
        }
        List deptIds = Collections.emptyList();
        AllowPartys allowPartys = agent.getAllowPartys();
        if (allowPartys != null && CollectionUtils.isNotEmpty((Collection)allowPartys.getPartyIdList())) {
            deptIds = allowPartys.getPartyIdList();
        }
        ArrayList fetchUserList = Lists.newArrayList();
        HashSet fetchUserIds = Sets.newHashSet();
        for (String userId : userIds) {
            if (fetchUserIds.contains(userId)) continue;
            fetchUserIds.add(userId);
            fetchUserList.add(userId);
        }
        for (Integer deptId : deptIds) {
            List<UserInfo> list;
            try {
                list = this.userApi.list(accessToken, deptId, Integer.valueOf(1));
                if (list == null) {
                    list = Collections.emptyList();
                }
                log.info("fetch user list, deptId:{}, count:{}", (Object)deptId, (Object)list.size());
            }
            catch (WeworkException e) {
                log.error("{}, deptId:{}", (Object)e.getMessage(), (Object)deptId);
                throw e;
            }
            catch (Exception e) {
                log.error("fetch user list failed, deptId:{}", (Object)deptId, (Object)e);
                throw e;
            }
            for (UserInfo u : list) {
                if (fetchUserIds.contains(u.getUserId())) continue;
                fetchUserIds.add(u.getUserId());
                fetchUserList.add(u.getUserId());
            }
        }
        fetchUserList.sort(String::compareTo);
        this.updateAgentAuth(corpId, fetchUserList);
    }

    private void updateAgentAuth(String corpId, List<String> userIds) {
        List weworkUsers;
        List existUserIds = this.weworkUserMapper.getWeworkUserIds(corpId);
        if (CollectionUtils.isNotEmpty(userIds) && CollectionUtils.isNotEmpty((Collection)existUserIds)) {
            for (String userId : userIds) {
                existUserIds.remove(userId);
            }
        }
        log.info("update agent auth, corpId:{}, userIds:{}, existIds:{}", new Object[]{corpId, userIds, existUserIds});
        if (CollectionUtils.isNotEmpty(userIds)) {
            this.weworkUserMapper.updateAgentAuth(corpId, userIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)existUserIds)) {
            this.weworkUserMapper.updateAgentDeauth(corpId, (Collection)existUserIds);
        }
        if (CollectionUtils.isNotEmpty(userIds) && CollectionUtils.isNotEmpty((Collection)(weworkUsers = this.weworkUserMapper.queryAuthListByWeworkUserId(corpId, userIds)))) {
            List weworkUserIds = weworkUsers.stream().map(WeworkUser::getWeworkUserId).collect(Collectors.toList());
            log.info("updateAgentAuth: \u6210\u5458\u8f6c\u5316\u4e3a\u7528\u6237, corpId:{}, weworkUserIds\uff1a{}", (Object)corpId, weworkUserIds);
            for (WeworkUser weworkUser : weworkUsers) {
                if (weworkUser.getSyncStatus().intValue() != WeworkUserSyncStatus.SYNCHRONIZED.getValue()) continue;
                this.userService.insertUser(weworkUser, false);
            }
        }
    }
}

