/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.synctask.service.impl;

import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.AgentIdConvertDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.CustomizedAppDevStatus;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.agent.entity.AgentToken;
import com.kuaike.scrm.dal.agent.mapper.AgentTokenMapper;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.synctask.service.AgentIdConvertSyncService;
import com.kuaike.scrm.synctask.service.SyncTaskService;
import com.kuaike.scrm.synctask.service.enums.SyncTaskType;
import com.kuaike.scrm.token.service.CustomizedTokenService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;

@Service
public class AgentIdConvertSyncServiceImpl
implements AgentIdConvertSyncService {
    private static final Logger log = LoggerFactory.getLogger(AgentIdConvertSyncServiceImpl.class);
    @Value(value="${kafka.topic.agent_id_convert}")
    private String topic;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Autowired
    private SyncTaskService syncTaskService;
    @Autowired
    private CustomizedTokenService customizedTokenService;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private AgentTokenMapper agentTokenMapper;

    @Override
    public Long sync() {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"user not login");
        Long bizId = user.getBizId();
        String corpId = user.getCorpId();
        Long operatorId = user.getId();
        Integer devStatus = this.customizedTokenService.getAuthStatus(bizId);
        if (devStatus == null) {
            log.warn("\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, corpId={}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528");
        }
        if (devStatus.intValue() != CustomizedAppDevStatus.DONE.getValue()) {
            log.warn("\u4f01\u4e1a\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528\u914d\u7f6e\u672a\u5b8c\u6210, corpId={}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528\u914d\u7f6e\u672a\u5b8c\u6210");
        }
        AgentToken agentToken = this.agentTokenMapper.queryByBizId(bizId);
        if (agentToken == null) {
            log.warn("\u4f01\u4e1a\u672a\u914d\u7f6e\u81ea\u5efa\u5e94\u7528");
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u672a\u914d\u7f6e\u81ea\u5efa\u5e94\u7528");
        }
        return this.syncTaskService.start(bizId, corpId, SyncTaskType.AGENT_ID_CONVERT, operatorId);
    }

    @Override
    public void sync(String corpId) {
        Long bizId = this.businessCustomerMapper.getExistBizId(corpId);
        AgentToken token = this.agentTokenMapper.queryByBizId(bizId);
        if (token == null) {
            log.info("\u672a\u914d\u7f6e\u81ea\u5efa\u5e94\u7528");
            return;
        }
        this.syncTaskService.start(bizId, corpId, SyncTaskType.AGENT_ID_CONVERT, -1L);
    }

    @Override
    public void syncUserId(String corpId, String userId) {
        Long bizId = this.businessCustomerMapper.getExistBizId(corpId);
        AgentToken token = this.agentTokenMapper.queryByBizId(bizId);
        if (token == null) {
            log.info("\u672a\u914d\u7f6e\u81ea\u5efa\u5e94\u7528");
            return;
        }
        log.info("send agent_id_convert, taskId:{}, corpId:{}, userId:{}", new Object[]{bizId, corpId, userId});
        AgentIdConvertDto dto = new AgentIdConvertDto();
        dto.setBizId(bizId);
        dto.setCorpId(corpId);
        dto.setUserId(userId);
        String json = JacksonUtil.obj2Str((Object)dto);
        try {
            this.kafkaTemplate.send(this.topic, (Object)corpId, (Object)json);
            log.info("send kafka: {}", (Object)json);
        }
        catch (Exception e) {
            log.error("send kafka failed: {}\n", (Object)json, (Object)e);
        }
    }

    @Override
    public void syncExternalUserId(String corpId, String externalUserId) {
        Long bizId = this.businessCustomerMapper.getExistBizId(corpId);
        AgentToken token = this.agentTokenMapper.queryByBizId(bizId);
        if (token == null) {
            return;
        }
        log.info("send agent_id_convert, bizId:{}, corpId:{}, externalUserId:{}", new Object[]{bizId, corpId, externalUserId});
        AgentIdConvertDto dto = new AgentIdConvertDto();
        dto.setBizId(bizId);
        dto.setCorpId(corpId);
        dto.setExternalUserId(externalUserId);
        String json = JacksonUtil.obj2Str((Object)dto);
        try {
            this.kafkaTemplate.send(this.topic, (Object)corpId, (Object)json);
            log.info("send kafka: {}", (Object)json);
        }
        catch (Exception e) {
            log.error("send kafka failed: {}\n", (Object)json, (Object)e);
        }
    }
}

