/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.synctask.service.impl;

import cn.kinyun.wework.sdk.api.external.MassMsgPushApi;
import cn.kinyun.wework.sdk.api.external.MassMsgPushClient;
import cn.kinyun.wework.sdk.entity.external.massmsg.MassMsgInfo;
import cn.kinyun.wework.sdk.entity.external.massmsg.MassMsgListParams;
import cn.kinyun.wework.sdk.entity.external.massmsg.MassMsgListResp;
import cn.kinyun.wework.sdk.entity.external.massmsg.MassMsgSendInfo;
import cn.kinyun.wework.sdk.entity.external.massmsg.MassMsgTask;
import cn.kinyun.wework.sdk.entity.external.massmsg.MassMsgTaskResult;
import cn.kinyun.wework.sdk.entity.external.massmsg.MassMsgUserTask;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.CustomizedAppDevStatus;
import com.kuaike.scrm.common.enums.GroupSendTaskType;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.common.utils.ThreadPoolMonitorUtils;
import com.kuaike.scrm.dal.accesstoken.entity.CorpCustomizedToken;
import com.kuaike.scrm.dal.accesstoken.mapper.CorpCustomizedTokenMapper;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.groupsend.entity.WeworkGroupMsg;
import com.kuaike.scrm.dal.groupsend.entity.WeworkGroupMsgResult;
import com.kuaike.scrm.dal.groupsend.entity.WeworkGroupMsgStat;
import com.kuaike.scrm.dal.groupsend.entity.WeworkGroupMsgTask;
import com.kuaike.scrm.dal.groupsend.mapper.MessageGroupSendDetailMapper;
import com.kuaike.scrm.dal.groupsend.mapper.WeworkGroupMsgMapper;
import com.kuaike.scrm.dal.groupsend.mapper.WeworkGroupMsgResultMapper;
import com.kuaike.scrm.dal.groupsend.mapper.WeworkGroupMsgStatMapper;
import com.kuaike.scrm.dal.groupsend.mapper.WeworkGroupMsgTaskMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.synctask.service.GroupMsgSyncService;
import com.kuaike.scrm.synctask.service.SyncTaskService;
import com.kuaike.scrm.synctask.service.enums.SyncTaskStatus;
import com.kuaike.scrm.synctask.service.enums.SyncTaskType;
import com.kuaike.scrm.token.service.CustomizedTokenService;
import com.kuaike.trace.utils.TraceExecutorWrapUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class GroupMsgSyncServiceImpl
implements GroupMsgSyncService {
    private static final Logger log = LoggerFactory.getLogger(GroupMsgSyncServiceImpl.class);
    private static final String SINGLE = "single";
    private static final String GROUP = "group";
    @Value(value="${qyapi.customized.id}")
    private String customizedId;
    @Autowired
    @Qualifier(value="syncGroupMsgThreadPool")
    private ExecutorService executorService;
    @Autowired
    private MassMsgPushClient massMsgPushClient;
    @Autowired
    private MassMsgPushApi massMsgPushApi;
    @Autowired
    private CustomizedTokenService customizedTokenService;
    @Autowired
    private SyncTaskService syncTaskService;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private WeworkGroupMsgMapper weworkGroupMsgMapper;
    @Autowired
    private WeworkGroupMsgTaskMapper weworkGroupMsgTaskMapper;
    @Autowired
    private WeworkGroupMsgResultMapper weworkGroupMsgResultMapper;
    @Autowired
    private WeworkGroupMsgStatMapper weworkGroupMsgStatMapper;
    @Autowired
    private CorpCustomizedTokenMapper corpCustomizedTokenMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Resource
    private MessageGroupSendDetailMapper messageGroupSendDetailMapper;
    private static final int DEQUE_LEN = 300;
    private ExecutorService fetchGroupMsgExecutorService = new ThreadPoolExecutor(2, 5, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(300), (ThreadFactory)new NamedThreadFactory("fetch-GroupMsg-Executor"));

    @PostConstruct
    public void init() {
        ThreadPoolMonitorUtils.addToMonitor((ExecutorService)this.fetchGroupMsgExecutorService);
    }

    @Override
    public void startAll() {
        log.info("start sync group msg task");
        List corpList = this.weworkCorpMapper.selectAllAuthed();
        if (CollectionUtils.isEmpty((Collection)corpList)) {
            log.info("no authed corp found");
            return;
        }
        List corpIds = corpList.stream().map(WeworkCorp::getCorpId).collect(Collectors.toList());
        List corpCustomizedTokenList = this.corpCustomizedTokenMapper.getByCorpIds(corpIds, this.customizedId);
        if (CollectionUtils.isEmpty((Collection)corpCustomizedTokenList)) {
            log.info("no authed customized app");
            return;
        }
        Map corpCustomizedTokenMap = corpCustomizedTokenList.stream().collect(Collectors.toMap(CorpCustomizedToken::getCorpId, Function.identity()));
        for (WeworkCorp corp : corpList) {
            Long bizId = corp.getBizId();
            String corpId = corp.getCorpId();
            log.info("\u540c\u6b65 groupMessage corp :{}; bizId:{}", (Object)corpId, (Object)bizId);
            TraceExecutorWrapUtil.wrapExecute((Executor)this.fetchGroupMsgExecutorService, () -> this.fetchByCorpId(corpId, corpCustomizedTokenMap, bizId));
        }
    }

    private void fetchByCorpId(String corpId, Map<String, CorpCustomizedToken> corpCustomizedTokenMap, Long bizId) {
        Long lastRunningTaskId = this.syncTaskService.getLastRunningTask(corpId, SyncTaskType.GROUP_MSG);
        if (Objects.nonNull(lastRunningTaskId)) {
            log.info("\u5f53\u524d\u7c7b\u578b\u6709\u4efb\u52a1\u5728\u5728\u6267\u884c\u4e2d\uff0c\u5f53\u524d\u4efb\u52a1\u4e22\u5f03 corpId:{} taskType:{} taskId:{}", new Object[]{corpId, SyncTaskType.GROUP_MSG, lastRunningTaskId});
            return;
        }
        CorpCustomizedToken customizedToken = corpCustomizedTokenMap.get(corpId);
        if (customizedToken == null || customizedToken.getIsAuth() == 0 || customizedToken.getDevStatus().intValue() != CustomizedAppDevStatus.DONE.getValue()) {
            log.warn("\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, \u4e0d\u6267\u884c\u6570\u636e\u540c\u6b65\uff0ccorpId={}", (Object)corpId);
            return;
        }
        Long taskId = null;
        Long cost = 0L;
        try {
            taskId = this.syncTaskService.startWithOutMq(bizId, corpId, SyncTaskType.GROUP_MSG, -1L, SyncTaskStatus.RUNNING);
            long startTime = System.currentTimeMillis();
            this.fetch(corpId);
            long endTime = System.currentTimeMillis();
            cost = endTime - startTime;
            this.syncTaskService.success(taskId, cost.intValue());
        }
        catch (Exception e) {
            log.error("errorMsg:{}", (Object)e.getMessage());
            this.syncTaskService.failed(taskId, e.getMessage());
        }
    }

    @Override
    public Long sync() {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"user not login");
        Long bizId = user.getBizId();
        String corpId = user.getCorpId();
        Long operatorId = user.getId();
        Integer devStatus = this.customizedTokenService.getAuthStatus(bizId);
        if (devStatus == null) {
            log.warn("\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, corpId={}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528");
        }
        if (devStatus.intValue() != CustomizedAppDevStatus.DONE.getValue()) {
            log.warn("\u4f01\u4e1a\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528\u914d\u7f6e\u672a\u5b8c\u6210, corpId={}", (Object)corpId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528\u914d\u7f6e\u672a\u5b8c\u6210");
        }
        return this.syncTaskService.start(bizId, corpId, SyncTaskType.GROUP_MSG, operatorId);
    }

    @Override
    public void fetch(String corpId) {
        log.info("fetch group msg, corpId:{}", (Object)corpId);
        Long bizId = this.businessCustomerMapper.getBizId(corpId);
        if (bizId == null) {
            log.warn("bizId is null, corpId:{}", (Object)corpId);
            return;
        }
        Date endTime = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(endTime);
        cal.add(5, -30);
        Date startTime = cal.getTime();
        Set msgIds = this.messageGroupSendDetailMapper.selectUnFetchMsgId(bizId, Integer.valueOf(GroupSendTaskType.QYAPI.getValue()), startTime, endTime);
        log.info("all msgIds, corpId={}, msgIds={}", (Object)corpId, (Object)msgIds);
        ArrayList fetchTasks = Lists.newArrayList();
        ArrayList exceptions = Lists.newArrayList();
        for (String msgId : msgIds) {
            Callable task = TraceExecutorWrapUtil.wrap(() -> {
                try {
                    this.fetch(bizId, corpId, msgId);
                }
                catch (Exception e) {
                    List list = exceptions;
                    synchronized (list) {
                        exceptions.add(e);
                    }
                }
                return null;
            });
            fetchTasks.add(task);
        }
        try {
            this.executorService.invokeAll(fetchTasks);
        }
        catch (InterruptedException e) {
            log.error("invoke sync task failed", (Throwable)e);
            Thread.currentThread().interrupt();
            exceptions.add(new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u62c9\u53d6\u6570\u636e\u5931\u8d25:" + e.getMessage()));
        }
        TraceExecutorWrapUtil.wrapCompletableFutureRunAsync(() -> this.statistic(bizId, corpId));
        if (CollectionUtils.isNotEmpty((Collection)exceptions)) {
            log.info("fetch group msg error:{}", (Object)exceptions.size());
            Exception e = (Exception)exceptions.get(0);
            if (e instanceof BusinessException) {
                throw (BusinessException)e;
            }
            if (e instanceof WeworkException) {
                throw (WeworkException)((Object)e);
            }
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u62c9\u53d6\u6570\u636e\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
    }

    public void fetch(Long bizId, String corpId, String msgId) {
        log.info("\u62c9\u53d6\u7fa4\u53d1\u8be6\u60c5, bizId={}, corpId={}, msgId={}", new Object[]{bizId, corpId, msgId});
        Date now = new Date();
        ArrayList groupMsgTaskAddList = Lists.newArrayList();
        ArrayList groupMsgResultAddList = Lists.newArrayList();
        String keyFormat = "%s:%s:%s";
        List existTasks = this.weworkGroupMsgTaskMapper.queryByMsgId(corpId, msgId);
        Map<Object, Object> taskStatusMap = Collections.emptyMap();
        if (CollectionUtils.isNotEmpty((Collection)existTasks)) {
            taskStatusMap = existTasks.stream().collect(Collectors.toMap(it -> it.getWeworkUserId(), it -> it.getStatus()));
        }
        List existResults = this.weworkGroupMsgResultMapper.queryByMsgId(corpId, msgId);
        Map<Object, Object> resultStatusMap = Collections.emptyMap();
        if (CollectionUtils.isNotEmpty((Collection)existResults)) {
            resultStatusMap = existResults.stream().collect(Collectors.toMap(it -> String.format(keyFormat, it.getWeworkUserId(), it.getContactId(), it.getWeworkRoomId()), it -> it.getStatus()));
        }
        List<MassMsgTask> taskList = this.fetchGroupMsgTask(corpId, msgId);
        Set weworkUserIds = taskList.stream().map(MassMsgTask::getUserId).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        Map onJobUser = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(weworkUserIds)) {
            onJobUser = this.weworkUserMapper.queryAgentAuthWeworkNameMap(corpId, weworkUserIds);
        }
        for (MassMsgTask task : taskList) {
            String userId = task.getUserId();
            WeworkGroupMsgTask weworkGroupMsgTask = new WeworkGroupMsgTask();
            weworkGroupMsgTask.setBizId(bizId);
            weworkGroupMsgTask.setCorpId(corpId);
            weworkGroupMsgTask.setMsgId(msgId);
            weworkGroupMsgTask.setWeworkUserId(userId);
            weworkGroupMsgTask.setStatus(task.getStatus());
            if (task.getSendTime() != null) {
                weworkGroupMsgTask.setSendTime(new Date(task.getSendTime() * 1000L));
            }
            weworkGroupMsgTask.setCreateTime(now);
            weworkGroupMsgTask.setUpdateTime(now);
            Integer taskStatus = (Integer)taskStatusMap.get(userId);
            if (taskStatus == null || !taskStatus.equals(task.getStatus())) {
                groupMsgTaskAddList.add(weworkGroupMsgTask);
            }
            if (MapUtils.isEmpty((Map)onJobUser) || StringUtils.isBlank((CharSequence)((CharSequence)onJobUser.get(userId)))) {
                log.warn("\u5f53\u524dis auth \u6210\u5458\u672a\u627e\u5230\uff1amsgId:{};userId:{}", (Object)msgId, (Object)userId);
                continue;
            }
            List<MassMsgSendInfo> userResults = this.fetchGroupMsgResult(corpId, msgId, userId);
            for (MassMsgSendInfo result : userResults) {
                WeworkGroupMsgResult record2 = new WeworkGroupMsgResult();
                record2.setBizId(bizId);
                record2.setCorpId(corpId);
                record2.setMsgId(msgId);
                record2.setWeworkUserId(userId);
                record2.setContactId(result.getExternalUserId() == null ? "" : result.getExternalUserId());
                record2.setWeworkRoomId(result.getChatId() == null ? "" : result.getChatId());
                record2.setStatus(result.getStatus());
                if (result.getSendTime() != null) {
                    record2.setSendTime(new Date(result.getSendTime() * 1000L));
                }
                record2.setCreateTime(now);
                record2.setUpdateTime(now);
                String key = String.format(keyFormat, record2.getWeworkUserId(), record2.getContactId(), record2.getWeworkRoomId());
                Integer resultStatus = (Integer)resultStatusMap.get(key);
                if (resultStatus != null && resultStatus.equals(result.getStatus())) continue;
                groupMsgResultAddList.add(record2);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)groupMsgTaskAddList)) {
            this.weworkGroupMsgTaskMapper.batchInsert((Collection)groupMsgTaskAddList);
        }
        if (CollectionUtils.isNotEmpty((Collection)groupMsgResultAddList)) {
            this.weworkGroupMsgResultMapper.batchInsert((Collection)groupMsgResultAddList);
        }
    }

    private void fetchGroupMsgByType(Long bizId, String corpId, String chatType, Date startTime, Date endTime) {
        log.info("fetch group msg, corpId={}, chatType={}, startTime={}, endTime={}", new Object[]{corpId, chatType, startTime, endTime});
        Long startTimestamp = startTime.getTime() / 1000L;
        Long endTimestamp = endTime.getTime() / 1000L;
        List<MassMsgInfo> msglist = this.fetchMsgList(corpId, chatType, startTimestamp, endTimestamp);
        List msgIds = this.weworkGroupMsgMapper.queryMsgIds(corpId, startTime, endTime, chatType);
        HashSet msgIdSet = Sets.newHashSet((Iterable)msgIds);
        ArrayList list = Lists.newArrayListWithCapacity((int)msglist.size());
        for (MassMsgInfo msg : msglist) {
            if (msgIdSet.contains(msg.getMsgId())) continue;
            WeworkGroupMsg weworkGroupMsg = new WeworkGroupMsg();
            weworkGroupMsg.setBizId(bizId);
            weworkGroupMsg.setCorpId(corpId);
            weworkGroupMsg.setChatType(chatType);
            weworkGroupMsg.setMsgId(msg.getMsgId());
            weworkGroupMsg.setCreator(msg.getCreator());
            weworkGroupMsg.setCreateType(msg.getCreateType());
            weworkGroupMsg.setContentJson(JacksonUtil.obj2Str((Object)msg));
            weworkGroupMsg.setMsgCreateTime(new Date(msg.getCreateTime() * 1000L));
            weworkGroupMsg.setCreateTime(new Date());
            weworkGroupMsg.setUpdateTime(new Date());
            list.add(weworkGroupMsg);
        }
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            log.info("save wework group msg, corpId={}, size={}", (Object)corpId, (Object)list.size());
            this.weworkGroupMsgMapper.batchInsert((Collection)list);
        }
    }

    private List<MassMsgInfo> fetchMsgList(String corpId, String chatType, Long startTime, Long endTime) {
        ArrayList results = Lists.newArrayList();
        MassMsgListParams params = new MassMsgListParams();
        params.setChatType(chatType);
        params.setStartTime(startTime);
        params.setEndTime(endTime);
        params.setFilterType(Integer.valueOf(2));
        params.setLimit(Integer.valueOf(100));
        String cursor = null;
        do {
            try {
                MassMsgListResp resp = this.massMsgPushClient.getMassMsgList(corpId, params);
                List list = resp.getGroupMsgList();
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    results.addAll(list);
                }
                if (StringUtils.isNotBlank((CharSequence)resp.getNextCursor())) {
                    cursor = resp.getNextCursor();
                    params.setCursor(cursor);
                    continue;
                }
                cursor = null;
                params.setCursor(null);
            }
            catch (WeworkException e) {
                log.error("{}, corpId:{}, params:{}", new Object[]{e.getMessage(), corpId, params, e});
                throw e;
            }
            catch (Exception e) {
                log.error("failed to group msg, corpId:{}, params:{}", new Object[]{corpId, params, e});
                throw e;
            }
        } while (StringUtils.isNotBlank((CharSequence)cursor));
        log.info("fetch group msg list:{}", (Object)results);
        return results;
    }

    private List<MassMsgTask> fetchGroupMsgTask(String corpId, String msgId) {
        log.info("fetch group msg task, corpId={}, msgId={}", (Object)corpId, (Object)msgId);
        ArrayList results = Lists.newArrayList();
        int limit = 1000;
        String cursor = null;
        do {
            try {
                MassMsgUserTask resp = this.massMsgPushClient.getMassMsgUserTask(corpId, msgId, Integer.valueOf(limit), cursor);
                List list = resp.getTaskList();
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    results.addAll(list);
                }
                if (StringUtils.isNotBlank((CharSequence)resp.getNextCursor())) {
                    cursor = resp.getNextCursor();
                    continue;
                }
                cursor = null;
            }
            catch (WeworkException e) {
                log.error("{}, corpId:{}, params:{}", new Object[]{e.getMessage(), corpId, msgId, e});
                throw e;
            }
            catch (Exception e) {
                log.error("failed to group msg task, corpId:{}, params:{}", new Object[]{corpId, msgId, e});
                throw e;
            }
        } while (StringUtils.isNotBlank((CharSequence)cursor));
        log.info("fetch group msg task, corpId={}, msgId={}, size={}", new Object[]{corpId, msgId, results.size()});
        return results;
    }

    private List<MassMsgSendInfo> fetchGroupMsgResult(String corpId, String msgId, String userId) {
        log.info("fetch group msg result, corpId={}, msgId={}, userId={}", new Object[]{corpId, msgId, userId});
        ArrayList results = Lists.newArrayList();
        String cursor = null;
        int limit = 1000;
        do {
            try {
                MassMsgTaskResult resp = this.massMsgPushClient.getMassMsgTaskResult(corpId, msgId, userId, Integer.valueOf(limit), cursor);
                List list = resp.getSendList();
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    results.addAll(list);
                }
                if (StringUtils.isNotBlank((CharSequence)resp.getNextCursor())) {
                    cursor = resp.getNextCursor();
                    continue;
                }
                cursor = null;
            }
            catch (WeworkException e) {
                log.error("{}, corpId:{}, params:{}", new Object[]{e.getMessage(), corpId, msgId, e});
                throw e;
            }
            catch (Exception e) {
                log.error("failed to group msg task, corpId:{}, params:{}", new Object[]{corpId, msgId, e});
                throw e;
            }
        } while (StringUtils.isNotBlank((CharSequence)cursor));
        log.info("fetch group msg result, corpId={}, msgId={}, userId={}, size={}", new Object[]{corpId, msgId, userId, results.size()});
        return results;
    }

    public void statistic(Long bizId, String corpId) {
        Date now = new Date();
        String month = new SimpleDateFormat("yyyyMM", Locale.getDefault()).format(now);
        Calendar cal = Calendar.getInstance();
        cal.setTime(now);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date startTime = cal.getTime();
        cal.add(2, 1);
        cal.set(11, 0);
        cal.add(13, -1);
        Date endTime = cal.getTime();
        Map contactSendCountMap = this.weworkGroupMsgStatMapper.queryContactSendCount(corpId, month);
        Map roomSendCountMap = this.weworkGroupMsgStatMapper.queryRoomSendCount(corpId, month);
        Map singleMap = this.weworkGroupMsgResultMapper.countSingle(corpId, startTime, endTime);
        Map groupMap = this.weworkGroupMsgResultMapper.countGroup(corpId, startTime, endTime);
        ArrayList list = Lists.newArrayList();
        if (singleMap != null && !singleMap.isEmpty()) {
            singleMap.forEach((contactId, count) -> {
                Integer exist = (Integer)contactSendCountMap.get(contactId);
                if (exist == null || !exist.equals(count)) {
                    list.add(this.newStat(bizId, corpId, month, (String)contactId, "", (Integer)count, now));
                }
            });
        }
        if (groupMap != null && !groupMap.isEmpty()) {
            groupMap.forEach((weworkRoomId, count) -> {
                Integer exist = (Integer)roomSendCountMap.get(weworkRoomId);
                if (exist == null || !exist.equals(count)) {
                    list.add(this.newStat(bizId, corpId, month, "", (String)weworkRoomId, (Integer)count, now));
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            log.info("save group msg statistic data, size={}", (Object)list.size());
            list.sort((a, b) -> {
                String ida = a.getContactId() + "#" + a.getWeworkRoomId();
                String idb = b.getContactId() + "#" + b.getWeworkRoomId();
                return ida.compareTo(idb);
            });
            this.weworkGroupMsgStatMapper.batchInsert((Collection)list);
        }
    }

    private WeworkGroupMsgStat newStat(Long bizId, String corpId, String month, String contactId, String weworkRoomId, Integer count, Date now) {
        WeworkGroupMsgStat weworkGroupMsgStat = new WeworkGroupMsgStat();
        weworkGroupMsgStat.setBizId(bizId);
        weworkGroupMsgStat.setCorpId(corpId);
        weworkGroupMsgStat.setMonth(month);
        weworkGroupMsgStat.setContactId(contactId);
        weworkGroupMsgStat.setWeworkRoomId(weworkRoomId);
        weworkGroupMsgStat.setSendCount(count);
        weworkGroupMsgStat.setCreateTime(now);
        weworkGroupMsgStat.setUpdateTime(now);
        return weworkGroupMsgStat;
    }
}

