/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.synctask.config;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.kuaike.scrm.common.utils.ThreadPoolMonitorUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SynctaskThreadPoolConfig {
    private static final Logger log = LoggerFactory.getLogger(SynctaskThreadPoolConfig.class);

    @Bean(value={"synctaskThreadPool"})
    public ExecutorService getSynctaskThreadPool() {
        int nThread = Runtime.getRuntime().availableProcessors() * 2 + 1;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("synctask-thread-%d").setUncaughtExceptionHandler((t, e) -> log.error("synctask error", e)).build();
        ExecutorService executorService = Executors.newFixedThreadPool(nThread, threadFactory);
        ThreadPoolMonitorUtils.addToMonitor((ExecutorService)executorService);
        return executorService;
    }

    @Bean(value={"syncGroupMsgThreadPool"})
    public ExecutorService getSyncGroupMsgThreadPool() {
        int nThread = Runtime.getRuntime().availableProcessors() * 2 + 1;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("sync-group-msg-thread-%d").setUncaughtExceptionHandler((t, e) -> log.error("sync group msg error", e)).build();
        ExecutorService executorService = Executors.newFixedThreadPool(nThread, threadFactory);
        ThreadPoolMonitorUtils.addToMonitor((ExecutorService)executorService);
        return executorService;
    }
}

