/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.setting.service.impl;

import cn.kinyun.wework.sdk.api.AccessTokenApi;
import cn.kinyun.wework.sdk.entity.AccessToken;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.accesstoken.entity.CorpExternalContactToken;
import com.kuaike.scrm.dal.accesstoken.mapper.CorpExternalContactTokenMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.setting.dto.req.SetCorpSecretReq;
import com.kuaike.scrm.setting.dto.resp.GetCorpTokenCfg;
import com.kuaike.scrm.setting.service.SettingExternalService;
import com.kuaike.scrm.token.service.RefreshTokenService;
import com.kuaike.scrm.token.utils.TokenGen;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Deprecated
public class SettingExternalServiceImpl
implements SettingExternalService {
    private static final Logger log = LoggerFactory.getLogger(SettingExternalServiceImpl.class);
    @Value(value="http://${qyapi.domain.scrm-callback}/external/")
    private String callbackUrl;
    @Autowired
    private AccessTokenApi accessTokenApi;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private CorpExternalContactTokenMapper corpExternalContactTokenMapper;
    @Autowired
    private RefreshTokenService refreshTokenService;

    @Override
    public boolean set(SetCorpSecretReq params) {
        log.info("set secret, params:{}, operatorId:{}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((user.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)user.getCorpId()), (Object)"corpId\u4e3a\u7a7a");
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getSecret()), (Object)"secret\u4e3a\u7a7a");
        Long bizId = user.getBizId();
        String corpId = user.getCorpId();
        String secret = params.getSecret();
        Date now = new Date();
        boolean flag = false;
        CorpExternalContactToken externalContactToken = this.corpExternalContactTokenMapper.getAccessToken(corpId);
        if (externalContactToken == null) {
            AccessToken accessToken = this.getAccessToken(corpId, secret);
            externalContactToken = new CorpExternalContactToken();
            externalContactToken.setBizId(bizId);
            externalContactToken.setCorpId(corpId);
            externalContactToken.setSecret(secret);
            externalContactToken.setAccessToken(accessToken.getAccessToken());
            externalContactToken.setExpireTime(new Date(now.getTime() + accessToken.getExpires() * 1000L));
            externalContactToken.setCreateTime(now);
            externalContactToken.setUpdateTime(now);
            log.info("insert secret:{}", (Object)externalContactToken);
            this.corpExternalContactTokenMapper.insertSelective((Object)externalContactToken);
            flag = true;
        } else {
            if (secret.equals(externalContactToken.getSecret())) {
                log.info("secret not changed");
                return false;
            }
            AccessToken accessToken = this.getAccessToken(corpId, secret);
            externalContactToken.setSecret(secret);
            if (!accessToken.getAccessToken().equals(externalContactToken.getAccessToken())) {
                log.info("update access_token");
                externalContactToken.setAccessToken(accessToken.getAccessToken());
                externalContactToken.setExpireTime(new Date(now.getTime() + accessToken.getExpires() * 1000L));
            }
            externalContactToken.setUpdateTime(now);
            log.info("update secret:{}", (Object)externalContactToken);
            this.corpExternalContactTokenMapper.updateByPrimaryKeySelective((Object)externalContactToken);
            this.refreshTokenService.freshExternalContactAccessToken(corpId, accessToken);
            flag = true;
        }
        return flag;
    }

    private AccessToken getAccessToken(String corpId, String secret) {
        AccessToken accessToken = null;
        try {
            accessToken = this.accessTokenApi.getAccessToken(corpId, secret);
        }
        catch (WeworkException e) {
            log.error("{}, corpId:{}, secret:{}", new Object[]{e.getMessage(), corpId, secret});
        }
        catch (Exception e) {
            log.error("Failed getting accessToken, corpId:{}, secret:{}", new Object[]{e, corpId, secret});
        }
        Preconditions.checkArgument((accessToken != null ? 1 : 0) != 0, (Object)"\u65e0\u6548\u7684secret");
        return accessToken;
    }

    @Override
    public GetCorpTokenCfg detail() {
        log.info("get token detail, operatorId:{}", (Object)LoginUtils.getCurrentUserId());
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((user.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)user.getCorpId()), (Object)"corpId\u4e3a\u7a7a");
        Long bizId = user.getBizId();
        String corpId = user.getCorpId();
        WeworkCorp corp = this.weworkCorpMapper.getByCorpId(corpId);
        Preconditions.checkArgument((corp != null ? 1 : 0) != 0, (Object)"corp\u4e3a\u7a7a");
        CorpExternalContactToken corpExternalContactToken = this.corpExternalContactTokenMapper.queryByCorpId(corpId);
        if (corpExternalContactToken == null) {
            corpExternalContactToken = new CorpExternalContactToken();
            corpExternalContactToken.setBizId(bizId);
            corpExternalContactToken.setCorpId(corpId);
            corpExternalContactToken.setToken(TokenGen.getRandomToken());
            corpExternalContactToken.setAesKey(TokenGen.getRandomAESKey());
            corpExternalContactToken.setCreateTime(new Date());
            corpExternalContactToken.setUpdateTime(new Date());
            log.info("insert secret:{}", (Object)corpExternalContactToken);
            this.corpExternalContactTokenMapper.insertSelective((Object)corpExternalContactToken);
        }
        GetCorpTokenCfg result = new GetCorpTokenCfg();
        result.setSecret(corpExternalContactToken.getSecret());
        result.setCallbackUrl(this.callbackUrl + corp.getNum());
        result.setAeskey(corpExternalContactToken.getAesKey());
        result.setToken(corpExternalContactToken.getToken());
        return result;
    }

    @Override
    public String rndAeskey() {
        log.info("generate random aeskey, operatorId:{}", (Object)LoginUtils.getCurrentUserId());
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((user.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)user.getCorpId()), (Object)"corpId\u4e3a\u7a7a");
        Long bizId = user.getBizId();
        String corpId = user.getCorpId();
        CorpExternalContactToken corpExternalContactToken = this.corpExternalContactTokenMapper.getCryptToken(corpId);
        if (corpExternalContactToken == null) {
            corpExternalContactToken = new CorpExternalContactToken();
            corpExternalContactToken.setBizId(bizId);
            corpExternalContactToken.setCorpId(corpId);
            corpExternalContactToken.setAesKey(TokenGen.getRandomAESKey());
            corpExternalContactToken.setCreateTime(new Date());
            corpExternalContactToken.setUpdateTime(new Date());
            log.info("insert aeskey:{}", (Object)corpExternalContactToken);
            this.corpExternalContactTokenMapper.insertSelective((Object)corpExternalContactToken);
        } else {
            corpExternalContactToken.setAesKey(TokenGen.getRandomAESKey());
            corpExternalContactToken.setUpdateTime(new Date());
            log.info("update aeskey:{}", (Object)corpExternalContactToken);
            this.corpExternalContactTokenMapper.updateByPrimaryKeySelective((Object)corpExternalContactToken);
        }
        return corpExternalContactToken.getAesKey();
    }

    @Override
    public String rndToken() {
        log.info("generate random token, operatorId:{}", (Object)LoginUtils.getCurrentUserId());
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((user.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)user.getCorpId()), (Object)"corpId\u4e3a\u7a7a");
        Long bizId = user.getBizId();
        String corpId = user.getCorpId();
        CorpExternalContactToken corpExternalContactToken = this.corpExternalContactTokenMapper.getCryptToken(corpId);
        if (corpExternalContactToken == null) {
            corpExternalContactToken = new CorpExternalContactToken();
            corpExternalContactToken.setBizId(bizId);
            corpExternalContactToken.setCorpId(corpId);
            corpExternalContactToken.setToken(TokenGen.getRandomToken());
            corpExternalContactToken.setCreateTime(new Date());
            corpExternalContactToken.setUpdateTime(new Date());
            log.info("insert token:{}", (Object)corpExternalContactToken);
            this.corpExternalContactTokenMapper.insertSelective((Object)corpExternalContactToken);
        } else {
            corpExternalContactToken.setToken(TokenGen.getRandomToken());
            corpExternalContactToken.setUpdateTime(new Date());
            log.info("update token:{}", (Object)corpExternalContactToken);
            this.corpExternalContactTokenMapper.updateByPrimaryKeySelective((Object)corpExternalContactToken);
        }
        return corpExternalContactToken.getToken();
    }
}

