/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.setting.service.impl;

import cn.kinyun.wework.sdk.api.AccessTokenApi;
import cn.kinyun.wework.sdk.entity.AccessToken;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.accesstoken.entity.CorpAgentToken;
import com.kuaike.scrm.dal.accesstoken.mapper.CorpAgentTokenMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.setting.dto.req.SetAgentSecretReq;
import com.kuaike.scrm.setting.dto.resp.GetAgentTokenCfg;
import com.kuaike.scrm.setting.service.SettingAgentService;
import com.kuaike.scrm.token.service.RefreshTokenService;
import com.kuaike.scrm.token.utils.TokenGen;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Deprecated
public class SettingAgentServiceImpl
implements SettingAgentService {
    private static final Logger log = LoggerFactory.getLogger(SettingAgentServiceImpl.class);
    @Value(value="http://${qyapi.domain.scrm-callback}/agent/")
    private String callbackUrl;
    @Autowired
    private AccessTokenApi accessTokenApi;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private CorpAgentTokenMapper corpAgentTokenMapper;
    @Autowired
    private RefreshTokenService refreshTokenService;

    @Override
    public void setAgentId(Integer agentId, String appid) {
        log.info("set agentId:{}, appid:{}, operatorId:{}", new Object[]{agentId, appid, LoginUtils.getCurrentUserId()});
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((user.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)user.getCorpId()), (Object)"corpId\u4e3a\u7a7a");
        Preconditions.checkArgument((agentId != null ? 1 : 0) != 0, (Object)"agentId is null");
        Preconditions.checkArgument((appid != null ? 1 : 0) != 0, (Object)"appid is null");
        Long bizId = user.getBizId();
        String corpId = user.getCorpId();
        CorpAgentToken corpAgentToken = this.corpAgentTokenMapper.queryByCorpId(corpId);
        if (corpAgentToken != null && agentId.equals(corpAgentToken.getAgentId()) && appid.equals(corpAgentToken.getAppid())) {
            log.info("\u65e0\u9700\u66f4\u65b0");
            return;
        }
        if (corpAgentToken == null) {
            corpAgentToken = new CorpAgentToken();
            corpAgentToken.setBizId(bizId);
            corpAgentToken.setCorpId(corpId);
            corpAgentToken.setAgentId(agentId);
            corpAgentToken.setAppid(appid);
            corpAgentToken.setToken(TokenGen.getRandomToken());
            corpAgentToken.setAesKey(TokenGen.getRandomAESKey());
            corpAgentToken.setErrCode(Integer.valueOf(-1));
            corpAgentToken.setErrBizMsg("\u672a\u8bbe\u7f6esecret");
            corpAgentToken.setCreateTime(new Date());
            corpAgentToken.setUpdateTime(new Date());
            this.corpAgentTokenMapper.insertSelective((Object)corpAgentToken);
        } else {
            corpAgentToken.setAgentId(agentId);
            corpAgentToken.setAppid(appid);
            corpAgentToken.setSecret(null);
            corpAgentToken.setAccessToken(null);
            corpAgentToken.setExpireTime(null);
            corpAgentToken.setJsapiTicket(null);
            corpAgentToken.setJsapiTicketExpireTime(null);
            corpAgentToken.setAgentTicket(null);
            corpAgentToken.setAgentTicketExpireTime(null);
            corpAgentToken.setErrCode(Integer.valueOf(-1));
            corpAgentToken.setErrBizMsg("\u672a\u8bbe\u7f6esecret");
            corpAgentToken.setUpdateTime(new Date());
            this.corpAgentTokenMapper.updateByPrimaryKey((Object)corpAgentToken);
        }
    }

    @Override
    public boolean set(SetAgentSecretReq params) {
        log.info("set secret, params:{}, operatorId:{}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((user.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)user.getCorpId()), (Object)"corpId\u4e3a\u7a7a");
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getAgentId() != null ? 1 : 0) != 0, (Object)"agentId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getSecret()), (Object)"secret\u4e3a\u7a7a");
        Long bizId = user.getBizId();
        String corpId = user.getCorpId();
        Integer agentId = params.getAgentId();
        String secret = params.getSecret();
        Date now = new Date();
        boolean flag = false;
        CorpAgentToken corpAgentToken = this.corpAgentTokenMapper.getAccessToken(corpId);
        if (corpAgentToken == null) {
            AccessToken accessToken = this.getAccessToken(corpId, secret);
            corpAgentToken = new CorpAgentToken();
            corpAgentToken.setBizId(bizId);
            corpAgentToken.setCorpId(corpId);
            corpAgentToken.setAgentId(agentId);
            corpAgentToken.setSecret(secret);
            corpAgentToken.setAccessToken(accessToken.getAccessToken());
            corpAgentToken.setExpireTime(new Date(now.getTime() + accessToken.getExpires() * 1000L));
            corpAgentToken.setCreateTime(now);
            corpAgentToken.setUpdateTime(now);
            log.info("insert secret:{}", (Object)corpAgentToken);
            this.corpAgentTokenMapper.insertSelective((Object)corpAgentToken);
            flag = true;
        } else {
            if (secret.equals(corpAgentToken.getSecret()) && agentId.equals(corpAgentToken.getAgentId())) {
                log.info("nothing changed");
                return false;
            }
            AccessToken accessToken = this.getAccessToken(corpId, secret);
            corpAgentToken.setAgentId(agentId);
            corpAgentToken.setSecret(secret);
            if (!accessToken.getAccessToken().equals(corpAgentToken.getAccessToken())) {
                log.info("update access_token");
                corpAgentToken.setAccessToken(accessToken.getAccessToken());
                corpAgentToken.setExpireTime(new Date(now.getTime() + accessToken.getExpires() * 1000L));
            }
            corpAgentToken.setUpdateTime(now);
            log.info("update secret:{}", (Object)corpAgentToken);
            this.corpAgentTokenMapper.updateByPrimaryKeySelective((Object)corpAgentToken);
            this.refreshTokenService.freshCorpAgentAccessToken(corpId, accessToken);
            flag = true;
        }
        return flag;
    }

    private AccessToken getAccessToken(String corpId, String secret) {
        AccessToken accessToken = null;
        try {
            accessToken = this.accessTokenApi.getAccessToken(corpId, secret);
        }
        catch (WeworkException e) {
            log.error("{}, corpId:{}, secret:{}", new Object[]{e.getMessage(), corpId, secret});
        }
        catch (Exception e) {
            log.error("Failed getting accessToken, corpId:{}, secret:{}", new Object[]{e, corpId, secret});
        }
        Preconditions.checkArgument((accessToken != null ? 1 : 0) != 0, (Object)"\u65e0\u6548\u7684secret");
        return accessToken;
    }

    @Override
    public GetAgentTokenCfg detail() {
        log.info("get token detail, operatorId:{}", (Object)LoginUtils.getCurrentUserId());
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((user.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)user.getCorpId()), (Object)"corpId\u4e3a\u7a7a");
        Long bizId = user.getBizId();
        String corpId = user.getCorpId();
        WeworkCorp corp = this.weworkCorpMapper.getByCorpId(corpId);
        Preconditions.checkArgument((corp != null ? 1 : 0) != 0, (Object)"corp\u4e3a\u7a7a");
        CorpAgentToken corpAgentToken = this.corpAgentTokenMapper.queryByCorpId(corpId);
        if (corpAgentToken == null) {
            corpAgentToken = new CorpAgentToken();
            corpAgentToken.setBizId(bizId);
            corpAgentToken.setCorpId(corpId);
            corpAgentToken.setToken(TokenGen.getRandomToken());
            corpAgentToken.setAesKey(TokenGen.getRandomAESKey());
            corpAgentToken.setCreateTime(new Date());
            corpAgentToken.setUpdateTime(new Date());
            log.info("insert secret:{}", (Object)corpAgentToken);
            this.corpAgentTokenMapper.insertSelective((Object)corpAgentToken);
        }
        GetAgentTokenCfg result = new GetAgentTokenCfg();
        result.setAgentId(corpAgentToken.getAgentId());
        result.setAppId(corpAgentToken.getAppid());
        result.setSecret(corpAgentToken.getSecret());
        result.setCallbackUrl(this.callbackUrl + corp.getNum());
        result.setAeskey(corpAgentToken.getAesKey());
        result.setToken(corpAgentToken.getToken());
        return result;
    }

    @Override
    public String rndAeskey() {
        log.info("generate random aeskey, operatorId:{}", (Object)LoginUtils.getCurrentUserId());
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((user.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)user.getCorpId()), (Object)"corpId\u4e3a\u7a7a");
        Long bizId = user.getBizId();
        String corpId = user.getCorpId();
        CorpAgentToken agentToken = this.corpAgentTokenMapper.getCryptToken(corpId);
        if (agentToken == null) {
            agentToken = new CorpAgentToken();
            agentToken.setBizId(bizId);
            agentToken.setCorpId(corpId);
            agentToken.setAesKey(TokenGen.getRandomAESKey());
            agentToken.setCreateTime(new Date());
            agentToken.setUpdateTime(new Date());
            log.info("insert aeskey:{}", (Object)agentToken);
            this.corpAgentTokenMapper.insertSelective((Object)agentToken);
        } else {
            agentToken.setAesKey(TokenGen.getRandomAESKey());
            agentToken.setUpdateTime(new Date());
            log.info("update aeskey:{}", (Object)agentToken);
            this.corpAgentTokenMapper.updateByPrimaryKeySelective((Object)agentToken);
        }
        return agentToken.getAesKey();
    }

    @Override
    public String rndToken() {
        log.info("generate random token, operatorId:{}", (Object)LoginUtils.getCurrentUserId());
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((user.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)user.getCorpId()), (Object)"corpId\u4e3a\u7a7a");
        Long bizId = user.getBizId();
        String corpId = user.getCorpId();
        CorpAgentToken agentToken = this.corpAgentTokenMapper.getCryptToken(corpId);
        if (agentToken == null) {
            agentToken = new CorpAgentToken();
            agentToken.setBizId(bizId);
            agentToken.setCorpId(corpId);
            agentToken.setToken(TokenGen.getRandomToken());
            agentToken.setCreateTime(new Date());
            agentToken.setUpdateTime(new Date());
            log.info("insert token:{}", (Object)agentToken);
            this.corpAgentTokenMapper.insertSelective((Object)agentToken);
        } else {
            agentToken.setToken(TokenGen.getRandomToken());
            agentToken.setUpdateTime(new Date());
            log.info("update token:{}", (Object)agentToken);
            this.corpAgentTokenMapper.updateByPrimaryKeySelective((Object)agentToken);
        }
        return agentToken.getToken();
    }
}

