/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.token.service.impl;

import cn.kinyun.wework.sdk.api.AccessTokenApi;
import cn.kinyun.wework.sdk.entity.AccessToken;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.dal.approval.entity.CorpApproveToken;
import com.kuaike.scrm.dal.approval.mapper.CorpApproveTokenMapper;
import com.kuaike.scrm.token.service.ApproveTokenService;
import com.kuaike.scrm.token.utils.ServiceContext;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApproveTokenServiceImpl
implements ApproveTokenService {
    private static final Logger log = LoggerFactory.getLogger(ApproveTokenServiceImpl.class);
    @Autowired
    private CorpApproveTokenMapper corpApproveTokenMapper;
    @Autowired
    private AccessTokenApi accessTokenApi;

    public void setProxy(CorpApproveToken token) {
        Proxy proxy = this.getProxy(token);
        log.info("setProxy, id:{}, proxy:{}", (Object)token.getId(), (Object)proxy);
        ServiceContext.getContext().setProxy(proxy);
    }

    public Proxy getProxy(CorpApproveToken token) {
        if (StringUtils.isNotBlank((CharSequence)token.getProxyAddress()) && token.getProxyPort() != null) {
            Proxy.Type proxyType = StringUtils.isBlank((CharSequence)token.getProxyType()) ? Proxy.Type.HTTP : Proxy.Type.valueOf(token.getProxyType());
            return new Proxy(proxyType, new InetSocketAddress(token.getProxyAddress(), (int)token.getProxyPort()));
        }
        return null;
    }

    @Override
    public void freshApproveAccessToken() {
        long startTime = System.currentTimeMillis();
        List corpApproveTokens = this.corpApproveTokenMapper.selectAll();
        if (CollectionUtils.isEmpty((Collection)corpApproveTokens)) {
            return;
        }
        log.info("refresh corp_contact_token, size={}", (Object)corpApproveTokens.size());
        for (CorpApproveToken corpContactToken : corpApproveTokens) {
            try {
                this.freshApproveToken(corpContactToken);
            }
            catch (Exception ex) {
                log.error("\u5237\u65b0corpId:{}\u7684accessToken\u53d1\u751f\u5f02\u5e38:", (Object)corpContactToken.getCorpId(), (Object)ex);
            }
        }
        long endTime = System.currentTimeMillis();
        log.info("refreshApproveToken, totalTime:{}ms", (Object)(endTime - startTime));
    }

    @Override
    public AccessToken getAccessToken(String corpId, String secret) {
        AccessToken accessToken = null;
        try {
            accessToken = this.accessTokenApi.getAccessToken(corpId, secret);
        }
        catch (WeworkException e) {
            log.error("{}, corpId:{}, secret:{}", new Object[]{e.getMessage(), corpId, secret});
        }
        catch (Exception e) {
            log.error("Failed getting accessToken, corpId:{}, secret:{}", new Object[]{corpId, secret, e});
        }
        Preconditions.checkArgument((boolean)Objects.nonNull(accessToken), (Object)"\u65e0\u6548\u7684secret");
        return accessToken;
    }

    @Override
    public String getAccessToken(Long bizId) {
        CorpApproveToken existRecord = this.corpApproveTokenMapper.getAccessToken(bizId);
        if (existRecord == null) {
            log.warn("approve token not found, bizId:{}", (Object)bizId);
            return null;
        }
        this.setProxy(existRecord);
        Date now = new Date();
        String token = existRecord.getAccessToken();
        Date expireTime = existRecord.getExpireTime();
        if (StringUtils.isNotBlank((CharSequence)token) && expireTime != null && expireTime.after(now)) {
            return token;
        }
        String corpSecret = existRecord.getSecret();
        String corpId = existRecord.getCorpId();
        AccessToken accessToken = this.getAccessToken(corpId, corpSecret);
        token = accessToken != null ? accessToken.getAccessToken() : null;
        this.updateApproveAccessToken(bizId, accessToken);
        return token;
    }

    @Override
    public void updateApproveAccessToken(Long bizId, AccessToken accessToken) {
        if (accessToken == null) {
            return;
        }
        CorpApproveToken contactToken = this.corpApproveTokenMapper.getCryptToken(bizId);
        String token = accessToken.getAccessToken();
        Date now = new Date();
        Long expires = accessToken.getExpires();
        Date expireTime = new Date(now.getTime() + expires * 1000L);
        this.corpApproveTokenMapper.updateAccessToken(contactToken.getId(), token, expireTime, now, null, Integer.valueOf(0), null, null);
    }

    private void freshApproveToken(CorpApproveToken corpApproveToken) {
        String corpSecret = corpApproveToken.getSecret();
        String corpId = corpApproveToken.getCorpId();
        Long bizId = corpApproveToken.getBizId();
        if (StringUtils.isBlank((CharSequence)corpApproveToken.getSecret())) {
            return;
        }
        AccessToken accessToken = this.getAccessToken(corpId, corpSecret);
        this.updateApproveAccessToken(bizId, accessToken);
    }
}

