/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.token.service.impl;

import cn.kinyun.wework.sdk.api.AccessTokenApi;
import cn.kinyun.wework.sdk.api.JsSdkApi;
import cn.kinyun.wework.sdk.entity.AccessToken;
import cn.kinyun.wework.sdk.entity.Ticket;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.dal.accesstoken.entity.CorpCustomizedToken;
import com.kuaike.scrm.dal.accesstoken.mapper.CorpCustomizedTokenMapper;
import com.kuaike.scrm.token.service.CustomizedTokenService;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CustomizedTokenServiceImpl
implements CustomizedTokenService {
    private static final Logger log = LoggerFactory.getLogger(CustomizedTokenServiceImpl.class);
    @Autowired
    private JsSdkApi jsSdkApi;
    @Autowired
    private AccessTokenApi accessTokenApi;
    @Autowired
    private CorpCustomizedTokenMapper corpCustomizedTokenMapper;
    @Value(value="${qyapi.customized.id}")
    private String customizedId;

    @Override
    public Integer getAgentId(String corpId) {
        return this.corpCustomizedTokenMapper.getAgentId(corpId, this.customizedId);
    }

    @Override
    public String getJsapiTicket(String corpId) {
        log.info("get customized jsapi ticket, corpId={}", (Object)corpId);
        CorpCustomizedToken existRecord = this.corpCustomizedTokenMapper.getJsapiTicket(corpId, this.customizedId);
        if (existRecord == null || existRecord.getIsAuth() == 0) {
            log.warn("\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, corpId={}", (Object)corpId);
            return null;
        }
        Date now = new Date();
        String jsapiTicket = existRecord.getJsapiTicket();
        Date expireTime = existRecord.getJsapiTicketExpireTime();
        if (StringUtils.isNotBlank((CharSequence)jsapiTicket) && expireTime != null && expireTime.after(now)) {
            return jsapiTicket;
        }
        String accessToken = this.getAgentAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684access_token\uff0c\u65e0\u6cd5\u83b7\u53d6jsapi_ticket");
            return null;
        }
        Ticket ticket = null;
        try {
            ticket = this.jsSdkApi.getJsapiTicket(accessToken);
        }
        catch (WeworkException e) {
            log.error("{}, corpId:{}", new Object[]{e.getMessage(), corpId, e});
            return null;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6jsapi_ticket\u5931\u8d25, corpId:{}", (Object)corpId, (Object)e);
            return null;
        }
        jsapiTicket = ticket.getTicket();
        int expires = ticket.getExpires();
        expireTime = new Date(now.getTime() + (long)expires * 1000L);
        CorpCustomizedToken corpCustomizedToken = new CorpCustomizedToken();
        corpCustomizedToken.setId(existRecord.getId());
        corpCustomizedToken.setJsapiTicket(jsapiTicket);
        corpCustomizedToken.setJsapiTicketExpireTime(expireTime);
        corpCustomizedToken.setUpdateTime(now);
        this.corpCustomizedTokenMapper.updateByPrimaryKeySelective((Object)corpCustomizedToken);
        return jsapiTicket;
    }

    @Override
    public String getAgentTicket(String corpId) {
        log.info("get customized ticket, corpId={}", (Object)corpId);
        CorpCustomizedToken existRecord = this.corpCustomizedTokenMapper.getAgentTicket(corpId, this.customizedId);
        if (existRecord == null || existRecord.getIsAuth() == 0) {
            log.warn("\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, corpId={}", (Object)corpId);
            return null;
        }
        Date now = new Date();
        String agentTicket = existRecord.getAgentTicket();
        Date expireTime = existRecord.getAgentTicketExpireTime();
        if (StringUtils.isNotBlank((CharSequence)agentTicket) && expireTime != null && expireTime.after(now)) {
            return agentTicket;
        }
        String accessToken = this.getAgentAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684access_token\uff0c\u65e0\u6cd5\u83b7\u53d6agent_ticket");
            return null;
        }
        Ticket ticket = null;
        try {
            ticket = this.jsSdkApi.getAgentTicket(accessToken);
        }
        catch (WeworkException e) {
            log.error("{}, corpId:{}", new Object[]{e.getMessage(), corpId, e});
            return null;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6agent_ticket\u5931\u8d25, corpId:{}", (Object)corpId, (Object)e);
            return null;
        }
        agentTicket = ticket.getTicket();
        int expires = ticket.getExpires();
        expireTime = new Date(now.getTime() + (long)expires * 1000L);
        CorpCustomizedToken corpCustomizedToken = new CorpCustomizedToken();
        corpCustomizedToken.setId(existRecord.getId());
        corpCustomizedToken.setAgentTicket(agentTicket);
        corpCustomizedToken.setAgentTicketExpireTime(expireTime);
        corpCustomizedToken.setUpdateTime(now);
        this.corpCustomizedTokenMapper.updateByPrimaryKeySelective((Object)corpCustomizedToken);
        return agentTicket;
    }

    @Override
    public String getAgentAccessToken(String corpId) {
        log.info("get customized access token, corpId={}", (Object)corpId);
        CorpCustomizedToken existRecord = this.corpCustomizedTokenMapper.getAccessToken(corpId, this.customizedId);
        if (existRecord == null || existRecord.getIsAuth() == 0) {
            log.warn("\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528, corpId={}", (Object)corpId);
            return null;
        }
        return this.getAccessToken(corpId, existRecord);
    }

    private String getAccessToken(String corpId, CorpCustomizedToken existRecord) {
        Date now = new Date();
        String token = existRecord.getAccessToken();
        Date expireTime = existRecord.getExpireTime();
        if (StringUtils.isNotBlank((CharSequence)token) && expireTime != null && expireTime.after(now)) {
            return token;
        }
        String corpSecret = existRecord.getPermanentCode();
        AccessToken accessToken = null;
        try {
            log.info("getAgentToken with corpId={}", (Object)corpId);
            accessToken = this.accessTokenApi.getAccessToken(corpId, corpSecret);
        }
        catch (WeworkException e) {
            log.error("{}, corpId={}", (Object)e.getMessage(), (Object)corpId);
            return null;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6accessToken\u5931\u8d25, {}, corpId={}", (Object)e.getMessage(), (Object)corpId);
            return null;
        }
        token = accessToken.getAccessToken();
        now = new Date();
        Long expires = accessToken.getExpires();
        expireTime = new Date(now.getTime() + expires * 1000L);
        existRecord.setAccessToken(token);
        existRecord.setExpireTime(expireTime);
        existRecord.setUpdateTime(now);
        this.corpCustomizedTokenMapper.updateByPrimaryKeySelective((Object)existRecord);
        return token;
    }

    @Override
    public Integer getAuthStatus(Long bizId) {
        log.info("get auth status, bizId={}", (Object)bizId);
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null");
        Integer devStatus = this.corpCustomizedTokenMapper.getDevStatusByBizId(bizId, this.customizedId);
        if (devStatus != null) {
            return devStatus;
        }
        return -1;
    }

    @Override
    public void setDevStatus(Long bizId, Integer devStatus) {
        log.info("set dev status, bizId={}, devStatus={}", (Object)bizId, (Object)devStatus);
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((devStatus != null ? 1 : 0) != 0, (Object)"devStatus is null");
        Integer curStatus = this.corpCustomizedTokenMapper.getDevStatusByBizId(bizId, this.customizedId);
        if (curStatus != null && !curStatus.equals(devStatus)) {
            log.info("update devStatus, bizId={}, {} -> {}", (Object)curStatus, (Object)devStatus);
            this.corpCustomizedTokenMapper.setDevStatusByBizId(bizId, this.customizedId, devStatus.intValue());
        }
    }
}

